/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.losolutions.wrappers;

import alma.Control.BasebandSpec;
import alma.valuetypes.Frequency;

public class BasebandSpecWrapper {
    protected Frequency skyFrequency;
    protected double weight;
    protected Frequency ifFrequency;

    public String toString() {
        return "BasebandSpecWrapper [skyFrequency=" + (Object)((Object)this.skyFrequency) + ", weight=" + this.weight + ", ifFrequency=" + (Object)((Object)this.ifFrequency) + "]";
    }

    public BasebandSpecWrapper() {
        this.setWeight(100.0);
    }

    public BasebandSpecWrapper(double d, double d2, double d3) {
        this(new BasebandSpec(d, d2, d3));
    }

    public BasebandSpecWrapper(BasebandSpec basebandSpec) {
        this();
        this.importNativeBasebandSpec(basebandSpec);
    }

    public void importNativeBasebandSpec(BasebandSpec basebandSpec) {
        this.getSkyFrequency().setContentInGHz(basebandSpec.skyFreqHz / 1.0E9);
        this.setWeight(basebandSpec.weight);
        this.getIfFrequency().setContentInGHz(basebandSpec.ifFreqHz / 1.0E9);
    }

    public BasebandSpec exportNativeBasebandSpec() {
        BasebandSpec basebandSpec = new BasebandSpec();
        basebandSpec.skyFreqHz = this.getSkyFrequency().getContentInGHz() * 1.0E9;
        basebandSpec.weight = this.getWeight();
        basebandSpec.ifFreqHz = this.getIfFrequency().getContentInGHz() * 1.0E9;
        return basebandSpec;
    }

    public Frequency getSkyFrequency() {
        if (this.skyFrequency == null) {
            this.skyFrequency = Frequency.createFrequency();
        }
        return this.skyFrequency;
    }

    public void setSkyFrequency(Frequency frequency) {
        this.skyFrequency = frequency;
    }

    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double d) {
        this.weight = d;
    }

    public Frequency getIfFrequency() {
        if (this.ifFrequency == null) {
            this.ifFrequency = Frequency.createFrequency();
        }
        return this.ifFrequency;
    }

    public void setIfFrequency(Frequency frequency) {
        this.ifFrequency = frequency;
    }

    public boolean isUsed() {
        return this.getSkyFrequency().getContentInMHz() > 1.0;
    }
}

