/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.losolutions.wrappers;

import alma.Control.SSBbasebandSpec;
import alma.obsprep.services.losolutions.wrappers.AbstractBasebandSpecWrapper;
import alma.obsprep.services.losolutions.wrappers.BasebandSpecWrapper;
import alma.obsprep.services.losolutions.wrappers.SidebandPreferenceWrapper;
import alma.valuetypes.Frequency;

public class SSBbasebandSpecWrapper
extends AbstractBasebandSpecWrapper {
    private BasebandSpecWrapper spec;
    private SidebandPreferenceWrapper sidebandPreference = SidebandPreferenceWrapper.NoPreference;

    public String toString() {
        return "SSBbasebandSpecWrapper [spec=" + this.spec + ", sidebandPreference=" + (Object)((Object)this.sidebandPreference) + "]";
    }

    public SSBbasebandSpecWrapper() {
        this.spec = new BasebandSpecWrapper();
        this.setWeight(100.0);
    }

    public SSBbasebandSpecWrapper(Frequency frequency, double d, Frequency frequency2, SidebandPreferenceWrapper sidebandPreferenceWrapper) {
        this();
        this.setSkyFrequency(frequency);
        this.setWeight(d);
        this.setIfFrequency(frequency2);
    }

    public SSBbasebandSpecWrapper(double d, double d2, double d3, SidebandPreferenceWrapper sidebandPreferenceWrapper) {
        this();
        this.setSkyFrequency(Frequency.createFrequencyGHZ(d / 1.0E9));
        this.setWeight(d2);
        this.setIfFrequency(Frequency.createFrequencyGHZ(d3 / 1.0E9));
        this.setSidebandPreference(sidebandPreferenceWrapper);
    }

    public SSBbasebandSpecWrapper(SSBbasebandSpec sSBbasebandSpec) {
        this.spec = new BasebandSpecWrapper();
        this.importNativeBasebandSpec(sSBbasebandSpec);
    }

    public SSBbasebandSpecWrapper(Frequency frequency) {
        this();
        this.setSkyFrequency(frequency);
    }

    @Override
    public void importNativeBasebandSpec(Object object) {
        if (!(object instanceof SSBbasebandSpec)) {
            throw new IllegalArgumentException("Must be an instance of SSBbasebandSpec");
        }
        SSBbasebandSpec sSBbasebandSpec = (SSBbasebandSpec)object;
        this.getSkyFrequency().setContentInGHz(sSBbasebandSpec.skyFreqHz / 1.0E9);
        this.setWeight(sSBbasebandSpec.weight);
        this.getIfFrequency().setContentInGHz(sSBbasebandSpec.ifFreqHz / 1.0E9);
        this.setSidebandPreference(SidebandPreferenceWrapper.getOTSidebandPreference(sSBbasebandSpec.sidebandPref));
    }

    public SSBbasebandSpec exportNativeBasebandSpec() {
        SSBbasebandSpec sSBbasebandSpec = new SSBbasebandSpec();
        sSBbasebandSpec.skyFreqHz = this.getSkyFrequency().getContentInGHz() * 1.0E9;
        sSBbasebandSpec.weight = this.getWeight();
        sSBbasebandSpec.ifFreqHz = this.getIfFrequency().getContentInGHz() * 1.0E9;
        sSBbasebandSpec.sidebandPref = this.getSidebandPreference().nativeEnumeration;
        return sSBbasebandSpec;
    }

    @Override
    public void setOneSkyFrequency(Frequency frequency) {
        this.setSidebandPreference(SidebandPreferenceWrapper.NoPreference);
        this.setSkyFrequency(frequency);
    }

    public Frequency getIfFrequency() {
        return this.spec.getIfFrequency();
    }

    public Frequency getSkyFrequency() {
        return this.spec.getSkyFrequency();
    }

    public double getWeight() {
        return this.spec.getWeight();
    }

    public void setIfFrequency(Frequency frequency) {
        this.spec.setIfFrequency(frequency);
    }

    public void setSkyFrequency(Frequency frequency) {
        this.spec.setSkyFrequency(frequency);
    }

    public void setWeight(double d) {
        this.spec.setWeight(d);
    }

    public SidebandPreferenceWrapper getSidebandPreference() {
        return this.sidebandPreference;
    }

    public void setSidebandPreference(SidebandPreferenceWrapper sidebandPreferenceWrapper) {
        this.sidebandPreference = sidebandPreferenceWrapper;
    }
}

