/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.network.roledirectory;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.gui.toplevel.UserAuthenticator;
import alma.obsprep.roledirectory.OTOperation;
import alma.obsprep.services.network.roledirectory.RoleDirectoryService;
import alma.obsprep.services.userlookup.UserLookupRemote;
import java.io.IOException;
import java.util.Objects;
import org.apache.commons.jcs.JCS;
import org.apache.commons.jcs.access.CacheAccess;

public class RoleDirectoryServiceHelper {
    private static CacheAccess<Integer, Boolean> contactScientistCache;
    private static CacheAccess<Integer, Boolean> p2DelegateCache;
    private static boolean skipUserLookup;

    public static boolean isContactScientist(ObsProject obsProject) {
        if (obsProject == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: project");
        }
        if (skipUserLookup || ObservingToolController.isOTInBatchMode()) {
            return false;
        }
        ObservingToolController observingToolController = ObservingToolController.getMyInstance();
        UserAuthenticator userAuthenticator = observingToolController.getUserAuthenticator();
        if (userAuthenticator == null) {
            return false;
        }
        Integer n = Objects.hash(obsProject.getEntityID(), userAuthenticator.getUsername());
        Boolean bl = (Boolean)contactScientistCache.get((Object)n);
        if (bl == null) {
            try {
                bl = observingToolController.getUserLookup().isContactScientist(obsProject.getEntityID(), userAuthenticator.getUsername());
            }
            catch (UserLookupRemote.UnableToDetermineRoleException unableToDetermineRoleException) {
                Log.logger(RoleDirectoryServiceHelper.class).warning("Unable to determine if the user is a contact scientist " + unableToDetermineRoleException.getMessage());
                return false;
            }
            contactScientistCache.put((Object)n, (Object)bl);
        }
        return bl;
    }

    public static boolean isPhase2ProposalDelegate(ObsProject obsProject) {
        if (obsProject == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: project");
        }
        if (skipUserLookup || ObservingToolController.isOTInBatchMode()) {
            return false;
        }
        ObservingToolController observingToolController = ObservingToolController.getMyInstance();
        UserAuthenticator userAuthenticator = observingToolController.getUserAuthenticator();
        if (userAuthenticator == null) {
            return false;
        }
        Integer n = Objects.hash(obsProject.getCode(), userAuthenticator.getUsername());
        Boolean bl = (Boolean)p2DelegateCache.get((Object)n);
        if (bl == null) {
            try {
                bl = observingToolController.getUserLookup().isPhase2Delegee(obsProject.getCode(), userAuthenticator.getUsername());
            }
            catch (UserLookupRemote.UnableToDetermineRoleException unableToDetermineRoleException) {
                Log.logger(RoleDirectoryServiceHelper.class).warning("Unable to determine if the user is a P2 delegate " + unableToDetermineRoleException.getMessage());
                return false;
            }
            p2DelegateCache.put((Object)n, (Object)bl);
        }
        return bl;
    }

    public static boolean isUserP2G() {
        if (skipUserLookup || ObservingToolController.isOTInBatchMode()) {
            return true;
        }
        ObservingToolController observingToolController = ObservingToolController.getMyInstance();
        RoleDirectoryService roleDirectoryService = observingToolController.getRoleDirectory();
        boolean bl = true;
        try {
            bl &= roleDirectoryService.canExecute(OTOperation.ENABLE_ADVANCED_OPTIONS);
            bl &= roleDirectoryService.canExecute(OTOperation.CREATE_OBSERVATORY_GOAL);
            bl &= roleDirectoryService.canExecute(OTOperation.SUBMIT_OBSERVATORY_GOAL);
            bl &= roleDirectoryService.canExecute(OTOperation.RETRIEVE_AS_NON_PI);
            bl &= roleDirectoryService.canExecute(OTOperation.STORE_AS_NON_PI);
            bl &= roleDirectoryService.canExecute(OTOperation.RESUBMIT_PROPOSAL);
        }
        catch (IOException iOException) {
            Log.logger(RoleDirectoryServiceHelper.class).warning("Unable to determine if user is P2G : " + iOException.getMessage());
            bl = false;
        }
        return bl;
    }

    static {
        skipUserLookup = false;
        contactScientistCache = JCS.getInstance((String)"contactScientistCache");
        p2DelegateCache = JCS.getInstance((String)"delegateCache");
    }
}

