/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.sfi;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.annotations.SpectralSpecDocument;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralScan;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.workbooks.WorkbookPage;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.ot.editors.obsproject.ObsProposalEditor;
import alma.obsprep.ot.editors.sciencegoals.AbstractTargetEditor;
import alma.obsprep.ot.editors.sciencegoals.FieldSetupEditor;
import alma.obsprep.ot.editors.spectralvisual.ScienceViewSpectralVisualEditor;
import alma.obsprep.ot.models.obsproject.CalibratedGoalModel;
import alma.obsprep.ot.models.obsproject.CalibrationSetupParametersModel;
import alma.obsprep.ot.models.sciencegoals.FieldSetupModel;
import alma.obsprep.ot.models.sciencegoals.SfiControlParameterModel;
import alma.obsprep.ot.models.sciencegoals.SgNoteModel;
import alma.obsprep.ot.models.sciencegoals.SpectralSetupParametersModel;
import alma.obsprep.ot.models.sciencegoals.TechnicalJustificationModel;
import alma.obsprep.ot.models.spectralvisual.TargetParametersTableModel;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.ConfigurationSet;
import alma.obsprep.services.experts.InvalidConfigurationParametersException;
import alma.obsprep.services.experts.SchedBlockExpert;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.sfi.SingleFieldScienceGoalEditor;
import alma.obsprep.util.FrequencyRange;
import alma.obsprep.util.VupRange;
import alma.valuetypes.Frequency;
import alma.valuetypes.UserFrequency;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.Timer;

public class SingleFieldScienceGoalModel
extends Model
implements CalibratedGoalModel,
ModelChangeSubscriber {
    public static final FieldID EDITOR_SUBVIEW_FID = new FieldID("SingleFieldScienceGoalModel.editorSubview");
    private SingleFieldScienceGoalEditor.ScienceGoalEditorSubviews currentSubview = null;
    private final SgNoteModel sgNoteModel = new SgNoteModel(null);
    private final FieldSetupModel sgFieldSetupModel = new FieldSetupModel(null);
    private final SpectralSetupParametersModel spectralSetupParametersModel = new SpectralSetupParametersModel(null);
    private final SfiControlParameterModel sfiControlParameterModel = new SfiControlParameterModel(null);
    private final CalibrationSetupParametersModel calibratorsModel = new CalibrationSetupParametersModel(null);
    private final TargetParametersTableModel targetParametersTableModel = new TargetParametersTableModel(null);
    private final TechnicalJustificationModel technicalJustificationModel = new TechnicalJustificationModel(null);
    private boolean timerActive = false;
    private SpectralSpecDocument context;
    private ScienceGoal scienceGoal;

    public SingleFieldScienceGoalModel(Object object2) {
        super(object2);
        this.setDocument(object2);
        this.registerSubModel(this.sgNoteModel);
        this.registerSubModel(this.sgFieldSetupModel);
        this.registerSubModel(this.spectralSetupParametersModel);
        this.registerSubModel(this.sfiControlParameterModel);
        this.registerSubModel(this.calibratorsModel);
        this.registerSubModel(this.technicalJustificationModel);
        this.spectralSetupParametersModel.rsubscribe(new ModelChangeSubscriber(){

            @Override
            public void modelChanged(Model model, FieldID fieldID, Object object) {
                if (fieldID == ScienceViewSpectralVisualEditor.FID_VISUALPANEL) {
                    SingleFieldScienceGoalModel.this.publish(fieldID, null);
                }
                if (fieldID == ScienceViewSpectralVisualEditor.OVERLAY_LINES_SELECTED_FID) {
                    SingleFieldScienceGoalModel.this.publish(fieldID, object);
                }
            }
        });
        this.sgFieldSetupModel.subscribe(new ModelChangeSubscriber(){

            @Override
            public void modelChanged(Model model, FieldID fieldID, Object object) {
                ScienceGoal scienceGoal;
                if (FieldSetupEditor.FID_TABBEDPANE.equals(fieldID) && object instanceof ScienceGoal && (scienceGoal = (ScienceGoal)object).getTargetParametersCount() > 0) {
                    TargetParameters targetParameters = scienceGoal.getTargetParameters(0);
                    SingleFieldScienceGoalModel.this.calibratorsModel.setDefaultSearchPosition(targetParameters);
                }
            }
        });
        ModelChangeSubscriber modelChangeSubscriber = (model, fieldID, object) -> this.scheduleScienceGoalModeCheck();
        ModelChangeSubscriber modelChangeSubscriber2 = new ModelChangeSubscriber(){
            String oldUnit = null;
            String oldVelocity = null;

            @Override
            public void modelChanged(Model model, FieldID fieldID, Object object) {
                if (fieldID.equals(AbstractTargetEditor.FID_SOURCEVELOCITY_VALUE) || fieldID.equals(AbstractTargetEditor.FID_SOURCEVELOCITY_UNIT)) {
                    String string;
                    if (fieldID.equals(AbstractTargetEditor.FID_SOURCEVELOCITY_VALUE)) {
                        string = (String)object;
                        if (this.oldVelocity == null) {
                            this.oldVelocity = string;
                            return;
                        }
                        if (this.oldVelocity.equals(string)) {
                            return;
                        }
                        this.oldVelocity = string;
                    }
                    if (fieldID.equals(AbstractTargetEditor.FID_SOURCEVELOCITY_UNIT)) {
                        string = (String)object;
                        if (this.oldUnit == null) {
                            this.oldUnit = string;
                            return;
                        }
                        if (this.oldUnit.equals(string)) {
                            return;
                        }
                        this.oldUnit = string;
                    }
                    SingleFieldScienceGoalModel.this.spectralSetupParametersModel.publishRepSpectralWindow();
                }
            }
        };
        this.sgFieldSetupModel.getTargetParametersModel().rsubscribe(modelChangeSubscriber2);
        this.calibratorsModel.rsubscribe(modelChangeSubscriber);
        this.sgFieldSetupModel.rsubscribe(modelChangeSubscriber);
        this.spectralSetupParametersModel.rsubscribe(modelChangeSubscriber);
        this.sfiControlParameterModel.rsubscribe(modelChangeSubscriber);
    }

    private void scheduleScienceGoalModeCheck() {
        if (!this.timerActive) {
            this.timerActive = true;
            Timer timer = new Timer(100, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SingleFieldScienceGoalModel.this.timerActive = false;
                    SingleFieldScienceGoalModel.this.determineScienceGoalObservingMode();
                    SingleFieldScienceGoalModel.this.setACAselection();
                }
            });
            timer.setRepeats(false);
            timer.start();
        }
    }

    private void setACAselection() {
        this.sfiControlParameterModel.setACAScheduling();
    }

    private void determineScienceGoalObservingMode() {
        this.scienceGoal = this.getScienceGoal();
        if (this.scienceGoal == null) {
            return;
        }
        String string = this.scienceGoal.getMode();
        EnumSet<NonStandardMode> enumSet = null;
        try {
            enumSet = SingleFieldScienceGoalModel.establishNonStandardObservingModes(this.scienceGoal);
        }
        catch (UnableToDetermineObservingModesException unableToDetermineObservingModesException) {
            this.scienceGoal.setMode(ScienceGoal.MODE_STANDARD);
            return;
        }
        assert (enumSet != null);
        String string2 = null;
        string2 = enumSet.isEmpty() ? ScienceGoal.MODE_STANDARD : ScienceGoal.MODE_OTHER;
        assert (string2 != null);
        if (!string.equals(string2)) {
            this.scienceGoal.setMode(string2);
        }
    }

    public static EnumSet<NonStandardMode> establishNonStandardObservingModes(ScienceGoal scienceGoal) throws UnableToDetermineObservingModesException {
        Object object;
        boolean bl = false;
        if (scienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: scienceGoal");
        }
        boolean bl2 = scienceGoal.isStandAloneACA();
        EnumSet<NonStandardMode> enumSet = EnumSet.noneOf(NonStandardMode.class);
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        assert (performanceParameters != null);
        SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
        assert (spectralSetupParameters != null);
        TargetParameters[] targetParametersArray = scienceGoal.getTargetParameters();
        assert (targetParametersArray != null);
        ReceiverBand receiverBand = spectralSetupParameters.getReceiverBand();
        if (receiverBand == null) {
            throw new UnableToDetermineObservingModesException("Unable to determine receiver band");
        }
        if (ReceiverBand.isReceiverBandInSet(receiverBand, 9, 10)) {
            Log.logger(SingleFieldScienceGoalModel.class).fine(scienceGoal.getName() + " is experimental as we are using bands [9,10]");
            enumSet.add(NonStandardMode.EXPERIMENTAL_RECEIVERBANDS);
        }
        try {
            object = scienceGoal.getObsProposal();
            if (object == null) {
                Log.logger(SingleFieldScienceGoalModel.class).info("Unable to determine obsProposal for science goal");
            } else if (((ObsProposal)((Object)object)).isVLBI()) {
                bl = true;
                Log.logger(SingleFieldScienceGoalModel.class).fine(scienceGoal.getName() + " is experimental as it is a VLBI proposal");
                enumSet.add(NonStandardMode.VLBI_MODE);
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(SingleFieldScienceGoalModel.class).info("Unable to determine obsProposal for science goal");
        }
        try {
            if (scienceGoal.isSolarScienceGoal()) {
                enumSet.add(NonStandardMode.SOLAR_MODE);
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(SingleFieldScienceGoalModel.class).info("Unable to determine if this is a solar science goal : " + unknownEntityException.getMessage());
        }
        if (SpectralSetupParameters.POLARISATION_FULL.equals(spectralSetupParameters.getPolarisation())) {
            Log.logger(SingleFieldScienceGoalModel.class).fine(scienceGoal.getName() + " is experimental as it's full polarization");
            enumSet.add(NonStandardMode.FULL_POLARIZATION);
        }
        if (SpectralSetupParameters.TYPE_SCAN.equals(spectralSetupParameters.getType())) {
            Log.logger(SingleFieldScienceGoalModel.class).fine(scienceGoal.getName() + " is experimental as it's a spectral scan");
            enumSet.add(NonStandardMode.SPECTRAL_SCAN);
        }
        if (!(bl || bl2 || ReceiverBand.isReceiverBandInSet(receiverBand, 3, 4, 5, 6))) {
            object = null;
            try {
                object = SchedBlockExpert.getRecommended12mConfigurations(scienceGoal, performanceParameters.getRepresentativeFrequency());
            }
            catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
                return enumSet;
            }
            Configuration configuration = ((SchedBlockExpert.RequiredConfigurations)object).getBest12mExtConfig();
            try {
                if (receiverBand.getNumber() == 7 && ConfigurationSet.isConfigurationInSet(configuration, RequestedArray.TWELVE_M, "C43-8", "C43-9") || ReceiverBand.isReceiverBandInSet(receiverBand, 8, 9, 10) && ConfigurationSet.isConfigurationInSet(configuration, RequestedArray.TWELVE_M, "C43-7", "C43-8", "C43-9")) {
                    Log.logger(SingleFieldScienceGoalModel.class).fine(String.format("Receiver band %d with the configuration %s is considered non-standard", receiverBand.getNumber(), configuration.getMaxBaseline()));
                    enumSet.add(NonStandardMode.LONGBASELINE_CONFIGURATION);
                }
            }
            catch (Configuration.UnableToDetermineConfigurationException unableToDetermineConfigurationException) {
                Log.logger(SingleFieldScienceGoalModel.class).info("Unable to determine band/configuration non-standard science goal constraint : " + unableToDetermineConfigurationException.getMessage());
            }
        }
        if (scienceGoal.getCalibrationSetupParameters().isUserDefinedCalibration()) {
            Log.logger(SingleFieldScienceGoalModel.class).fine("User defined calibration strategy is an experimental setup");
            enumSet.add(NonStandardMode.USERDEFINED_CALIBRATION);
        }
        if (SingleFieldScienceGoalModel.isNarrowBWScienceGoal(scienceGoal)) {
            enumSet.add(NonStandardMode.BANDWIDTH_SWITCHING);
        }
        return enumSet;
    }

    public static boolean isNarrowBWScienceGoal(ScienceGoal scienceGoal) {
        Frequency frequency = Frequency.createFrequencyGHZ(1.0);
        if (scienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: scienceGoal");
        }
        SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
        if (SpectralSetupParameters.TYPE_FULL.equals(spectralSetupParameters.getType()) || SpectralSetupParameters.TYPE_CONTINUUM.equals(spectralSetupParameters.getType())) {
            Object object = UserFrequency.createUserFrequency();
            ArrayList<VupRange> arrayList = new ArrayList<VupRange>();
            for (ScienceSpectralWindow scienceSpectralWindow : spectralSetupParameters.getScienceSpectralWindow()) {
                arrayList.add(FrequencyRange.fastCentredOn(scienceSpectralWindow.getCenterFrequency(), scienceSpectralWindow.getEffectiveBandwidth()));
            }
            List<VupRange> list = FrequencyRange.aggregate(arrayList);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                VupRange vupRange = (VupRange)iterator.next();
                object = (Frequency)object.plus((AbstractDoubleWithUnit)((Frequency)((Object)vupRange.range())));
            }
            if (object.isLessThan((AbstractDoubleWithUnit)frequency)) {
                Log.logger(SingleFieldScienceGoalModel.class).fine(scienceGoal.getName() + " is experimental: bandwidth switching detected - aggregate BW is " + object);
                return true;
            }
        } else if (SpectralSetupParameters.TYPE_SCAN.equals(spectralSetupParameters.getType())) {
            SpectralScan.SpectralScanTunings spectralScanTunings = null;
            SpectralScan spectralScan = spectralSetupParameters.getSpectralScan();
            try {
                spectralScanTunings = spectralScan.getTunings();
            }
            catch (UnableToFindSolutionException unableToFindSolutionException) {
                // empty catch block
            }
            FrequencyRange frequencyRange = null;
            try {
                frequencyRange = spectralScanTunings.getAchievedScanRange();
            }
            catch (SpectralScan.SpectralScanTunings.SpectralScanTuningException spectralScanTuningException) {
                // empty catch block
            }
            if (frequencyRange != null && ((Frequency)((Object)frequencyRange.range())).isLessThan((AbstractDoubleWithUnit)frequency)) {
                Log.logger(SingleFieldScienceGoalModel.class).fine("Bandwidth switching science goal detected: aggregate BW in scan is less than 1 GHz");
                return true;
            }
        }
        return false;
    }

    @Override
    public void publish() {
        if (this.document == null) {
            return;
        }
    }

    @Override
    public CalibrationSetupParametersModel getCalibrationSetupParametersModel() {
        return this.calibratorsModel;
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        if (ScienceViewSpectralVisualEditor.OVERLAY_LINES_SELECTED_FID.equals(fieldID)) {
            this.spectralSetupParametersModel.update(editor, fieldID, object);
        }
        return object;
    }

    public static SingleFieldScienceGoalEditor.ScienceGoalEditorSubviews getScienceGoalSubview(ScienceGoal scienceGoal) throws UnableToDetermineSubviewException {
        if (scienceGoal == null) {
            throw new UnableToDetermineSubviewException();
        }
        try {
            ObsProposal obsProposal = scienceGoal.getObsProposal();
            if (obsProposal != null && obsProposal.isVLBI()) {
                return SingleFieldScienceGoalEditor.ScienceGoalEditorSubviews.VLBI;
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(SingleFieldScienceGoalModel.class).info("Unable to determine if science goal is VLBI " + unknownEntityException.getMessage());
        }
        boolean bl = false;
        try {
            bl = scienceGoal.isSolarScienceGoal();
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(SingleFieldScienceGoalModel.class).info("Unable to determine if the SG is Solar: " + unknownEntityException.getMessage());
        }
        if (bl) {
            return SingleFieldScienceGoalEditor.ScienceGoalEditorSubviews.SOLAR;
        }
        return SingleFieldScienceGoalEditor.ScienceGoalEditorSubviews.DEFAULTVIEW;
    }

    public SgNoteModel getSgNoteModel() {
        return this.sgNoteModel;
    }

    public CalibrationSetupParametersModel getObservatoryGoalTargetsModel() {
        return this.calibratorsModel;
    }

    public SfiControlParameterModel getSfiControlParameterModel() {
        return this.sfiControlParameterModel;
    }

    public FieldSetupModel getSgFieldSetupModel() {
        return this.sgFieldSetupModel;
    }

    public SpectralSetupParametersModel getSpectralSetupParametersModel() {
        return this.spectralSetupParametersModel;
    }

    public TargetParametersTableModel getTargetParametersTableModel() {
        return this.targetParametersTableModel;
    }

    public TechnicalJustificationModel getTechnicalJustificationModel() {
        return this.technicalJustificationModel;
    }

    public void setPage(int n) {
    }

    private ScienceGoal getScienceGoal() {
        if (this.document instanceof ScienceGoal) {
            return (ScienceGoal)this.document;
        }
        return null;
    }

    @Override
    public void setDocument(Object object) {
        Object object2 = object;
        if (object instanceof WorkbookPage) {
            object2 = ((WorkbookPage)object).getParent();
        }
        this.document = object2;
        ScienceGoal scienceGoal = this.getScienceGoal();
        if (scienceGoal != null) {
            this.targetParametersTableModel.setDocument(scienceGoal);
            this.sgNoteModel.setDocument(scienceGoal);
            this.sfiControlParameterModel.setModelInTransitionState(true);
            this.spectralSetupParametersModel.setDocument((Object)scienceGoal.getSpectralSetupParameters());
            this.sgFieldSetupModel.setDocument(scienceGoal);
            this.sfiControlParameterModel.setModelInTransitionState(false);
            this.sfiControlParameterModel.setDocument(scienceGoal.getPerformanceParameters());
            this.calibratorsModel.setDocument((Object)scienceGoal.getCalibrationSetupParameters());
            this.technicalJustificationModel.setonlyDocument(scienceGoal);
        }
        this.publish();
        try {
            SingleFieldScienceGoalEditor.ScienceGoalEditorSubviews scienceGoalEditorSubviews = SingleFieldScienceGoalModel.getScienceGoalSubview(scienceGoal);
            if (scienceGoalEditorSubviews != this.currentSubview) {
                this.publish(EDITOR_SUBVIEW_FID, (Object)scienceGoalEditorSubviews);
                this.currentSubview = scienceGoalEditorSubviews;
            }
        }
        catch (UnableToDetermineSubviewException unableToDetermineSubviewException) {
            // empty catch block
        }
    }

    public SpectralSpecDocument getContext() {
        return this.context;
    }

    @Override
    public void modelChanged(Model model, FieldID fieldID, Object object) {
        if (fieldID == AbstractTargetEditor.FID_SOLARSYSTEMOBJECT || fieldID == ObsProposalEditor.PROPOSALTYPE_FID) {
            try {
                ScienceGoal scienceGoal = (ScienceGoal)this.getDocument();
                if (scienceGoal != null) {
                    this.getSfiControlParameterModel().setonlyDocument(scienceGoal.getPerformanceParameters());
                    SingleFieldScienceGoalEditor.ScienceGoalEditorSubviews scienceGoalEditorSubviews = SingleFieldScienceGoalModel.getScienceGoalSubview(scienceGoal);
                    this.publish(EDITOR_SUBVIEW_FID, (Object)scienceGoalEditorSubviews);
                }
            }
            catch (UnableToDetermineSubviewException unableToDetermineSubviewException) {
                return;
            }
        }
    }

    public static class UnableToDetermineObservingModesException
    extends Exception {
        public UnableToDetermineObservingModesException(String string) {
            super(string);
        }
    }

    public static enum NonStandardMode {
        EXPERIMENTAL_RECEIVERBANDS("One of band 9 or 10 has been selected."),
        FULL_POLARIZATION("Full polarization has been requested."),
        SPECTRAL_SCAN("A spectral scan has been requested."),
        LONGBASELINE_CONFIGURATION("Band 7 or higher has been paired with its largest allowed configuration."),
        USERDEFINED_CALIBRATION("A user-defined calibration strategy has been selected."),
        BANDWIDTH_SWITCHING("The aggregate bandwidth for the spectral setup is less than 1 GHz."),
        VLBI_MODE("This is a VLBI project"),
        SOLAR_MODE("Solar observing has been requested");

        private String explanation;

        private NonStandardMode(String string2) {
            this.explanation = string2;
        }

        public String getExplanation() {
            return this.explanation;
        }
    }

    public static class UnableToDetermineSubviewException
    extends Exception {
    }
}

