/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.submission;

import alma.obsprep.services.submission.Data;
import alma.obsprep.services.submission.NullResolver;
import alma.obsprep.services.submission.RemoteProgressListener;
import com.sunsetbrew.csv4180.CSVReader;
import com.sunsetbrew.csv4180.CSVWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Codecs {

    public static class ResponseDecoder {
        byte[] response;

        public ResponseDecoder(byte[] byArray) {
            this.response = byArray;
        }

        public byte[] decodeAsFile() {
            return this.response;
        }

        public String decodeAsHtml() {
            if (this.response == null || this.response.length == 0) {
                return new String();
            }
            return new String(this.response);
        }

        public String decodeAsString() {
            if (this.response == null || this.response.length == 0) {
                return new String();
            }
            return new String(this.response);
        }

        public String[][] decodeAsCsv() throws IOException {
            String[][] stringArray;
            if (this.response == null || this.response.length == 0) {
                return new String[0][];
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.response);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)byteArrayInputStream, "utf-8");
            CSVReader cSVReader = new CSVReader((Reader)inputStreamReader);
            ArrayList<String[][]> arrayList = new ArrayList<String[][]>();
            ArrayList arrayList2 = new ArrayList();
            while (!cSVReader.isEOF()) {
                cSVReader.readFields(arrayList2);
                stringArray = new String[arrayList2.size()];
                arrayList2.toArray((T[])stringArray);
                arrayList.add(stringArray);
            }
            cSVReader.close();
            stringArray = new String[arrayList.size()][];
            arrayList.toArray((T[])stringArray);
            return stringArray;
        }

        public String[] decodeAsXml() throws IOException {
            if (this.response == null || this.response.length == 0) {
                return new String[0];
            }
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.response);
                MimeMessage mimeMessage = new MimeMessage((Session)null, (InputStream)byteArrayInputStream);
                if (!(mimeMessage.getContent() instanceof Multipart)) {
                    return new String[0];
                }
                Multipart multipart = (Multipart)mimeMessage.getContent();
                String[] stringArray = new String[multipart.getCount()];
                for (int i = 0; i < stringArray.length; ++i) {
                    BodyPart bodyPart = multipart.getBodyPart(i);
                    Object object = bodyPart.getContent();
                    if (object instanceof StreamSource) {
                        try {
                            Document document = ResponseDecoder.readXml((StreamSource)object);
                            stringArray[i] = ResponseDecoder.getStringFromDocument(document);
                            continue;
                        }
                        catch (SAXException sAXException) {
                            throw new IOException(sAXException);
                        }
                        catch (ParserConfigurationException parserConfigurationException) {
                            throw new IOException(parserConfigurationException);
                        }
                        catch (TransformerException transformerException) {
                            throw new IOException(transformerException);
                        }
                    }
                    stringArray[i] = bodyPart.getContent().toString();
                }
                return stringArray;
            }
            catch (MessagingException messagingException) {
                throw new IOException(messagingException);
            }
        }

        private static Document readXml(StreamSource streamSource) throws SAXException, IOException, ParserConfigurationException {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            documentBuilderFactory.setIgnoringComments(false);
            documentBuilderFactory.setIgnoringElementContentWhitespace(true);
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = null;
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(new NullResolver());
            InputSource inputSource = new InputSource();
            inputSource.setSystemId(streamSource.getSystemId());
            inputSource.setByteStream(streamSource.getInputStream());
            inputSource.setCharacterStream(streamSource.getReader());
            return documentBuilder.parse(inputSource);
        }

        private static String getStringFromDocument(Document document) throws TransformerException {
            DOMSource dOMSource = new DOMSource(document);
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.transform(dOMSource, streamResult);
            return stringWriter.toString();
        }
    }

    public static class ResponseEncoder {
        public void send(String[] mimeMessage, HttpServletResponse httpServletResponse) throws IOException {
            try {
                ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                if (((String[])mimeMessage).length > 0) {
                    int n = 0;
                    MimeMultipart mimeMultipart = new MimeMultipart();
                    for (String string : mimeMessage) {
                        MimeBodyPart mimeBodyPart = new MimeBodyPart();
                        mimeBodyPart.setContent((Object)string, "text/xml; charset=utf-8");
                        mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
                        n += string.length();
                    }
                    httpServletResponse.setContentType("multi-part/mime");
                    MimeMessage mimeMessage2 = new MimeMessage((Session)null);
                    mimeMessage2.setContent((Multipart)mimeMultipart);
                    mimeMessage2.writeTo((OutputStream)servletOutputStream);
                }
                servletOutputStream.flush();
            }
            catch (MessagingException messagingException) {
                throw new IOException(messagingException);
            }
        }

        public void send(byte[] byArray, HttpServletResponse httpServletResponse) throws IOException {
            httpServletResponse.setContentType("x-application/aot-file");
            httpServletResponse.setContentLength(byArray.length);
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            servletOutputStream.write(byArray);
            servletOutputStream.flush();
        }

        public void send(String string, HttpServletResponse httpServletResponse) throws IOException {
            httpServletResponse.setContentType("text/html");
            httpServletResponse.setContentLength(string.length());
            PrintWriter printWriter = httpServletResponse.getWriter();
            printWriter.print(string);
            printWriter.flush();
        }

        public void sendJson(String string, HttpServletResponse httpServletResponse) throws IOException {
            httpServletResponse.setContentType("application/json");
            httpServletResponse.setCharacterEncoding("UTF-8");
            httpServletResponse.setContentLength(string.getBytes("UTF-8").length);
            PrintWriter printWriter = httpServletResponse.getWriter();
            printWriter.print(string);
            printWriter.flush();
        }

        public void send(String[][] stringArray, HttpServletResponse httpServletResponse) throws IOException {
            httpServletResponse.setContentType("text/plain");
            httpServletResponse.setCharacterEncoding("UTF-8");
            PrintWriter printWriter = httpServletResponse.getWriter();
            CSVWriter cSVWriter = new CSVWriter((Writer)printWriter);
            for (String[] stringArray2 : stringArray) {
                cSVWriter.writeFields(stringArray2);
            }
            cSVWriter.close();
            printWriter.flush();
        }
    }

    public static class PostDecoder {
        List<FileItem> fileItems;
        Hashtable<String, String> strings;
        Map<?, ?> parameters;

        public void receive(HttpServletRequest httpServletRequest) throws IOException {
            try {
                this.parameters = httpServletRequest.getParameterMap();
                this.fileItems = new ArrayList<FileItem>();
                this.strings = new Hashtable();
                if (!ServletFileUpload.isMultipartContent((HttpServletRequest)httpServletRequest)) {
                    throw new FileUploadException("not a multipart-request");
                }
                DiskFileItemFactory diskFileItemFactory = new DiskFileItemFactory();
                ServletFileUpload servletFileUpload = new ServletFileUpload((FileItemFactory)diskFileItemFactory);
                List list = servletFileUpload.parseRequest(httpServletRequest);
                for (FileItem fileItem : list) {
                    if (fileItem.isFormField()) {
                        String string = fileItem.getFieldName();
                        String string2 = fileItem.getString();
                        this.strings.put(string, string2);
                        continue;
                    }
                    this.fileItems.add(fileItem);
                }
            }
            catch (FileUploadException fileUploadException) {
                throw new IOException(fileUploadException);
            }
        }

        public List<File> writeFiles(File file) throws Exception {
            ArrayList<File> arrayList = new ArrayList<File>();
            for (FileItem fileItem : this.fileItems) {
                String string = fileItem.getName();
                File file2 = new File(file, string);
                fileItem.write(file2);
                System.out.println("written file " + file2.getAbsolutePath());
                arrayList.add(file2);
            }
            return arrayList;
        }

        public String get(String string) {
            return this.strings.get(string);
        }

        public String getParameter(String string) {
            Object obj = this.parameters.get(string);
            return obj == null ? null : obj.toString();
        }
    }

    public static class PostEncoder {
        Header userAgentHeader;
        String urlString;
        ArrayList<Part> partsV = new ArrayList();
        int statusCode;
        byte[] response;

        public PostEncoder(String string, String string2) {
            this.urlString = string;
            this.userAgentHeader = new Header("User-Agent", string2);
        }

        public void add(File file) throws FileNotFoundException {
            this.partsV.add((Part)new FilePart(file.getName(), file));
        }

        public void add(String string, String string2) {
            this.partsV.add((Part)new StringPart(string, string2, "utf-8"));
        }

        public void send_resimplified(String string, String string2, String string3) throws HttpException, IOException {
            String string4 = "";
            if (string != null) {
                string4 = string4 + "?action=" + string;
            }
            PostMethod postMethod = new PostMethod(this.urlString + string4);
            postMethod.setRequestHeader(this.userAgentHeader);
            Part[] partArray = this.partsV.toArray(new Part[this.partsV.size()]);
            postMethod.setRequestEntity((RequestEntity)new MultipartRequestEntity(partArray, postMethod.getParams()));
            HttpClientParams httpClientParams = new HttpClientParams();
            httpClientParams.setConnectionManagerTimeout(30000L);
            httpClientParams.setSoTimeout(180000);
            if (string2 != null && string3 != null) {
                httpClientParams.setAuthenticationPreemptive(true);
            }
            HttpClient httpClient = new HttpClient(httpClientParams);
            if (string2 != null && string3 != null) {
                UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials(string2, string3);
                httpClient.getState().setCredentials(new AuthScope(AuthScope.ANY), (Credentials)usernamePasswordCredentials);
            }
            this.statusCode = httpClient.executeMethod((HttpMethod)postMethod);
            this.response = this.statusCode == 401 ? postMethod.getStatusLine().toString().getBytes() : postMethod.getResponseBody();
            postMethod.releaseConnection();
        }

        public void send(String string, String string2, String string3, final RemoteProgressListener remoteProgressListener) throws HttpException, IOException {
            String string4 = "?action=" + string;
            PostMethod postMethod = new PostMethod(this.urlString + string4){
                private Set<Data.PartialReplyData> receivedData;
                {
                    super(string);
                    this.receivedData = new HashSet<Data.PartialReplyData>();
                }

                public void processResponseHeaders(HttpState httpState, HttpConnection httpConnection) {
                    super.processResponseHeaders(httpState, httpConnection);
                    int n = this.statusLine.getStatusCode();
                    Header[] headerArray = this.getResponseHeaders();
                    if (n == 120) {
                        Data.PartialReplyData partialReplyData = new Data.PartialReplyData();
                        for (int i = 0; i < headerArray.length; ++i) {
                            Header header = headerArray[i];
                            if (header.getName().equals("OT-progress-message")) {
                                partialReplyData.message = header.getValue();
                                continue;
                            }
                            if (header.getName().equals("OT-progress-total")) {
                                partialReplyData.totalSteps = Integer.parseInt(header.getValue());
                                continue;
                            }
                            if (!header.getName().equals("OT-progress-current")) continue;
                            partialReplyData.currentStep = Integer.parseInt(header.getValue());
                        }
                        if (!this.receivedData.contains(partialReplyData)) {
                            remoteProgressListener.remoteProgress(partialReplyData.currentStep, partialReplyData.totalSteps, partialReplyData.message);
                            this.receivedData.add(partialReplyData);
                        }
                    }
                }
            };
            postMethod.setRequestHeader(this.userAgentHeader);
            Part[] partArray = this.partsV.toArray(new Part[this.partsV.size()]);
            postMethod.setRequestEntity((RequestEntity)new MultipartRequestEntity(partArray, postMethod.getParams()));
            HttpClientParams httpClientParams = new HttpClientParams();
            httpClientParams.setConnectionManagerTimeout(30000L);
            httpClientParams.setSoTimeout(180000);
            httpClientParams.setAuthenticationPreemptive(true);
            HttpClient httpClient = new HttpClient(httpClientParams);
            UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials(string2, string3);
            httpClient.getState().setCredentials(new AuthScope(AuthScope.ANY), (Credentials)usernamePasswordCredentials);
            this.statusCode = httpClient.executeMethod((HttpMethod)postMethod);
            this.response = this.statusCode == 401 ? postMethod.getStatusLine().toString().getBytes() : postMethod.getResponseBody();
            postMethod.releaseConnection();
        }

        public boolean isOk() {
            return this.statusCode == 200;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public byte[] getResponse() {
            return this.response;
        }
    }
}

