/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.summaryfeedback;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.ot.models.sciencegoals.AngularResolutionMode;
import alma.obsprep.ot.models.sciencegoals.AngularResolutionProviderInterface;
import alma.obsprep.ot.models.sciencegoals.SfiControlParameterModel;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.InvalidConfigurationParametersException;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.summaryfeedback.SensitivityTableData;
import alma.obsprep.services.summaryfeedback.SummaryTableCellRendererFactory;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.UserAngle;
import alma.valuetypes.UserSensitivity;
import java.util.ArrayList;
import java.util.Arrays;

public class ARRangeSensitivityRenderer
extends SummaryTableCellRendererFactory.SummaryTableCellRenderer {
    private final String fluxFormat;
    private final String tempFormat;

    public ARRangeSensitivityRenderer(String string, String string2) {
        this.fluxFormat = string;
        this.tempFormat = string2;
    }

    @Override
    String format(Object object) {
        if (object == null || !(object instanceof SensitivityTableData)) {
            return "Undefined";
        }
        SummaryTableCellRendererFactory summaryTableCellRendererFactory = new SummaryTableCellRendererFactory();
        SummaryTableCellRendererFactory.SummaryTableCellRenderer summaryTableCellRenderer = summaryTableCellRendererFactory.getSensitivityARRangeRenderer(this.fluxFormat, this.tempFormat);
        SummaryTableCellRendererFactory.SummaryTableCellRenderer summaryTableCellRenderer2 = summaryTableCellRendererFactory.getSensitivityRenderer(this.fluxFormat, this.tempFormat);
        SensitivityTableData sensitivityTableData = (SensitivityTableData)object;
        ScienceGoal scienceGoal = sensitivityTableData.getScienceGoal();
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        UserSensitivity userSensitivity = sensitivityTableData.getSensitivity().deepCopy();
        UserSensitivity userSensitivity2 = sensitivityTableData.getSensitivity().deepCopy();
        AngularResolutionMode angularResolutionMode = performanceParameters.getAngularResolutionMode();
        UserAngle userAngle = performanceParameters.getDesiredAngularResolution();
        switch (angularResolutionMode) {
            case Any: 
            case Range: {
                UserAngle userAngle2;
                UserAngle userAngle3 = null;
                try {
                    userAngle2 = SfiControlParameterModel.getARForFirstSensitivityFeedbackField(UserSensitivity.USERUNIT_JY, performanceParameters);
                    userAngle3 = SfiControlParameterModel.getARForSecondSensitivityFeedbackField(UserSensitivity.USERUNIT_JY, performanceParameters);
                }
                catch (AngularResolutionProviderInterface.UnableToDetermineResolutionsException unableToDetermineResolutionsException) {
                    Log.logger(ARRangeSensitivityRenderer.class).warning("Unable to get ARs " + unableToDetermineResolutionsException.getMessage());
                    return "Unknown";
                }
                assert (userAngle2 != null && userAngle3 != null);
                userSensitivity.setBeamsize((Angle)((Object)userAngle2));
                userSensitivity2.setBeamsize((Angle)((Object)userAngle3));
                return summaryTableCellRenderer.format(new ArrayList<UserSensitivity>(Arrays.asList(userSensitivity, userSensitivity2)));
            }
            case SACA: {
                UserAngle userAngle4;
                try {
                    Configuration configuration = Configuration.MOST_COMPACT.get((Object)RequestedArray.SEVEN_M);
                    Frequency frequency = scienceGoal.getRepresentativeFrequencyInSky();
                    userAngle4 = UserAngle.createUserAngle(configuration.getAchievableResolution(frequency.getContentInGHz(), scienceGoal, RequestedArray.SEVEN_M), Angle.UNIT_ARCSEC);
                    userAngle4.setObservingFrequency(frequency);
                }
                catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
                    Log.logger((Object)this).info("Unable to determine configuration for ACA 7-m : " + invalidConfigurationParametersException.getMessage());
                    return "Undefined";
                }
                userSensitivity.setBeamsize((Angle)((Object)userAngle4));
                return summaryTableCellRenderer2.format(userSensitivity);
            }
            case Single: {
                userSensitivity.setBeamsize((Angle)((Object)userAngle));
                return summaryTableCellRenderer2.format(userSensitivity);
            }
        }
        throw new RuntimeException("Unknown AR mode " + angularResolutionMode);
    }
}

