/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.summaryfeedback;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.services.etc.ObservingTimeCalculator;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.ToBeSupportedException;
import alma.obsprep.services.summaryfeedback.ScienceGoalSummaryParameters;
import alma.obsprep.services.summaryfeedback.TargetSummary;
import alma.obsprep.services.summaryfeedback.TargetSummaryOTFTP;
import alma.obsprep.services.summaryfeedback.TargetSummarySynthesis;
import alma.valuetypes.DataRate;
import alma.valuetypes.StorageVolume;
import alma.valuetypes.Time;

@Deprecated
public abstract class AbstractTargetSummary
implements TargetSummary {
    protected Array array;
    protected ScienceGoal sg;
    protected ObservingTimeCalculator timeCalculator;

    protected AbstractTargetSummary(ScienceGoal scienceGoal, Array array) {
        this.array = array;
        this.setScienceGoal(scienceGoal);
    }

    public static AbstractTargetSummary createTargetsummary(ScienceGoal scienceGoal, Array array, ScienceGoalSummaryParameters.ScanType scanType) {
        if (scanType == ScienceGoalSummaryParameters.ScanType.SMI) {
            return new TargetSummarySynthesis(scienceGoal, array);
        }
        if (scanType == ScienceGoalSummaryParameters.ScanType.OTF) {
            return new TargetSummaryOTFTP(scienceGoal, array);
        }
        throw new IllegalArgumentException("Unknown Scan Type : " + (Object)((Object)scanType));
    }

    @Override
    public void setScienceGoal(ScienceGoal scienceGoal) {
        this.sg = scienceGoal;
        this.timeCalculator = new ObservingTimeCalculator(scienceGoal);
    }

    protected ScienceGoal getScienceGoal() {
        return this.sg;
    }

    public abstract Time getTotalObservingTimeOnSource() throws InvalidObsProgramParametersException, ToBeSupportedException;

    @Override
    public StorageVolume getDataVolume() throws InvalidObsProgramParametersException, ToBeSupportedException {
        return this.timeCalculator.getDataVolume(this.array);
    }

    @Override
    public DataRate getDataRate() {
        DataRate dataRate = DataRate.createDataRate();
        try {
            dataRate = this.timeCalculator.getAverageDataRate(this.array);
        }
        catch (ObservingTimeCalculator.UnableToDetermineInstantaneousDataRateException unableToDetermineInstantaneousDataRateException) {
            Log.logger(AbstractTargetSummary.class).warning("Unable to determine data rate " + unableToDetermineInstantaneousDataRateException);
        }
        return dataRate;
    }
}

