/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.summaryfeedback;

import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.services.summaryfeedback.ObsProposalScienceGoalNavigator;
import alma.obsprep.services.summaryfeedback.ScienceGoalPrintable;
import alma.obsprep.services.summaryfeedback.ScienceGoalSummaryModel;
import alma.obsprep.services.summaryfeedback.ScienceGoalSummaryParameters;
import alma.obsprep.services.summaryfeedback.ScienceGoalSummaryView;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;

public class AllScienceGoalsPrintable
implements Printable {
    private List<ScienceGoalSummaryParameters> params = new ArrayList<ScienceGoalSummaryParameters>();
    private List<Integer> totalPages;
    private ScienceGoalPrintable sgPrintable;
    private ObsProposal proposal;
    private ScienceGoalSummaryView offView;
    private JFrame offFrame;
    private ObsProposalScienceGoalNavigator obsProposalScienceGoalNavigator;

    public AllScienceGoalsPrintable(ObsProposal obsProposal) {
        this.obsProposalScienceGoalNavigator = new ObsProposalScienceGoalNavigator(obsProposal, true);
        this.build();
        this.setProposal(obsProposal);
    }

    private void setProposal(ObsProposal obsProposal) {
        this.proposal = obsProposal;
        this.totalPages = null;
        for (ScienceGoal scienceGoal : this.obsProposalScienceGoalNavigator.getScienceGoals()) {
            ScienceGoalSummaryParameters scienceGoalSummaryParameters = new ScienceGoalSummaryParameters(scienceGoal, this.obsProposalScienceGoalNavigator);
            scienceGoalSummaryParameters.collectInfo();
            this.params.add(scienceGoalSummaryParameters);
        }
    }

    private void build() {
        this.offFrame = new JFrame();
        ScienceGoalSummaryModel scienceGoalSummaryModel = new ScienceGoalSummaryModel();
        this.offView = new ScienceGoalSummaryView(scienceGoalSummaryModel);
        scienceGoalSummaryModel.setDocument(new ScienceGoalSummaryParameters());
        this.offFrame.getContentPane().add(this.offView);
        this.offFrame.pack();
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        int n2;
        if (this.totalPages == null) {
            n2 = 0;
            this.totalPages = new ArrayList<Integer>();
            for (ScienceGoalSummaryParameters scienceGoalSummaryParameters : this.params) {
                this.offView.getModel().setDocument(scienceGoalSummaryParameters);
                this.sgPrintable = new ScienceGoalPrintable(this.offView);
                this.offFrame.pack();
                int n3 = this.sgPrintable.maxPages(graphics, pageFormat);
                this.totalPages.add(n2 += n3);
            }
        }
        n2 = 0;
        int n4 = this.totalPages.size();
        while (this.totalPages.get(n2) <= n) {
            if (++n2 != n4) continue;
            return 1;
        }
        this.offView.getModel().setDocument(this.params.get(n2));
        this.sgPrintable = new ScienceGoalPrintable(this.offView);
        int n5 = n - (n2 == 0 ? 0 : this.totalPages.get(n2 - 1));
        this.sgPrintable.print(graphics, pageFormat, n5);
        return 0;
    }
}

