/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.summaryfeedback;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.ot.models.sciencegoals.AngularResolutionMode;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.ConfigurationHelper;
import alma.obsprep.services.experts.InvalidConfigurationParametersException;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.summaryfeedback.SummaryTableCellRendererFactory;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.UserAngle;

public class AngularResolutionRenderer
extends SummaryTableCellRendererFactory.SummaryTableCellRenderer {
    private String format = null;
    private String unit = null;

    AngularResolutionRenderer(String string, String string2) {
        this.format = string;
        this.unit = string2;
    }

    @Override
    String format(Object object) {
        if (object == null || !(object instanceof ScienceGoal)) {
            return "Undefined";
        }
        SummaryTableCellRendererFactory summaryTableCellRendererFactory = new SummaryTableCellRendererFactory();
        SummaryTableCellRendererFactory.SummaryTableCellRenderer summaryTableCellRenderer = summaryTableCellRendererFactory.getVupRenderer(this.format, this.unit);
        ScienceGoal scienceGoal = (ScienceGoal)object;
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        AngularResolutionMode angularResolutionMode = performanceParameters.getAngularResolutionMode();
        UserAngle userAngle = UserAngle.min((UserAngle)performanceParameters.getDesiredAngularResolution(), (UserAngle)performanceParameters.getAcceptableAngularResolution());
        UserAngle userAngle2 = UserAngle.max((UserAngle)performanceParameters.getDesiredAngularResolution(), (UserAngle)performanceParameters.getAcceptableAngularResolution());
        switch (angularResolutionMode) {
            case Any: {
                UserAngle[] userAngleArray = ConfigurationHelper.determineARRangeForARModeAny(scienceGoal);
                assert (userAngleArray.length == 2);
                return summaryTableCellRenderer.format(userAngleArray[0]) + " - " + summaryTableCellRenderer.format(userAngleArray[1]);
            }
            case Range: {
                return summaryTableCellRenderer.format(userAngle2) + " - " + summaryTableCellRenderer.format(userAngle);
            }
            case SACA: {
                UserAngle userAngle3;
                try {
                    Configuration configuration = Configuration.MOST_COMPACT.get((Object)RequestedArray.SEVEN_M);
                    Frequency frequency = scienceGoal.getRepresentativeFrequencyInSky();
                    userAngle3 = UserAngle.createUserAngle(configuration.getAchievableResolution(frequency.getContentInGHz(), scienceGoal, RequestedArray.SEVEN_M), Angle.UNIT_ARCSEC);
                    userAngle3.setObservingFrequency(frequency);
                }
                catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
                    Log.logger((Object)this).info("Unable to determine configuration for ACA 7-m : " + invalidConfigurationParametersException.getMessage());
                    return "Undefined";
                }
                assert (userAngle3 != null);
                return summaryTableCellRenderer.format(userAngle3);
            }
            case Single: {
                return summaryTableCellRenderer.format(userAngle);
            }
        }
        throw new RuntimeException("Unknown AR mode " + angularResolutionMode);
    }
}

