/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.summaryfeedback;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.ot.gui.toplevel.GuiFactory;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.services.summaryfeedback.DefaultPdfExporter;
import alma.obsprep.util.FileUtilities;
import alma.obsprep.util.GUIUtilities;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.Component;
import java.awt.Graphics2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;

public class ConguratulationsDialog {
    private final String timeFormat = "yyyy-MM-dd HH:mm:ss z";
    private JOptionPane optionPane;
    private JComponent messageLabel;
    private boolean isDDT = false;

    public static void showDialog(Component component, ObsProject obsProject) {
        ConguratulationsDialog conguratulationsDialog;
        try {
            conguratulationsDialog = new ConguratulationsDialog(component, obsProject);
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(ConguratulationsDialog.class).warning(unknownEntityException.getMessage());
            return;
        }
        if (conguratulationsDialog.showDialog(component) == 0) {
            conguratulationsDialog.printToPdf();
        }
    }

    private ConguratulationsDialog(Component component, ObsProject obsProject) throws UnknownEntityException {
        if (obsProject == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: project");
        }
        this.isDDT = obsProject.getIsDDT();
        this.build(obsProject);
    }

    private String formatMessage(String string, String string2, String string3, Date date, String string4, String string5) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append("<font size=+1><p>Congratulations!</p></font>");
        stringBuilder.append("<p></p>");
        stringBuilder.append("<p>Your project has been successfully submitted.</p>");
        stringBuilder.append("<p></p>");
        stringBuilder.append("<center><table>");
        stringBuilder.append("<tr><td>PI Name</td><td>").append(string).append("</td></tr>");
        stringBuilder.append("<tr><td>Project Name</td><td>").append(string2).append("</td></tr>");
        stringBuilder.append("<tr><td>Project Code</td><td>").append(string5).append("</td></tr>");
        stringBuilder.append("<tr><td>Date Submitted</td><td>").append(simpleDateFormat.format(date)).append("</td></tr>");
        stringBuilder.append("<tr><td>Internal Project ID</td><td>").append(string4).append("</td></tr>");
        stringBuilder.append("</table></center>");
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    private void build(ObsProject obsProject) throws UnknownEntityException {
        ObsProposal obsProposal = obsProject.getObsProposal();
        String string = obsProposal.getPrincipalInvestigator().getFullName();
        String string2 = obsProject.getProjectName();
        String string3 = obsProject.getVersion();
        Date date = obsProposal.getDateReceived();
        String string4 = obsProject.getEntityID();
        String string5 = obsProject.getCode();
        String string6 = "<html>Do you wish to save this information into a pdf file? </html>";
        this.messageLabel = new JLabel(this.formatMessage(string, string2, string3, date, string4, string5));
        JLabel jLabel = new JLabel(string6);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        jPanel.add(this.messageLabel);
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add(jLabel);
        this.optionPane = new JOptionPane(jPanel, 1, 0);
    }

    private int showDialog(Component component) {
        JDialog jDialog = this.optionPane.createDialog(component, this.isDDT ? "DDT Proposal has been submitted" : "Proposal has been submitted");
        jDialog.setVisible(true);
        Object object = this.optionPane.getValue();
        int n = object == null ? 1 : (Integer)object;
        return n;
    }

    private File outFile() {
        JFileChooser jFileChooser = GuiFactory.getFactory().giveFileChooser(this.getClass());
        FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("PDF file", "pdf");
        jFileChooser.addChoosableFileFilter(fileNameExtensionFilter);
        IntegerHolder integerHolder = new IntegerHolder();
        try {
            SwingUtilities.invokeAndWait(() -> {
                integerHolder.value = jFileChooser.showSaveDialog(null);
            });
        }
        catch (Exception exception) {
            Log.logger((Object)this).warning(exception.getMessage());
            return null;
        }
        if (integerHolder.value == 0 && jFileChooser.getSelectedFile() != null) {
            String string = jFileChooser.getSelectedFile().getAbsolutePath();
            String string2 = FileUtilities.getExtension(string);
            if (string2 == null || !string2.equals("pdf")) {
                string = string + ".pdf";
            }
            File file = new File(string);
            return file;
        }
        return null;
    }

    private void printToPdf() {
        block5: {
            File file = this.outFile();
            if (file != null) {
                Rectangle rectangle = PageSize.A4;
                Document document = new Document(rectangle);
                try {
                    PdfWriter pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(file));
                    document.open();
                    int n = 40;
                    float f = rectangle.getWidth();
                    float f2 = rectangle.getHeight();
                    PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
                    PdfTemplate pdfTemplate = pdfContentByte.createTemplate(f, f2);
                    Graphics2D graphics2D = pdfTemplate.createGraphics(f, f2, DefaultPdfExporter.SWING_FONTMAPPER);
                    this.messageLabel.print(graphics2D);
                    graphics2D.dispose();
                    pdfContentByte.addTemplate(pdfTemplate, (float)n, (float)(-n));
                    document.close();
                }
                catch (DocumentException documentException) {
                    Log.logger((Object)this).warning(documentException.getMessage());
                    GUIUtilities.warning(null, documentException.getMessage());
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Log.logger((Object)this).warning(fileNotFoundException.getMessage());
                    GUIUtilities.warning(null, fileNotFoundException.getMessage());
                }
                catch (ExceptionConverter exceptionConverter) {
                    if (document.getPageNumber() <= 0) break block5;
                    GUIUtilities.warning(null, exceptionConverter.getMessage());
                    Log.logger((Object)this).warning(exceptionConverter.getMessage());
                }
            }
        }
    }

    public static void main(String[] stringArray) throws Exception {
        InitServices.init();
        ObsProject obsProject = ObsProject.createObsProject();
        obsProject.setProjectName("Test Proposal");
        ObsProposal obsProposal = ObsProposal.createObsProposal();
        obsProject.setObsProposal(obsProposal);
        obsProposal.getPrincipalInvestigator().setFullName("Hiroshi Yatagai");
        obsProposal.setDateReceived(Calendar.getInstance().getTime());
        obsProposal.setCode("XXX-YYY-ZZZ");
        ConguratulationsDialog.showDialog(null, obsProject);
    }

    private class IntegerHolder {
        int value;

        private IntegerHolder() {
        }
    }
}

