/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.summaryfeedback;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.services.etc.SourceClusterDetector;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.summaryfeedback.AllScienceGoalsPrintable;
import alma.obsprep.services.summaryfeedback.FeedbackSummary;
import alma.obsprep.services.summaryfeedback.ScienceGoalSummaryModel;
import alma.obsprep.services.summaryfeedback.ScienceGoalSummaryParameters;
import alma.obsprep.services.summaryfeedback.ScienceGoalSummaryView;
import java.awt.print.Printable;
import java.util.ArrayList;
import java.util.List;

public class FeedbackSummaryScienceGoal
extends FeedbackSummary {
    final List<ScienceGoal> clusterList = new ArrayList<ScienceGoal>();
    public static final String LEAVE_BLANK = "";

    public FeedbackSummaryScienceGoal(ScienceGoal scienceGoal) throws InvalidObsProgramParametersException {
        SourceClusterDetector sourceClusterDetector = new SourceClusterDetector(scienceGoal);
        for (ScienceGoal scienceGoal2 : sourceClusterDetector.splitScienceGoalIntoSourceClusters()) {
            this.clusterList.add(scienceGoal2);
        }
        assert (this.clusterList != null && this.clusterList.size() > 0) : "Cluster alogorithm has not completed";
        ScienceGoalSummaryModel scienceGoalSummaryModel = new ScienceGoalSummaryModel();
        scienceGoalSummaryModel.setScienceGoal(this.clusterList.get(0));
        this.setView(new ScienceGoalSummaryView(scienceGoalSummaryModel));
        this.buildPage(this.clusterList.get(0));
    }

    protected void buildPage(ScienceGoal scienceGoal) {
        this.setUserObject((BusinessObject)scienceGoal);
        ScienceGoalSummaryParameters scienceGoalSummaryParameters = new ScienceGoalSummaryParameters(scienceGoal);
        scienceGoalSummaryParameters.collectInfo();
        this.setSummaryDocument(scienceGoalSummaryParameters);
    }

    protected ScienceGoal getScienceGoal() {
        return (ScienceGoal)this.userObject;
    }

    protected ObsProposal getObsProposal() {
        ScienceGoal scienceGoal = this.getScienceGoal();
        if (scienceGoal == null || !scienceGoal.isPhase1ScienceGoal()) {
            return null;
        }
        return (ObsProposal)scienceGoal.getParent();
    }

    private int indexOf(ScienceGoal scienceGoal) {
        boolean bl = false;
        int n = 0;
        for (ScienceGoal scienceGoal2 : this.clusterList) {
            if (scienceGoal2.equals(scienceGoal)) {
                bl = true;
                return n;
            }
            ++n;
        }
        if (!bl) {
            n = -1;
        }
        return n;
    }

    @Override
    public boolean hasNext() {
        int n = this.indexOf(this.getScienceGoal());
        if (n == -1) {
            return false;
        }
        return n < this.clusterList.size() - 1;
    }

    @Override
    public boolean hasPrev() {
        int n = this.indexOf(this.getScienceGoal());
        if (n == -1) {
            return false;
        }
        return n > 0;
    }

    @Override
    public void showNext() {
        if (!this.hasNext()) {
            return;
        }
        this.buildPage(this.clusterList.get(this.indexOf(this.getScienceGoal()) + 1));
    }

    @Override
    public void showPrev() {
        if (!this.hasPrev()) {
            return;
        }
        this.buildPage(this.clusterList.get(this.indexOf(this.getScienceGoal()) - 1));
    }

    @Override
    public Printable getAllPagePrintable() {
        ObsProposal obsProposal = this.getObsProposal();
        return new AllScienceGoalsPrintable(obsProposal);
    }
}

