/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.summaryfeedback;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.services.summaryfeedback.AllScienceGoalsExporter;
import alma.obsprep.services.summaryfeedback.CompleteProposalPrintable;
import alma.obsprep.services.summaryfeedback.ExportableFeedback;
import alma.obsprep.services.summaryfeedback.FeedbackSummary;
import alma.obsprep.services.summaryfeedback.ObsProposalScienceGoalNavigator;
import alma.obsprep.services.summaryfeedback.PdfExporter;
import alma.obsprep.services.summaryfeedback.ScienceGoalSummaryModel;
import alma.obsprep.services.summaryfeedback.ScienceGoalSummaryParameters;
import alma.obsprep.services.summaryfeedback.ScienceGoalSummaryView;
import alma.obsprep.services.summaryfeedback.SummaryDocument;
import java.awt.print.Printable;

public class FeedbackSummarySgCollection
extends FeedbackSummary
implements ExportableFeedback {
    private ScienceGoalSummaryModel sgModel = new ScienceGoalSummaryModel();
    private ScienceGoalSummaryView sgView = new ScienceGoalSummaryView(this.sgModel);
    private ObsProposalScienceGoalNavigator obsProposalScienceGoalNavigator;

    public FeedbackSummarySgCollection(ObsProposal obsProposal, ObsProposalScienceGoalNavigator obsProposalScienceGoalNavigator) {
        this.setView(this.sgView);
        this.setUserObject((BusinessObject)obsProposal);
        this.obsProposalScienceGoalNavigator = obsProposalScienceGoalNavigator;
        if (obsProposal != null && obsProposalScienceGoalNavigator.getScienceGoalCount() > 0) {
            this.buildPage(obsProposalScienceGoalNavigator.getScienceGoal(0));
        }
    }

    protected void buildPage(ScienceGoal scienceGoal) {
        this.setView(this.sgView);
        ScienceGoalSummaryParameters scienceGoalSummaryParameters = new ScienceGoalSummaryParameters(scienceGoal, this.obsProposalScienceGoalNavigator);
        scienceGoalSummaryParameters.collectInfo();
        this.setSummaryDocument(scienceGoalSummaryParameters);
    }

    private ObsProposal getObsProposal() {
        return (ObsProposal)this.userObject;
    }

    public BusinessObject getCurrentObject() {
        SummaryDocument summaryDocument = (SummaryDocument)this.view.getModel().getDocument();
        return summaryDocument == null ? null : summaryDocument.getUserObject();
    }

    @Override
    public boolean hasNext() {
        ObsProposal obsProposal = this.getObsProposal();
        if (obsProposal == null) {
            return false;
        }
        BusinessObject businessObject = this.getCurrentObject();
        if (businessObject == null) {
            return false;
        }
        ScienceGoal scienceGoal = (ScienceGoal)businessObject;
        int n = this.obsProposalScienceGoalNavigator.indexOf(scienceGoal);
        if (n == -1) {
            return false;
        }
        return n < this.obsProposalScienceGoalNavigator.getScienceGoalCount() - 1;
    }

    @Override
    public boolean hasPrev() {
        ObsProposal obsProposal = this.getObsProposal();
        if (obsProposal == null) {
            return false;
        }
        BusinessObject businessObject = this.getCurrentObject();
        if (businessObject == null) {
            return false;
        }
        ScienceGoal scienceGoal = (ScienceGoal)businessObject;
        int n = this.obsProposalScienceGoalNavigator.indexOf(scienceGoal);
        if (n == -1) {
            return false;
        }
        return n > 0;
    }

    @Override
    public void showNext() {
        if (!this.hasNext()) {
            return;
        }
        ObsProposal obsProposal = this.getObsProposal();
        if (obsProposal == null) {
            return;
        }
        BusinessObject businessObject = this.getCurrentObject();
        int n = this.obsProposalScienceGoalNavigator.indexOf((ScienceGoal)businessObject);
        this.buildPage(this.obsProposalScienceGoalNavigator.getScienceGoal(n + 1));
    }

    @Override
    public void showPrev() {
        if (!this.hasPrev()) {
            return;
        }
        ObsProposal obsProposal = this.getObsProposal();
        if (obsProposal == null) {
            return;
        }
        BusinessObject businessObject = this.getCurrentObject();
        int n = this.obsProposalScienceGoalNavigator.indexOf((ScienceGoal)businessObject);
        this.buildPage(this.obsProposalScienceGoalNavigator.getScienceGoal(n - 1));
    }

    @Override
    public Printable getAllPagePrintable() {
        return new CompleteProposalPrintable(this.getObsProposal());
    }

    @Override
    public PdfExporter getPdfExporter() {
        AllScienceGoalsExporter allScienceGoalsExporter = new AllScienceGoalsExporter(this.sgView.createOffView());
        allScienceGoalsExporter.setObsProposal(this.getObsProposal());
        return allScienceGoalsExporter;
    }
}

