/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.summaryfeedback;

import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.services.etc.SourceClusterDetector;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ObsProposalScienceGoalNavigator {
    private List<ScienceGoal> clusteredScienceGoals = new ArrayList<ScienceGoal>();
    private Map<ScienceGoal, List<ScienceGoal>> scienceGoalsByCluster = new HashMap<ScienceGoal, List<ScienceGoal>>();
    private ObsProposal obsProposal;

    public ObsProposalScienceGoalNavigator(ObsProposal obsProposal, boolean bl) {
        if (obsProposal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: obsProposal");
        }
        this.obsProposal = obsProposal;
        if (obsProposal.getAbstractScienceGoalCount() > 0) {
            if (bl) {
                this.determineClusterSGsInProposal();
            } else {
                this.determineSGsInProposal();
            }
        }
    }

    public int getScienceGoalCount() {
        return this.clusteredScienceGoals.size();
    }

    public ScienceGoal getScienceGoal(int n) {
        if (n > this.clusteredScienceGoals.size()) {
            throw new IllegalArgumentException("Bad index specified");
        }
        return this.clusteredScienceGoals.get(n);
    }

    public List<ScienceGoal> getScienceGoals() {
        return Collections.unmodifiableList(this.clusteredScienceGoals);
    }

    public int indexOf(ScienceGoal scienceGoal) {
        if (scienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: scienceGoal");
        }
        int n = 0;
        for (ScienceGoal scienceGoal2 : this.clusteredScienceGoals) {
            if (scienceGoal2 == scienceGoal) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private void determineClusterSGsInProposal() {
        for (AbstractScienceGoal abstractScienceGoal : this.obsProposal.getAbstractScienceGoal()) {
            Collection<ScienceGoal> collection;
            if (!(abstractScienceGoal instanceof ScienceGoal)) continue;
            ScienceGoal scienceGoal = (ScienceGoal)((Object)abstractScienceGoal);
            SourceClusterDetector sourceClusterDetector = new SourceClusterDetector(scienceGoal);
            try {
                collection = sourceClusterDetector.splitScienceGoalIntoSourceClusters();
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                throw new WizardSBGenerationException(invalidObsProgramParametersException);
            }
            ArrayList<ScienceGoal> arrayList = new ArrayList<ScienceGoal>();
            this.scienceGoalsByCluster.put(scienceGoal, arrayList);
            for (ScienceGoal scienceGoal2 : collection) {
                this.clusteredScienceGoals.add(scienceGoal2);
                arrayList.add(scienceGoal2);
            }
        }
    }

    private void determineSGsInProposal() {
        for (AbstractScienceGoal abstractScienceGoal : this.obsProposal.getAbstractScienceGoal()) {
            if (!(abstractScienceGoal instanceof ScienceGoal)) continue;
            ScienceGoal scienceGoal = (ScienceGoal)((Object)abstractScienceGoal);
            this.scienceGoalsByCluster.put(scienceGoal, (List<ScienceGoal>)ImmutableList.of((Object)scienceGoal));
            this.clusteredScienceGoals.add(scienceGoal);
        }
    }

    public int getSBIndex(ScienceGoal scienceGoal) {
        boolean bl = false;
        int n = 1;
        block0: for (ScienceGoal scienceGoal2 : this.scienceGoalsByCluster.keySet()) {
            n = 1;
            for (ScienceGoal scienceGoal3 : this.scienceGoalsByCluster.get(scienceGoal2)) {
                if (scienceGoal3 == scienceGoal) {
                    bl = true;
                    break block0;
                }
                ++n;
            }
        }
        assert (bl);
        return n;
    }
}

