/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.summaryfeedback;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.bo.enumerations.CorrPolarization;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.CalibrationSetupParameters;
import alma.obsprep.bo.obsproject.ObsPhase;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.RepresentativeFrequencyListener;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.ot.valdef.DefaultProblemListModel;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.services.experts.ACANecessityEstimator;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.InvalidConfigurationParametersException;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.summaryfeedback.SummaryDocument;
import alma.valuetypes.Angle;
import alma.valuetypes.AngularVelocity;
import alma.valuetypes.Flux;
import alma.valuetypes.Frequency;
import alma.valuetypes.Sensitivity;
import alma.valuetypes.Velocity;
import java.util.HashSet;
import java.util.Set;

@Deprecated
public class ObsProposalTAFlagging
implements SummaryDocument {
    private ObsProposal obsProposal;
    private Set<Integer> targetMaxElLow = new HashSet<Integer>();
    private Set<Integer> targetMaxElHigh = new HashSet<Integer>();
    private Set<Integer> nonZeroPMTargets = new HashSet<Integer>();
    private Set<Integer> spatialDynrange = new HashSet<Integer>();
    private Set<Integer> spectralDynrange = new HashSet<Integer>();
    private Set<Integer> mosaicSep = new HashSet<Integer>();
    private Set<Integer> velFrame = new HashSet<Integer>();
    private Set<Integer> velDef = new HashSet<Integer>();
    private Set<Integer> singlePol = new HashSet<Integer>();
    private Set<Integer> linewidth = new HashSet<Integer>();
    private Set<Integer> singleSpecwindow = new HashSet<Integer>();
    private Set<Integer> anyUserCal = new HashSet<Integer>();
    private Set<Integer> multipleCals = new HashSet<Integer>();
    private Set<Integer> largestScaleInterest = new HashSet<Integer>();
    private Set<Integer> spatialSmoothing = new HashSet<Integer>();
    private Set<Integer> extraTime = new HashSet<Integer>();
    private Set<Integer> detectionOverLW = new HashSet<Integer>();
    private Set<Integer> acaValid = new HashSet<Integer>();

    public ObsProposalTAFlagging(ObsProposal obsProposal) {
        this.setObsProposal(obsProposal);
    }

    public Set<Integer> getTargetMaxElLow() {
        return this.targetMaxElLow;
    }

    public Set<Integer> getTargetMaxElHigh() {
        return this.targetMaxElHigh;
    }

    public Set<Integer> getNonZeroPMTargets() {
        return this.nonZeroPMTargets;
    }

    public Set<Integer> getSpatialDynrange() {
        return this.spatialDynrange;
    }

    public Set<Integer> getMosaicSep() {
        return this.mosaicSep;
    }

    public Set<Integer> getVelFrame() {
        return this.velFrame;
    }

    public Set<Integer> getVelDef() {
        return this.velDef;
    }

    public Set<Integer> getSinglePol() {
        return this.singlePol;
    }

    public Set<Integer> getSpectralDynrange() {
        return this.spectralDynrange;
    }

    public Set<Integer> getLinewidth() {
        return this.linewidth;
    }

    public Set<Integer> getSingleSpecwindow() {
        return this.singleSpecwindow;
    }

    public Set<Integer> getAnyUserCal() {
        return this.anyUserCal;
    }

    public Set<Integer> getMultipleCals() {
        return this.multipleCals;
    }

    public Set<Integer> getLargestScaleInterest() {
        return this.largestScaleInterest;
    }

    public Set<Integer> getSpatialSmoothing() {
        return this.spatialSmoothing;
    }

    public Set<Integer> getExtraTime() {
        return this.extraTime;
    }

    public Set<Integer> getDetectionOverLW() {
        return this.detectionOverLW;
    }

    public Set<Integer> getACAInvalidSetup() {
        return this.acaValid;
    }

    public ObsProposal getObsProposal() {
        return this.obsProposal;
    }

    public void setObsProposal(ObsProposal obsProposal) {
        this.obsProposal = obsProposal;
        this.recalculateFlagging();
    }

    public void recalculateFlagging() {
        this.resetFlaggedSGs();
        AbstractScienceGoal[] abstractScienceGoalArray = this.obsProposal.getAbstractScienceGoal();
        if (abstractScienceGoalArray == null) {
            return;
        }
        for (int i = 0; i < abstractScienceGoalArray.length; ++i) {
            Object object;
            CalibrationSetupParameters calibrationSetupParameters;
            double d;
            RepresentativeFrequencyListener representativeFrequencyListener;
            AbstractScienceGoal abstractScienceGoal = abstractScienceGoalArray[i];
            ScienceGoal scienceGoal = (ScienceGoal)((Object)abstractScienceGoal);
            int n = ((ObsPhase)scienceGoal.getParent()).indexOf(scienceGoal) + 1;
            SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
            TargetParameters[] targetParametersArray = scienceGoal.getTargetParameters();
            for (int j = 0; j < targetParametersArray.length; ++j) {
                double d2;
                double d3;
                Object object2;
                representativeFrequencyListener = targetParametersArray[j];
                if (((TargetParameters)representativeFrequencyListener).isMaxElevationTooLow()) {
                    this.targetMaxElLow.add(n);
                }
                if (((TargetParameters)representativeFrequencyListener).isMaxElevationTooHigh()) {
                    this.targetMaxElHigh.add(n);
                }
                if (representativeFrequencyListener.getPMDec().getContentInUnits(AngularVelocity.UNIT_MAS_YR) != 0.0 || representativeFrequencyListener.getPMDec().getContentInUnits(AngularVelocity.UNIT_MAS_YR) != 0.0) {
                    this.nonZeroPMTargets.add(n);
                }
                if (representativeFrequencyListener.getExpectedProperties().getExpectedPeakFluxDensity().getContentInUnits(Flux.UNIT_JY) / scienceGoal.getPerformanceParameters().getDesiredSensitivity().getContentInUnits(Sensitivity.UNIT_JY) > 500.0) {
                    this.spatialDynrange.add(n);
                }
                d = representativeFrequencyListener.getExpectedProperties().getExpectedPeakLineFluxDensity().getContentInUnits(Flux.UNIT_JY);
                double d4 = scienceGoal.getPerformanceParameters().getDesiredSensitivity().getContentInUnits(Sensitivity.UNIT_JY);
                double d5 = scienceGoal.getReceiverBand().getDynamicRangeLimit();
                try {
                    if (d / d4 > d5) {
                        this.spectralDynrange.add(n);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (((TargetParameters)representativeFrequencyListener).isRectanglePattern()) {
                    object2 = Antenna.ANTENNA_12M;
                    d3 = 0.48 * ((Antenna)((Object)object2)).getBeamSize(scienceGoal.getRepresentativeFrequencyInSky()).getContentInUnits(Angle.UNIT_ARCSEC);
                    d2 = 0.8 * ((Antenna)((Object)object2)).getBeamSize(scienceGoal.getRepresentativeFrequencyInSky()).getContentInUnits(Angle.UNIT_ARCSEC);
                    double d6 = ((TargetParameters)representativeFrequencyListener).getSingleRectangle().getSpacing().getContentInUnits(Angle.UNIT_ARCSEC);
                    if (d6 < d3 || d6 > d2) {
                        this.mosaicSep.add(n);
                    }
                }
                if ((object2 = representativeFrequencyListener.getSourceVelocity()).getDopplerCalcType().equals(Velocity.DOPPLERCALCTYPE_RELATIVISTIC)) {
                    this.velDef.add(n);
                }
                if (!((Velocity)((Object)object2)).getReferenceSystem().equals(Velocity.REFERENCESYSTEM_LSRK)) {
                    this.velFrame.add(n);
                }
                d3 = 0.0;
                d2 = representativeFrequencyListener.getExpectedProperties().getExpectedLineWidth().getContentInMHz();
                for (ScienceSpectralWindow scienceSpectralWindow : spectralSetupParameters.getScienceSpectralWindow()) {
                    if (!(scienceSpectralWindow.getBandWidth().getContentInMHz() > d3)) continue;
                    d3 = scienceSpectralWindow.getBandWidth().getContentInMHz();
                }
                if (!(d2 > 0.9 * d3)) continue;
                this.linewidth.add(n);
            }
            if (spectralSetupParameters.getPolarisation().equals(CorrPolarization.SINGLE_X.toString()) || spectralSetupParameters.getPolarisation().equals(CorrPolarization.SINGLE_Y.toString())) {
                this.singlePol.add(n);
            }
            if (spectralSetupParameters.getType() == SpectralSetupParameters.TYPE_FULL && spectralSetupParameters.getScienceSpectralWindowCount() == 1) {
                this.singleSpecwindow.add(n);
            }
            if ((calibrationSetupParameters = scienceGoal.getCalibrationSetupParameters()).isUserDefinedCalibration()) {
                this.anyUserCal.add(n);
            }
            representativeFrequencyListener = scienceGoal.getPerformanceParameters();
            d = representativeFrequencyListener.getDesiredAngularResolution().getContentInUnits(Angle.UNIT_ARCSEC);
            Frequency frequency = ((PerformanceParameters)representativeFrequencyListener).getRepresentativeFrequencyWithSkyOffset();
            double d7 = frequency.getContentInGHz();
            double d8 = representativeFrequencyListener.getDesiredLargestScale().getContentInUnits(Angle.UNIT_ARCSEC);
            ScienceGoal scienceGoal2 = ((PerformanceParameters)representativeFrequencyListener).getScienceGoal();
            try {
                object = scienceGoal2.getTargetParameters();
                Configuration configuration = Configuration.getBestConfiguration(d7, RequestedArray.TWELVE_M, scienceGoal2);
                if (d8 > configuration.getRecoverableScale(d7, (TargetParameters[])object, RequestedArray.TWELVE_M)) {
                    this.largestScaleInterest.add(n);
                }
            }
            catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
                this.largestScaleInterest.add(n);
            }
            if (representativeFrequencyListener.getNeedsMoreTime()) {
                this.extraTime.add(n);
            }
            if ((object = null) == null) {
                object = new ACANecessityEstimator();
            }
            ((ACANecessityEstimator)object).setParameters(representativeFrequencyListener.getDesiredLargestScale(), (Angle)((Object)representativeFrequencyListener.getDesiredAngularResolution()), frequency);
            if (((ACANecessityEstimator)object).acaNecessity(scienceGoal2) == representativeFrequencyListener.getUseACA()) continue;
            this.acaValid.add(n);
        }
    }

    private void resetFlaggedSGs() {
        this.targetMaxElLow.clear();
        this.targetMaxElHigh.clear();
        this.nonZeroPMTargets.clear();
        this.spatialDynrange.clear();
        this.spectralDynrange.clear();
        this.mosaicSep.clear();
        this.velFrame.clear();
        this.velDef.clear();
        this.singlePol.clear();
        this.linewidth.clear();
        this.singleSpecwindow.clear();
        this.anyUserCal.clear();
        this.multipleCals.clear();
        this.largestScaleInterest.clear();
        this.spatialSmoothing.clear();
        this.extraTime.clear();
        this.detectionOverLW.clear();
    }

    @Override
    public BusinessObject getUserObject() {
        return null;
    }

    @Override
    public void collectInfo() {
        this.recalculateFlagging();
    }

    @Override
    public ProblemListModel getProblems() {
        return new DefaultProblemListModel();
    }
}

