/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.summaryfeedback;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproposal.Investigator;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.obsproposal.TimeAllocationBreakdown;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.ot.models.sciencegoals.AngularResolutionMode;
import alma.obsprep.ot.valdef.DefaultProblemListModel;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.services.summaryfeedback.ObsProposalScienceGoalNavigator;
import alma.obsprep.services.summaryfeedback.ScienceGoalSummaryParameters;
import alma.obsprep.services.summaryfeedback.SummaryDocument;
import alma.valuetypes.Angle;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Time;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;

public class ProposalSummaryParameters
implements SummaryDocument {
    protected String projectCode;
    protected String astronomicalCategoryString;
    protected String title;
    protected String piName;
    protected String piInstitute;
    protected Investigator[] copis;
    protected Investigator[] cois;
    protected String copiNames;
    protected Time total12mTime;
    protected Time totalOtherTime;
    protected Time total12mNonStandardTime;
    protected TimeAllocationBreakdown execshares;
    protected String resubmission;
    protected boolean student;
    protected String duplicateObservationsJustification;
    protected String abstractString;
    protected List<ScienceGoalInfo> scienceGoalInfo;
    protected List<PreviousProposalInfo> previousProposalInfo;
    protected List<RelatedProposalInfo> relatedProposalInfo;
    protected String timeConstraints;
    protected String extraTime;
    protected PIContactInfo piContactInfo;
    protected String recentPublications;
    protected List<ScienceGoalSummaryParameters> sgSummary;
    private ObsProposal obsProposal;
    private ProblemListModel problems;
    private ObsProposalScienceGoalNavigator obsProposalScienceGoalNavigator;

    public ProposalSummaryParameters(ObsProposal obsProposal) {
        if (obsProposal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: obsProposal");
        }
        this.obsProposal = obsProposal;
        this.problems = new DefaultProblemListModel();
        this.obsProposalScienceGoalNavigator = new ObsProposalScienceGoalNavigator(obsProposal, true);
        this.sgSummary = new ArrayList<ScienceGoalSummaryParameters>();
    }

    public ObsProposal getObsProposal() {
        return this.obsProposal;
    }

    public ObsProposal getUserObject() {
        return this.getObsProposal();
    }

    @Override
    public ProblemListModel getProblems() {
        return this.problems;
    }

    @Override
    public void collectInfo() {
        ObsProposal obsProposal = this.getObsProposal();
        try {
            obsProposal.getProposalFeedback().fill();
        }
        catch (Exception exception) {
            Log.logger((Object)this).warning(exception.getMessage());
        }
        this.sgSummary.clear();
        for (ScienceGoal scienceGoal : this.obsProposalScienceGoalNavigator.getScienceGoals()) {
            ScienceGoalSummaryParameters scienceGoalSummaryParameters = new ScienceGoalSummaryParameters(scienceGoal);
            scienceGoalSummaryParameters.collectInfo();
            this.sgSummary.add(scienceGoalSummaryParameters);
        }
        this.projectCode = this.getProjectCode();
        this.title = obsProposal.getTitle();
        this.astronomicalCategoryString = obsProposal.getScientificCategoryString();
        this.total12mTime = this.getTotal12mTime();
        this.totalOtherTime = this.getTotalOtherTime();
        this.total12mNonStandardTime = this.getTotal12mNonStandardTime();
        Object object = obsProposal.getPrincipalInvestigator();
        this.piName = object.getFullName();
        this.piInstitute = object.getOrganisation();
        this.piContactInfo = new PIContactInfo((Investigator)((Object)object));
        this.copis = obsProposal.getCoPrincipalInvestigator();
        this.cois = obsProposal.getCoInvestigator();
        this.execshares = this.getTimeAllocationBreakdown();
        this.resubmission = this.getResubmission();
        this.student = obsProposal.getStudentProject();
        this.duplicateObservationsJustification = obsProposal.getDuplicateObservationsJustification();
        this.abstractString = obsProposal.getAbstract();
        this.scienceGoalInfo = this.getScienceGoalInfo();
        this.previousProposalInfo = this.getPreviousProposalInfo();
        this.relatedProposalInfo = this.getRelatedProposalInfo();
        this.timeConstraints = this.getTimeConstraints();
        this.extraTime = this.getExtraTime();
    }

    protected String getProjectCode() {
        try {
            return this.getObsProposal().getObsProject().getCode();
        }
        catch (UnknownEntityException unknownEntityException) {
            return "Unknown";
        }
    }

    protected Date getDateSubmitted() {
        return this.getObsProposal().getDateReceived();
    }

    protected TimeAllocationBreakdown getTimeAllocationBreakdown() {
        return this.getObsProposal().getProposalFeedback().getTimeAllocationBreakdown();
    }

    protected Time getTotal12mTime() {
        Time time = this.getObsProposal().getTotalRequestedTime(Array.ARRAY_12M, false);
        time.convertToUnit(Time.UNIT_H);
        return time;
    }

    protected Time getTotalOtherTime() {
        Time time;
        Time time2 = this.getObsProposal().getTotalRequestedTime(Array.ARRAY_TP, false);
        Time time3 = time2.isGreaterThan((AbstractDoubleWithUnit)(time = this.getObsProposal().getTotalRequestedTime(Array.ARRAY_7M, false))) ? time2 : time;
        time3.convertToUnit(Time.UNIT_H);
        return time3;
    }

    protected Time getTotal12mNonStandardTime() {
        Time time = this.getObsProposal().getTotal12mNonStandardTime();
        time.convertToUnit(Time.UNIT_H);
        return time;
    }

    protected String getResubmission() {
        if (this.getObsProposal().getIsResubmission()) {
            return this.getObsProposal().getResubmittedProjectCode();
        }
        return "";
    }

    protected String getTimeConstraints() {
        String string = "There are time constraints.";
        String string2 = "NONE";
        for (ScienceGoal scienceGoal : this.obsProposalScienceGoalNavigator.getScienceGoals()) {
            PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
            if (!performanceParameters.getIsTimeConstrained()) continue;
            return string;
        }
        return string2;
    }

    public String capitalizeFirstLetter(String string) {
        if (string.length() == 0) {
            return string;
        }
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    /*
     * WARNING - void declaration
     */
    protected String getExtraTime() {
        String string = "No";
        ObsProposal obsProposal = this.getObsProposal();
        if (obsProposal != null && obsProposal.isVLBI()) {
            return string;
        }
        EnumSet<ReasonsForExtraTime> enumSet = EnumSet.noneOf(ReasonsForExtraTime.class);
        for (ScienceGoal object : this.obsProposalScienceGoalNavigator.getScienceGoals()) {
            boolean bl = false;
            try {
                bl = object.isSolarScienceGoal();
            }
            catch (UnknownEntityException unknownEntityException) {
                Log.logger((Object)this).warning("Unable to determine if this is a Solar Science Goal : " + unknownEntityException.getMessage());
            }
            PerformanceParameters performanceParameters = object.getPerformanceParameters();
            if (performanceParameters.getNeedsMoreTime() && !bl) {
                enumSet.add(ReasonsForExtraTime.USERDEFINEDTIME);
            }
            if (!performanceParameters.getIsTimeConstrained() || performanceParameters.getMonitoringConstraintCount() <= 0) continue;
            enumSet.add(ReasonsForExtraTime.CONTINUOUSMONITORING);
        }
        if (!enumSet.isEmpty()) {
            StringBuffer stringBuffer = new StringBuffer("");
            Integer n = 1;
            for (ReasonsForExtraTime reasonsForExtraTime : enumSet) {
                Integer n2;
                void var5_7;
                if (var5_7.intValue() == 1) {
                    stringBuffer.append(this.capitalizeFirstLetter(reasonsForExtraTime.getDescription()));
                } else {
                    stringBuffer.append(reasonsForExtraTime.getDescription());
                }
                if (var5_7.intValue() < enumSet.size()) {
                    stringBuffer.append(" and ");
                }
                void var8_16 = var5_7;
                Integer n3 = n2 = Integer.valueOf(var5_7.intValue() + 1);
            }
            stringBuffer.append(" requested.");
            return stringBuffer.toString();
        }
        return string;
    }

    protected List<ScienceGoalInfo> getScienceGoalInfo() {
        ArrayList<ScienceGoalInfo> arrayList = new ArrayList<ScienceGoalInfo>();
        for (ScienceGoal scienceGoal : this.obsProposalScienceGoalNavigator.getScienceGoals()) {
            arrayList.add(new ScienceGoalInfo(scienceGoal));
        }
        return arrayList;
    }

    protected List<RelatedProposalInfo> getRelatedProposalInfo() {
        ArrayList<RelatedProposalInfo> arrayList = new ArrayList<RelatedProposalInfo>();
        ObsProposal obsProposal = this.getObsProposal();
        String string = obsProposal.getRelatedProposals();
        if (string.length() > 0) {
            String[] stringArray;
            for (String string2 : stringArray = string.split("\n")) {
                RelatedProposalInfo relatedProposalInfo;
                String[] stringArray2 = string2.split(",");
                if (stringArray2.length == 1) {
                    relatedProposalInfo = new RelatedProposalInfo();
                    relatedProposalInfo.code = stringArray2[0];
                    arrayList.add(relatedProposalInfo);
                    continue;
                }
                if (stringArray2.length != 3) continue;
                relatedProposalInfo = new RelatedProposalInfo();
                relatedProposalInfo.code = stringArray2[0];
                relatedProposalInfo.title = stringArray2[1];
                relatedProposalInfo.piName = stringArray2[2];
                arrayList.add(relatedProposalInfo);
            }
        }
        return arrayList;
    }

    protected List<PreviousProposalInfo> getPreviousProposalInfo() {
        ArrayList<PreviousProposalInfo> arrayList = new ArrayList<PreviousProposalInfo>();
        ObsProposal obsProposal = this.getObsProposal();
        String string = obsProposal.getPreviousProposals();
        if (string.length() > 0) {
            String[] stringArray;
            for (String string2 : stringArray = string.split("\n")) {
                PreviousProposalInfo previousProposalInfo;
                String[] stringArray2 = string2.split(",");
                if (stringArray2.length == 1) {
                    previousProposalInfo = new PreviousProposalInfo();
                    previousProposalInfo.code = stringArray2[0];
                    arrayList.add(previousProposalInfo);
                    continue;
                }
                if (stringArray2.length != 4) continue;
                previousProposalInfo = new PreviousProposalInfo();
                previousProposalInfo.code = stringArray2[0];
                previousProposalInfo.title = stringArray2[1];
                previousProposalInfo.piName = stringArray2[2];
                previousProposalInfo.publicationStatus = stringArray2[3];
                arrayList.add(previousProposalInfo);
            }
        }
        return arrayList;
    }

    protected class ScienceGoalInfo {
        ScienceGoal sg;
        String sgname;
        String sourceName;
        SkyCoordinates sourceCoordinates;
        ReceiverBand receiverBand;
        Angle angularResolution;
        Angle angularResolutionLimit;
        AngularResolutionMode mode;
        Angle largestAngularScale;
        boolean useACA;
        boolean sgNonStandardMode;
        String clusterId;
        boolean isStandAloneACA;

        ScienceGoalInfo(ScienceGoal scienceGoal) {
            this.sg = scienceGoal;
            this.sgname = scienceGoal.getNameOrDefault();
            TargetParameters targetParameters = scienceGoal.getSoleTargetParameters();
            if (targetParameters != null) {
                this.sourceName = targetParameters.getSourceName();
                this.sourceCoordinates = targetParameters.getSourceCoordinates();
            }
            try {
                int n = scienceGoal.getClusterIndex();
                this.clusterId = String.format("(Cluster %d)", n);
            }
            catch (ScienceGoal.NotClusteredScienceGoalException notClusteredScienceGoalException) {
                this.clusterId = "";
            }
            PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
            this.receiverBand = scienceGoal.getSpectralSetupParameters().getReceiverBand();
            this.angularResolution = performanceParameters.getDesiredAngularResolution();
            this.angularResolutionLimit = performanceParameters.getAcceptableAngularResolution();
            this.mode = performanceParameters.getAngularResolutionMode();
            this.largestAngularScale = performanceParameters.getDesiredLargestScale();
            this.useACA = performanceParameters.getUseACA();
            try {
                this.sgNonStandardMode = scienceGoal.getMode().equals(ScienceGoal.MODE_OTHER) || scienceGoal.isSolarScienceGoal();
            }
            catch (UnknownEntityException unknownEntityException) {
                this.sgNonStandardMode = scienceGoal.getMode().equals(ScienceGoal.MODE_OTHER);
            }
            this.isStandAloneACA = scienceGoal.isStandAloneACA();
        }
    }

    protected static class PreviousProposalInfo {
        protected String code = "";
        protected String title = "";
        protected String piName = "";
        protected String publicationStatus = "";

        protected PreviousProposalInfo() {
        }
    }

    protected static class RelatedProposalInfo {
        protected String code = "";
        protected String title = "";
        protected String piName = "";

        protected RelatedProposalInfo() {
        }
    }

    class PIContactInfo {
        private Investigator pi;

        PIContactInfo(Investigator investigator) {
            this.setPI(investigator);
        }

        void setPI(Investigator investigator) {
            this.pi = investigator;
        }

        String getInfo(PIContactProperty pIContactProperty) {
            String string = "&nbsp;";
            if (this.pi == null) {
                return string;
            }
            switch (pIContactProperty) {
                case TITLE: {
                    return string;
                }
                case NAME: {
                    return this.pi.getFullName();
                }
                case EMAIL: {
                    return this.pi.getEMail();
                }
                case PHONE1: {
                    return this.pi.getTelephone();
                }
                case PHONE2: {
                    return this.pi.getMobile();
                }
                case FAX: {
                    return string;
                }
                case INSTITUTE: {
                    return this.pi.getOrganisation();
                }
                case EXECUTIVE: {
                    return this.pi.getAssociatedExec();
                }
                case ADDRESS: {
                    return string;
                }
            }
            return string;
        }
    }

    static enum PIContactProperty {
        TITLE,
        NAME,
        EMAIL("E-MAIL"),
        PHONE1("PHONE[FIRST]"),
        PHONE2("PHONE[SECOND]"),
        FAX,
        INSTITUTE("INSTITUTE &/OR DEPT."),
        ADDRESS("ADDRESS"),
        STREET("STREET ADDRESS"),
        POSTCODE("POSTCODE/ZIP CODE"),
        CITY("TOWN/CITY"),
        REGION("COUNTY/STATE/REGION"),
        COUNTRY,
        EXECUTIVE("ALMA EXECUTIVE"),
        PREFERREDARC("PREFERRED ARC[EA/EU/NA]");

        private String label;

        private PIContactProperty() {
            this.label = this.name();
        }

        private PIContactProperty(String string2) {
            this.label = string2;
        }

        public String toString() {
            return this.label;
        }
    }

    private static enum ReasonsForExtraTime {
        CONTINUOUSMONITORING("continuous monitoring"),
        USERDEFINEDTIME("extra time");

        String description;

        public String getDescription() {
            return this.description;
        }

        private ReasonsForExtraTime(String string2) {
            this.description = string2;
        }
    }
}

