/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.summaryfeedback;

import alma.obsprep.ot.editors.sciencegoals.TechnicalJustificationEditor;
import alma.obsprep.services.summaryfeedback.DefaultPdfExporter;
import alma.obsprep.services.summaryfeedback.ScienceGoalSummaryView;
import com.itextpdf.awt.PdfGraphics2D;
import com.itextpdf.text.Document;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;

public class ScienceGoalExporter
extends DefaultPdfExporter {
    private static final int ONE_TEXT_ROW_HEIGHT = 40;
    protected ScienceGoalSummaryView offView;

    protected ScienceGoalExporter(ScienceGoalSummaryView scienceGoalSummaryView) {
        super(scienceGoalSummaryView);
        this.offView = scienceGoalSummaryView;
    }

    @Override
    protected void exportToPdfPage(Document document, PdfWriter pdfWriter, Rectangle rectangle) {
        this.exportToPdfPageFromPage(document, pdfWriter, 1, 1);
    }

    protected int exportToPdfPageFromPage(Document document, PdfWriter pdfWriter, int n, int n2) {
        int n3 = 0;
        if (this.offView == null) {
            return n3;
        }
        ArrayList<JPanel> arrayList = new ArrayList<JPanel>();
        arrayList.add(this.offView.headerPanel);
        arrayList.add(this.offView.fieldInfoPanel);
        arrayList.add(this.offView.spectralInfoPanel);
        arrayList.add(this.offView.initalTargetsPanel);
        arrayList.add(this.offView.additionalTargetsPanel);
        PageSplitter pageSplitter = new PageSplitter(arrayList);
        pageSplitter.splitPages();
        JLabel jLabel = new JLabel();
        JPanel jPanel = this.addHaderLabelToView(this.offView, jLabel);
        this.doLayout(jPanel);
        for (int i = 0; i < pageSplitter.getNumberOfPages(); ++i) {
            pageSplitter.showPage(i);
            jLabel.setText("SG-" + n2);
            this.addPanelToDocument(pdfWriter, jPanel);
            n3 = this.addNewPage(document, n3);
        }
        this.offView.technicalJustificationsSections.put(TechnicalJustificationEditor.TechJustEditor.ED_SENSITIVITY_COMMENTS, this.offView.sensitivityCommentPanel);
        this.offView.technicalJustificationsSections.put(TechnicalJustificationEditor.TechJustEditor.ED_CORR_COMMENTS, this.offView.correlatorCommentPanel);
        n3 = this.addSubpanels(this.offView.technicalJustificationsSections, document, pdfWriter, n3, "SG-" + n2);
        return n3;
    }

    private int addSubpanels(TreeMap<TechnicalJustificationEditor.TechJustEditor, JComponent> treeMap, Document document, PdfWriter pdfWriter, int n, String string) {
        if (treeMap == null) {
            return n;
        }
        Iterator<JComponent> iterator = treeMap.values().iterator();
        if (iterator == null || !iterator.hasNext()) {
            return n;
        }
        TextPanelHelper textPanelHelper = new TextPanelHelper(1000, 350);
        textPanelHelper.createPage(string);
        int n2 = textPanelHelper.pageHeight;
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (((Container)object).getComponents().length > 0 && ((Container)object).getComponent(0) instanceof JTextComponent) {
                object = (JTextComponent)((Container)object).getComponent(0);
            }
            if ((n2 = this.addToTextPanelHelper(textPanelHelper, (JComponent)object, n2, string)) != 0) continue;
            textPanelHelper.createPage(string);
        }
        for (JComponent jComponent : textPanelHelper.textPages) {
            this.addPanelToDocument(pdfWriter, jComponent);
            n = this.addNewPage(document, n);
        }
        return n;
    }

    private int addToTextPanelHelper(TextPanelHelper textPanelHelper, JComponent jComponent, int n, String string) {
        int n2 = textPanelHelper.addComponentToTextPanel(jComponent);
        if (n <= 40) {
            textPanelHelper.createPage(string);
            n = textPanelHelper.pageHeight;
        }
        if (jComponent instanceof JTextArea && n2 > n) {
            JTextArea jTextArea = (JTextArea)jComponent;
            JPanel jPanel = null;
            StringBuffer stringBuffer = new StringBuffer(jTextArea.getText().trim());
            stringBuffer.append(" ");
            int n3 = stringBuffer.length();
            if (n3 <= 1) {
                return n;
            }
            CharSequence[] charSequenceArray = new String[]{"\n", "\r", " "};
            do {
                String string2 = stringBuffer.substring(0, n3).trim();
                n3 = StringUtils.lastIndexOfAny((CharSequence)string2, (CharSequence[])charSequenceArray);
                jTextArea.setText(string2);
                this.doLayout(jTextArea);
            } while ((n2 = (int)jComponent.getPreferredSize().getHeight()) > n && n3 > 0);
            this.doLayout(textPanelHelper.currentPanel);
            textPanelHelper.createPage(string);
            n = textPanelHelper.pageHeight;
            if (n3 + 1 < stringBuffer.length()) {
                stringBuffer.delete(0, n3 + 1);
                stringBuffer.delete(0, stringBuffer.indexOf(" ") + 1);
                if (stringBuffer.toString().trim().length() > 0) {
                    jPanel = this.createAdditionalTextPanel(stringBuffer.toString().trim());
                    this.addToTextPanelHelper(textPanelHelper, (JTextComponent)jPanel.getComponent(0), n, string);
                }
            }
            return n - n2;
        }
        if (n2 > n) {
            textPanelHelper.createPage(string);
            n = textPanelHelper.pageHeight;
        }
        this.doLayout(textPanelHelper.currentPanel);
        n2 = (int)jComponent.getPreferredSize().getHeight();
        return n -= n2;
    }

    private void addPanelToDocument(PdfWriter pdfWriter, JComponent jComponent) {
        Rectangle rectangle = pdfWriter.getPageSize();
        int n = this.getPdfPageMargin();
        float f = rectangle.getWidth();
        float f2 = rectangle.getHeight();
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add(new JScrollPane(jComponent));
        jFrame.pack();
        float f3 = f;
        float f4 = f2;
        double d = this.getPageFitScale(f, f2, n, jComponent);
        PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
        PdfTemplate pdfTemplate = pdfContentByte.createTemplate(f3, f4);
        PdfGraphics2D pdfGraphics2D = new PdfGraphics2D((PdfContentByte)pdfTemplate, f3, f4, SWING_FONTMAPPER);
        pdfGraphics2D.scale(d, d);
        jComponent.print((Graphics)pdfGraphics2D);
        pdfGraphics2D.dispose();
        pdfContentByte.addTemplate(pdfTemplate, (float)n, (float)(-n));
    }

    protected double getPageFitScale(float f, float f2, float f3, JComponent jComponent) {
        double d;
        double d2 = (f - f3 * 2.0f) / (float)jComponent.getWidth();
        double d3 = Math.min(d2, d = (double)((f2 - f3 * 2.0f) / (float)jComponent.getHeight()));
        d3 = d3 < 1.0 ? d3 : 1.0;
        return d3;
    }

    private JPanel createAdditionalTextPanel(String string) {
        JPanel jPanel = new JPanel();
        BorderLayout borderLayout = new BorderLayout();
        jPanel.setLayout(borderLayout);
        JTextArea jTextArea = new JTextArea();
        jTextArea.setOpaque(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setEditable(false);
        jTextArea.setFocusable(false);
        jTextArea.setText(string);
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Continued ...");
        jTextArea.setBorder(titledBorder);
        jPanel.add((Component)jTextArea, "First");
        return jPanel;
    }

    private int addNewPage(Document document, int n) {
        document.newPage();
        return ++n;
    }

    private class TextPanelHelper {
        private List<JComponent> textPages = new ArrayList<JComponent>();
        private int pageWidth;
        private int pageHeight;
        private JComponent currentPanel;

        public TextPanelHelper(int n, int n2) {
            this.pageHeight = n;
            this.pageWidth = n2;
            this.currentPanel = null;
        }

        private JComponent createPage(String string) {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.setPreferredSize(new Dimension(this.pageWidth, 0));
            JLabel jLabel = new JLabel(string);
            JPanel jPanel2 = ScienceGoalExporter.this.addHaderLabelToView(jPanel, jLabel);
            jPanel2.setVisible(true);
            jPanel2.setSize(new Dimension(this.pageWidth, 0));
            this.textPages.add(jPanel2);
            this.currentPanel = jPanel2;
            ScienceGoalExporter.this.doLayout(jPanel2);
            return jPanel2;
        }

        private int addComponentToTextPanel(JComponent jComponent) {
            this.currentPanel.add(jComponent);
            ScienceGoalExporter.this.doLayout(this.currentPanel);
            return (int)jComponent.getPreferredSize().getHeight();
        }
    }

    private class PageSplitter {
        private List<JPanel> allViews;
        private int pageIndex = -1;
        private List<List<JPanel>> pages = new ArrayList<List<JPanel>>();

        private PageSplitter(List<JPanel> list) {
            this.allViews = list;
        }

        private void setAllViewsOnOff(boolean bl) {
            for (JPanel jPanel : this.allViews) {
                jPanel.setVisible(bl);
            }
        }

        private void showPage(int n) {
            this.pageIndex = n;
            this.setView();
        }

        private void setView() {
            if (this.pageIndex == -1) {
                this.setAllViewsOnOff(true);
                return;
            }
            this.setAllViewsOnOff(false);
            for (JPanel jPanel : this.pages.get(this.pageIndex)) {
                jPanel.setVisible(true);
            }
        }

        private void defaultSplitPages() {
            ScienceGoalExporter.this.offView.headerPanel.setVisible(true);
            ScienceGoalExporter.this.offView.fieldInfoPanel.setVisible(true);
            ScienceGoalExporter.this.offView.spectralInfoPanel.setVisible(true);
            ScienceGoalExporter.this.offView.initalTargetsPanel.setVisible(true);
            JPanel[][] jPanelArrayArray = new JPanel[][]{{ScienceGoalExporter.this.offView.headerPanel, ScienceGoalExporter.this.offView.fieldInfoPanel, ScienceGoalExporter.this.offView.spectralInfoPanel, ScienceGoalExporter.this.offView.initalTargetsPanel}};
            if (ScienceGoalExporter.this.offView.additionalTargetsPanel.isVisible()) {
                jPanelArrayArray = new JPanel[][]{{ScienceGoalExporter.this.offView.headerPanel, ScienceGoalExporter.this.offView.fieldInfoPanel, ScienceGoalExporter.this.offView.spectralInfoPanel, ScienceGoalExporter.this.offView.initalTargetsPanel}, {ScienceGoalExporter.this.offView.additionalTargetsPanel}};
            }
            ScienceGoalExporter.this.offView.technicalJustificationsPanel.setVisible(false);
            ScienceGoalExporter.this.offView.choicesToBeJustifiedPanel.setVisible(false);
            for (JPanel[] jPanelArray : jPanelArrayArray) {
                ArrayList<JPanel> arrayList = new ArrayList<JPanel>();
                boolean bl = false;
                for (JPanel jPanel : jPanelArray) {
                    if (!jPanel.isVisible()) continue;
                    arrayList.add(jPanel);
                    bl = true;
                }
                if (!bl) continue;
                this.pages.add(arrayList);
            }
        }

        private void splitPages() {
            this.defaultSplitPages();
        }

        private int getNumberOfPages() {
            return this.pages.size();
        }
    }
}

