/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.summaryfeedback;

import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.TechnicalJustification;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.ot.editors.sciencegoals.TechnicalJustificationEditor;
import alma.obsprep.ot.models.sciencegoals.TechnicalJustificationModel;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.ConfigurationSet;
import alma.obsprep.services.experts.ScienceGoalConfigurations;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.summaryfeedback.FieldInfoTableModel;
import alma.obsprep.services.summaryfeedback.ScienceGoalSummaryParameters;
import alma.obsprep.services.summaryfeedback.ScienceGoalSummaryView;
import alma.obsprep.services.summaryfeedback.SgControlTableModel;
import alma.obsprep.services.summaryfeedback.SingleContinuumSetupTableModel;
import alma.obsprep.services.summaryfeedback.SourcePropertiesTableModel;
import alma.obsprep.services.summaryfeedback.SpectralLineSetupTableModel;
import alma.obsprep.services.summaryfeedback.SpectralScanSetupTableModel;
import alma.obsprep.services.summaryfeedback.SpectralScanTuningsTableModel;
import alma.obsprep.services.summaryfeedback.SpectralTuningsTableModel;
import alma.obsprep.services.summaryfeedback.TargetListTableModel;
import alma.valuetypes.SkyCoordinates;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ScienceGoalSummaryModel
extends Model {
    protected final SgControlTableModel sgctm = new SgControlTableModel();
    protected final TargetListTableModel tltm1 = new TargetListTableModel(0);
    protected final TargetListTableModel tltm2 = new TargetListTableModel(1);
    protected final TargetListTableModel tltm3 = new TargetListTableModel(2);
    protected final SourcePropertiesTableModel sptm = new SourcePropertiesTableModel();
    protected final Map<Array, FieldInfoTableModel> fitmmap = new HashMap<Array, FieldInfoTableModel>();
    protected final SpectralLineSetupTableModel spectralLineSetupModel;
    protected final SingleContinuumSetupTableModel singleContinuumSetupModel;
    protected final SpectralScanSetupTableModel spectralScanSetupModel;
    protected final SpectralTuningsTableModel spectralTuningsModel;
    protected final SpectralScanTuningsTableModel spectralScanTuningsModel;
    private ScienceGoal scienceGoal;

    public ScienceGoalSummaryModel() {
        super(null);
        this.fitmmap.put(Array.ARRAY_12M, new FieldInfoTableModel(Array.ARRAY_12M));
        this.fitmmap.put(Array.ARRAY_7M, new FieldInfoTableModel(Array.ARRAY_7M));
        this.spectralLineSetupModel = new SpectralLineSetupTableModel();
        this.singleContinuumSetupModel = new SingleContinuumSetupTableModel();
        this.spectralTuningsModel = new SpectralTuningsTableModel();
        this.spectralScanSetupModel = new SpectralScanSetupTableModel();
        this.spectralScanTuningsModel = new SpectralScanTuningsTableModel();
    }

    public ScienceGoalSummaryParameters getParameters() {
        return (ScienceGoalSummaryParameters)this.getDocument();
    }

    public FieldInfoTableModel getFieldInfoTableModel(Array array) {
        return this.fitmmap.get((Object)array);
    }

    @Override
    public void publish() {
        if (this.document == null) {
            return;
        }
        ScienceGoalSummaryParameters scienceGoalSummaryParameters = this.getParameters();
        this.publish(ScienceGoalSummaryView.PROPOSALID, scienceGoalSummaryParameters.proposalID);
        this.publish(ScienceGoalSummaryView.TOOID, scienceGoalSummaryParameters.isToO);
        this.publish(ScienceGoalSummaryView.TIMECONSTRAIND, scienceGoalSummaryParameters.dateRanges);
        this.publish(ScienceGoalSummaryView.SGINDEX, scienceGoalSummaryParameters.sgIndex);
        this.publish(ScienceGoalSummaryView.SBINDEX, scienceGoalSummaryParameters.sbIndex);
        this.publish(ScienceGoalSummaryView.NSGS, scienceGoalSummaryParameters.numberOfSgs);
        this.publish(ScienceGoalSummaryView.SGNAME, scienceGoalSummaryParameters.sgName);
        this.publish(ScienceGoalSummaryView.RECEIVERBAND, scienceGoalSummaryParameters.receiverBand);
        this.publish(ScienceGoalSummaryView.DESCRIPTION, scienceGoalSummaryParameters.description);
        this.publish(ScienceGoalSummaryView.SPECTRALLINESETUPPANEL, (Object)scienceGoalSummaryParameters.getScienceGoal().getSpectralSetupParameters());
        this.publish(ScienceGoalSummaryView.SINGLECONTINUUMSETUPPANEL, (Object)scienceGoalSummaryParameters.getScienceGoal().getSpectralSetupParameters());
        this.publish(ScienceGoalSummaryView.SPECTRALSCANSETUPPANEL, (Object)scienceGoalSummaryParameters.getScienceGoal().getSpectralSetupParameters());
        this.publish(ScienceGoalSummaryView.TUNINGSPANEL, (Object)scienceGoalSummaryParameters.getScienceGoal().getSpectralSetupParameters());
        this.publish(ScienceGoalSummaryView.SCANTUNINGSPANEL, (Object)scienceGoalSummaryParameters.getScienceGoal().getSpectralSetupParameters());
        this.publish(ScienceGoalSummaryView.NTARGETS, scienceGoalSummaryParameters.numberOfTargets);
        this.publish(ScienceGoalSummaryView.NTUNINGS, scienceGoalSummaryParameters.tuningInfo == null ? 0 : scienceGoalSummaryParameters.tuningInfo.getNumTunings());
        this.publish(ScienceGoalSummaryView.SOURCEPROPERITESDYNR, scienceGoalSummaryParameters.sourcePropertiesInfo.dynamicRange);
        FieldID[] fieldIDArray = new FieldID[]{TechnicalJustificationEditor.FID_SHOW_WIDE_BANDWIDTH_WARNING, TechnicalJustificationEditor.FID_SHOW_MAY_NOT_RESOLVE_WARNING, TechnicalJustificationEditor.FID_SHOW_SNR_LOW_WARNING, TechnicalJustificationEditor.FID_SHOW_MAX_DR_WARNING, TechnicalJustificationEditor.FID_LINEWIDTH_GREATER_THAN_SPW_WARNING};
        final HashSet<FieldID> hashSet = new HashSet<FieldID>(Arrays.asList(fieldIDArray));
        TechnicalJustificationModel technicalJustificationModel = new TechnicalJustificationModel(this.getScienceGoal());
        technicalJustificationModel.subscribe(new ModelChangeSubscriber(){

            @Override
            public void modelChanged(Model model, FieldID fieldID, Object object) {
                if (hashSet.contains(fieldID)) {
                    ScienceGoalSummaryModel.this.publish(fieldID, object);
                } else {
                    TechnicalJustificationEditor.TechJustEditor techJustEditor = TechnicalJustificationEditor.TechJustEditor.getEditor(fieldID);
                    if (techJustEditor != null) {
                        ScienceGoalSummaryModel.this.publish(fieldID, object);
                    }
                }
            }
        });
        technicalJustificationModel.publish();
        if (scienceGoalSummaryParameters != null && scienceGoalSummaryParameters.getScienceGoal() != null) {
            SkyCoordinates skyCoordinates = scienceGoalSummaryParameters.getScienceGoal().getKeyTargetParameters().getSourceCoordinates();
            String object = skyCoordinates.getSystem();
            if (SkyCoordinates.isEquatorial(object)) {
                this.publish(ScienceGoalSummaryView.SOURCE_COORD_TYPE, "Ra,Dec ( " + object + " )");
            } else if (SkyCoordinates.isAltAz(object)) {
                this.publish(ScienceGoalSummaryView.SOURCE_COORD_TYPE, "Az,Alt (Deg)");
            } else {
                this.publish(ScienceGoalSummaryView.SOURCE_COORD_TYPE, "Long,Lat (Deg)");
            }
        }
        this.sgctm.fireTableDataChanged();
        this.tltm1.fireTableDataChanged();
        this.tltm2.fireTableDataChanged();
        this.tltm3.fireTableDataChanged();
        this.publish(ScienceGoalSummaryView.SHOWTARGETLISTTABLE, this.tltm1.getRowCount() > 0);
        this.publish(ScienceGoalSummaryView.SHOWTARGETLISTTABLE_2, this.tltm2.getRowCount() > 0);
        this.publish(ScienceGoalSummaryView.SHOWTARGETLISTTABLE_3, this.tltm3.getRowCount() > 0);
        this.sptm.fireTableDataChanged();
        for (FieldInfoTableModel fieldInfoTableModel : this.fitmmap.values()) {
            fieldInfoTableModel.fireTableDataChanged();
        }
        this.publish(ScienceGoalSummaryView.CONFIG_NAME_FOR_12M_EXTENDED, this.configurationNameFor12mExtended());
        this.publish(ScienceGoalSummaryView.CONFIG_NAME_FOR_12M_COMPACT, this.configurationNameFor12mCompact());
        this.spectralLineSetupModel.fireTableDataChanged();
        this.singleContinuumSetupModel.fireTableDataChanged();
        this.spectralScanSetupModel.fireTableDataChanged();
        this.spectralTuningsModel.fireTableDataChanged();
        this.spectralScanTuningsModel.fireTableDataChanged();
    }

    private String configurationNameFor12mCompact() {
        ScienceGoal scienceGoal = this.getScienceGoal();
        if (scienceGoal != null) {
            try {
                ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations = Configuration.getConfigurationsToBeScheduled(scienceGoal);
                assert (scienceGoalConfigurations != null);
                if (scienceGoalConfigurations.getCompactConfigurations().size() == 0) {
                    return "()";
                }
                StringBuffer stringBuffer = new StringBuffer();
                for (Configuration configuration : scienceGoalConfigurations.getCompactConfigurations()) {
                    stringBuffer.append(configuration.getName() + ",");
                }
                return "(" + StringUtils.chop((String)stringBuffer.toString()) + ")";
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                return "()";
            }
        }
        return "()";
    }

    private String configurationNameFor12mExtended() {
        ScienceGoal scienceGoal = this.getScienceGoal();
        if (scienceGoal != null) {
            try {
                ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations = Configuration.getConfigurationsToBeScheduled(scienceGoal);
                assert (scienceGoalConfigurations != null);
                if (scienceGoalConfigurations.getExtendedConfigurations().size() == 0) {
                    return "()";
                }
                StringBuffer stringBuffer = new StringBuffer();
                for (Configuration configuration : scienceGoalConfigurations.getExtendedConfigurations()) {
                    stringBuffer.append(configuration.getName() + ",");
                }
                return "(" + StringUtils.chop((String)stringBuffer.toString()) + ")";
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                return "()";
            }
        }
        return "()";
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        return null;
    }

    @Override
    public void setDocument(Object object) {
        this.document = object;
        ScienceGoalSummaryParameters scienceGoalSummaryParameters = this.getParameters();
        if (scienceGoalSummaryParameters == null) {
            return;
        }
        this.setScienceGoal(scienceGoalSummaryParameters.getScienceGoal());
        this.sgctm.setDocument(scienceGoalSummaryParameters);
        this.tltm1.setDocument(scienceGoalSummaryParameters);
        this.tltm2.setDocument(scienceGoalSummaryParameters);
        this.tltm3.setDocument(scienceGoalSummaryParameters);
        this.sptm.setDocument(scienceGoalSummaryParameters);
        for (FieldInfoTableModel fieldInfoTableModel : this.fitmmap.values()) {
            fieldInfoTableModel.setDocument(scienceGoalSummaryParameters);
        }
        this.spectralLineSetupModel.setDocument(scienceGoalSummaryParameters.tuningInfo);
        this.singleContinuumSetupModel.setDocument(scienceGoalSummaryParameters.tuningInfo);
        this.spectralTuningsModel.setDocument(scienceGoalSummaryParameters.tuningInfo);
        this.spectralScanSetupModel.setDocument(scienceGoalSummaryParameters.scanTuningInfo);
        this.spectralScanTuningsModel.setDocument(scienceGoalSummaryParameters.scanTuningInfo);
        this.publish();
    }

    public String getTechnicalJustificationText(String string) {
        TechnicalJustification[] technicalJustificationArray;
        if (null == this.document) {
            return null;
        }
        TechnicalJustification[] technicalJustificationArray2 = this.getScienceGoal().getTechnicalJustification();
        if (technicalJustificationArray2 instanceof TechnicalJustification[] && (technicalJustificationArray = technicalJustificationArray2).length > 0) {
            for (TechnicalJustification technicalJustification : technicalJustificationArray) {
                if (!technicalJustification.getJustificationKey().equals(string)) continue;
                return technicalJustification.gettrueJustificationText();
            }
        }
        return "";
    }

    public boolean hasTechnicalJustificationFor(String string) {
        TechnicalJustification[] technicalJustificationArray;
        if (null == this.document || null == this.getScienceGoal()) {
            return false;
        }
        TechnicalJustification[] technicalJustificationArray2 = this.getScienceGoal().getTechnicalJustification();
        if (technicalJustificationArray2 instanceof TechnicalJustification[] && (technicalJustificationArray = technicalJustificationArray2).length > 0) {
            for (TechnicalJustification technicalJustification : technicalJustificationArray) {
                if (!technicalJustification.getJustificationKey().equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public ScienceGoal getScienceGoal() {
        return this.scienceGoal;
    }

    public void setScienceGoal(ScienceGoal scienceGoal) {
        this.scienceGoal = scienceGoal;
    }
}

