/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.summaryfeedback;

import alma.obsprep.guiutil.ColumnResizer;
import alma.obsprep.ot.gui.factory.Table;
import alma.obsprep.services.summaryfeedback.FieldInfoTableModel;
import alma.obsprep.services.summaryfeedback.SgControlTableModel;
import alma.obsprep.services.summaryfeedback.SingleContinuumSetupTableModel;
import alma.obsprep.services.summaryfeedback.SourcePropertiesTableModel;
import alma.obsprep.services.summaryfeedback.SpectralLineSetupTableModel;
import alma.obsprep.services.summaryfeedback.SpectralScanSetupTableModel;
import alma.obsprep.services.summaryfeedback.SpectralScanTuningsTableModel;
import alma.obsprep.services.summaryfeedback.SpectralTuningsTableModel;
import alma.obsprep.services.summaryfeedback.SummaryTableCellRendererFactory;
import alma.obsprep.services.summaryfeedback.TargetListTableModel;
import alma.valuetypes.Angle;
import alma.valuetypes.DataRate;
import alma.valuetypes.Frequency;
import alma.valuetypes.Speed;
import alma.valuetypes.StorageVolume;
import alma.valuetypes.Time;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class ScienceGoalSummaryTableFactory {
    private SummaryTableCellRendererFactory rendererFactory = new SummaryTableCellRendererFactory();

    protected Table makeTable(TableModel tableModel) {
        Table table = new Table(tableModel);
        table.getTableHeader().setReorderingAllowed(false);
        table.setRowSelectionAllowed(false);
        table.getColumnModel().setColumnSelectionAllowed(false);
        table.setCellSelectionEnabled(false);
        return table;
    }

    public JTable createScienceGoalControlTable(TableModel tableModel) {
        Table table = this.makeTable(tableModel);
        ColumnResizer.initColumnSizes(table, ((SgControlTableModel)tableModel).getLongValues());
        for (SgControlTableModel.SgControlCols sgControlCols : SgControlTableModel.SgControlCols.values()) {
            SummaryTableCellRendererFactory.SummaryTableCellRenderer summaryTableCellRenderer;
            int n = sgControlCols.ordinal();
            TableColumn tableColumn = table.getColumnModel().getColumn(n);
            switch (sgControlCols) {
                case RESOLUTION: {
                    summaryTableCellRenderer = this.rendererFactory.getAngularResolutionRenderer("%.4f\"", Angle.UNIT_ARCSEC);
                    break;
                }
                case LARGESTSTRUCTURE: {
                    summaryTableCellRenderer = this.rendererFactory.getVupRenderer("%.1f\"", Angle.UNIT_ARCSEC);
                    break;
                }
                case SENSITIVITY: {
                    summaryTableCellRenderer = this.rendererFactory.getARRangeSensitivityRenderer("###0.###", "###0.#");
                    break;
                }
                case REPFREQUENCY: {
                    summaryTableCellRenderer = this.rendererFactory.getVupRenderer("%.6f %s", Frequency.UNIT_GHZ);
                    break;
                }
                case REFERENCEWIDTH: {
                    summaryTableCellRenderer = this.rendererFactory.getUserFrequencyRenderer("###0.###", "###0.#");
                    break;
                }
                case CONTRMS: {
                    summaryTableCellRenderer = this.rendererFactory.getARRangeSensitivityRenderer("###0.###", "###0.#");
                    break;
                }
                case CONTBANDWIDTH: {
                    summaryTableCellRenderer = this.rendererFactory.getVupRenderer("%.3f %s");
                    break;
                }
                default: {
                    summaryTableCellRenderer = this.rendererFactory.getDefaultRenderer();
                }
            }
            tableColumn.setCellRenderer(summaryTableCellRenderer);
        }
        return table;
    }

    public JTable createFieldInfoTable(TableModel tableModel) {
        Table table = this.makeTable(tableModel);
        ColumnResizer.initColumnSizes(table, ((FieldInfoTableModel)tableModel).getLongValues());
        for (FieldInfoTableModel.FieldInfoCols fieldInfoCols : FieldInfoTableModel.FieldInfoCols.values()) {
            SummaryTableCellRendererFactory.SummaryTableCellRenderer summaryTableCellRenderer;
            int n = fieldInfoCols.ordinal();
            TableColumn tableColumn = table.getColumnModel().getColumn(n);
            switch (fieldInfoCols) {
                case MAPSIZE: {
                    summaryTableCellRenderer = this.rendererFactory.getAreaSizeRenderer();
                    break;
                }
                case SPACING: {
                    summaryTableCellRenderer = this.rendererFactory.getMosaicSpacingRenderer();
                    break;
                }
                case HPBW: {
                    summaryTableCellRenderer = this.rendererFactory.getArcsecRenderer("%.1f");
                    break;
                }
                case TOTALTIME: 
                case OTHERTIME: 
                case SCIENCETIME: {
                    summaryTableCellRenderer = this.rendererFactory.getVupRenderer("%.1f %s", Time.UNIT_H, true);
                    break;
                }
                case TIMEPERPOINT: {
                    summaryTableCellRenderer = this.rendererFactory.getVupRenderer("%.1f %s", Time.UNIT_S, true);
                    break;
                }
                case DATAVOLUME: {
                    summaryTableCellRenderer = this.rendererFactory.getVupRenderer("%.1f %s", StorageVolume.UNIT_GB);
                    break;
                }
                case DATARATE: {
                    summaryTableCellRenderer = this.rendererFactory.getVupRenderer("%.1f %s", DataRate.UNIT_MB_S);
                    break;
                }
                default: {
                    summaryTableCellRenderer = this.rendererFactory.getDefaultRenderer();
                }
            }
            tableColumn.setCellRenderer(summaryTableCellRenderer);
        }
        return table;
    }

    public JTable createTargetListTable(TableModel tableModel) {
        Table table = this.makeTable(tableModel);
        ColumnResizer.initColumnSizes(table, ((TargetListTableModel)tableModel).getLongValues());
        for (TargetListTableModel.TargetListCols targetListCols : TargetListTableModel.TargetListCols.values()) {
            SummaryTableCellRendererFactory.SummaryTableCellRenderer summaryTableCellRenderer;
            int n = targetListCols.ordinal();
            TableColumn tableColumn = table.getColumnModel().getColumn(n);
            switch (targetListCols) {
                case TARGETNAME: {
                    summaryTableCellRenderer = this.rendererFactory.getLeftAlignmentRenderer();
                    break;
                }
                case SKYCOORDINATES: {
                    summaryTableCellRenderer = this.rendererFactory.getSkyCoordinatesRenderer();
                    break;
                }
                case VELOCITY: {
                    summaryTableCellRenderer = this.rendererFactory.getVelocityRenderer();
                    break;
                }
                default: {
                    summaryTableCellRenderer = this.rendererFactory.getDefaultRenderer();
                }
            }
            tableColumn.setCellRenderer(summaryTableCellRenderer);
        }
        return table;
    }

    public JTable createSourcePropertiesTable(TableModel tableModel) {
        Table table = this.makeTable(tableModel);
        ColumnResizer.initColumnSizes(table, ((SourcePropertiesTableModel)tableModel).getLongValues());
        for (SourcePropertiesTableModel.SourcePropertiesCols sourcePropertiesCols : SourcePropertiesTableModel.SourcePropertiesCols.values()) {
            SummaryTableCellRendererFactory.SummaryTableCellRenderer summaryTableCellRenderer;
            int n = sourcePropertiesCols.ordinal();
            TableColumn tableColumn = table.getColumnModel().getColumn(n);
            switch (sourcePropertiesCols) {
                case LINEWIDTH: {
                    summaryTableCellRenderer = this.rendererFactory.getVupRenderer("%.0f %s", Speed.UNIT_KM_S);
                    break;
                }
                case PEAKFLUX: {
                    summaryTableCellRenderer = this.rendererFactory.getFluxRenderer();
                    break;
                }
                case POLARIZATION: {
                    summaryTableCellRenderer = this.rendererFactory.getPolarizationRenderer();
                    break;
                }
                case SNR: 
                case POLSNR: {
                    summaryTableCellRenderer = this.rendererFactory.getSimpleValueRenderer("%.1f");
                    break;
                }
                case REQLINERMS: {
                    summaryTableCellRenderer = this.rendererFactory.getSensitivityRenderer("###0.##", "###0.#");
                    break;
                }
                case WIDTHRATIO: {
                    summaryTableCellRenderer = this.rendererFactory.getSignificantDigitRenderer();
                    break;
                }
                default: {
                    summaryTableCellRenderer = this.rendererFactory.getDefaultRenderer();
                }
            }
            tableColumn.setCellRenderer(summaryTableCellRenderer);
        }
        return table;
    }

    public JTable createSpectralLineSetupTable(TableModel tableModel) {
        Table table = this.makeTable(tableModel);
        ColumnResizer.initColumnSizes(table, ((SpectralLineSetupTableModel)tableModel).getLongValues());
        for (SpectralLineSetupTableModel.SpectralLineSetupCols spectralLineSetupCols : SpectralLineSetupTableModel.SpectralLineSetupCols.values()) {
            SummaryTableCellRendererFactory.SummaryTableCellRenderer summaryTableCellRenderer;
            int n = spectralLineSetupCols.ordinal();
            TableColumn tableColumn = table.getColumnModel().getColumn(n);
            switch (spectralLineSetupCols) {
                case RESTFREQUENCY: {
                    summaryTableCellRenderer = this.rendererFactory.getSimpleValueRenderer("%.6f");
                    break;
                }
                case BANDWIDTH: {
                    summaryTableCellRenderer = this.rendererFactory.getVupRenderer("%.2f %s", Frequency.UNIT_MHZ);
                    break;
                }
                case RESOLUTION: {
                    summaryTableCellRenderer = this.rendererFactory.getVupRenderer("%.3f %s");
                    break;
                }
                case VELWIDTH: {
                    summaryTableCellRenderer = this.rendererFactory.getVupRenderer("%.1f %s", Speed.UNIT_KM_S);
                    break;
                }
                case VELRES: {
                    summaryTableCellRenderer = this.rendererFactory.getVupRenderer("%.3f %s", Speed.UNIT_KM_S);
                    break;
                }
                case RESEL: {
                    summaryTableCellRenderer = this.rendererFactory.getSimpleValueRenderer("%.0f");
                    break;
                }
                default: {
                    summaryTableCellRenderer = this.rendererFactory.getDefaultRenderer();
                }
            }
            tableColumn.setCellRenderer(summaryTableCellRenderer);
        }
        return table;
    }

    public JTable createSingleContinuumSetupTable(TableModel tableModel) {
        Table table = this.makeTable(tableModel);
        ColumnResizer.initColumnSizes(table, ((SingleContinuumSetupTableModel)tableModel).getLongValues());
        for (SingleContinuumSetupTableModel.SingleContinuumSetupCols singleContinuumSetupCols : SingleContinuumSetupTableModel.SingleContinuumSetupCols.values()) {
            SummaryTableCellRendererFactory.SummaryTableCellRenderer summaryTableCellRenderer;
            int n = singleContinuumSetupCols.ordinal();
            TableColumn tableColumn = table.getColumnModel().getColumn(n);
            switch (singleContinuumSetupCols) {
                case CENTERFREQSKY: {
                    summaryTableCellRenderer = this.rendererFactory.getSingleContinuumSkyFrequencyRenderer("%.6f");
                    break;
                }
                case SPWFREQSKY: {
                    summaryTableCellRenderer = this.rendererFactory.getSimpleValueRenderer("%.6f");
                    break;
                }
                case BANDWIDTH: {
                    summaryTableCellRenderer = this.rendererFactory.getVupRenderer("%.2f %s", Frequency.UNIT_MHZ);
                    break;
                }
                case RESOLUTION: {
                    summaryTableCellRenderer = this.rendererFactory.getVupRenderer("%.3f %s");
                    break;
                }
                case VELWIDTH: {
                    summaryTableCellRenderer = this.rendererFactory.getVupRenderer("%.1f %s", Speed.UNIT_KM_S);
                    break;
                }
                case VELRESOLUTION: {
                    summaryTableCellRenderer = this.rendererFactory.getVupRenderer("%.3f %s", Speed.UNIT_KM_S);
                    break;
                }
                case RMS: {
                    summaryTableCellRenderer = this.rendererFactory.getSensitivityRenderer("###0.##", "###0.0");
                    break;
                }
                default: {
                    summaryTableCellRenderer = this.rendererFactory.getDefaultRenderer();
                }
            }
            tableColumn.setCellRenderer(summaryTableCellRenderer);
        }
        return table;
    }

    public JTable createTuningsTable(TableModel tableModel) {
        Table table = this.makeTable(tableModel);
        ColumnResizer.initColumnSizes(table, ((SpectralTuningsTableModel)tableModel).getLongValues());
        for (SpectralTuningsTableModel.TuningCols tuningCols : SpectralTuningsTableModel.TuningCols.values()) {
            SummaryTableCellRendererFactory.SummaryTableCellRenderer summaryTableCellRenderer;
            int n = tuningCols.ordinal();
            TableColumn tableColumn = table.getColumnModel().getColumn(n);
            switch (tuningCols) {
                case TUNING: {
                    summaryTableCellRenderer = this.rendererFactory.getSimpleValueRenderer("%d");
                    break;
                }
                case TARGET: {
                    summaryTableCellRenderer = this.rendererFactory.getSimpleValueRenderer("%s");
                    break;
                }
                case FREQUENCY: {
                    summaryTableCellRenderer = this.rendererFactory.getVupRenderer("%.6f", Frequency.UNIT_GHZ);
                    break;
                }
                case RMS: {
                    summaryTableCellRenderer = this.rendererFactory.getSensitivityRenderer("###0.##", "###0.0");
                    break;
                }
                case RMSRANGE: {
                    summaryTableCellRenderer = this.rendererFactory.getSensitivityRangeRenderer();
                    break;
                }
                default: {
                    summaryTableCellRenderer = this.rendererFactory.getDefaultRenderer();
                }
            }
            tableColumn.setCellRenderer(summaryTableCellRenderer);
        }
        return table;
    }

    public JTable createSpectralScanSetupTable(TableModel tableModel) {
        Table table = this.makeTable(tableModel);
        ColumnResizer.initColumnSizes(table, ((SpectralScanSetupTableModel)tableModel).getLongValues());
        for (SpectralScanSetupTableModel.SpectralScanSetupCols spectralScanSetupCols : SpectralScanSetupTableModel.SpectralScanSetupCols.values()) {
            SummaryTableCellRendererFactory.SummaryTableCellRenderer summaryTableCellRenderer;
            int n = spectralScanSetupCols.ordinal();
            TableColumn tableColumn = table.getColumnModel().getColumn(n);
            switch (spectralScanSetupCols) {
                case STARTFREQUENCY: 
                case ENDFREQUENCY: {
                    summaryTableCellRenderer = this.rendererFactory.getVupRenderer("%.3f %s", Frequency.UNIT_GHZ);
                    break;
                }
                case RESOLUTION: {
                    summaryTableCellRenderer = this.rendererFactory.getVupRenderer("%.3f %s", Frequency.UNIT_MHZ);
                    break;
                }
                case VELWIDTH: {
                    summaryTableCellRenderer = this.rendererFactory.getVupRenderer("%.0f %s", Speed.UNIT_KM_S);
                    break;
                }
                case VELRESOLUTION: {
                    summaryTableCellRenderer = this.rendererFactory.getVupRenderer("%.3f %s", Speed.UNIT_KM_S);
                    break;
                }
                case RESEL: {
                    summaryTableCellRenderer = this.rendererFactory.getSimpleValueRenderer("%.1f");
                    break;
                }
                case RMS: {
                    summaryTableCellRenderer = this.rendererFactory.getSensitivityRenderer("###0.##", "###0.0");
                    break;
                }
                default: {
                    summaryTableCellRenderer = this.rendererFactory.getDefaultRenderer();
                }
            }
            tableColumn.setCellRenderer(summaryTableCellRenderer);
        }
        return table;
    }

    public JTable createScanTuningsTable(TableModel tableModel) {
        Table table = this.makeTable(tableModel);
        ColumnResizer.initColumnSizes(table, ((SpectralScanTuningsTableModel)tableModel).getLongValues());
        for (SpectralScanTuningsTableModel.ScanTuningCols scanTuningCols : SpectralScanTuningsTableModel.ScanTuningCols.values()) {
            SummaryTableCellRendererFactory.SummaryTableCellRenderer summaryTableCellRenderer;
            int n = scanTuningCols.ordinal();
            TableColumn tableColumn = table.getColumnModel().getColumn(n);
            switch (scanTuningCols) {
                case SPW1: 
                case SPW2: 
                case SPW3: 
                case SPW4: {
                    summaryTableCellRenderer = this.rendererFactory.getVupRenderer("%.6f");
                    break;
                }
                default: {
                    summaryTableCellRenderer = this.rendererFactory.getDefaultRenderer();
                }
            }
            tableColumn.setCellRenderer(summaryTableCellRenderer);
        }
        return table;
    }
}

