/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.summaryfeedback;

import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TemporalParameters;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.sciencegoals.TechnicalJustificationEditor;
import alma.obsprep.services.summaryfeedback.FieldInfoTableModel;
import alma.obsprep.services.summaryfeedback.PdfExporter;
import alma.obsprep.services.summaryfeedback.ScienceGoalExporter;
import alma.obsprep.services.summaryfeedback.ScienceGoalPrintable;
import alma.obsprep.services.summaryfeedback.ScienceGoalSummaryModel;
import alma.obsprep.services.summaryfeedback.ScienceGoalSummaryTableFactory;
import alma.obsprep.services.summaryfeedback.SummaryFeedbackView;
import alma.obsprep.services.summaryfeedback.TargetListTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.print.Printable;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ScienceGoalSummaryView
extends SummaryFeedbackView {
    private static final long serialVersionUID = -403414363237550735L;
    public static final FieldID PROPOSALID = new FieldID("ScienceGoalSummary.proposalId");
    public static final FieldID TOOID = new FieldID("ScienceGoalSummary.tooId");
    public static final FieldID TIMECONSTRAIND = new FieldID("ScienceGoalSummary.timeConstraint");
    public static final FieldID SGINDEX = new FieldID("ScienceGoalSummary.sgIndex");
    public static final FieldID SBINDEX = new FieldID("ScienceGoalSummaryView.sbIndex");
    public static final FieldID NSGS = new FieldID("ScienceGoalSummary.nSGs");
    public static final FieldID SGNAME = new FieldID("ScienceGoalSummary.sgName");
    public static final FieldID RECEIVERBAND = new FieldID("ScienceGoalSummary.receiverBand");
    public static final FieldID DESCRIPTION = new FieldID("ScienceGoalSummary.description");
    public static final FieldID SGCONTROLTABLE = new FieldID("ScienceGoalSummary.scControlTable");
    public static final FieldID FIELDINFOTABLE_12 = new FieldID("ScienceGoalSummary.fieldInfoTable");
    public static final FieldID FIELDINFOTABLE_7 = new FieldID("ScienceGoalSummary.fieldInfoTable");
    public static final FieldID TARGETLISTTABLE = new FieldID("ScienceGoalSummary.targetlistTable");
    public static final FieldID TARGETLISTTABLE_2 = new FieldID("ScienceGoalSummary.targetlistTable2");
    public static final FieldID TARGETLISTTABLE_3 = new FieldID("ScienceGoalSummary.targetlistTable3");
    public static final FieldID SHOWTARGETLISTTABLE = new FieldID("ScienceGoalSummary.showTargetlistTable");
    public static final FieldID SHOWTARGETLISTTABLE_2 = new FieldID("ScienceGoalSummary.showTargetlistTable2");
    public static final FieldID SHOWTARGETLISTTABLE_3 = new FieldID("ScienceGoalSummary.showTargetlistTable3");
    public static final FieldID NTARGETS = new FieldID("ScienceGoalSummary.nTargets");
    public static final FieldID SOURCEPROPERTIESTABLE = new FieldID("ScienceGoalSummary.sourcePropsTable");
    public static final FieldID SOURCEPROPERITESDYNR = new FieldID("SicneceGoalSummary.sourcePropsDynRange");
    public static final FieldID SPECTRALLINESETUPPANEL = new FieldID("ScienceGoalSummary.spectralLineSetupPanel");
    public static final FieldID SINGLECONTINUUMSETUPPANEL = new FieldID("ScienceGoalSummary.singleContinuumSetupPanel");
    public static final FieldID SPECTRALSCANSETUPPANEL = new FieldID("ScienceGoalSummary.spectralScanSetupPanel");
    public static final FieldID SPECTRALLINESETUPTABLE = new FieldID("ScienceGoalSummary.spectralLineSetupTable");
    public static final FieldID SINGLECONTINUUMSETUPTABLE = new FieldID("ScienceGoalSummary.singleContinuumSetupTable");
    public static final FieldID SPECTRALSCANSETUPTABLE = new FieldID("ScienceGoalSummary.spectralScanSetupTable");
    public static final FieldID SPECTRALLINETUNINGTABLE = new FieldID("ScienceGoalSummary.spectralLineTuningTable");
    public static final FieldID SPECTRALSCANTUNINGTABLE = new FieldID("ScienceGoalSummary.spectralScanTuningTable");
    public static final FieldID NTUNINGS = new FieldID("ScienceGoalSummary.nTunings");
    public static final FieldID TUNINGSPANEL = new FieldID("ScienceGoalSummary.tuningsPanel");
    public static final FieldID SCANTUNINGSPANEL = new FieldID("ScienceGoalSummary.scanTuningsPanel");
    public static final FieldID JUSTIFICATIONTEXT = new FieldID("ScienceGoalSummary.justificaitonText");
    public static final FieldID ADDITIONAL_TIME = new FieldID("ScienceGoalSummaryView.ADDITIONAL_TIME");
    public static final FieldID ANGULAR_RESOLUTION = new FieldID("ScienceGoalSummaryView.ANGULAR_RESOLUTION");
    public static final FieldID CORRELATOR = new FieldID("ScienceGoalSummaryView.CORRELATOR");
    public static final FieldID HIGH_DATA_RATE = new FieldID("ScienceGoalSummaryView.HIGH_DATA_RATE");
    public static final FieldID LOW_MAX_ELEVATION = new FieldID("ScienceGoalSummaryView.LOW_MAX_ELEVATION");
    public static final FieldID NON_NYQUIST = new FieldID("ScienceGoalSummaryView.NON_NYQUIST");
    public static final FieldID NON_STD_CONT_FREQ = new FieldID("ScienceGoalSummaryView.NON_STD_CONT_FREQ");
    public static final FieldID SENSITIVITY = new FieldID("ScienceGoalSummaryView.SENSITIVITY");
    public static final FieldID SINGLE_POLARISATION = new FieldID("ScienceGoalSummaryView.SINGLE_POLARISATION");
    public static final FieldID TIME_CONSTRAINT = new FieldID("ScienceGoalSummaryView.TIME_CONSTRAINT");
    public static final FieldID USER_DEFINED_CALIB = new FieldID("ScienceGoalSummaryView.USER_DEFINED_CALIB");
    public static final FieldID ACA_SETUP = new FieldID("ScienceGoalSummaryView.ACA");
    public static final FieldID ADDITIONAL_TIME_FLG = new FieldID("ScienceGoalSummaryView.ADDITIONAL_TIME_FLG");
    public static final FieldID ANGULAR_RESOLUTION_FLG = new FieldID("ScienceGoalSummaryView.ANGULAR_RESOLUTION_FLG");
    public static final FieldID CORRELATOR_FLG = new FieldID("ScienceGoalSummaryView.CORRELATOR_FLG");
    public static final FieldID HIGH_DATA_RATE_FLG = new FieldID("ScienceGoalSummaryView.HIGH_DATA_RATE_FLG");
    public static final FieldID LOW_MAX_ELEVATION_FLG = new FieldID("ScienceGoalSummaryView.LOW_MAX_ELEVATION_FLG");
    public static final FieldID NON_NYQUIST_FLG = new FieldID("ScienceGoalSummaryView.NON_NYQUIST_FLG");
    public static final FieldID NON_STD_CONT_FREQ_FLG = new FieldID("ScienceGoalSummaryView.NON_STD_CONT_FREQ_FLG");
    public static final FieldID SENSITIVITY_FLG = new FieldID("ScienceGoalSummaryView.SENSITIVITY_FLG");
    public static final FieldID SINGLE_POLARISATION_FLG = new FieldID("ScienceGoalSummaryView.SINGLE_POLARISATION_FLG");
    public static final FieldID TIME_CONSTRAINT_FLG = new FieldID("ScienceGoalSummaryView.TIME_CONSTRAINT");
    public static final FieldID USER_DEFINED_CALIB_FLG = new FieldID("ScienceGoalSummaryView.USER_DEFINED_CALIB_FLG");
    public static final FieldID ACA_SETUP_FLG = new FieldID("ScienceGoalSummaryView.ACA_FLG");
    public static final FieldID CONFIG_NAME_FOR_12M_COMPACT = new FieldID("ScienceGoalSummaryView.CONFIG_NAME_FOR_12M");
    public static final FieldID CONFIG_NAME_FOR_12M_EXTENDED = new FieldID("ScienceGoalSummaryView.CONFIG_NAME_FOR_12M");
    public static final FieldID SOURCE_COORD_TYPE = new FieldID("ScienceGoalSummaryView.SOURCE_COORD_TYPE");
    protected JPanel headerPanel;
    protected JPanel fieldInfoPanel;
    protected JPanel initalTargetsPanel;
    protected JPanel additionalTargetsPanel;
    protected JPanel spectralInfoPanel;
    protected JPanel technicalJustificationsPanel;
    protected JPanel choicesToBeJustifiedPanel;
    protected JPanel additionalTimePanel;
    protected JPanel angularResolutionPanel;
    protected JPanel correlatorPanel;
    protected JPanel lowMaxElevationPanel;
    protected JPanel nonNyquistPanel;
    protected JPanel nonStdContFrequencyPanel;
    protected JPanel sensitivityPanel;
    protected JPanel singlePolarisationPanel;
    protected JPanel timeConstraintPanel;
    protected JPanel userDefinedCalibrationPanel;
    protected JPanel acaSetupPanel;
    protected JPanel sensitivityCommentPanel;
    protected JPanel correlatorCommentPanel;
    protected JPanel targetList_1;
    protected JPanel targetList_2;
    protected JPanel targetList_3;
    protected TreeMap<TechnicalJustificationEditor.TechJustEditor, JComponent> technicalJustificationsSections = new TreeMap();
    private ScienceGoalSummaryTableFactory tableFactory;
    protected static final JLabel wideBandwidthWarning = ScienceGoalSummaryView.decorateLabelForPDF(new JLabel(TechnicalJustificationEditor.wideBandwidthWarning.getText()));
    protected static final JLabel mayNotResolveWarning = ScienceGoalSummaryView.decorateLabelForPDF(new JLabel(TechnicalJustificationEditor.mayNotResolveWarning.getText()));
    protected static final JLabel snrLowWarning = ScienceGoalSummaryView.decorateLabelForPDF(new JLabel(TechnicalJustificationEditor.snrLowWarning.getText()));
    protected static final JLabel dynamicRangeWarning = ScienceGoalSummaryView.decorateLabelForPDF(new JLabel(TechnicalJustificationEditor.dynamicRangeWarning.getText()));
    protected static final JLabel linewidthGreaterThanSPWWarning = ScienceGoalSummaryView.decorateLabelForPDF(new JLabel(TechnicalJustificationEditor.linewidthGreaterThanSPWWarning.getText()));
    private Color sectionTitleColor = new Color(0, 128, 0);

    private static JLabel decorateLabelForPDF(JLabel jLabel) {
        jLabel.setForeground(Color.BLUE);
        return jLabel;
    }

    private String sectionTitleColorString(String string) {
        return "<html><font color=green>" + string + "</font></html>";
    }

    public ScienceGoalSummaryView(Model model) {
        this.tableFactory = new ScienceGoalSummaryTableFactory();
        this.setModel(model);
        this.build();
        model.publish();
    }

    @Override
    protected ScienceGoalSummaryView createOffView() {
        ScienceGoalSummaryModel scienceGoalSummaryModel = new ScienceGoalSummaryModel();
        scienceGoalSummaryModel.setDocument(this.getModel().getDocument());
        ScienceGoalSummaryView scienceGoalSummaryView = new ScienceGoalSummaryView(scienceGoalSummaryModel);
        scienceGoalSummaryView.defaultBackgroundColor = scienceGoalSummaryView.getBackground();
        scienceGoalSummaryView.setBackgroundToWhite();
        return scienceGoalSummaryView;
    }

    @Override
    public ScienceGoalSummaryModel getModel() {
        return (ScienceGoalSummaryModel)super.getModel();
    }

    @Override
    protected void build() {
        super.build("ScienceGoalSummaryView");
    }

    @Override
    protected void addComponents(String string) {
        this.addComponent(this.createMainPanel());
    }

    private JTable registerTable(JTable jTable, FieldID fieldID) {
        this.register(jTable, fieldID);
        return jTable;
    }

    protected JPanel addTableHeader(JTable jTable) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jTable.getTableHeader(), "North");
        jPanel.add((Component)jTable, "South");
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        return jPanel;
    }

    protected JPanel createMainPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        this.headerPanel = this.createHeaderPanel();
        this.fieldInfoPanel = this.createFieldInfoPanel();
        this.spectralInfoPanel = this.createSpectralInfoPanel();
        this.initalTargetsPanel = this.createInitialTargetFieldInfoPanel();
        this.additionalTargetsPanel = this.createAdditionalTargetsPanel();
        this.technicalJustificationsPanel = this.createTechnicalJustificationsPanel();
        this.choicesToBeJustifiedPanel = this.createChoicesToBeJustifiedPanel();
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.headerPanel, 10, 2);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.fieldInfoPanel, 10, 2);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.spectralInfoPanel, 10, 2);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.initalTargetsPanel, 19, 2);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.additionalTargetsPanel, 19, 2);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.technicalJustificationsPanel, 10, 2);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.choicesToBeJustifiedPanel, 10, 2);
        return jPanel;
    }

    protected JPanel createTechnicalJustificationsPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.setLayout(gridBagLayout);
        jPanel.setFont(new Font("Serif", 1, 64));
        jPanel.setForeground(Color.red);
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints, 20);
        this.sensitivityCommentPanel = this.createSensitivityCommentPanel(new FieldID(), "Sensitivity Comments");
        this.correlatorCommentPanel = this.createCorrelatorCommentPanel(new FieldID(), "Correlator Comments");
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.sensitivityCommentPanel, 10, 2);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.correlatorCommentPanel, 10, 2);
        this.sensitivityPanel = this.createJustificationTextPanel(TechnicalJustificationEditor.TechJustEditor.ED_SENSITIVITY, "Justification for requested RMS and resulting S/N (and for spectral lines the bandwidth selected) for the sensitivity calculation.");
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.sensitivityPanel, 11, 2);
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        this.angularResolutionPanel = this.createJustificationTextPanel(TechnicalJustificationEditor.TechJustEditor.ED_ANGULAR_RESOLUTION, "Justification of the chosen angular resolution and largest angular scale for the source(s) in this Science Goal.");
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.angularResolutionPanel, 11, 2);
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        this.nonNyquistPanel = this.createJustificationTextPanel(TechnicalJustificationEditor.TechJustEditor.ED_NON_NYQUIST, "Justification for use of Non-nyquist sampling.");
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.nonNyquistPanel, 11, 2);
        this.correlatorPanel = this.createJustificationTextPanel(TechnicalJustificationEditor.TechJustEditor.ED_CORRELATOR, "Justification of the correlator set-up with particular reference to the number of spectral resolution elements per line width. ");
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.correlatorPanel, 11, 2);
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        return jPanel;
    }

    protected JPanel createChoicesToBeJustifiedPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.setLayout(gridBagLayout);
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints, 10);
        this.userDefinedCalibrationPanel = this.createJustificationTextPanel(TechnicalJustificationEditor.TechJustEditor.ED_USER_DEFINED_CALIB, "Justification of selection of user-defined calibration.");
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.userDefinedCalibrationPanel, 10, 2);
        this.additionalTimePanel = this.createJustificationTextPanel(TechnicalJustificationEditor.TechJustEditor.ED_ADDITIONAL_TIME, "Justification for override of OT's sensitivity-based time estimate.");
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.additionalTimePanel, 10, 2);
        this.lowMaxElevationPanel = this.createJustificationTextPanel(TechnicalJustificationEditor.TechJustEditor.ED_LOW_MAX_ELEVATION, "Justification for low max elevation for target.");
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.lowMaxElevationPanel, 10, 2);
        this.nonStdContFrequencyPanel = this.createJustificationTextPanel(TechnicalJustificationEditor.TechJustEditor.ED_NON_STD_CONT_FREQ, "Justification for non standard continuum frequencies.");
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.nonStdContFrequencyPanel, 10, 2);
        this.singlePolarisationPanel = this.createJustificationTextPanel(TechnicalJustificationEditor.TechJustEditor.ED_SINGLE_POLARISATION, "Justification for single polarisation.");
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.singlePolarisationPanel, 10, 2);
        this.timeConstraintPanel = this.createJustificationTextPanel(TechnicalJustificationEditor.TechJustEditor.ED_TIME_CONSTRAINT, "Justification and additional details of specific time constraints.");
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.timeConstraintPanel, 10, 2);
        this.timeConstraintPanel = this.createJustificationTextPanel(TechnicalJustificationEditor.TechJustEditor.ED_VLBI, "Justification and additional details for VLBI.");
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.timeConstraintPanel, 10, 2);
        this.timeConstraintPanel = this.createJustificationTextPanel(TechnicalJustificationEditor.TechJustEditor.ED_SOLAR, "Justification and additional details for Solar.");
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.timeConstraintPanel, 10, 2);
        return jPanel;
    }

    private JPanel createHeaderPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        jPanel.setLayout(gridBagLayout);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.makeLabel(PROPOSALID), 10);
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        EditorWithGridBagLayout.ComponentCollection componentCollection = new EditorWithGridBagLayout.ComponentCollection(this);
        JLabel jLabel = this.makeLabel("<html>This is a ScienceGoal in the \"Target Of Opportunity\" proposal.</html>");
        this.register(jLabel, TOOID);
        componentCollection.remember(jLabel);
        this.addComponentsLine(jPanel, gridBagLayout, gridBagConstraints, componentCollection);
        componentCollection = new EditorWithGridBagLayout.ComponentCollection(this);
        jLabel = this.makeLabel(TIMECONSTRAIND);
        componentCollection.remember(jLabel);
        this.addComponentsLine(jPanel, gridBagLayout, gridBagConstraints, componentCollection);
        componentCollection = new EditorWithGridBagLayout.ComponentCollection(this);
        Box box = Box.createHorizontalBox();
        box.add(this.makeLabel(SGINDEX));
        box.add(this.makeLabel(NSGS));
        JLabel jLabel2 = this.makeLabel(SBINDEX);
        jLabel2.setVisible(false);
        box.add(jLabel2);
        componentCollection.remember(box);
        componentCollection.remember(this.makeLabel(SGNAME));
        componentCollection.remember(this.makeLabel(RECEIVERBAND));
        this.addComponentsLine(jPanel, gridBagLayout, gridBagConstraints, componentCollection);
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        return jPanel;
    }

    private JPanel createFieldInfoPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.setLayout(gridBagLayout);
        ScienceGoalSummaryModel scienceGoalSummaryModel = this.getModel();
        JTextArea jTextArea = this.makeTextArea(DESCRIPTION, 2, 75);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, jTextArea);
        jTextArea.setOpaque(true);
        jTextArea.setBorder(BorderFactory.createEtchedBorder());
        String string = "Science Goal Parameters";
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.makeLabel(this.sectionTitleColorString(string)));
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.addTableHeader(this.registerTable(this.tableFactory.createScienceGoalControlTable(scienceGoalSummaryModel.sgctm), SGCONTROLTABLE)));
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        AlmaCapabilities almaCapabilities = AlmaCapabilities.getInstance();
        SpectralSetupParameters spectralSetupParameters = null;
        if (scienceGoalSummaryModel.getScienceGoal() != null) {
            spectralSetupParameters = scienceGoalSummaryModel.getScienceGoal().getSpectralSetupParameters();
        }
        string = "Use of 12m Array (" + almaCapabilities.getNumAntennas(Array.ARRAY_12M, spectralSetupParameters) + " antennas)";
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.makeLabel(this.sectionTitleColorString(string)));
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.addTableHeader(this.registerTable(this.tableFactory.createFieldInfoTable(scienceGoalSummaryModel.getFieldInfoTableModel(Array.ARRAY_12M)), FIELDINFOTABLE_12)));
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        string = "Use of ACA 7m Array (" + almaCapabilities.getNumAntennas(Array.ARRAY_7M, spectralSetupParameters) + " antennas) and TP Array";
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.makeLabel(this.sectionTitleColorString(string)));
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.addTableHeader(this.registerTable(this.tableFactory.createFieldInfoTable(scienceGoalSummaryModel.getFieldInfoTableModel(Array.ARRAY_7M)), FIELDINFOTABLE_7)));
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        return jPanel;
    }

    private JPanel createInitialTargetFieldInfoPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 19;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.setLayout(gridBagLayout);
        ScienceGoalSummaryModel scienceGoalSummaryModel = this.getModel();
        this.targetList_1 = this.createTargetListTable(scienceGoalSummaryModel.tltm1, true, TARGETLISTTABLE);
        JPanel jPanel2 = this.createSourcePropertiesTuningPanel();
        this.addLeftAndRightPanels(jPanel, gridBagLayout, gridBagConstraints, this.targetList_1, jPanel2);
        return jPanel;
    }

    private JPanel createAdditionalTargetsPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 19;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.setLayout(gridBagLayout);
        ScienceGoalSummaryModel scienceGoalSummaryModel = this.getModel();
        this.targetList_2 = this.createTargetListTable(scienceGoalSummaryModel.tltm2, false, TARGETLISTTABLE_2);
        this.targetList_3 = this.createTargetListTable(scienceGoalSummaryModel.tltm3, false, TARGETLISTTABLE_3);
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        this.addLeftAndRightPanels(jPanel, gridBagLayout, gridBagConstraints, this.targetList_2, this.targetList_3);
        return jPanel;
    }

    private JPanel createTargetListTable(TargetListTableModel targetListTableModel, boolean bl, FieldID fieldID) {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 19;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.8;
        jPanel.setLayout(gridBagLayout);
        if (bl) {
            this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.makeLabel(NTARGETS));
            this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        }
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.addTableHeader(this.registerTable(this.tableFactory.createTargetListTable(targetListTableModel), fieldID)));
        return jPanel;
    }

    private JPanel createSourcePropertiesTuningPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.setLayout(gridBagLayout);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.createSourcePropertiesTuningsPanel());
        return jPanel;
    }

    private void addLeftAndRightPanels(JPanel jPanel, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, JPanel jPanel2, JPanel jPanel3) {
        JPanel jPanel4 = new JPanel();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 11;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 0.8;
        gridBagConstraints2.fill = 2;
        jPanel4.setLayout(gridBagLayout2);
        EditorWithGridBagLayout.ComponentCollection componentCollection = new EditorWithGridBagLayout.ComponentCollection(this);
        if (null != jPanel2) {
            componentCollection.remember(jPanel2);
        }
        if (null != jPanel3) {
            componentCollection.remember(jPanel3);
        }
        if (componentCollection.size() > 0) {
            this.addComponentsLine(jPanel4, gridBagLayout2, gridBagConstraints2, componentCollection);
            this.addComponent(jPanel, gridBagLayout, gridBagConstraints, jPanel4);
            this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
            jPanel.setVisible(true);
        } else {
            jPanel.setVisible(false);
        }
    }

    private JPanel createSourcePropertiesTuningsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = this.createSourcePropertiesPanel();
        jPanel.add(jPanel2);
        JPanel jPanel3 = this.createTuningsPanel();
        this.register(jPanel3, TUNINGSPANEL);
        jPanel.add(jPanel3);
        JPanel jPanel4 = this.createScanTuningsPanel();
        this.register(jPanel4, SCANTUNINGSPANEL);
        jPanel.add(jPanel4);
        return jPanel;
    }

    private JPanel createSourcePropertiesPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.setLayout(gridBagLayout);
        ScienceGoalSummaryModel scienceGoalSummaryModel = this.getModel();
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.makeLabel(this.sectionTitleColorString("Expected Source Properties")));
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints, 5);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.addTableHeader(this.registerTable(this.tableFactory.createSourcePropertiesTable(scienceGoalSummaryModel.sptm), SOURCEPROPERTIESTABLE)));
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.makeLabel(SOURCEPROPERITESDYNR));
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints, 10);
        return jPanel;
    }

    private JPanel createTuningsPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.setLayout(gridBagLayout);
        ScienceGoalSummaryModel scienceGoalSummaryModel = this.getModel();
        JTable jTable = this.tableFactory.createTuningsTable(scienceGoalSummaryModel.spectralTuningsModel);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.makeLabel(NTUNINGS));
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.addTableHeader(this.registerTable(jTable, SPECTRALLINETUNINGTABLE)));
        jPanel.setVisible(true);
        return jPanel;
    }

    private JPanel createScanTuningsPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.setLayout(gridBagLayout);
        ScienceGoalSummaryModel scienceGoalSummaryModel = this.getModel();
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.makeLabel(this.sectionTitleColorString("Spectral scan tunings (frequencies on Sky)")));
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.addTableHeader(this.registerTable(this.tableFactory.createScanTuningsTable(scienceGoalSummaryModel.spectralScanTuningsModel), SPECTRALSCANTUNINGTABLE)));
        return jPanel;
    }

    private JPanel createSpectralInfoPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = this.createSpectralLineSetupPanel();
        this.register(jPanel2, SPECTRALLINESETUPPANEL);
        jPanel.add(jPanel2);
        jPanel2 = this.createSingleContinuumSetupPanel();
        this.register(jPanel2, SINGLECONTINUUMSETUPPANEL);
        jPanel.add(jPanel2);
        jPanel2 = this.createSpectralScanSetupPanel();
        this.register(jPanel2, SPECTRALSCANSETUPPANEL);
        jPanel.add(jPanel2);
        return jPanel;
    }

    private JPanel createSpectralLineSetupPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        jPanel.setLayout(gridBagLayout);
        ScienceGoalSummaryModel scienceGoalSummaryModel = this.getModel();
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 10;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        jPanel2.setLayout(gridBagLayout2);
        String string = "Spectral Setup : Spectral Line";
        this.addComponent(jPanel2, gridBagLayout2, gridBagConstraints2, this.makeLabel(this.sectionTitleColorString(string)));
        this.addVerticalSpace(jPanel2, gridBagLayout2, gridBagConstraints2);
        this.addComponent(jPanel2, gridBagLayout2, gridBagConstraints2, this.addTableHeader(this.registerTable(this.tableFactory.createSpectralLineSetupTable(scienceGoalSummaryModel.spectralLineSetupModel), SPECTRALLINESETUPTABLE)));
        return jPanel2;
    }

    private JPanel createSingleContinuumSetupPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        jPanel.setLayout(gridBagLayout);
        ScienceGoalSummaryModel scienceGoalSummaryModel = this.getModel();
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 10;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        jPanel2.setLayout(gridBagLayout2);
        String string = "Spectral Setup : Single Continuum";
        this.addComponent(jPanel2, gridBagLayout2, gridBagConstraints2, this.makeLabel(this.sectionTitleColorString(string)));
        this.addVerticalSpace(jPanel2, gridBagLayout2, gridBagConstraints2);
        this.addComponent(jPanel2, gridBagLayout2, gridBagConstraints2, this.addTableHeader(this.registerTable(this.tableFactory.createSingleContinuumSetupTable(scienceGoalSummaryModel.singleContinuumSetupModel), SINGLECONTINUUMSETUPTABLE)));
        return jPanel2;
    }

    private JPanel createSpectralScanSetupPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        jPanel.setLayout(gridBagLayout);
        ScienceGoalSummaryModel scienceGoalSummaryModel = this.getModel();
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 10;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        jPanel2.setLayout(gridBagLayout2);
        String string = "Spectral Scan Setup";
        this.addComponent(jPanel2, gridBagLayout2, gridBagConstraints2, this.makeLabel(this.sectionTitleColorString(string)));
        this.addVerticalSpace(jPanel2, gridBagLayout2, gridBagConstraints2);
        this.addComponent(jPanel2, gridBagLayout2, gridBagConstraints2, this.addTableHeader(this.registerTable(this.tableFactory.createSpectralScanSetupTable(scienceGoalSummaryModel.spectralScanSetupModel), SPECTRALSCANSETUPTABLE)));
        return jPanel2;
    }

    private JPanel createJustificationTextPanel(TechnicalJustificationEditor.TechJustEditor techJustEditor, String string) {
        JPanel jPanel = new JPanel();
        BorderLayout borderLayout = new BorderLayout();
        jPanel.setLayout(borderLayout);
        JTextArea jTextArea = new JTextArea();
        jTextArea.setOpaque(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setEditable(false);
        jTextArea.setFocusable(false);
        this.register(jTextArea, techJustEditor.id);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(null, string, 0, 0, null, this.sectionTitleColor);
        jTextArea.setBorder(titledBorder);
        jPanel.add((Component)jTextArea, "First");
        return jPanel;
    }

    private JPanel createSensitivityCommentPanel(FieldID fieldID, String string) {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.setLayout(gridBagLayout);
        snrLowWarning.setOpaque(false);
        snrLowWarning.setFocusable(false);
        snrLowWarning.setHorizontalTextPosition(2);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, snrLowWarning);
        wideBandwidthWarning.setOpaque(false);
        wideBandwidthWarning.setFocusable(false);
        wideBandwidthWarning.setHorizontalTextPosition(2);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, wideBandwidthWarning);
        dynamicRangeWarning.setOpaque(false);
        dynamicRangeWarning.setFocusable(false);
        dynamicRangeWarning.setHorizontalTextPosition(2);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, dynamicRangeWarning);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(null, string, 0, 0, null, this.sectionTitleColor);
        jPanel.setBorder(titledBorder);
        this.register(jPanel, fieldID);
        return jPanel;
    }

    private JPanel createCorrelatorCommentPanel(FieldID fieldID, String string) {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.setLayout(gridBagLayout);
        mayNotResolveWarning.setOpaque(false);
        mayNotResolveWarning.setFocusable(false);
        mayNotResolveWarning.setHorizontalTextPosition(2);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, mayNotResolveWarning);
        linewidthGreaterThanSPWWarning.setOpaque(false);
        linewidthGreaterThanSPWWarning.setFocusable(false);
        linewidthGreaterThanSPWWarning.setHorizontalTextPosition(2);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, linewidthGreaterThanSPWWarning);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(null, string, 0, 0, null, this.sectionTitleColor);
        jPanel.setBorder(titledBorder);
        this.register(jPanel, fieldID);
        return jPanel;
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID == SHOWTARGETLISTTABLE) {
            this.targetList_1.setVisible((Boolean)object);
        }
        if (fieldID == SHOWTARGETLISTTABLE_2) {
            this.targetList_2.setVisible((Boolean)object);
            this.additionalTargetsPanel.setVisible((Boolean)object);
        }
        if (fieldID == SHOWTARGETLISTTABLE_3) {
            this.targetList_3.setVisible((Boolean)object);
        }
        if (fieldID == PROPOSALID) {
            this.updateLabel(fieldID, "<html><font size=+2><u>" + (String)object + "</u></font></html>");
            return;
        }
        if (fieldID == TOOID) {
            JLabel jLabel = (JLabel)this.retrieve(fieldID);
            jLabel.setVisible((Boolean)object);
            return;
        }
        if (fieldID == TIMECONSTRAIND) {
            JLabel jLabel = (JLabel)this.retrieve(fieldID);
            if (object == null) {
                jLabel.setVisible(false);
            } else {
                this.updateLabel(fieldID, "<html>Time Constrained to <b>execute during one</b> of the following windows", this.formatTimeRange((List)object) + "</html>");
            }
            return;
        }
        if (fieldID == SGINDEX) {
            this.updateLabel(fieldID, "SG", ((Integer)object).toString());
            return;
        }
        if (fieldID == SBINDEX) {
            this.updateLabel(fieldID, String.format(" (Cluster %d)", (int)((Integer)object)));
            return;
        }
        if (fieldID == NSGS) {
            this.updateLabel(fieldID, " of " + (Integer)object);
            return;
        }
        if (fieldID == SGNAME) {
            this.updateLabel(fieldID, (String)object);
            return;
        }
        if (fieldID == RECEIVERBAND) {
            ReceiverBand receiverBand = (ReceiverBand)object;
            String string = receiverBand == null ? "Band unknown" : "Band " + receiverBand.getNumber();
            this.updateLabel(fieldID, string);
            return;
        }
        if (fieldID == NTARGETS) {
            int n = (Integer)object;
            String string = n > 1 ? "s" : "";
            String string2 = this.sectionTitleColorString(n + " Target" + string);
            this.updateLabel(fieldID, string2);
            return;
        }
        if (fieldID == SOURCEPROPERITESDYNR) {
            String string = "Dynamic range (cont flux/line rms):";
            String string3 = (Double)object < 0.0 ? String.format("%s N/A", string) : String.format("%s %.1f", string, (Double)object);
            this.updateLabel(fieldID, string3);
            return;
        }
        if (fieldID == NTUNINGS) {
            int n = (Integer)object;
            String string = n > 1 ? "s" : "";
            String string4 = this.sectionTitleColorString(n + " Tuning" + string);
            this.updateLabel(fieldID, string4);
            return;
        }
        if (fieldID == TUNINGSPANEL) {
            SpectralSetupParameters spectralSetupParameters = (SpectralSetupParameters)((Object)object);
            this.retrieve(fieldID).setVisible(!spectralSetupParameters.isSpectralScan() && !spectralSetupParameters.isSingleContinuum());
            return;
        }
        if (fieldID == SCANTUNINGSPANEL) {
            SpectralSetupParameters spectralSetupParameters = (SpectralSetupParameters)((Object)object);
            this.retrieve(fieldID).setVisible(spectralSetupParameters.isSpectralScan());
            return;
        }
        if (fieldID == SPECTRALLINESETUPPANEL) {
            SpectralSetupParameters spectralSetupParameters = (SpectralSetupParameters)((Object)object);
            this.retrieve(fieldID).setVisible(!spectralSetupParameters.isSpectralScan() && !spectralSetupParameters.isSingleContinuum());
            return;
        }
        if (fieldID == SINGLECONTINUUMSETUPPANEL) {
            SpectralSetupParameters spectralSetupParameters = (SpectralSetupParameters)((Object)object);
            this.retrieve(fieldID).setVisible(spectralSetupParameters.isSingleContinuum());
            return;
        }
        if (fieldID == SPECTRALSCANSETUPPANEL) {
            SpectralSetupParameters spectralSetupParameters = (SpectralSetupParameters)((Object)object);
            this.retrieve(fieldID).setVisible(spectralSetupParameters.isSpectralScan());
            return;
        }
        if (fieldID == CONFIG_NAME_FOR_12M_COMPACT && object != null) {
            this.update12MHeadingWithLabel(FieldInfoTableModel.FieldInfoCols.OTHERTIME.ordinal(), "t_total" + object);
        } else if (fieldID == CONFIG_NAME_FOR_12M_EXTENDED && object != null) {
            this.update12MHeadingWithLabel(FieldInfoTableModel.FieldInfoCols.SCIENCETIME.ordinal(), "t_science" + object);
        } else if (fieldID == SOURCE_COORD_TYPE && object != null) {
            this.updateTLTSourceHeadingWithLabel(TargetListTableModel.TargetListCols.SKYCOORDINATES.ordinal(), (String)object);
        } else if (TechnicalJustificationEditor.TechJustEditor.isMember(fieldID)) {
            JTextArea jTextArea = (JTextArea)this.retrieve(fieldID);
            if (jTextArea != null) {
                if (object == null) {
                    this.technicalJustificationsSections.put(TechnicalJustificationEditor.TechJustEditor.getEditor(fieldID), jTextArea);
                    jTextArea.setVisible(false);
                    return;
                }
                this.technicalJustificationsSections.put(TechnicalJustificationEditor.TechJustEditor.getEditor(fieldID), jTextArea);
                jTextArea.setText(object.toString());
                jTextArea.setVisible(true);
                return;
            }
        } else if (fieldID == TechnicalJustificationEditor.FID_SHOW_WIDE_BANDWIDTH_WARNING) {
            boolean bl = (Boolean)object;
            wideBandwidthWarning.setVisible(bl);
            this.checkIfSensitivityCommentsDisplayed();
        } else if (fieldID == TechnicalJustificationEditor.FID_SHOW_MAY_NOT_RESOLVE_WARNING) {
            boolean bl = (Boolean)object;
            mayNotResolveWarning.setVisible(bl);
            this.checkIfCorrelatorCommentsDisplayed();
        } else if (fieldID == TechnicalJustificationEditor.FID_SHOW_SNR_LOW_WARNING) {
            boolean bl = (Boolean)object;
            snrLowWarning.setVisible(bl);
            this.checkIfSensitivityCommentsDisplayed();
        } else if (fieldID == TechnicalJustificationEditor.FID_SHOW_MAX_DR_WARNING) {
            boolean bl = (Boolean)object;
            dynamicRangeWarning.setVisible(bl);
            this.checkIfSensitivityCommentsDisplayed();
        } else if (fieldID == TechnicalJustificationEditor.FID_LINEWIDTH_GREATER_THAN_SPW_WARNING) {
            boolean bl = (Boolean)object;
            linewidthGreaterThanSPWWarning.setVisible(bl);
            this.checkIfCorrelatorCommentsDisplayed();
        }
        super.update(fieldID, object);
    }

    private void checkIfCorrelatorCommentsDisplayed() {
        this.correlatorCommentPanel.setVisible(mayNotResolveWarning.isVisible() || linewidthGreaterThanSPWWarning.isVisible());
    }

    private void checkIfSensitivityCommentsDisplayed() {
        this.sensitivityCommentPanel.setVisible(wideBandwidthWarning.isVisible() || snrLowWarning.isVisible() || dynamicRangeWarning.isVisible());
    }

    private void update12MHeadingWithLabel(int n, String string) {
        JTable jTable = (JTable)this.retrieve(FIELDINFOTABLE_12);
        JTableHeader jTableHeader = jTable.getTableHeader();
        TableColumnModel tableColumnModel = jTableHeader.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(n);
        tableColumn.setHeaderValue(string);
        jTableHeader.repaint();
    }

    private void updateTLTSourceHeadingWithLabel(int n, String string) {
        this.updateTargetListTableHeading((JTable)this.retrieve(TARGETLISTTABLE), n, string);
        this.updateTargetListTableHeading((JTable)this.retrieve(TARGETLISTTABLE_2), n, string);
        this.updateTargetListTableHeading((JTable)this.retrieve(TARGETLISTTABLE_3), n, string);
    }

    private void updateTargetListTableHeading(JTable jTable, int n, String string) {
        JTableHeader jTableHeader = jTable.getTableHeader();
        TableColumnModel tableColumnModel = jTableHeader.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(n);
        tableColumn.setHeaderValue(string);
        jTableHeader.repaint();
    }

    private String formatTimeRange(List<ZonedDateTime[]> list) {
        String string = "<ol>";
        for (ZonedDateTime[] zonedDateTimeArray : list) {
            if (zonedDateTimeArray == null || zonedDateTimeArray.length != 2) {
                return "";
            }
            if (zonedDateTimeArray[0] == null || zonedDateTimeArray[1] == null) {
                return "";
            }
            String string2 = TemporalParameters.convertDateToString(zonedDateTimeArray[0]);
            String string3 = TemporalParameters.convertDateToString(zonedDateTimeArray[1]);
            string = string + "<li>" + string2 + " - " + string3 + "</li>";
        }
        string = string + "</ol>";
        return string;
    }

    @Override
    protected Printable getPrintable() {
        return new ScienceGoalPrintable(this);
    }

    @Override
    public PdfExporter getPageExporter() {
        return new ScienceGoalExporter(this.createOffView());
    }
}

