/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.summaryfeedback;

import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.services.summaryfeedback.ScienceGoalSummaryParameters;
import alma.valuetypes.Frequency;
import alma.valuetypes.Speed;
import alma.valuetypes.UserFrequency;
import alma.valuetypes.Velocity;
import javax.swing.table.AbstractTableModel;

public class SpectralLineSetupTableModel
extends AbstractTableModel {
    protected ScienceGoalSummaryParameters.TuningInfo tuningInfo;
    private String[] longvalues = new String[]{" 0 ", " 100.123456 ", "xxx-xxx-xxx-xxx-xxx-xxx", " 9999 ", " 1000.0 MHz ", " 11100.00 kHz  ", " 5600 - 6000 km/s ", "2.9-3.2 km/s", "20-21"};

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public int getRowCount() {
        int n = this.tuningInfo == null ? 0 : this.tuningInfo.getNumSpectralWindows();
        return n;
    }

    public ScienceGoalSummaryParameters.TuningInfo getParameters() {
        return this.tuningInfo;
    }

    public void setDocument(ScienceGoalSummaryParameters.TuningInfo tuningInfo) {
        this.tuningInfo = tuningInfo;
    }

    public ScienceGoal getScienceGoal() {
        return this.tuningInfo.ssp.getScienceGoal();
    }

    @Override
    public int getColumnCount() {
        return SpectralLineSetupCols.getColumnCount();
    }

    @Override
    public String getColumnName(int n) {
        SpectralLineSetupCols spectralLineSetupCols = SpectralLineSetupCols.getColumnDescriptor(n);
        return spectralLineSetupCols.getColumnName();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.tuningInfo == null) {
            return null;
        }
        ScienceSpectralWindow scienceSpectralWindow = this.tuningInfo.sortedWindowList.get(n);
        if (scienceSpectralWindow == null) {
            return null;
        }
        SpectralLineSetupCols spectralLineSetupCols = SpectralLineSetupCols.getColumnDescriptor(n2);
        switch (spectralLineSetupCols) {
            case BASEBAND: {
                return scienceSpectralWindow.getGroupIndex() + 1;
            }
            case RESTFREQUENCY: {
                return scienceSpectralWindow.getCenterFrequency().getContentInGHz();
            }
            case LINEID: {
                return scienceSpectralWindow.getTransitionName();
            }
            case NCHANNELS: {
                return scienceSpectralWindow.getCorrConfigMode().getEffectiveChannels();
            }
            case BANDWIDTH: {
                return scienceSpectralWindow.getCorrConfigMode().getEffectiveBandwidth();
            }
            case RESOLUTION: {
                return scienceSpectralWindow.getSpectralResolutionSmoothed();
            }
            case VELWIDTH: 
            case VELRES: {
                Object object = spectralLineSetupCols == SpectralLineSetupCols.VELWIDTH ? scienceSpectralWindow.getEffectiveBandwidth() : scienceSpectralWindow.getSpectralResolutionSmoothed();
                return Speed.getSpeedResolution(object, scienceSpectralWindow.getCenterFrequencySky());
            }
            case RESEL: {
                ScienceGoal.ExpectedPropertiesElements expectedPropertiesElements = this.getScienceGoal().collapseExpectedProperties();
                UserFrequency userFrequency = expectedPropertiesElements.expectedLineWidth;
                Velocity velocity = expectedPropertiesElements.velocity;
                double d = scienceSpectralWindow.getVelocityResolutionInSky(velocity);
                return userFrequency.getContentInUnits(UserFrequency.USERUNIT_KM_S) / d;
            }
        }
        return null;
    }

    public String[] getLongValues() {
        return this.longvalues;
    }

    public static enum SpectralLineSetupCols {
        BASEBAND("<html>&nbsp;BB&nbsp;<br>&nbsp;</html>", Integer.class),
        RESTFREQUENCY("<html>Center Freq<br>Rest GHz</html>", Double.class),
        LINEID("spw name", String.class),
        NCHANNELS("<html>&nbsp;Eff #Ch&nbsp;<br>&nbsp;p.p.</html>", Integer.class),
        BANDWIDTH("Bandwidth", Frequency.class),
        RESOLUTION("Resolution", Frequency.class),
        VELWIDTH("Vel. Bandwidth", Speed.class),
        VELRES("Vel. Res.", Speed.class),
        RESEL("<html>Res. El.<br>per FWHM</html>", String.class);

        public final String colName;
        public final Class colClass;

        private SpectralLineSetupCols(String string2, Class clazz) {
            this.colName = string2;
            this.colClass = clazz;
        }

        protected static int getColumnCount() {
            return SpectralLineSetupCols.values().length;
        }

        protected static SpectralLineSetupCols getColumnDescriptor(int n) {
            return SpectralLineSetupCols.values()[n];
        }

        protected String getColumnName() {
            return this.colName;
        }

        protected Class getColumnClass() {
            return this.colClass;
        }
    }
}

