/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.summaryfeedback;

import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.obsproject.AdvancedWindowSetup;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralScan;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.schedblock.CorrConfigMode;
import alma.obsprep.services.etc.SourceNeverVisibleException;
import alma.obsprep.services.experts.InvalidFrequencyException;
import alma.obsprep.services.summaryfeedback.ScienceGoalSummaryParameters;
import alma.valuetypes.Frequency;
import alma.valuetypes.Sensitivity;
import alma.valuetypes.Speed;
import alma.valuetypes.Time;
import alma.valuetypes.UserFrequency;
import alma.valuetypes.UserSensitivity;
import javax.swing.table.AbstractTableModel;

public class SpectralScanSetupTableModel
extends AbstractTableModel {
    protected ScienceGoalSummaryParameters.SpectralScanTuningInfo scanTuningInfo;
    private String[] longvalues = new String[]{" 100.123456 GHz", " 100.123456 GHz", " xxxx.x MHz ", " xxx.xxx MHz ", " xxxx.xx km/s ", "xxx.xx km/s", " nnn.n ", " xxx.xx mJy, xx.x mK "};

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public int getRowCount() {
        return this.scanTuningInfo == null ? 0 : 1;
    }

    public ScienceGoalSummaryParameters.SpectralScanTuningInfo getParameters() {
        return this.scanTuningInfo;
    }

    public void setDocument(ScienceGoalSummaryParameters.SpectralScanTuningInfo spectralScanTuningInfo) {
        this.scanTuningInfo = spectralScanTuningInfo;
    }

    @Override
    public int getColumnCount() {
        return SpectralScanSetupCols.getColumnCount();
    }

    @Override
    public String getColumnName(int n) {
        SpectralScanSetupCols spectralScanSetupCols = SpectralScanSetupCols.getColumnDescriptor(n);
        return spectralScanSetupCols.getColumnName();
    }

    private Speed getVelocityResolution() {
        if (this.scanTuningInfo == null || this.scanTuningInfo.scan == null) {
            return null;
        }
        SpectralScan spectralScan = this.scanTuningInfo.scan;
        Frequency frequency = spectralScan.getSpectralResolution();
        CorrConfigMode corrConfigMode = spectralScan.getCorrConfigMode();
        Frequency frequency2 = spectralScan.getSpectralSetupParameters().getRepresentativeFrequency();
        Speed speed = Speed.getSpeedResolution(corrConfigMode.getEffectiveResolution(spectralScan.getAdvancedWindowSetup()), frequency2);
        return speed;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.scanTuningInfo == null) {
            return null;
        }
        int n3 = this.scanTuningInfo.getNumTunings();
        if (n3 == 0) {
            return null;
        }
        if (n % n3 != 0) {
            return null;
        }
        int n4 = n / n3;
        SpectralScan spectralScan = this.scanTuningInfo.scan;
        if (spectralScan == null) {
            return null;
        }
        SpectralScanSetupCols spectralScanSetupCols = SpectralScanSetupCols.getColumnDescriptor(n2);
        SpectralSetupParameters spectralSetupParameters = spectralScan.getSpectralSetupParameters();
        Frequency frequency = spectralSetupParameters.getRepresentativeFrequency();
        CorrConfigMode corrConfigMode = spectralScan.getCorrConfigMode();
        AdvancedWindowSetup advancedWindowSetup = spectralScan.getAdvancedWindowSetup();
        switch (spectralScanSetupCols) {
            case STARTFREQUENCY: {
                return spectralScan.getStartFrequency();
            }
            case ENDFREQUENCY: {
                return spectralScan.getEndFrequency();
            }
            case BANDWIDTH: {
                return corrConfigMode.getEffectiveBandwidth();
            }
            case RESOLUTION: {
                return corrConfigMode.getEffectiveResolution(advancedWindowSetup);
            }
            case VELWIDTH: {
                Frequency frequency2 = spectralScan.getEffectiveBandwidth();
                return Speed.getSpeedResolution(frequency2, frequency);
            }
            case VELRESOLUTION: {
                return this.getVelocityResolution();
            }
            case RESEL: {
                UserFrequency userFrequency = this.scanTuningInfo.getScienceGoal().getKeyTargetParameters().getExpectedProperties().getExpectedLineWidth();
                userFrequency.setObservingFrequency(frequency);
                Frequency frequency3 = spectralScan.getSpectralResolution();
                Speed speed = userFrequency.asSpeed();
                Speed speed2 = this.getVelocityResolution();
                return speed.getContentInDefaultUnits() / speed2.getContentInDefaultUnits();
            }
            case RMS: {
                Time time = this.scanTuningInfo.integrationTime;
                try {
                    ScienceGoal scienceGoal = spectralSetupParameters.getScienceGoal();
                    Sensitivity sensitivity = scienceGoal.getSinglePointOnSourceSensitivity(Array.ARRAY_12M, time, scienceGoal.getSoleTargetParameters(), frequency);
                    UserSensitivity userSensitivity = UserSensitivity.createUserSensitivity(sensitivity.getContent(), sensitivity.getUnit());
                    userSensitivity.setObservingFrequency(frequency);
                    userSensitivity.setBeamsize(this.scanTuningInfo.beamSize);
                    return userSensitivity;
                }
                catch (InvalidFrequencyException invalidFrequencyException) {
                    return null;
                }
                catch (SourceNeverVisibleException sourceNeverVisibleException) {
                    return null;
                }
            }
        }
        return null;
    }

    public String[] getLongValues() {
        return this.longvalues;
    }

    public static enum SpectralScanSetupCols {
        STARTFREQUENCY("<html>Start<br>Frequency</html>", Frequency.class),
        ENDFREQUENCY("<html>END<br>Frequency</html>", Frequency.class),
        BANDWIDTH("Bandwidth", Frequency.class),
        RESOLUTION("Resolution", Frequency.class),
        VELWIDTH("Vel. Bandwidth", Speed.class),
        VELRESOLUTION("Vel. Resolution", Speed.class),
        RESEL("<html>Res. El.<br>per FWHM</html>", String.class),
        RMS("RMS", Sensitivity.class);

        public final String colName;
        public final Class colClass;

        private SpectralScanSetupCols(String string2, Class clazz) {
            this.colName = string2;
            this.colClass = clazz;
        }

        protected static int getColumnCount() {
            return SpectralScanSetupCols.values().length;
        }

        protected static SpectralScanSetupCols getColumnDescriptor(int n) {
            return SpectralScanSetupCols.values()[n];
        }

        protected String getColumnName() {
            return this.colName;
        }

        protected Class getColumnClass() {
            return this.colClass;
        }
    }
}

