/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.summaryfeedback;

import alma.obsprep.bo.obsproject.SpectralScan;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.obsprep.services.summaryfeedback.ScienceGoalSummaryParameters;
import alma.valuetypes.Frequency;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class SpectralScanTuningsTableModel
extends AbstractTableModel {
    protected ScienceGoalSummaryParameters.SpectralScanTuningInfo scanTuningInfo;
    private String[] longvalues = new String[]{"  1  ", " 100.123456 ", " 100.123456 ", " 100.123456 ", " 100.123456 "};

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public int getRowCount() {
        int n = this.scanTuningInfo == null ? 0 : this.scanTuningInfo.getNumTunings();
        return n;
    }

    public ScienceGoalSummaryParameters.SpectralScanTuningInfo getParameters() {
        return this.scanTuningInfo;
    }

    public void setDocument(ScienceGoalSummaryParameters.SpectralScanTuningInfo spectralScanTuningInfo) {
        this.scanTuningInfo = spectralScanTuningInfo;
    }

    @Override
    public int getColumnCount() {
        return ScanTuningCols.getColumnCount();
    }

    @Override
    public String getColumnName(int n) {
        ScanTuningCols scanTuningCols = ScanTuningCols.getColumnDescriptor(n);
        return scanTuningCols.getColumnName();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        List<Frequency> list;
        SpectralScan.SpectralScanTunings spectralScanTunings;
        if (this.scanTuningInfo == null) {
            return null;
        }
        SpectralSetupParameters spectralSetupParameters = this.scanTuningInfo.getSpectralSetupParameters();
        int n3 = this.scanTuningInfo.getNumTunings();
        try {
            spectralScanTunings = this.scanTuningInfo.getTunings();
        }
        catch (UnableToFindSolutionException unableToFindSolutionException) {
            return null;
        }
        try {
            list = spectralScanTunings.getTuning(n);
        }
        catch (SpectralScan.SpectralScanTunings.SpectralScanTuningException spectralScanTuningException) {
            return null;
        }
        ScanTuningCols scanTuningCols = ScanTuningCols.getColumnDescriptor(n2);
        try {
            switch (scanTuningCols) {
                case TUNING: {
                    return n + 1;
                }
                case SPW1: {
                    return list.get(0);
                }
                case SPW2: {
                    return list.get(1);
                }
                case SPW3: {
                    return list.get(2);
                }
                case SPW4: {
                    return list.get(3);
                }
            }
            return null;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public String[] getLongValues() {
        return this.longvalues;
    }

    public static enum ScanTuningCols {
        TUNING("Tuning", Integer.class),
        SPW1("Spw1(GHz)", Frequency.class),
        SPW2("Spw2(GHz)", Frequency.class),
        SPW3("Spw3(GHz)", Frequency.class),
        SPW4("Spw4(GHz)", Frequency.class);

        public final String colName;
        public final Class colClass;

        private ScanTuningCols(String string2, Class clazz) {
            this.colName = string2;
            this.colClass = clazz;
        }

        protected static int getColumnCount() {
            return ScanTuningCols.values().length;
        }

        protected static ScanTuningCols getColumnDescriptor(int n) {
            return ScanTuningCols.values()[n];
        }

        protected String getColumnName() {
            return this.colName;
        }

        protected Class getColumnClass() {
            return this.colClass;
        }
    }
}

