/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.summaryfeedback;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.problems.Problem;
import alma.obsprep.services.summaryfeedback.ExportableFeedback;
import alma.obsprep.services.summaryfeedback.FeedbackSummary;
import alma.obsprep.services.summaryfeedback.PdfExporter;
import alma.obsprep.services.summaryfeedback.SummaryDocument;
import alma.obsprep.services.summaryfeedback.SummaryFeedbackView;
import alma.obsprep.util.GUIUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.logging.Level;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SummaryFrame
extends JFrame {
    public static final int WINDOW_WIDTH = 950;
    private FeedbackSummary feedback;
    protected JPanel mainPanel;
    private JComponent buttons;
    public static final DialogId did = new DialogId("ProposalSummary.warning");
    private boolean showsNavButtons = false;
    protected JButton nextButton;
    protected JButton prevButton;
    protected JButton printButton;
    protected JButton printAllButton;
    protected JButton pdfButton;
    protected JButton closeButton;
    private PrintService preferredPrintService = null;

    public SummaryFrame(FeedbackSummary feedbackSummary) {
        this.feedback = feedbackSummary;
        this.setDefaultCloseOperation(2);
    }

    private Container createMainPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(gridBagLayout);
        this.buttons = this.createButtonBox();
        this.updateMainPanel();
        return this.mainPanel;
    }

    private void updateMainPanel() {
        this.mainPanel.removeAll();
        GridBagLayout gridBagLayout = (GridBagLayout)this.mainPanel.getLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        SummaryFeedbackView summaryFeedbackView = this.feedback.view;
        gridBagLayout.setConstraints(summaryFeedbackView, gridBagConstraints);
        this.mainPanel.add(summaryFeedbackView);
        ++gridBagConstraints.gridy;
        this.mainPanel.revalidate();
        this.mainPanel.repaint();
    }

    public void showPanel() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle rectangle = graphicsEnvironment.getMaximumWindowBounds();
        int n = rectangle.height;
        this.setTitle(this.titleString());
        this.getContentPane().removeAll();
        JScrollPane jScrollPane = new JScrollPane(this.createMainPanel());
        this.updateNavButtons();
        this.setPreferredSize(new Dimension(950, n));
        this.getContentPane().add((Component)jScrollPane, "Center");
        this.getContentPane().add((Component)this.buttons, "South");
        this.pack();
        this.setVisible(true);
        this.showErrorDialog();
    }

    public void closePanel() {
        this.setVisible(false);
    }

    protected void showErrorDialog() {
        block0: {
            int n;
            SummaryFeedbackView summaryFeedbackView = this.feedback.view;
            SummaryDocument summaryDocument = (SummaryDocument)summaryFeedbackView.getModel().getDocument();
            ProblemListModel problemListModel = summaryDocument.getProblems();
            if (problemListModel.getSize() <= 0 || (n = 0) >= problemListModel.getSize()) break block0;
            Problem problem = problemListModel.getProblemAt(n);
            GUIUtilities.warning(did, problem.getDescription());
        }
    }

    private String titleString() {
        return "Summary Information : " + this.feedback.getTitleString();
    }

    public void setShowsNavButtons(boolean bl) {
        this.showsNavButtons = bl;
    }

    protected JComponent createButtonBox() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Close")) {
                    SummaryFrame.this.closePanel();
                } else if (string.equals("Print")) {
                    SummaryFrame.this.printPanel();
                } else if (string.equals("Print All")) {
                    SummaryFrame.this.printAll();
                } else if (string.equals("Export to PDF")) {
                    SummaryFrame.this.exportToPdf();
                } else if (string.equals("Next")) {
                    SummaryFrame.this.showNext();
                } else if (string.equals("Prev")) {
                    SummaryFrame.this.showPrev();
                }
            }
        };
        this.prevButton = new JButton("Prev");
        this.prevButton.setVisible(this.showsNavButtons);
        this.prevButton.addActionListener(actionListener);
        this.nextButton = new JButton("Next");
        this.nextButton.setVisible(this.showsNavButtons);
        this.nextButton.addActionListener(actionListener);
        this.printButton = new JButton("Print");
        this.printButton.setVisible(this.showsPrintButton());
        this.printButton.addActionListener(actionListener);
        this.printAllButton = new JButton("Print All");
        this.printAllButton.setVisible(this.showsNavButtons && this.showsPrintButton());
        this.printAllButton.addActionListener(actionListener);
        this.pdfButton = new JButton("Export to PDF");
        this.pdfButton.setVisible(this.showsPdfButton());
        this.pdfButton.addActionListener(actionListener);
        this.closeButton = new JButton("Close");
        this.closeButton.setVisible(this.showsCloseButton());
        this.closeButton.addActionListener(actionListener);
        JPanel jPanel = new JPanel();
        jPanel.add(this.prevButton);
        jPanel.add(this.nextButton);
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add(this.printButton);
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add(this.printAllButton);
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add(this.pdfButton);
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add(this.closeButton);
        return jPanel;
    }

    protected boolean showsCloseButton() {
        return true;
    }

    protected boolean showsPrintButton() {
        return true;
    }

    protected boolean showsPdfButton() {
        return this.feedback instanceof ExportableFeedback;
    }

    protected void updateNavButtons() {
        this.nextButton.setEnabled(this.showsNavButtons && this.feedback.hasNext());
        this.prevButton.setEnabled(this.showsNavButtons && this.feedback.hasPrev());
    }

    protected void showNext() {
        this.feedback.showNext();
        this.updateMainPanel();
        this.updateNavButtons();
        this.showErrorDialog();
    }

    protected void showPrev() {
        this.feedback.showPrev();
        this.updateMainPanel();
        this.updateNavButtons();
        this.showErrorDialog();
    }

    public void setPreferredPrintService(PrintService printService) {
        this.preferredPrintService = printService;
    }

    private void print(Printable printable) {
        if (printable == null) {
            return;
        }
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(printable);
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        PrintService[] printServiceArray = PrinterJob.lookupPrintServices();
        if (printServiceArray.length == 0) {
            String string = "No printer found";
            Log.logger((Object)this).warning(string);
            GUIUtilities.warning(null, string);
            return;
        }
        try {
            if (this.preferredPrintService == null) {
                this.preferredPrintService = printServiceArray[0];
            }
            printerJob.setPrintService(this.preferredPrintService);
            if (printerJob.printDialog(hashPrintRequestAttributeSet)) {
                printerJob.print(hashPrintRequestAttributeSet);
                this.preferredPrintService = printerJob.getPrintService();
            }
        }
        catch (PrinterException printerException) {
            Log.logger((Object)this).log(Level.WARNING, printerException.getMessage(), (Throwable)printerException);
            GUIUtilities.warning(null, printerException.getMessage());
        }
    }

    protected void printPanel() {
        this.print(this.feedback.view.getPrintable());
    }

    protected void printAll() {
        try {
            this.print(this.feedback.getAllPagePrintable());
        }
        catch (Exception exception) {
            Log.logger(SummaryFrame.class).info("Unable to print all science goals : " + exception.getMessage());
            GUIUtilities.warning(null, "Unable to print all science goals: does your project pass validation?");
        }
    }

    protected void exportToPdf() {
        PdfExporter pdfExporter = this.feedback.getPdfExporter();
        if (pdfExporter != null) {
            pdfExporter.exportToPdf();
        }
    }
}

