/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.util;

import alma.obsprep.guiutil.mvc.InvalidCoordException;
import alma.obsprep.guiutil.mvc.OutOfRangeException;
import alma.obsprep.util.TextUtils;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.regex.Pattern;

public final class Convert {
    public static final int DECIMAL_PLACES_ACCURACY = 3;
    public static final double HOURS_TO_DEGREES = 15.0;
    public static final double MAX_MILLISECS_DEC = 3.24E8;
    public static final double MAX_MILLISECS_RA = 1.295999985E9;
    public static final int MILLISECS_PER_SEC = 1000;
    public static final int SECONDS_PER_MINUTE = 60;
    public static final int MINUTES_PER_DEGREE = 60;
    public static final int MINUTES_PER_HOUR = 60;
    public static final int DEC_MAX_DEGREES = 90;
    public static final int RA_MAX_HOURS = 24;
    public static final int MILLISECS_PER_MINUTE = 60000;
    public static final int MILLISECS_PER_UNIT = 3600000;
    public static final int FW_BEFORE = 2;
    public static final int FW_AFTER = 3;
    public static final BigDecimal BD_MILLISECS_PER_UNIT = BigDecimal.valueOf(3600000L);
    public static final BigDecimal BD_MILLISECS_PER_MINUTE = BigDecimal.valueOf(60000L);
    public static final BigDecimal BD_MILLISECS_PER_SEC = BigDecimal.valueOf(1000L);
    private static ArrayBlockingQueue<DateFormat> converterPool = new ArrayBlockingQueue<SimpleDateFormat>(3, true, Arrays.asList(new SimpleDateFormat("yyyy.MM.dd HH.mm"), new SimpleDateFormat("yyyy.MM.dd HH.mm"), new SimpleDateFormat("yyyy.MM.dd HH.mm")));

    private Convert() {
    }

    private static void checkBoundsDDMMSS(int n, int n2, int n3, int n4, int n5) throws InvalidCoordException {
        if (n2 > 90 || n3 >= 60 || n4 >= 60 || n5 >= 1000) {
            throw new InvalidCoordException("Illegal DD:MM:SS value: " + Convert.valuesToString(n, n2, n3, n4, n5));
        }
        if (n2 == 90 && (n3 > 0 || n4 > 0 || n5 > 0)) {
            throw new InvalidCoordException("Illegal DD:MM:SS value: " + Convert.valuesToString(n, n2, n3, n4, n5));
        }
    }

    private static void checkBoundsHHMMSS(int n, int n2, int n3, int n4, int n5) throws InvalidCoordException {
        if (n < 0 || n2 >= 24 || n3 >= 60 || n4 >= 60 || n5 >= 1000) {
            throw new InvalidCoordException("Invalid HH:MM:SS.SSS value: " + Convert.valuesToString(n, n2, n3, n4, n5));
        }
    }

    public static String convertToXXMMSS(long l) {
        String string = "";
        if (l < 0L) {
            string = "-";
            l = -l;
        }
        long l2 = l % 1000L;
        long l3 = (l /= 1000L) % 60L;
        long l4 = (l /= 60L) % 60L;
        long l5 = l /= 60L;
        return string + TextUtils.zeroPadded(2, l5) + TextUtils.zeroPadded(2, l4) + TextUtils.zeroPadded(2, l3) + "." + TextUtils.zeroPadded(3, l2);
    }

    public static double DDMMSSToDeg(String string) throws InvalidCoordException, NumberFormatException {
        double d = Convert.DDMMSSToMilliarcsec(string);
        double d2 = d / 3600000.0;
        return d2;
    }

    public static double DDMMSSToMilliarcsec(String string) throws InvalidCoordException, NumberFormatException {
        return Convert.stringToMilliarcsec(string, false, false);
    }

    public static double HHMMSSToDeg(String string) throws InvalidCoordException, NumberFormatException {
        double d = Convert.HHMMSSToMilliarcsec(string);
        double d2 = d / 3600000.0;
        return d2;
    }

    public static double HHMMSSToMilliarcsec(String string) throws InvalidCoordException, NumberFormatException {
        return Convert.stringToMilliarcsec(string, true, false);
    }

    public static double HHMMSSToSec(String string) throws InvalidCoordException, NumberFormatException {
        double d = Convert.HHMMSSToMilliarcsec(string);
        double d2 = d / 1000.0;
        return d2;
    }

    public static boolean isValidDec(long l) {
        return -3.24E8 <= (double)l && (double)l <= 3.24E8;
    }

    public static boolean isValidDec(BigDecimal bigDecimal) {
        return BigDecimal.valueOf(3.24E8).negate().compareTo(bigDecimal) != 1 && bigDecimal.compareTo(BigDecimal.valueOf(3.24E8)) != 1;
    }

    public static boolean isValidRA(long l) {
        return 0L <= l && (double)l <= 1.295999985E9;
    }

    public static boolean isValidRA(BigDecimal bigDecimal) {
        return BigDecimal.ZERO.compareTo(bigDecimal) != 1 && bigDecimal.compareTo(BigDecimal.valueOf(1.295999986E9)) != 1;
    }

    public static String degToDDMMSS(double d) throws OutOfRangeException, InvalidCoordException {
        BigDecimal bigDecimal = BigDecimal.valueOf(d).multiply(BigDecimal.valueOf(3600000L));
        BigDecimal bigDecimal2 = bigDecimal.setScale(3, 4);
        return Convert.milliarcsecToString(bigDecimal2, false, false);
    }

    public static String degToHHMMSS(double d) throws OutOfRangeException, InvalidCoordException {
        BigDecimal bigDecimal = BigDecimal.valueOf(d).multiply(BigDecimal.valueOf(3600000L));
        BigDecimal bigDecimal2 = bigDecimal.setScale(3, 4);
        return Convert.milliarcsecToString(bigDecimal2, true, false);
    }

    public static String milliarcsecToDDMMSS(double d) throws OutOfRangeException, InvalidCoordException {
        return Convert.milliarcsecToString(BigDecimal.valueOf(d), false, false);
    }

    public static String milliarcsecToHHMMSS(double d) throws OutOfRangeException, InvalidCoordException {
        return Convert.milliarcsecToString(BigDecimal.valueOf(d), true, false);
    }

    public static String milliarcsecToString(BigDecimal bigDecimal, boolean bl, boolean bl2) throws OutOfRangeException, InvalidCoordException {
        BigDecimal bigDecimal2;
        if (!bl2) {
            if (bl) {
                if (!Convert.isValidRA(bigDecimal)) {
                    throw new InvalidCoordException("Invalid masec RA: " + bigDecimal);
                }
            } else if (!Convert.isValidDec(bigDecimal)) {
                throw new InvalidCoordException("Invalid masec Dec: " + bigDecimal);
            }
        }
        MathContext mathContext = new MathContext(bigDecimal.precision());
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMinimumIntegerDigits(2);
        decimalFormat.setRoundingMode(RoundingMode.DOWN);
        if (bl) {
            bigDecimal2 = bigDecimal.divide(BigDecimal.valueOf(15.0), mathContext);
            decimalFormat.setMinimumFractionDigits(4);
        } else {
            bigDecimal2 = new BigDecimal(bigDecimal.toString());
            decimalFormat.setMinimumFractionDigits(3);
        }
        char c = ' ';
        if (bigDecimal2.compareTo(BigDecimal.ZERO) < 0) {
            c = '-';
            bigDecimal2 = bigDecimal2.negate();
        }
        BigDecimal[] bigDecimalArray = bigDecimal2.divideAndRemainder(BD_MILLISECS_PER_UNIT, mathContext);
        BigDecimal bigDecimal3 = bigDecimalArray[0];
        bigDecimal2 = bigDecimal2.subtract(bigDecimal3.multiply(BD_MILLISECS_PER_UNIT));
        bigDecimalArray = bigDecimal2.divideAndRemainder(BD_MILLISECS_PER_MINUTE, mathContext);
        BigDecimal bigDecimal4 = bigDecimalArray[0];
        bigDecimal2 = bigDecimal2.subtract(bigDecimal4.multiply(BD_MILLISECS_PER_MINUTE));
        BigDecimal bigDecimal5 = bigDecimal2.divide(BD_MILLISECS_PER_SEC, mathContext);
        String string = decimalFormat.format(bigDecimal5);
        String string2 = c + TextUtils.zeroPadded(2, bigDecimal3.intValue()) + ":" + TextUtils.zeroPadded(2, bigDecimal4.intValue()) + ":" + string;
        return string2;
    }

    public static String normalizeDec(String string) throws OutOfRangeException, InvalidCoordException, NumberFormatException {
        double d = Convert.DDMMSSToMilliarcsec(string);
        String string2 = Convert.milliarcsecToDDMMSS(d);
        return string2;
    }

    public static String normalizeRa(String string) throws OutOfRangeException, InvalidCoordException, NumberFormatException {
        double d = Convert.HHMMSSToMilliarcsec(string);
        String string2 = Convert.milliarcsecToHHMMSS(d);
        return string2;
    }

    public static double round(double d, int n) {
        double d2 = 1.0;
        for (int i = 1; i <= n; ++i) {
            d2 *= 10.0;
        }
        double d3 = d * d2;
        d3 = d3 >= 0.0 ? (d3 += 0.5) : (d3 -= 0.5);
        int n2 = (int)d3;
        d3 = (double)n2 / d2;
        return d3;
    }

    public static String secToHHMMSS(long l) throws OutOfRangeException, InvalidCoordException {
        BigDecimal bigDecimal = BigDecimal.valueOf(l).multiply(BigDecimal.valueOf(1000L));
        return Convert.milliarcsecToString(bigDecimal, false, true);
    }

    private static double stringToMilliarcsec(String string, boolean bl, boolean bl2) throws InvalidCoordException, NumberFormatException {
        double d = 0.0;
        try {
            int n;
            string = string.trim();
            if (string.startsWith("+")) {
                string = string.substring(1);
            }
            if (string.indexOf(58) == -1) {
                return Convert.stringToMilliarcsecNoColons(string, bl, bl2);
            }
            d = 0.0;
            StringTokenizer stringTokenizer = new StringTokenizer(string, " :");
            String string2 = stringTokenizer.nextToken();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 1;
            if (stringTokenizer.hasMoreTokens()) {
                n2 = new Integer(stringTokenizer.nextToken());
                if (stringTokenizer.hasMoreTokens()) {
                    n3 = new Integer(stringTokenizer.nextToken(": ,."));
                    if (stringTokenizer.hasMoreTokens()) {
                        String string3 = stringTokenizer.nextToken(".,");
                        for (int i = 1; i <= 3; ++i) {
                            string3 = string3 + "0";
                        }
                        string3 = string3.substring(0, 3);
                        n4 = new Integer(string3);
                    }
                }
            }
            if (string2.startsWith("-")) {
                n5 = -1;
                n = -new Integer(string2).intValue();
            } else {
                n = new Integer(string2);
            }
            if (!bl2) {
                if (bl) {
                    Convert.checkBoundsHHMMSS(n5, n, n2, n3, n4);
                } else {
                    Convert.checkBoundsDDMMSS(n5, n, n2, n3, n4);
                }
            }
            d = n5 * (n * 3600000 + n2 * 60000 + n3 * 1000 + n4);
            if (bl) {
                d *= 15.0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException("Invalid number: '" + numberFormatException.getMessage() + "'");
        }
        return d;
    }

    private static double stringToMilliarcsecNoColons(String string, boolean bl, boolean bl2) throws InvalidCoordException, NumberFormatException {
        int n;
        int n2;
        double d = 0.0;
        int n3 = -1;
        int n4 = -1;
        String string2 = null;
        String string3 = "000";
        int n5 = 0;
        int n6 = 0;
        string = string.trim();
        n5 = string.indexOf(46);
        n6 = string.length();
        n3 = n5 == -1 ? n6 : n5;
        if (string.startsWith("-")) {
            n4 = 1;
            n2 = -1;
        } else {
            n4 = 0;
            n2 = 1;
        }
        string2 = string.substring(n4, n3).trim();
        if (n3 < n6) {
            string3 = string.substring(n3 + 1, n6) + "000";
            string2 = TextUtils.padded("000000", 6, string2);
        } else {
            if (string2.length() == 1) {
                string2 = "0" + string2;
            }
            string2 = TextUtils.rightpadded("000000", 6, string2);
        }
        string3 = string3.substring(0, 3);
        if (string2.length() > 6) {
            throw new InvalidCoordException("String too long: '" + string + "'");
        }
        String string4 = string2.substring(0, 2);
        String string5 = string2.substring(2, 4);
        String string6 = string2.substring(4, 6);
        int n7 = 0;
        try {
            n7 = new Integer(string4);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(numberFormatException.getMessage());
        }
        int n8 = new Integer(string5);
        int n9 = new Integer(string6);
        try {
            n = new Integer(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(numberFormatException.getMessage());
        }
        if (!bl2) {
            if (bl) {
                Convert.checkBoundsHHMMSS(n2, n7, n8, n9, n);
            } else {
                Convert.checkBoundsDDMMSS(n2, n7, n8, n9, n);
            }
        }
        d = n2 * (n7 * 3600000 + n8 * 60000 + n9 * 1000 + n);
        if (bl) {
            d *= 15.0;
        }
        return d;
    }

    private static String valuesToString(int n, int n2, int n3, int n4, int n5) {
        String string = null;
        string = n < 0 ? "-" : "";
        string = string + n2 + ":" + n3 + ":" + n4 + "." + n5;
        return string;
    }

    public static String convertToDateTime(Date date) {
        try {
            DateFormat dateFormat = converterPool.take();
            String string = dateFormat.format(date);
            converterPool.put(dateFormat);
            return string;
        }
        catch (InterruptedException interruptedException) {
            return new SimpleDateFormat("yyyy.MM.dd HH.mm").format(date);
        }
    }

    public static String convertToISO(long l) {
        Date date = new Date(l);
        return Convert.convertToISO(date, false);
    }

    public static String convertToISO(Date date) {
        return Convert.convertToISO(date, false);
    }

    public static String convertToShortISO(long l) {
        Date date = new Date(l);
        return Convert.convertToISO(date, true);
    }

    public static String convertToShortISO(Date date) {
        return Convert.convertToISO(date, true);
    }

    static String convertToISO(Date date, boolean bl) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int n = calendar.get(1);
        int n2 = 0;
        switch (calendar.get(2)) {
            case 0: {
                n2 = 1;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 4;
                break;
            }
            case 4: {
                n2 = 5;
                break;
            }
            case 5: {
                n2 = 6;
                break;
            }
            case 6: {
                n2 = 7;
                break;
            }
            case 7: {
                n2 = 8;
                break;
            }
            case 8: {
                n2 = 9;
                break;
            }
            case 9: {
                n2 = 10;
                break;
            }
            case 10: {
                n2 = 11;
                break;
            }
            case 11: {
                n2 = 12;
            }
        }
        int n3 = calendar.get(5);
        int n4 = calendar.get(11);
        int n5 = calendar.get(12);
        int n6 = calendar.get(13);
        int n7 = calendar.get(14);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n);
        stringBuffer.append("-");
        stringBuffer.append(Convert.twoChars(n2));
        stringBuffer.append("-");
        stringBuffer.append(Convert.twoChars(n3));
        stringBuffer.append("T");
        stringBuffer.append(Convert.twoChars(n4));
        stringBuffer.append(":");
        stringBuffer.append(Convert.twoChars(n5));
        stringBuffer.append(":");
        stringBuffer.append(Convert.twoChars(n6));
        if (!bl) {
            stringBuffer.append(".");
            stringBuffer.append(Convert.threeChars(n7));
        }
        return stringBuffer.toString();
    }

    public static Calendar convertToCalendar(String string) throws NumberFormatException, IllegalArgumentException {
        Object object;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        float f = 0.0f;
        if (string == null || string.equals("") || Pattern.compile("^\\s+$").matcher(string).find()) {
            return null;
        }
        String[] stringArray = string.split("[T :-]");
        n = new Integer(stringArray[0]);
        n2 = new Integer(stringArray[1]);
        n3 = new Integer(stringArray[2]);
        switch (n2) {
            case 1: {
                n2 = 0;
                break;
            }
            case 2: {
                n2 = 1;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 4;
                break;
            }
            case 6: {
                n2 = 5;
                break;
            }
            case 7: {
                n2 = 6;
                break;
            }
            case 8: {
                n2 = 7;
                break;
            }
            case 9: {
                n2 = 8;
                break;
            }
            case 10: {
                n2 = 9;
                break;
            }
            case 11: {
                n2 = 10;
                break;
            }
            case 12: {
                n2 = 11;
                break;
            }
        }
        boolean bl = false;
        switch (6 - stringArray.length) {
            default: {
                object = stringArray[5];
                if (((String)object).endsWith("Z")) {
                    bl = true;
                    f = new Float(((String)object).substring(0, ((String)object).length() - 1)).floatValue();
                } else {
                    f = new Float((String)object).floatValue();
                }
                n6 = (int)f;
                n7 = Math.round(1000.0f * (f - (float)n6));
            }
            case 1: {
                n5 = new Integer(stringArray[4]);
            }
            case 2: {
                n4 = new Integer(stringArray[3]);
            }
            case 3: 
        }
        object = Calendar.getInstance();
        if (bl) {
            ((Calendar)object).setTimeZone(TimeZone.getTimeZone("UT"));
        }
        ((Calendar)object).setLenient(false);
        ((Calendar)object).set(n, n2, n3, n4, n5, n6);
        ((Calendar)object).set(14, n7);
        try {
            for (int i = 0; i < 17; ++i) {
                ((Calendar)object).get(i);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Invalid field (" + illegalArgumentException.getMessage() + "). Required format is YYYY-MM-DD [hh:mm:ss.mmm]");
        }
        return object;
    }

    private static String twoChars(int n) {
        String string = Integer.toString(n);
        if (n < 10) {
            return "0" + string;
        }
        return string;
    }

    private static String threeChars(int n) {
        String string = Integer.toString(n) + "00";
        return string.substring(0, 3);
    }

    public static void main(String[] stringArray) {
        String[] stringArray2;
        for (String string : stringArray2 = new String[]{"00:00:00.000", "11:11:11.111", "05:05:05.050", "23:59:59.999", "-23:59:59.999"}) {
            double d = 0.0;
            String string2 = null;
            try {
                d = Convert.stringToMilliarcsec(string, true, false);
                string2 = Convert.milliarcsecToString(BigDecimal.valueOf(d), true, false);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
            catch (InvalidCoordException invalidCoordException) {
                invalidCoordException.printStackTrace();
            }
            catch (OutOfRangeException outOfRangeException) {
                outOfRangeException.printStackTrace();
            }
            System.out.println(string + " - " + d + " - " + string2);
        }
    }
}

