/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.util;

import alma.obsprep.util.Range;
import java.util.IllegalFormatException;

public class DoubleRange
implements Range<Double> {
    private Double min;
    private Double max;
    protected String defaultFormat = "%.2f - %.2f";

    public DoubleRange(Double d, Double d2) {
        this.setMax(d2);
        this.setMin(d);
    }

    public void setMax(Double d) {
        this.max = d;
    }

    public void setMin(Double d) {
        this.min = d;
    }

    @Override
    public Double max() {
        return this.max;
    }

    @Override
    public Double mid() {
        return (this.max + this.min) / 2.0;
    }

    @Override
    public Double min() {
        return this.min;
    }

    @Override
    public Double range() {
        return this.max - this.min;
    }

    public String toString() {
        return this.format(this.defaultFormat);
    }

    public String format(String string) {
        String string2;
        try {
            string2 = String.format(string, this.min, this.max);
        }
        catch (IllegalFormatException illegalFormatException) {
            string2 = String.format(this.defaultFormat, this.min, this.max);
        }
        return string2;
    }
}

