/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;

public final class FileUtilities {
    public static final String jpeg = "jpeg";
    public static final String jpg = "jpg";
    public static final String gif = "gif";
    public static final String tiff = "tiff";
    public static final String tif = "tif";
    public static final String xml = "xml";
    public static final String txt = "txt";
    public static final String aot = "aot";
    public static final String pdf = "pdf";
    private static File tmpdir = null;
    private static final long timeInNanos = System.nanoTime();
    public static boolean deleteTmpDirOnExit = true;
    public static boolean threadUniqueTmpDir = false;
    private static String curDir = null;

    private FileUtilities() {
    }

    public static String getBasename(String string) {
        int n = string.length() - 1;
        if (n >= 0 && string.charAt(n) == '/') {
            string = string.substring(0, n);
        }
        if ((n = string.lastIndexOf(46)) < 0) {
            return string;
        }
        String string2 = string.substring(0, n);
        return string2;
    }

    public static String getBasename(File file) {
        String string = file.getName();
        return FileUtilities.getBasename(string);
    }

    public static String getBasename(URL uRL) {
        String string = uRL.toExternalForm();
        int n = string.indexOf(":");
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        File file = new File(string);
        return FileUtilities.getBasename(file);
    }

    public static String getExtension(File file) {
        String string = file.getName();
        return FileUtilities.getExtension(string);
    }

    public static String getExtension(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return null;
        }
        String string2 = string.substring(n + 1).toLowerCase();
        return string2;
    }

    public static File getTmpDir() throws IOException {
        File file;
        String string = System.getProperty("java.io.tmpdir");
        String string2 = Long.toString(timeInNanos);
        if (threadUniqueTmpDir) {
            long l = Thread.currentThread().getId();
            string2 = "thread" + Long.toString(l);
        }
        if (!(file = new File(string, string2)).exists() && !file.mkdirs()) {
            throw new IOException("Could not create temp directory: " + file.getAbsolutePath());
        }
        if (deleteTmpDirOnExit) {
            file.deleteOnExit();
        }
        return file;
    }

    public static void stringToFile(String string, String string2) throws IOException {
        File file = new File(string2);
        FileUtilities.stringToFile(string, file);
    }

    public static void stringToFile(String string, File file) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        bufferedWriter.write(string, 0, string.length());
        bufferedWriter.close();
    }

    public static String fileToString(String string) throws IOException {
        File file = new File(string);
        return FileUtilities.fileToString(file);
    }

    public static String fileToString(File file) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[64000];
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        while (bufferedReader.ready() && (n = bufferedReader.read(cArray, 0, cArray.length)) > 0) {
            stringBuffer.append(cArray, 0, n);
        }
        bufferedReader.close();
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] fileToBytes(File file) throws IOException {
        BufferedInputStream bufferedInputStream = null;
        try {
            int n;
            byte[] byArray = new byte[(int)file.length()];
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            for (int i = 0; i < byArray.length && (n = bufferedInputStream.read(byArray, i, bufferedInputStream.available())) != -1; i += n) {
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
        finally {
            try {
                bufferedInputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void bytesToFile(byte[] byArray, File file) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray);
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public static URL makeURL(String string) throws MalformedURLException {
        File file;
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Null or empty input.");
        }
        URL uRL = null;
        boolean bl = false;
        if (string.length() > 1) {
            char c = string.charAt(0);
            char c2 = string.charAt(1);
            if (c2 == ':' && "ABCDEFGHIJKLMNOPQRSTUVWXYZ".indexOf(c) != -1) {
                bl = true;
            }
        }
        if ((file = new File(string)).exists() || bl) {
            uRL = file.toURI().toURL();
            return uRL;
        }
        if (string.indexOf(58) == -1) {
            string = "file:" + string;
        }
        uRL = new URL(string);
        return uRL;
    }

    public static URL makeURL(File file) throws MalformedURLException {
        return FileUtilities.makeURL(file.getAbsolutePath());
    }

    public static String makeRelativePath(File file) {
        File file2 = new File(System.getProperty("user.dir"));
        return FileUtilities.makeRelativePath(file2, file);
    }

    static String makeRelativePath(File file, File file2) {
        int n;
        file = file.getAbsoluteFile();
        ArrayList<File> arrayList = new ArrayList<File>();
        do {
            arrayList.add(file);
        } while ((file = file.getParentFile()) != null);
        Collections.reverse(arrayList);
        file2 = file2.getAbsoluteFile();
        ArrayList<File> arrayList2 = new ArrayList<File>();
        do {
            arrayList2.add(file2);
        } while ((file2 = file2.getParentFile()) != null);
        Collections.reverse(arrayList2);
        int n2 = -1;
        int n3 = 0;
        while (n3 < arrayList.size() && n3 < arrayList2.size() && ((File)arrayList.get(n3)).equals(arrayList2.get(n3))) {
            n2 = n3++;
        }
        if (n2 == -1) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (n = arrayList.size() - 1; n > n2; --n) {
            stringBuilder.append("../");
        }
        for (n = n2 + 1; n < arrayList2.size(); ++n) {
            stringBuilder.append(((File)arrayList2.get(n)).getName()).append("/");
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    public static boolean isTestDir() {
        try {
            if (curDir == null) {
                String string = null;
                string = new File(".").getCanonicalPath();
                String string2 = string.replace('\\', '/');
                String[] stringArray = string2.split("/");
                curDir = stringArray[stringArray.length - 1];
            }
            return curDir.equals("test");
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

