/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.util;

import alma.obsprep.obstooluserprefs.DialogSettings;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.ot.gui.widgets.LimitableScroller;
import alma.obsprep.util.IHelpfulError;
import alma.obsprep.util.MiscUtils;
import alma.obsprep.util.VerticalFlowLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public final class GUIUtilities {
    private static Map<DialogId, Timer> timerMap = new ConcurrentHashMap<DialogId, Timer>();
    private static Window owner = null;
    public static boolean suppressAllMessageBoxes = false;
    private static Set<DialogId> allDialogs = new TreeSet<DialogId>();
    private static Map<DialogId, DialogSettings> autoDialogs = new HashMap<DialogId, DialogSettings>();
    public static DialogId allOthersId = new DialogId("(All Others)");

    public static void setParentWindow(Window window) {
        owner = window;
    }

    private static boolean isSuppressAllMessageBoxes() {
        return suppressAllMessageBoxes || Boolean.getBoolean("java.awt.headless");
    }

    private GUIUtilities() {
    }

    public static DialogSettings dialogSettings(DialogId dialogId) {
        if (dialogId == null) {
            throw new IllegalArgumentException("null id not allowed");
        }
        DialogSettings dialogSettings = autoDialogs.get(dialogId);
        if (dialogSettings == null) {
            dialogSettings = new DialogSettings();
            dialogSettings.setDialogId(dialogId.getId());
            dialogSettings.setDescription(dialogId.getDescription());
        }
        return dialogSettings;
    }

    public static Set<DialogId> dialogIds() {
        return allDialogs;
    }

    public static DialogId registerDialog(DialogId dialogId) {
        allDialogs.add(dialogId);
        return dialogId;
    }

    public static void automatiseDialog(DialogId dialogId, int n) {
        DialogSettings dialogSettings = GUIUtilities.dialogSettings(dialogId);
        dialogSettings.setDialogId(dialogId.getId());
        dialogSettings.setDescription(dialogId.getDescription());
        dialogSettings.setSuppress(true);
        dialogSettings.setAutoanswer(n);
        autoDialogs.put(dialogId, dialogSettings);
    }

    public static void clearAutomatisedDialogs() {
        autoDialogs.clear();
    }

    public static void plain(DialogId dialogId, Object object, String string) {
        GUIUtilities.show(dialogId, owner, object, string, -1, -1, null, null, null, null);
    }

    public static boolean confirm(DialogId dialogId, String string) {
        if (MiscUtils.isConfirmationsDisabled()) {
            return true;
        }
        int n = GUIUtilities.show(dialogId, owner, string, "ALMA OT - Question", 0, 3, null, null, null, null);
        return n == 0;
    }

    public static int offer(DialogId dialogId, String string, String ... stringArray) {
        int n = GUIUtilities.show(dialogId, owner, string, "ALMA OT - Question", -1, 3, null, stringArray, stringArray[0], null);
        return n;
    }

    public static void error(DialogId dialogId, Object object) {
        GUIUtilities.show(dialogId, owner, object, "ALMA OT - Error", -1, 0, null, null, null, null);
    }

    public static void error(DialogId dialogId, String string, Throwable throwable) {
        GUIUtilities.twoStage(dialogId, string, throwable, "ALMA OT - Error", 0);
    }

    public static void info(DialogId dialogId, Object object) {
        GUIUtilities.show(dialogId, owner, object, "ALMA OT - Information", -1, 1, null, null, null, null);
    }

    public static void info(DialogId dialogId, String string, Object object) {
        GUIUtilities.show(dialogId, owner, object, string, -1, 1, null, null, null, null);
    }

    public static void info(DialogId dialogId, String string, Object object, Dimension dimension) {
        GUIUtilities.show(dialogId, owner, object, string, -1, 1, null, null, null, dimension);
    }

    public static void infoWithDoNotShowAgain(DialogId dialogId, Object object) {
        JCheckBox jCheckBox = new JCheckBox("Do not show this message again");
        Object[] objectArray = new Object[]{object, jCheckBox};
        GUIUtilities.show(dialogId, owner, objectArray, "ALMA OT - Information", -1, 1, null, null, null, null);
        if (jCheckBox.isSelected()) {
            GUIUtilities.automatiseDialog(dialogId, 0);
        }
    }

    public static void info(DialogId dialogId, String string, Throwable throwable) {
        GUIUtilities.twoStage(dialogId, string, throwable, "ALMA OT - Information", 1);
    }

    public static void warning(DialogId dialogId, Object object) {
        GUIUtilities.show(dialogId, owner, object, "ALMA OT - Warning", -1, 2, null, null, null, null);
    }

    public static void warning(DialogId dialogId, Object object, long l) {
        if (!GUIUtilities.startTimer(dialogId, l)) {
            return;
        }
        GUIUtilities.show(dialogId, owner, object, "ALMA OT - Warning", -1, 2, null, null, null, null);
    }

    public static void warningWithDoNotShowAgain(DialogId dialogId, Object object) {
        JCheckBox jCheckBox = new JCheckBox("Do not show this message again");
        Object[] objectArray = new Object[]{object, jCheckBox};
        GUIUtilities.show(dialogId, owner, objectArray, "ALMA OT - Warning", -1, 2, null, null, null, null);
        if (jCheckBox.isSelected()) {
            GUIUtilities.automatiseDialog(dialogId, 0);
        }
    }

    public static void warning(DialogId dialogId, String string, Throwable throwable) {
        GUIUtilities.twoStage(dialogId, string, throwable, "ALMA OT - Warning", 2);
    }

    private static void twoStage(DialogId dialogId, String string, Throwable throwable, String string2, int n) {
        final Throwable throwable2 = throwable;
        JPanel jPanel = new JPanel(new VerticalFlowLayout(5));
        final JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "Center");
        if (string != null) {
            string = string.trim();
            jPanel.add(new JLabel(string));
        }
        JSeparator jSeparator = new JSeparator(0);
        jPanel.add((Component)jSeparator, "Stretch Width");
        String string3 = null;
        String string4 = null;
        if (throwable instanceof IHelpfulError) {
            string4 = ((IHelpfulError)((Object)throwable)).getUserDetails();
            if (string4 != null) {
                string4 = string4.trim();
                jPanel.add(GUIUtilities.textarea(string4, 40, 5));
            }
            if ((string3 = ((IHelpfulError)((Object)throwable)).getUserSuggestion()) != null) {
                string3 = string3.trim();
                jPanel.add(GUIUtilities.textarea(string3, 40, 5));
            }
        }
        jPanel.add(Box.createVerticalStrut(4));
        JLabel jLabel = new JLabel("Technical Error Report ...");
        jLabel.setToolTipText("See technical details, and copy to the log");
        jLabel.setForeground(Color.BLUE);
        jLabel.setCursor(Cursor.getPredefinedCursor(12));
        jLabel.setAlignmentY(3.0f);
        final JLabel jLabel2 = jLabel;
        jPanel.add(jLabel2);
        final JLabel jLabel3 = new JLabel("Technical Details about this problem were copied to your log");
        jPanel.add(jLabel3);
        jLabel3.setVisible(false);
        jPanel.add(Box.createVerticalStrut(2));
        final String string5 = string;
        final String string6 = string4;
        final String string7 = string3;
        jLabel2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                CharSequence charSequence;
                ByteArrayOutputStream byteArrayOutputStream;
                Object object = null;
                if (throwable2 != null) {
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    throwable2.printStackTrace(new PrintStream(byteArrayOutputStream));
                    object = "--Stacktrace--\n" + byteArrayOutputStream.toString();
                    if (throwable2 instanceof IHelpfulError && (charSequence = ((IHelpfulError)((Object)throwable2)).getTechnicalDetails()) != null) {
                        object = (String)object + "\n--Technical Details--\n" + (String)charSequence;
                    }
                }
                byteArrayOutputStream = object;
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append("\n===Technical Error Report initiated by user===");
                ((StringBuilder)charSequence).append("\n--Message--\n").append(string5);
                ((StringBuilder)charSequence).append("\n--Details--\n").append(string6);
                ((StringBuilder)charSequence).append("\n--Suggestion--\n").append(string7);
                ((StringBuilder)charSequence).append("\n").append((String)((Object)byteArrayOutputStream));
                System.out.println(((StringBuilder)charSequence).toString());
                JTextArea jTextArea = new JTextArea((String)((Object)byteArrayOutputStream));
                jTextArea.setCaretPosition(0);
                jTextArea.setEditable(false);
                JScrollPane jScrollPane = new JScrollPane(jTextArea);
                jScrollPane.setPreferredSize(new Dimension(450, 200));
                jPanel2.add((Component)jScrollPane, "South");
                jLabel2.setVisible(false);
                jLabel3.setVisible(true);
                jPanel2.validate();
                SwingUtilities.getWindowAncestor(jPanel2).pack();
            }
        });
        GUIUtilities.show(dialogId, owner, jPanel2, string2, -1, n, null, null, null, null);
    }

    private static JScrollPane textarea(String string, int n, int n2) {
        JTextArea jTextArea = new JTextArea(string);
        jTextArea.setColumns(n);
        jTextArea.setLineWrap(true);
        jTextArea.setOpaque(false);
        jTextArea.setEditable(false);
        LimitableScroller limitableScroller = new LimitableScroller(jTextArea);
        limitableScroller.setBorder(BorderFactory.createEmptyBorder());
        FontMetrics fontMetrics = jTextArea.getFontMetrics(jTextArea.getFont());
        limitableScroller.setHeightLimit(n2 * fontMetrics.getHeight());
        return limitableScroller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int show(DialogId dialogId, Component component, Object object, String string, int n, int n2, Icon icon, Object[] objectArray, Object object2, Dimension dimension) {
        JOptionPane jOptionPane;
        Object object3;
        Container container;
        DialogSettings dialogSettings;
        if (dialogId == null) {
            dialogId = allOthersId;
        }
        if ((dialogSettings = GUIUtilities.dialogSettings(dialogId)).getSuppress()) {
            return dialogSettings.getAutoanswer();
        }
        if (GUIUtilities.isSuppressAllMessageBoxes()) {
            String string2 = String.valueOf(object);
            System.out.println("MESSAGE BOX: '" + string + "' " + "'" + string2 + "'");
            return -1;
        }
        if (dimension != null) {
            container = new JLabel((String)object);
            object3 = new JScrollPane(container, 20, 30);
            ((JComponent)object3).setPreferredSize(dimension);
            jOptionPane = new JOptionPane(object3, n2, n, icon, objectArray, object2);
        } else {
            jOptionPane = new JOptionPane(object, n2, n, icon, objectArray, object2);
        }
        jOptionPane.setInitialValue(object2);
        container = jOptionPane.createDialog(component, string);
        object3 = "";
        switch (n2) {
            case 1: {
                object3 = "Info";
                break;
            }
            case 0: {
                object3 = "Error";
                break;
            }
            case -1: {
                object3 = "Plain";
                break;
            }
            case 3: {
                object3 = "Question";
                break;
            }
            case 2: {
                object3 = "Warning";
            }
        }
        jOptionPane.setName((String)object3 + "Box");
        AbstractButton abstractButton = null;
        jOptionPane.selectInitialValue();
        EventQueue.invokeLater(() -> GUIUtilities.lambda$show$335((JDialog)container));
        ((Dialog)container).setVisible(true);
        ((Window)container).dispose();
        int n3 = -1;
        try {
            Object object4 = jOptionPane.getValue();
            if (object4 == null) {
                n3 = -1;
                int n4 = -1;
                return n4;
            }
            if (objectArray != null) {
                int n5;
                for (n5 = 0; n5 < objectArray.length; ++n5) {
                    if (!object4.equals(objectArray[n5])) continue;
                    int n6 = n3 = n5;
                    return n6;
                }
                n3 = -1;
                n5 = -1;
                return n5;
            }
            if (object4 instanceof Integer) {
                int n7 = n3 = ((Integer)object4).intValue();
                return n7;
            }
            n3 = -1;
            int n8 = -1;
            return n8;
        }
        finally {
            if (abstractButton != null && abstractButton.isSelected()) {
                GUIUtilities.automatiseDialog(dialogId, n3);
            }
        }
    }

    private static synchronized boolean startTimer(final DialogId dialogId, long l) {
        if (timerMap.containsKey(dialogId)) {
            return false;
        }
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                timerMap.remove(dialogId);
            }
        }, l * 1000L);
        timerMap.put(dialogId, timer);
        return true;
    }

    public static void main(String[] stringArray) {
        int n;
        DialogId dialogId = new DialogId("bla1");
        String string = "Details: water is missing";
        String string2 = "Suggestion: Add water";
        String string3 = "Tech Details: the h2o detector reported 0.5% saturation";
        GUIUtilities.confirm(dialogId, "<html>This is a <br> two-line question</html>");
        Throwable throwable = new Throwable("This is an error");
        class Err
        extends Exception
        implements IHelpfulError {
            private final int c;
            private final String um;
            private final String us;
            private final String ud;
            private final String td;

            Err(String string, Throwable throwable, String string2, String string3, String string4, String string5, int n) {
                super(string, throwable);
                this.c = n;
                this.um = string2;
                this.us = string3;
                this.ud = string4;
                this.td = string5;
            }

            @Override
            public int getErrorCode() {
                return this.c;
            }

            @Override
            public String getUserMeaning() {
                return this.um;
            }

            @Override
            public String getUserSuggestion() {
                return this.us;
            }

            @Override
            public String getUserDetails() {
                return this.ud;
            }

            @Override
            public String getTechnicalDetails() {
                return this.td;
            }
        }
        Err err = new Err("This is error1", null, null, null, null, null, 0);
        GUIUtilities.error(dialogId, "error", err);
        err = new Err("This is error2", throwable, null, null, null, null, 0);
        GUIUtilities.error(dialogId, "error + cause", err);
        err = new Err("This is error3", throwable, null, string2, null, null, 0);
        GUIUtilities.error(dialogId, "error + cause + suggestion", err);
        err = new Err("This is error4", throwable, null, string2, string, null, 0);
        GUIUtilities.error(dialogId, "error + cause + suggestion + details", err);
        err = new Err("This is error5", throwable, null, string2, string, string3, 0);
        GUIUtilities.error(dialogId, "error + cause + suggestion + details + techinfo", err);
        err = new Err("This is error6", throwable, null, string2, string, string3, 1234);
        GUIUtilities.error(dialogId, "error + cause + suggestion + details + techinfo + code", err);
        for (n = 0; n < 20; ++n) {
            string = string + "\n" + n + " really a lot of details and details and details and details and details and details and details";
        }
        for (n = 0; n < 20; ++n) {
            string2 = string2 + "\n" + n + " a really long suggestion";
        }
        for (n = 0; n < 20; ++n) {
            string3 = string3 + "\n" + n + " really many techdetails";
        }
        err = new Err("This is error7", throwable, null, string2, null, null, 0);
        GUIUtilities.error(dialogId, "error + cause + big suggestion", err);
        err = new Err("This is error8", throwable, null, string2, string, null, 0);
        GUIUtilities.error(dialogId, "error + cause + big suggestion + big details", err);
        err = new Err("This is error9", throwable, null, string2, string, string3, 0);
        GUIUtilities.error(dialogId, "error + cause + big suggestion + big details + big techinfo", err);
        System.exit(0);
    }

    private static /* synthetic */ void lambda$show$335(JDialog jDialog) {
        jDialog.toFront();
        jDialog.repaint();
    }

    static {
        GUIUtilities.registerDialog(allOthersId);
    }
}

