/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.util;

import alma.hla.runtime.obsprep.util.Log;
import alma.valuetypes.Angle;
import alma.valuetypes.SkyCoordinates;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import org.apache.commons.jcs.JCS;
import org.apache.commons.jcs.access.CacheAccess;
import org.apache.commons.lang3.SerializationUtils;

public final class MinimumBoundingRectangle {
    private static CacheAccess<Integer, BoundedRectangle> rectangleCache = JCS.getInstance((String)"rectangleCache");

    private double getArea(Point2D.Double[] doubleArray) {
        double d = doubleArray[0].x - doubleArray[1].x;
        double d2 = doubleArray[0].y - doubleArray[1].y;
        double d3 = doubleArray[1].x - doubleArray[2].x;
        double d4 = doubleArray[1].y - doubleArray[2].y;
        double d5 = Math.sqrt(d * d + d2 * d2);
        double d6 = Math.sqrt(d3 * d3 + d4 * d4);
        return d5 * d6;
    }

    public BoundedRectangle determineMinimumBoundRectangleForCoordinates(List<SkyCoordinates> list) throws IllegalArgumentException, UnableToDetermineMinimumBoundingBoxException, PointsAreAllCollinearException {
        if (list == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: absCoords");
        }
        if (list.size() < 1) {
            throw new IllegalArgumentException("Illegal argument: offsetCoords.size() (" + list.size() + ") " + "did not pass the test: coords.size() < 1");
        }
        Object[] objectArray = new Double[list.size()];
        Object[] objectArray2 = new Double[list.size()];
        int n = 0;
        for (SkyCoordinates object2 : list) {
            objectArray[n] = object2.getLongitude().getContentInUnits(Angle.UNIT_ARCSEC);
            objectArray2[n] = object2.getLatitude().getContentInUnits(Angle.UNIT_ARCSEC);
            ++n;
        }
        int n2 = Arrays.hashCode(objectArray) + Arrays.hashCode(objectArray2);
        BoundedRectangle boundedRectangle = (BoundedRectangle)rectangleCache.get((Object)n2);
        if (boundedRectangle != null) {
            return (BoundedRectangle)SerializationUtils.clone((Serializable)boundedRectangle);
        }
        MinimumBoundingRectangle minimumBoundingRectangle = new MinimumBoundingRectangle();
        BoundedRectangle boundedRectangle2 = minimumBoundingRectangle.getMinimumBoundingRectangle((Double[])objectArray, (Double[])objectArray2);
        BoundedRectangle boundedRectangle3 = (BoundedRectangle)SerializationUtils.clone((Serializable)boundedRectangle2);
        rectangleCache.put((Object)n2, (Object)boundedRectangle3);
        return boundedRectangle2;
    }

    private List<BoundedRectangle> getAllBoundingRectangles(Double[] doubleArray, Double[] doubleArray2) throws IllegalArgumentException, UnableToDetermineMinimumBoundingBoxException, PointsAreAllCollinearException {
        if (doubleArray.length != doubleArray2.length) {
            throw new IllegalArgumentException("xs and ys don't have the same size");
        }
        ArrayList<Point> arrayList = new ArrayList<Point>();
        for (int i = 0; i < doubleArray.length; ++i) {
            arrayList.add(new Point(doubleArray[i], doubleArray2[i]));
        }
        return this.getAllBoundingRectangles(arrayList);
    }

    private List<BoundedRectangle> getAllBoundingRectangles(List<Point> list) throws IllegalArgumentException, UnableToDetermineMinimumBoundingBoxException, PointsAreAllCollinearException {
        ArrayList<BoundedRectangle> arrayList = new ArrayList<BoundedRectangle>();
        List<Point> list2 = GrahamScan.getConvexHull(list);
        Caliper caliper = new Caliper(list2, this.getIndex(list2, Corner.UPPER_RIGHT), 90.0);
        Caliper caliper2 = new Caliper(list2, this.getIndex(list2, Corner.UPPER_LEFT), 180.0);
        Caliper caliper3 = new Caliper(list2, this.getIndex(list2, Corner.LOWER_LEFT), 270.0);
        Caliper caliper4 = new Caliper(list2, this.getIndex(list2, Corner.LOWER_RIGHT), 0.0);
        double d = 0.0;
        while (caliper4.currentAngle < 90.0) {
            arrayList.add(new BoundedRectangle(new Point2D.Double[]{caliper4.getIntersection(caliper), caliper.getIntersection(caliper2), caliper2.getIntersection(caliper3), caliper3.getIntersection(caliper4)}, d));
            d = this.getSmallestTheta(caliper, caliper2, caliper3, caliper4);
            caliper.rotateBy(d);
            caliper2.rotateBy(d);
            caliper3.rotateBy(d);
            caliper4.rotateBy(d);
        }
        return arrayList;
    }

    private BoundedRectangle getMinimumBoundingRectangle(Double[] doubleArray, Double[] doubleArray2) throws IllegalArgumentException, UnableToDetermineMinimumBoundingBoxException, PointsAreAllCollinearException {
        if (doubleArray.length != doubleArray2.length) {
            throw new IllegalArgumentException("xs and ys don't have the same size");
        }
        ArrayList<Point> arrayList = new ArrayList<Point>();
        for (int i = 0; i < doubleArray.length; ++i) {
            arrayList.add(new Point(doubleArray[i], doubleArray2[i]));
        }
        return this.getMinimumBoundingRectangle(arrayList);
    }

    private BoundedRectangle getMinimumBoundingRectangle(List<Point> list) throws IllegalArgumentException, UnableToDetermineMinimumBoundingBoxException, PointsAreAllCollinearException {
        List<BoundedRectangle> list2 = this.getAllBoundingRectangles(list);
        Log.logger(MinimumBoundingRectangle.class).fine("Number of bounding boxes found : " + list2.size());
        BoundedRectangle boundedRectangle = null;
        double d = 9.223372036854776E18;
        for (BoundedRectangle boundedRectangle2 : list2) {
            double d2 = this.getArea(boundedRectangle2.getRectangle());
            if (boundedRectangle != null && !(d2 < d)) continue;
            boundedRectangle = boundedRectangle2;
            d = d2;
        }
        Log.logger(MinimumBoundingRectangle.class).fine("minimum.getRotationAngle(): " + boundedRectangle.getRotationAngle());
        return boundedRectangle;
    }

    private double getSmallestTheta(Caliper caliper, Caliper caliper2, Caliper caliper3, Caliper caliper4) {
        double d = caliper.getDeltaAngleNextPoint();
        double d2 = caliper2.getDeltaAngleNextPoint();
        double d3 = caliper3.getDeltaAngleNextPoint();
        double d4 = caliper4.getDeltaAngleNextPoint();
        if (d <= d2 && d <= d3 && d <= d4) {
            return d;
        }
        if (d2 <= d3 && d2 <= d4) {
            return d2;
        }
        if (d3 <= d4) {
            return d3;
        }
        return d4;
    }

    private int getIndex(List<Point> list, Corner corner) {
        int n = 0;
        Point point = list.get(n);
        for (int i = 1; i < list.size() - 1; ++i) {
            Point point2 = list.get(i);
            boolean bl = false;
            switch (corner) {
                case UPPER_RIGHT: {
                    bl = point2.x > point.x || point2.x == point.x && point2.y > point.y;
                    break;
                }
                case UPPER_LEFT: {
                    bl = point2.y > point.y || point2.y == point.y && point2.x < point.x;
                    break;
                }
                case LOWER_LEFT: {
                    bl = point2.x < point.x || point2.x == point.x && point2.y < point.y;
                    break;
                }
                case LOWER_RIGHT: {
                    boolean bl2 = bl = point2.y < point.y || point2.y == point.y && point2.x > point.x;
                }
            }
            if (!bl) continue;
            n = i;
            point = point2;
        }
        return n;
    }

    public static void main(String[] stringArray) {
        Double[] doubleArray = new Double[]{0.0, 10.0, 20.0};
        Double[] doubleArray2 = new Double[]{0.0, 19.0, 20.0};
        List<BoundedRectangle> list = null;
        MinimumBoundingRectangle minimumBoundingRectangle = new MinimumBoundingRectangle();
        try {
            list = minimumBoundingRectangle.getAllBoundingRectangles(doubleArray, doubleArray2);
        }
        catch (PointsAreAllCollinearException | UnableToDetermineMinimumBoundingBoxException | IllegalArgumentException exception) {
            exception.printStackTrace();
        }
        int n = 1;
        for (BoundedRectangle doubleArray3 : list) {
            Point2D.Double[] doubleArray4 = doubleArray3.getRectangle();
            int n2 = doubleArray4.length;
            for (int double_ = 0; double_ < n2; ++double_) {
                Point2D.Double double_2 = doubleArray4[double_];
                System.out.printf("corner[%d] (%.1f, %.1f) Theta (%.1f)%n", n++, double_2.x, double_2.y, doubleArray3.theta);
            }
            System.out.printf("%narea: %.1f\n\n", minimumBoundingRectangle.getArea(doubleArray3.getRectangle()));
            n = 0;
        }
        Object object = null;
        try {
            object = minimumBoundingRectangle.getMinimumBoundingRectangle(doubleArray, doubleArray2);
        }
        catch (PointsAreAllCollinearException | UnableToDetermineMinimumBoundingBoxException | IllegalArgumentException exception) {
            exception.printStackTrace();
        }
        System.out.println("\nMinimum bounded box\n");
        for (Point2D.Double double_ : ((BoundedRectangle)object).getRectangle()) {
            System.out.printf("corner[%d] (%.1f, %.1f) Theta (%.1f)%n", n++, double_.x, double_.y, ((BoundedRectangle)object).theta);
        }
        System.out.printf("%narea: %.1f", minimumBoundingRectangle.getArea(((BoundedRectangle)object).getRectangle()));
    }

    private static class GrahamScan {
        private GrahamScan() {
        }

        protected static boolean areAllCollinear(List<Point> list) {
            if (list.size() < 2) {
                return true;
            }
            Point point = list.get(0);
            Point point2 = list.get(1);
            for (int i = 2; i < list.size(); ++i) {
                Point point3 = list.get(i);
                if (GrahamScan.getTurn(point, point2, point3) == Turn.COLLINEAR) continue;
                return false;
            }
            return true;
        }

        public static List<Point> getConvexHull(List<Point> list) throws UnableToDetermineMinimumBoundingBoxException, PointsAreAllCollinearException {
            ArrayList<Point> arrayList = new ArrayList<Point>(GrahamScan.getSortedPointSet(list));
            if (arrayList.size() < 3) {
                throw new UnableToDetermineMinimumBoundingBoxException("can only create a convex hull of 3 or more unique points");
            }
            if (GrahamScan.areAllCollinear(arrayList)) {
                throw new PointsAreAllCollinearException("cannot create a convex hull from collinear points");
            }
            Stack stack = new Stack();
            stack.push(arrayList.get(0));
            stack.push(arrayList.get(1));
            block5: for (int i = 2; i < arrayList.size(); ++i) {
                Point point = (Point)arrayList.get(i);
                Point point2 = (Point)stack.pop();
                Point point3 = (Point)stack.peek();
                Turn turn = GrahamScan.getTurn(point3, point2, point);
                switch (turn) {
                    case COUNTER_CLOCKWISE: {
                        stack.push(point2);
                        stack.push(point);
                        continue block5;
                    }
                    case CLOCKWISE: {
                        --i;
                        continue block5;
                    }
                    case COLLINEAR: {
                        stack.push(point);
                    }
                }
            }
            stack.push(arrayList.get(0));
            return new ArrayList<Point>(stack);
        }

        protected static Point getLowestPoint(List<Point> list) {
            Point point = list.get(0);
            for (int i = 1; i < list.size(); ++i) {
                Point point2 = list.get(i);
                if (!(point2.y < point.y) && (point2.y != point.y || !(point2.x < point.x))) continue;
                point = point2;
            }
            return point;
        }

        protected static Set<Point> getSortedPointSet(List<Point> list) {
            final Point point = GrahamScan.getLowestPoint(list);
            TreeSet<Point> treeSet = new TreeSet<Point>(new Comparator<Point>(){

                @Override
                public int compare(Point point3, Point point2) {
                    double d;
                    double d2;
                    if (point3 == point2 || point3.equals(point2)) {
                        return 0;
                    }
                    double d3 = Math.atan2(point3.y - point.y, point3.x - point.x);
                    if (d3 < (d2 = Math.atan2(point2.y - point.y, point2.x - point.x))) {
                        return -1;
                    }
                    if (d3 > d2) {
                        return 1;
                    }
                    double d4 = Math.sqrt((point.x - point3.x) * (point.x - point3.x) + (point.y - point3.y) * (point.y - point3.y));
                    if (d4 < (d = Math.sqrt((point.x - point2.x) * (point.x - point2.x) + (point.y - point2.y) * (point.y - point2.y)))) {
                        return -1;
                    }
                    return 1;
                }
            });
            treeSet.addAll(list);
            return treeSet;
        }

        protected static Turn getTurn(Point point, Point point2, Point point3) {
            double d = (point2.x - point.x) * (point3.y - point.y) - (point2.y - point.y) * (point3.x - point.x);
            if (d > 0.0) {
                return Turn.COUNTER_CLOCKWISE;
            }
            if (d < 0.0) {
                return Turn.CLOCKWISE;
            }
            return Turn.COLLINEAR;
        }

        protected static enum Turn {
            CLOCKWISE,
            COUNTER_CLOCKWISE,
            COLLINEAR;

        }
    }

    private static class Caliper {
        static final double SIGMA = 1.0E-11;
        final List<Point> convexHull;
        int pointIndex;
        double currentAngle;

        Caliper(List<Point> list, int n, double d) {
            this.convexHull = list;
            this.pointIndex = n;
            this.currentAngle = d;
        }

        double getAngleNextPoint() {
            Point point = this.convexHull.get(this.pointIndex);
            Point point2 = this.convexHull.get((this.pointIndex + 1) % this.convexHull.size());
            double d = point2.y - point.y;
            double d2 = point2.x - point.x;
            double d3 = Math.atan2(d, d2) * 180.0 / Math.PI;
            return d3 < 0.0 ? 360.0 + d3 : d3;
        }

        double getConstant() {
            Point point = this.convexHull.get(this.pointIndex);
            return point.y - this.getSlope() * point.x;
        }

        double getDeltaAngleNextPoint() {
            double d = this.getAngleNextPoint();
            d = d < 0.0 ? 360.0 + d - this.currentAngle : d - this.currentAngle;
            return d < 0.0 ? 360.0 : d;
        }

        Point2D.Double getIntersection(Caliper caliper) {
            double d = this.isVertical() ? this.convexHull.get((int)this.pointIndex).x : (this.isHorizontal() ? caliper.convexHull.get((int)caliper.pointIndex).x : (caliper.getConstant() - this.getConstant()) / (this.getSlope() - caliper.getSlope()));
            double d2 = this.isVertical() ? caliper.getConstant() : (this.isHorizontal() ? this.getConstant() : this.getSlope() * d + this.getConstant());
            return new Point2D.Double(d, d2);
        }

        double getSlope() {
            return Math.tan(Math.toRadians(this.currentAngle));
        }

        boolean isHorizontal() {
            return Math.abs(this.currentAngle) < 1.0E-11 || Math.abs(this.currentAngle - 180.0) < 1.0E-11;
        }

        boolean isVertical() {
            return Math.abs(this.currentAngle - 90.0) < 1.0E-11 || Math.abs(this.currentAngle - 270.0) < 1.0E-11;
        }

        void rotateBy(double d) {
            if (this.getDeltaAngleNextPoint() == d) {
                ++this.pointIndex;
            }
            this.currentAngle += d;
        }
    }

    protected static enum Corner {
        UPPER_RIGHT,
        UPPER_LEFT,
        LOWER_LEFT,
        LOWER_RIGHT;

    }

    public static class BoundedRectangle
    implements Serializable {
        Point2D.Double[] rectangle;
        private double theta = 0.0;
        private double rotationAngle = 0.0;

        public BoundedRectangle(Point2D.Double[] doubleArray, double d) {
            this.rectangle = doubleArray;
            this.theta = d;
        }

        public Point2D.Double[] getRectangle() {
            return this.rectangle;
        }

        public Side getSide(SideType sideType) throws IllegalArgumentException {
            Point2D.Double double_ = null;
            Point2D.Double double_2 = null;
            if (this.rectangle == null || this.rectangle.length != 4) {
                throw new IllegalArgumentException("The bounding rectangle has not been determined");
            }
            double d = 0.0;
            boolean bl = false;
            block4: for (int i = 0; i < this.rectangle.length; ++i) {
                Point2D.Double double_3 = this.rectangle[i];
                Point2D.Double double_4 = this.rectangle[(i + 1) % this.rectangle.length];
                double d2 = double_4.distance(double_3);
                if (!bl) {
                    d = d2;
                    bl = true;
                    double_ = double_3;
                    double_2 = double_4;
                    continue;
                }
                switch (sideType) {
                    case LONGEST: {
                        if (!(d2 > d)) continue block4;
                        d = d2;
                        double_ = double_3;
                        double_2 = double_4;
                        continue block4;
                    }
                    case SHORTEST: {
                        if (!(d2 < d)) continue block4;
                        d = d2;
                        double_ = double_3;
                        double_2 = double_4;
                        continue block4;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown side type specified: " + (Object)((Object)sideType));
                    }
                }
            }
            if (!bl) {
                throw new IllegalArgumentException("Unable to determine sidelength");
            }
            Log.logger(BoundedRectangle.class).fine(String.format("Length of %s side is %.4g arcsec ", new Object[]{sideType, d}));
            return new Side(d, double_, double_2);
        }

        public double getTheta() {
            return this.theta;
        }

        public void setRectangle(Point2D.Double[] doubleArray) {
            this.rectangle = doubleArray;
        }

        public void setTheta(double d) {
            this.theta = d;
        }

        public String toString() {
            return "BoundedRectangle [rectangle=" + Arrays.toString(this.rectangle) + ", theta=" + this.theta + "]";
        }

        public final double getRotationAngle() {
            Side side = this.getSide(SideType.LONGEST);
            Point2D.Double double_ = side.getP1();
            Point2D.Double double_2 = side.getP2();
            return Math.toDegrees(Math.atan((double_2.getY() - double_.getY()) / (double_2.getX() - double_.getX())));
        }

        public final void setRotationAngle(double d) {
            this.rotationAngle = d;
        }

        public static enum SideType {
            SHORTEST,
            LONGEST;

        }
    }

    private static class Point {
        double x;
        double y;

        public Point(Double d, Double d2) {
            this.x = d;
            this.y = d2;
        }
    }

    public static class UnableToDetermineMinimumBoundingBoxException
    extends Exception {
        public UnableToDetermineMinimumBoundingBoxException(String string) {
            super(string);
        }
    }

    public static class PointsAreAllCollinearException
    extends Exception {
        public PointsAreAllCollinearException(String string) {
            super(string);
        }
    }

    public static class Side {
        private Point2D.Double p1;
        private Point2D.Double p2;
        private double sideLength;

        public Side(double d, Point2D.Double double_, Point2D.Double double_2) {
            this.sideLength = d;
            this.p1 = double_;
            this.p2 = double_2;
        }

        public Point2D.Double getP1() {
            return this.p1;
        }

        public void setP1(Point2D.Double double_) {
            this.p1 = double_;
        }

        public Point2D.Double getP2() {
            return this.p2;
        }

        public void setP2(Point2D.Double double_) {
            this.p2 = double_;
        }

        public double getSideLength() {
            return this.sideLength;
        }

        public void setSideLength(double d) {
            this.sideLength = d;
        }
    }
}

