/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;

public class PropertyHandler {
    static final String PROPS_FILE = "ObservingTool.properties";
    public String REPORT = null;
    private File almaOTFolder;
    protected Settings factorySettings = new Settings();
    protected Settings userSettings = new Settings();

    public String getProperty(String string) {
        String string2 = System.getProperty(string);
        if (string2 == null) {
            string2 = this.userSettings.properties.getProperty(string);
        }
        if (string2 == null) {
            string2 = this.factorySettings.properties.getProperty(string);
        }
        return string2;
    }

    public void setProperty(String string, String string2) {
        this.userSettings.properties.setProperty(string, string2);
    }

    public void saveUserSettings() throws IOException {
        String string = this.userSettings.location;
        if (string == null) {
            string = this.almaOTFolder.getAbsolutePath() + File.separator + PROPS_FILE;
        }
        FileWriter fileWriter = new FileWriter(string);
        this.userSettings.properties.store(fileWriter, null);
    }

    public PropertyHandler(File file) {
        this.almaOTFolder = file;
    }

    public void loadSystemProperties() throws IOException {
        this.readAllSettings(PROPS_FILE);
        this.setSystemProperties(System.getProperties());
    }

    void setSystemProperties(Properties properties) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.factorySettings.properties.stringPropertyNames());
        hashSet.addAll(this.userSettings.properties.stringPropertyNames());
        ArrayList arrayList = new ArrayList(hashSet);
        Collections.sort(arrayList);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Location of factory settings: ").append(this.factorySettings.location).append("\n");
        stringBuilder.append("Location of user    settings: ");
        stringBuilder.append(this.userSettings.location != null ? this.userSettings.location : "none").append("\n");
        for (String string : arrayList) {
            String string2 = properties.getProperty(string);
            if (string2 != null) {
                stringBuilder.append(" property ").append(string).append("=").append(string2).append(" set from command line\n");
                continue;
            }
            string2 = this.userSettings.properties.getProperty(string);
            if (string2 != null) {
                stringBuilder.append(" property ").append(string).append("=").append(string2).append(" set from user settings\n");
                properties.setProperty(string, string2);
                continue;
            }
            string2 = this.factorySettings.properties.getProperty(string);
            if (string2 == null) continue;
            stringBuilder.append(" property ").append(string).append("=").append(string2).append(" set from factory settings\n");
            properties.setProperty(string, string2);
        }
        this.REPORT = stringBuilder.toString();
    }

    void readAllSettings(String string) throws IOException {
        URL uRL = this.getClass().getClassLoader().getResource(string);
        if (uRL == null) {
            throw new IOException(string + " not found in classpath");
        }
        this.factorySettings.properties = this.createPropertiesFrom(uRL.openStream());
        this.factorySettings.location = uRL.toExternalForm();
        File file = new File(System.getProperty("user.dir") + File.separator + string);
        if (file.canRead()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            this.userSettings.properties = this.createPropertiesFrom(fileInputStream);
            this.userSettings.location = file.getAbsolutePath();
            fileInputStream.close();
            return;
        }
        file = new File(this.almaOTFolder.getAbsolutePath() + File.separator + string);
        if (file.canRead()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            this.userSettings.properties = this.createPropertiesFrom(fileInputStream);
            this.userSettings.location = file.getAbsolutePath();
            fileInputStream.close();
            return;
        }
        this.userSettings.properties = new Properties();
        this.userSettings.location = null;
    }

    Properties createPropertiesFrom(InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        properties.load(inputStream);
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            int n;
            int n2;
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            while ((n2 = string2.indexOf("${")) > -1 && (n = string2.indexOf("}", n2)) > -1) {
                String string3 = string2.substring(0, n2);
                String string4 = string2.substring(n2 + 2, n);
                String string5 = string2.substring(n + 1);
                string2 = string3 + System.getProperty(string4, "") + string5;
            }
            properties.setProperty(string, string2);
        }
        return properties;
    }

    protected class Settings {
        protected Properties properties = new Properties();
        protected String location;

        protected Settings() {
        }
    }
}

