/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.util;

import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;

public class TextUtils {
    public static final String ISO_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    private static final String SPACES = "                               ";
    private static final String ZEROES = "0000000000000000000000000000000";
    public static final char QUOTE = '\'';

    public static String padded(String string, int n, long l) {
        String string2 = new Long(l).toString();
        if (n <= string2.length()) {
            return string2;
        }
        return string.substring(0, n - string2.length()) + string2;
    }

    public static String padLeft(String string, int n, char c) {
        int n2 = string.length();
        if (n2 >= n) {
            return string;
        }
        if (n < n2) {
            throw new ArrayIndexOutOfBoundsException("Error number of characters to to small");
        }
        int n3 = n - string.length();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n3; ++i) {
            stringBuffer.append("" + c);
        }
        return stringBuffer.toString() + string;
    }

    public static String padded(String string, int n, String string2) {
        if (n <= string2.length()) {
            return string2;
        }
        return string.substring(0, n - string2.length()) + string2;
    }

    public static String rightpadded(String string, int n, String string2) {
        if (n <= string2.length()) {
            return string2;
        }
        return string2 + string.substring(0, n - string2.length());
    }

    public static String quoteSqlString(String string) {
        if (string == null) {
            return string;
        }
        if (string.indexOf(39) == -1) {
            return string;
        }
        String string2 = "";
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\'') {
                string2 = string2 + c;
            }
            string2 = string2 + c;
        }
        return string2;
    }

    public static String getEmptySqlStringIfNull(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    public static String spacePadded(int n, long l) {
        return TextUtils.padded(SPACES, n, l);
    }

    public static String zeroPadded(int n, long l) {
        return TextUtils.padded(ZEROES, n, l);
    }

    public static String zeroPadded(int n, String string) {
        return TextUtils.padded(ZEROES, n, string);
    }

    public static String padString(String string, int n) {
        if (string.length() >= n) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n2 = n - string.length();
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public static String escapedString(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        block4: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    stringBuffer.append("\\");
                    stringBuffer.append("" + c);
                    continue block4;
                }
                case '\n': 
                case '\r': {
                    stringBuffer.append("\\n");
                    continue block4;
                }
                default: {
                    stringBuffer.append("" + c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String revertEscapedString(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                if (++i < n) {
                    c = string.charAt(i);
                }
                switch (c) {
                    case 'n': {
                        stringBuffer.append("\n");
                        break;
                    }
                    case 'r': {
                        stringBuffer.append("\r");
                        break;
                    }
                    default: {
                        stringBuffer.append("" + c);
                        break;
                    }
                }
                continue;
            }
            stringBuffer.append("" + c);
        }
        return stringBuffer.toString();
    }

    public static String pkgToPath(Class<?> clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return "";
        }
        string = string.substring(0, n);
        while ((n = string.indexOf(46)) > 0) {
            string = string.substring(0, n) + File.separator + string.substring(n + 1);
        }
        return string + File.separator;
    }

    public static String convertFileToString(File file) {
        char[] cArray = new char[64000];
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while (bufferedReader.ready() && (n = bufferedReader.read(cArray, 0, cArray.length)) > 0) {
                stringBuffer.append(cArray, 0, n);
            }
            bufferedReader.close();
        }
        catch (Throwable throwable) {
            stringBuffer.append("Failed to read file contents.");
        }
        return stringBuffer.toString();
    }

    public static String[] stringToArray(String string, String string2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 1;
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (string2.indexOf(stringBuffer.charAt(i)) == -1) continue;
            ++n;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        if (stringBuffer.toString().indexOf(string2) != -1) {
            while (stringBuffer.length() > 0) {
                if (stringBuffer.toString().indexOf(string2) == -1) continue;
                int n3 = stringBuffer.toString().indexOf(string2);
                if (n3 != stringBuffer.toString().lastIndexOf(string2)) {
                    stringArray[n2] = stringBuffer.toString().substring(0, n3);
                    ++n2;
                    stringBuffer.delete(0, n3 + 1);
                    continue;
                }
                if (stringBuffer.toString().lastIndexOf(string2) != n3) continue;
                stringArray[n2] = stringBuffer.toString().substring(0, stringBuffer.toString().indexOf(string2));
                stringBuffer.delete(0, stringBuffer.toString().indexOf(string2) + 1);
                stringArray[++n2] = stringBuffer.toString();
                ++n2;
                stringBuffer.delete(0, stringBuffer.length());
            }
        } else {
            stringArray[0] = stringBuffer.toString();
        }
        stringBuffer = null;
        if (bl) {
            stringArray = TextUtils.trimStringArray(stringArray);
        }
        return stringArray;
    }

    private static String[] trimStringArray(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].trim();
        }
        if (stringArray.length == 1 && stringArray[0].length() == 0) {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    public static String arrayToString(String[] stringArray, String string, boolean bl) {
        int n;
        String string2 = "";
        if (stringArray == null) {
            n = 0;
        } else {
            if (bl) {
                TextUtils.trimStringArray(stringArray);
            }
            n = stringArray.length;
        }
        if (n > 0) {
            string2 = stringArray[0];
            for (int i = 1; i < n; ++i) {
                string2 = string2 + string + stringArray[i];
            }
        }
        return string2;
    }

    public static String[] splitString(String string, int n) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < string.length(); i += n) {
            String string2 = i + n > string.length() ? string.substring(i) : string.substring(i, i + n);
            vector.addElement(string2);
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static String[] sort(String[] stringArray) {
        int n;
        Vector<String> vector = new Vector<String>();
        for (n = 0; n < stringArray.length; ++n) {
            int n2;
            String string = stringArray[n];
            for (n2 = 0; n2 < n && string.compareTo((String)vector.elementAt(n2)) > 0; ++n2) {
            }
            if (n2 == n) {
                vector.addElement(string);
                continue;
            }
            vector.insertElementAt(string, n2);
        }
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = (String)vector.elementAt(n);
        }
        return stringArray;
    }

    public static Sortable[] sort(Sortable[] sortableArray) {
        int n;
        Vector<Sortable> vector = new Vector<Sortable>();
        for (n = 0; n < sortableArray.length; ++n) {
            int n2;
            String string = sortableArray[n].getSortKey();
            for (n2 = 0; n2 < n && string.compareTo(((Sortable)vector.elementAt(n2)).getSortKey()) > 0; ++n2) {
            }
            if (n2 == n) {
                vector.addElement(sortableArray[n]);
                continue;
            }
            vector.insertElementAt(sortableArray[n], n2);
        }
        for (n = 0; n < sortableArray.length; ++n) {
            sortableArray[n] = (Sortable)vector.elementAt(n);
        }
        return sortableArray;
    }

    public static SortableNumber[] sort(SortableNumber[] sortableNumberArray) {
        int n;
        Vector<SortableNumber> vector = new Vector<SortableNumber>();
        for (n = 0; n < sortableNumberArray.length; ++n) {
            int n2;
            double d = sortableNumberArray[n].getSortKey();
            for (n2 = 0; n2 < n && !(d <= ((SortableNumber)vector.elementAt(n2)).getSortKey()); ++n2) {
            }
            if (n2 == n) {
                vector.addElement(sortableNumberArray[n]);
                continue;
            }
            vector.insertElementAt(sortableNumberArray[n], n2);
        }
        for (n = 0; n < sortableNumberArray.length; ++n) {
            sortableNumberArray[n] = (SortableNumber)vector.elementAt(n);
        }
        return sortableNumberArray;
    }

    public static int isASCIIPrintable(String string, int n) {
        int n2 = Math.min(string.length(), n);
        for (int i = 0; i < n2; ++i) {
            if (TextUtils.isASCIIPrintable(string.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public static int isASCIIPrintable(String string) {
        return TextUtils.isASCIIPrintable(string, string.length());
    }

    public static boolean isASCIIPrintable(char c) {
        char c2 = c;
        if (c2 >= ' ' && c2 < '\u007f') {
            return true;
        }
        return c2 == '\t' || c2 == '\n' || c2 == '\f' || c2 == '\r';
    }

    public static String breakString(String string, int n) {
        if (string == null) {
            return string;
        }
        int n2 = string.length();
        if (n2 <= n) {
            return string;
        }
        int n3 = string.lastIndexOf(" ", n - 1);
        if (n3 == -1 && (n3 = string.indexOf(32)) == -1) {
            return string;
        }
        return string.substring(0, n3) + '\n' + TextUtils.breakString(string.substring(n3 + 1, n2), n);
    }

    public static String range(double d, double d2, boolean bl, boolean bl2) {
        String string = TextUtils.shortformat(d);
        String string2 = TextUtils.shortformat(d2);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(bl ? "[" : "(").append(string).append(",").append(string2).append(bl2 ? "]" : ")");
        return stringBuffer.toString();
    }

    private static String shortformat(double d) {
        String string = Double.toString(d);
        if (string.endsWith(".0")) {
            string = string.substring(0, string.length() - 2);
        }
        return string;
    }

    public static String format(double d, int n, int n2) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return "" + d;
        }
        if (n2 < 0 || n < 0) {
            throw new IllegalArgumentException("Negative number of digits");
        }
        String string = String.format("%%%d.%df", n + n2 + 1, n2);
        String string2 = String.format(string, d);
        return string2;
    }

    private static String spaces(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        while (n-- > 0) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public static String oldformat(double d, int n, int n2) {
        int n3;
        String string;
        String string2;
        if (n2 < 0 || n < 0) {
            throw new IllegalArgumentException("Negative number of digits");
        }
        String string3 = Double.toString(d);
        int n4 = string3.indexOf(".");
        if (n4 < 0) {
            string2 = string3;
            string = "";
        } else {
            string2 = string3.substring(0, n4);
            string = string3.substring(n4 + 1, string3.length());
        }
        int n5 = n2 - string.length();
        if (n2 == 0) {
            string = "";
        } else if (n5 < 0) {
            string = string.substring(0, n2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n6 = n - string2.length();
        if (n6 > 0) {
            for (n3 = 0; n3 < n6; ++n3) {
                stringBuffer.append(" ");
            }
        }
        stringBuffer.append(string2).append(".").append(string);
        if (n2 > 0 && n5 > 0) {
            for (n3 = 0; n3 < n5; ++n3) {
                stringBuffer.append("0");
            }
        }
        return stringBuffer.toString();
    }

    public static String format(ValueUnitPair<?> valueUnitPair, int n, int n2) {
        if (valueUnitPair == null) {
            return null;
        }
        if (n2 < 0 || n < 0) {
            throw new IllegalArgumentException("Negative number of digits");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(TextUtils.format(valueUnitPair.getContent(), n, n2));
        stringBuffer.append(' ');
        stringBuffer.append(valueUnitPair.getUnit());
        return stringBuffer.toString();
    }

    public static String format(ValueUnitPair<?> valueUnitPair, int n) {
        return TextUtils.format(valueUnitPair, 3, n);
    }

    public static String format(ValueUnitPair<?> valueUnitPair) {
        return TextUtils.format(valueUnitPair, 6);
    }

    public static boolean startsWithIgnoreCase(String string, String string2) {
        if (string == null || string2 == null || string.length() < string2.length()) {
            return false;
        }
        return string.substring(0, string2.length()).equalsIgnoreCase(string2);
    }

    public static String stripPrefix(String string, String string2) {
        String string3 = string.startsWith(string2) ? string.substring(string2.length()) : string;
        return string3;
    }

    public static String stripSuffix(String string, String string2) {
        String string3 = string.endsWith(string2) ? string.substring(0, string.length() - string2.length()) : string;
        return string3;
    }

    public static String getChoice(String string, String[] stringArray, boolean bl) {
        if (string == null) {
            return null;
        }
        String string2 = bl ? string : string.toLowerCase();
        for (String string3 : stringArray) {
            String string4;
            String string5 = string4 = bl ? string3 : string3.toLowerCase();
            if (!string2.equals(string4)) continue;
            return string3;
        }
        return null;
    }

    public static String stripHtmlTags(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        block4: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    bl = true;
                    continue block4;
                }
                case '>': {
                    bl = false;
                    continue block4;
                }
                default: {
                    if (bl) continue block4;
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String[] removeFromArray(String[] stringArray, String string) {
        return TextUtils.removeFromArray(stringArray, new String[]{string});
    }

    public static String[] removeFromArray(String[] stringArray, String[] stringArray2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(stringArray));
        for (String string : stringArray2) {
            arrayList.remove(string);
        }
        String[] stringArray3 = new String[arrayList.size()];
        return arrayList.toArray(stringArray3);
    }

    public static String[] enumsToStringArray(Enum[] enumArray) {
        String[] stringArray = new String[enumArray == null ? 0 : enumArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = enumArray[i].toString();
        }
        return stringArray;
    }

    public static String stripClasspaths(String string) {
        if (string == null) {
            return "";
        }
        return string.replaceAll("([\\$\\w\\.]+:[ ])+", "");
    }

    public static String stripNonAsciiChars(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (char c : string.toCharArray()) {
            if (c >= '\u007f' && (c <= '\u00a0' || c > '\u00ff')) continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static interface SortableNumber {
        public double getSortKey();
    }

    public static interface Sortable {
        public String getSortKey();
    }
}

