/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipSupport {

    public static class ZipNtry
    extends ZipEntry {
        byte[] data;

        public ZipNtry(ZipEntry zipEntry, byte[] byArray) {
            super(zipEntry);
            this.data = byArray;
        }

        public byte[] getData() {
            return this.data;
        }
    }

    public static class ZipWriter {
        private ZipOutputStream zout;

        public ZipWriter(OutputStream outputStream) {
            this.zout = new ZipOutputStream(outputStream);
        }

        public void putZipEntry(String string, byte[] byArray) throws IOException {
            ZipEntry zipEntry = new ZipEntry(string);
            zipEntry.setSize(byArray.length);
            this.zout.putNextEntry(zipEntry);
            this.zout.write(byArray, 0, byArray.length);
        }

        public void close() throws IOException {
            this.zout.close();
        }
    }

    public static class ZipReader {
        private ZipInputStream zin;
        private ByteArrayOutputStream buffer;
        private byte[] minibuf;

        public ZipReader(InputStream inputStream) {
            this.zin = new ZipInputStream(inputStream);
            this.buffer = new Buffer(262144);
            this.minibuf = new byte[10240];
        }

        public void close() throws IOException {
            this.zin.close();
            this.buffer.close();
            this.minibuf = null;
        }

        public ZipNtry getZipEntry() throws IOException {
            int n;
            this.buffer.reset();
            ZipEntry zipEntry = this.zin.getNextEntry();
            if (zipEntry == null) {
                return null;
            }
            while ((n = this.zin.read(this.minibuf)) >= 0) {
                this.buffer.write(this.minibuf, 0, n);
            }
            byte[] byArray = this.buffer.toByteArray();
            zipEntry.setSize(byArray.length);
            ZipNtry zipNtry = new ZipNtry(zipEntry, byArray);
            return zipNtry;
        }

        class Buffer
        extends ByteArrayOutputStream {
            Buffer(int n) {
                super(n);
            }

            @Override
            public void close() throws IOException {
                this.buf = null;
            }
        }
    }
}

