/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.util.astro;

import alma.observatorycharacteristics.site.SiteCharacteristics;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.util.Convert;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.SkyCoordinates;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jsky.coords.SiteDesc;
import jsky.coords.WorldCoords;
import jsky.util.SkyCalc;

public class AzElCalculator
implements ChangeListener {
    public static final TimeZone UT = TimeZone.getTimeZone("UT");
    private SkyCalc skyCalc;

    public AzElCalculator() {
        SiteCharacteristics siteCharacteristics = SiteCharacteristics.getInstance();
        this.newSkyCalc(siteCharacteristics);
        SiteCharacteristics.addChangeListener(this);
    }

    public AzElCalculator(SiteCharacteristics siteCharacteristics) {
        this.newSkyCalc(siteCharacteristics);
    }

    public AzElCalculator(SiteDesc siteDesc) {
        this.skyCalc = new SkyCalc(siteDesc);
    }

    private void newSkyCalc(SiteCharacteristics siteCharacteristics) {
        Latitude latitude = siteCharacteristics.getObsLatitude();
        Longitude longitude = siteCharacteristics.getObsLongitude();
        String string = siteCharacteristics.getObsName();
        double d = siteCharacteristics.getObsLongitude().getContentInUnits(Longitude.UNIT_DEG);
        double d2 = siteCharacteristics.getObsLatitude().getContentInUnits(Latitude.UNIT_DEG);
        SiteDesc siteDesc = new SiteDesc(string, d, d2, UT);
        this.skyCalc = new SkyCalc(siteDesc);
    }

    public Date getLst(Date date) {
        return this.skyCalc.getLst(date);
    }

    public Date getDate(Date date) {
        long l;
        Date date2 = date;
        int n = 0;
        do {
            l = this.skyCalc.getLst(date2).getTime() - date.getTime();
            long l2 = date2.getTime() - l;
            Date date3 = new Date();
            date3.setTime(l2);
            date2 = date3;
        } while (Math.abs(l) > 10L && ++n < 10);
        return date2;
    }

    public SkyCoordinates getAzEl(double d, double d2, Date date) {
        WorldCoords worldCoords = new WorldCoords(d, d2);
        this.skyCalc.calculate(worldCoords, date);
        SkyCoordinates skyCoordinates = SkyCoordinates.createSkyCoordinates();
        skyCoordinates.getLongitude().setContent(this.skyCalc.getAzimuth());
        skyCoordinates.getLongitude().setUnit(Longitude.UNIT_DEG);
        skyCoordinates.getLatitude().setContent(this.skyCalc.getAltitude());
        skyCoordinates.getLatitude().setUnit(Latitude.UNIT_DEG);
        return skyCoordinates;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == SiteCharacteristics.class) {
            SiteCharacteristics siteCharacteristics = SiteCharacteristics.getInstance();
            this.newSkyCalc(siteCharacteristics);
        }
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("UT"));
        calendar.set(2007, 1, 6, 15, 1, 31);
        System.out.println("15:01:31 GMT ? " + calendar.getTime());
        System.setProperty("Telescope", "ALMA");
        SiteCharacteristics siteCharacteristics = SiteCharacteristics.getInstance();
        AzElCalculator azElCalculator = new AzElCalculator();
        System.out.println("19:35:58 LST ? " + azElCalculator.getLst(calendar.getTime()));
        Date date = calendar.getTime();
        WorldCoords worldCoords = new WorldCoords(261.892575, -19.79763);
        double d = worldCoords.getRaDeg();
        double d2 = worldCoords.getDecDeg();
        Date date2 = azElCalculator.getLst(date);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SkyCoordinates skyCoordinates = azElCalculator.getAzEl(d, d2, date);
        System.out.println("ut  = " + simpleDateFormat.format(date));
        System.out.println("lst = " + simpleDateFormat.format(date2));
        double d3 = siteCharacteristics.getObsLatitude().getContentInDefaultUnits();
        double d4 = siteCharacteristics.getObsLongitude().getContentInDefaultUnits();
        double d5 = skyCoordinates.getLongitude().getContentInUnits(Longitude.UNIT_DEG);
        double d6 = skyCoordinates.getLatitude().getContentInUnits(Latitude.UNIT_DEG);
        try {
            System.out.println("lat = " + d3 + "[" + Convert.degToDDMMSS(d3) + "]");
            System.out.println("lon = " + d4 + "[" + Convert.degToDDMMSS(d4) + "]");
            System.out.println("ra  = " + d + "[" + worldCoords.getRA() + "]");
            System.out.println("dec = " + d2 + "[" + worldCoords.getDec() + "]");
            System.out.println("az  = " + d5 + "[" + Convert.degToHHMMSS(d5) + "]");
            System.out.println("el  = " + d6 + "[" + Convert.degToDDMMSS(d6) + "]");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

