/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.util.astro;

import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.valuetypes.Angle;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.SkyCoordinates;

public class PointingCoordsConverter {
    private SkyCoordinates origin;
    final double TWOPI = Math.PI * 2;
    private static PointingCoordsConverter pointingCoordsConverter = null;

    public PointingCoordsConverter(SkyCoordinates skyCoordinates) {
        this.setOrigin(skyCoordinates);
    }

    public PointingCoordsConverter() {
        this(null);
    }

    public SkyCoordinates getSourceCoordinates() {
        return this.origin;
    }

    public void setOrigin(SkyCoordinates skyCoordinates) {
        this.origin = skyCoordinates == null || skyCoordinates.getType().equals(SkyCoordinates.TYPE_RELATIVE) ? SkyCoordinates.createSkyCoordinates() : skyCoordinates;
    }

    public void convert(SkyCoordinates skyCoordinates, boolean bl) {
        if (skyCoordinates.isOffsetCoordinates() && !bl) {
            this.toAbsolute(skyCoordinates);
        } else if (!skyCoordinates.isOffsetCoordinates() && bl) {
            this.toOffset(skyCoordinates);
        }
    }

    public void toOffset(SkyCoordinates skyCoordinates) {
        if (!skyCoordinates.isOffsetCoordinates()) {
            SkyCoordinates skyCoordinates2 = this.absoluteToOffset(skyCoordinates);
            skyCoordinates.setType(SkyCoordinates.TYPE_RELATIVE);
            skyCoordinates.getLatitude().setContentAndUnit((ValueUnitPair)skyCoordinates2.getLatitude());
            skyCoordinates.getLongitude().setContentAndUnit((ValueUnitPair)skyCoordinates2.getLongitude());
        }
    }

    public void toAbsolute(SkyCoordinates skyCoordinates) {
        if (skyCoordinates.isOffsetCoordinates()) {
            SkyCoordinates skyCoordinates2 = this.offsetToAbsolute(skyCoordinates);
            skyCoordinates.setType(SkyCoordinates.TYPE_ABSOLUTE);
            skyCoordinates.getLatitude().setContentAndUnit((ValueUnitPair)skyCoordinates2.getLatitude());
            skyCoordinates.getLongitude().setContentAndUnit((ValueUnitPair)skyCoordinates2.getLongitude());
        }
    }

    public SkyCoordinates absoluteToOffsetGnomonic(SkyCoordinates skyCoordinates) {
        SkyCoordinates skyCoordinates2 = SkyCoordinates.createOffsetCoordinates();
        this.absoluteToOffsetGnomonic(skyCoordinates, skyCoordinates2);
        return skyCoordinates2;
    }

    public SkyCoordinates absoluteToOffset(SkyCoordinates skyCoordinates) {
        SkyCoordinates skyCoordinates2 = SkyCoordinates.createOffsetCoordinates();
        this.absoluteToOffset(skyCoordinates, skyCoordinates2);
        return skyCoordinates2;
    }

    public SkyCoordinates absoluteToOffsetEuler(SkyCoordinates skyCoordinates) {
        SkyCoordinates skyCoordinates2 = SkyCoordinates.createOffsetCoordinates();
        this.absoluteToOffsetEuler(skyCoordinates, skyCoordinates2);
        return skyCoordinates2;
    }

    public SkyCoordinates absoluteToOffsetSpherical(SkyCoordinates skyCoordinates) {
        SkyCoordinates skyCoordinates2 = SkyCoordinates.createOffsetCoordinates();
        this.absoluteToOffsetSpherical(skyCoordinates, skyCoordinates2);
        return skyCoordinates2;
    }

    public void absoluteToOffset(SkyCoordinates skyCoordinates, SkyCoordinates skyCoordinates2) {
        this.absoluteToOffsetEuler(skyCoordinates, skyCoordinates2);
    }

    public void absoluteToOffsetEuler(SkyCoordinates skyCoordinates, SkyCoordinates skyCoordinates2) {
        SkyCoordinates skyCoordinates3 = skyCoordinates.deepCopy();
        skyCoordinates3.convertToSystem(this.origin.getSystem());
        skyCoordinates2.setSystem(this.origin.getSystem());
        String string = skyCoordinates2.getLatitude().getUnit();
        String string2 = skyCoordinates2.getLongitude().getUnit();
        double d = Math.toRadians(this.origin.getLatitude().getContentInUnits(Angle.UNIT_DEG));
        double d2 = Math.toRadians(this.origin.getLongitude().getContentInUnits(Angle.UNIT_DEG));
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = Math.toRadians(skyCoordinates3.getLatitude().getContentInUnits(Angle.UNIT_DEG));
        double d6 = Math.toRadians(skyCoordinates3.getLongitude().getContentInUnits(Angle.UNIT_DEG));
        double[] dArray = new double[3];
        PointingCoordsConverter.dcs2c(d6, d5, dArray);
        double[][] dArray2 = new double[3][3];
        PointingCoordsConverter.euler("zy", d2, -d, 0.0, dArray2);
        double[] dArray3 = new double[3];
        PointingCoordsConverter.dmxv(dArray2, dArray, dArray3);
        double[] dArray4 = new double[2];
        PointingCoordsConverter.dcc2s(dArray3, dArray4);
        d4 = Math.toDegrees(dArray4[0]);
        d3 = Math.toDegrees(dArray4[1]);
        Latitude latitude = Latitude.createLatitude();
        latitude.setContent(d3);
        latitude.setUnit(Angle.UNIT_DEG);
        skyCoordinates2.getLatitude().setContent(latitude.getContentInUnits(string));
        Longitude longitude = Longitude.createLongitude();
        longitude.setContent(d4);
        longitude.setUnit(Angle.UNIT_DEG);
        skyCoordinates2.getLongitude().setContent(longitude.getContentInUnits(string2));
    }

    public void absoluteToOffsetSpherical(SkyCoordinates skyCoordinates, SkyCoordinates skyCoordinates2) {
        SkyCoordinates skyCoordinates3 = skyCoordinates.deepCopy();
        skyCoordinates3.convertToSystem(this.origin.getSystem());
        skyCoordinates2.setSystem(this.origin.getSystem());
        String string = skyCoordinates2.getLatitude().getUnit();
        String string2 = skyCoordinates2.getLongitude().getUnit();
        double d = Math.toRadians(this.origin.getLatitude().getContentInUnits(Angle.UNIT_DEG));
        double d2 = Math.cos(d);
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = Math.toRadians(skyCoordinates3.getLatitude().getContentInUnits(Angle.UNIT_DEG));
        double d6 = Math.toRadians(skyCoordinates3.getLongitude().getContentInUnits(Angle.UNIT_DEG) - this.origin.getLongitude().getContentInUnits(Angle.UNIT_DEG));
        double d7 = d5 - d;
        double d8 = d6 * d2;
        d3 = Math.toDegrees(d7);
        d4 = Math.toDegrees(d8);
        Latitude latitude = Latitude.createLatitude();
        latitude.setContent(d3);
        latitude.setUnit(Angle.UNIT_DEG);
        skyCoordinates2.getLatitude().setContent(latitude.getContentInUnits(string));
        Longitude longitude = Longitude.createLongitude();
        longitude.setContent(d4);
        longitude.setUnit(Angle.UNIT_DEG);
        skyCoordinates2.getLongitude().setContent(longitude.getContentInUnits(string2));
    }

    public void absoluteToOffsetGnomonic(SkyCoordinates skyCoordinates, SkyCoordinates skyCoordinates2) {
        SkyCoordinates skyCoordinates3 = skyCoordinates.deepCopy();
        skyCoordinates3.convertToSystem(this.origin.getSystem());
        skyCoordinates2.setSystem(this.origin.getSystem());
        String string = skyCoordinates2.getLatitude().getUnit();
        String string2 = skyCoordinates2.getLongitude().getUnit();
        double d = Math.toRadians(this.origin.getLatitude().getContentInUnits(Angle.UNIT_DEG));
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = Math.toRadians(skyCoordinates3.getLatitude().getContentInUnits(Angle.UNIT_DEG));
        double d7 = Math.sin(d6);
        double d8 = Math.cos(d6);
        double d9 = Math.toRadians(skyCoordinates3.getLongitude().getContentInUnits(Angle.UNIT_DEG) - this.origin.getLongitude().getContentInUnits(Angle.UNIT_DEG));
        double d10 = Math.sin(d9);
        double d11 = Math.cos(d9);
        double d12 = d3 * d11 * d8 + d2 * d7;
        double d13 = d10 * d8;
        double d14 = -d2 * d11 * d8 + d3 * d7;
        double d15 = Math.asin(d14);
        double d16 = Math.atan2(d13 / Math.cos(d15), d12 / Math.cos(d15));
        d4 = Math.toDegrees(d15);
        d5 = Math.toDegrees(d16);
        Latitude latitude = Latitude.createLatitude();
        latitude.setContent(d4);
        latitude.setUnit(Angle.UNIT_DEG);
        skyCoordinates2.getLatitude().setContent(latitude.getContentInUnits(string));
        Longitude longitude = Longitude.createLongitude();
        longitude.setContent(d5);
        longitude.setUnit(Angle.UNIT_DEG);
        skyCoordinates2.getLongitude().setContent(longitude.getContentInUnits(string2));
    }

    public SkyCoordinates offsetToAbsoluteGnomonic(SkyCoordinates skyCoordinates) {
        SkyCoordinates skyCoordinates2 = SkyCoordinates.createAbsoluteCoordinates();
        this.offsetToAbsoluteGnomonic(skyCoordinates, skyCoordinates2);
        return skyCoordinates2;
    }

    public SkyCoordinates offsetToAbsolute(SkyCoordinates skyCoordinates) {
        SkyCoordinates skyCoordinates2 = SkyCoordinates.createAbsoluteCoordinates();
        this.offsetToAbsolute(skyCoordinates, skyCoordinates2);
        return skyCoordinates2;
    }

    public SkyCoordinates offsetToAbsoluteSpherical(SkyCoordinates skyCoordinates) {
        SkyCoordinates skyCoordinates2 = SkyCoordinates.createAbsoluteCoordinates();
        this.offsetToAbsoluteSpherical(skyCoordinates, skyCoordinates2);
        return skyCoordinates2;
    }

    public SkyCoordinates offsetToAbsoluteEuler(SkyCoordinates skyCoordinates) {
        SkyCoordinates skyCoordinates2 = SkyCoordinates.createAbsoluteCoordinates();
        this.offsetToAbsoluteEuler(skyCoordinates, skyCoordinates2);
        return skyCoordinates2;
    }

    public void offsetToAbsoluteGnomonic(SkyCoordinates skyCoordinates, SkyCoordinates skyCoordinates2) {
        this.matchSystemToOrigin(skyCoordinates);
        skyCoordinates2.setSystem(this.origin.getSystem());
        String string = skyCoordinates2.getLatitude().getUnit();
        String string2 = skyCoordinates2.getLongitude().getUnit();
        double d = Math.toRadians(this.origin.getLatitude().getContentInUnits(Angle.UNIT_DEG));
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        double d4 = Math.toRadians(skyCoordinates.getLatitude().getContentInUnits(Angle.UNIT_DEG));
        double d5 = Math.sin(d4);
        double d6 = Math.cos(d4);
        double d7 = Math.toRadians(skyCoordinates.getLongitude().getContentInUnits(Angle.UNIT_DEG));
        double d8 = Math.sin(d7);
        double d9 = Math.cos(d7);
        double d10 = d3 * d9 * d6 - d2 * d5;
        double d11 = d8 * d6;
        double d12 = d2 * d9 * d6 + d3 * d5;
        double d13 = Math.asin(d12);
        double d14 = Math.atan2(d11 / Math.cos(d13), d10 / Math.cos(d13));
        double d15 = Math.toDegrees(d13);
        double d16 = Math.toDegrees(d14);
        Latitude latitude = Latitude.createLatitude();
        latitude.setContentInDeg(d15);
        skyCoordinates2.getLatitude().setContent(latitude.getContentInUnits(string));
        Longitude longitude = Longitude.createLongitude();
        longitude.setContentInDeg(this.origin.getLongitude().getContentInUnits(Angle.UNIT_DEG) + d16);
        skyCoordinates2.getLongitude().setContent(longitude.getContentInUnits(string2));
    }

    public void offsetToAbsolute(SkyCoordinates skyCoordinates, SkyCoordinates skyCoordinates2) {
        this.offsetToAbsoluteEuler(skyCoordinates, skyCoordinates2);
    }

    public void offsetToAbsoluteSpherical(SkyCoordinates skyCoordinates, SkyCoordinates skyCoordinates2) {
        this.matchSystemToOrigin(skyCoordinates);
        skyCoordinates2.setSystem(this.origin.getSystem());
        String string = skyCoordinates2.getLatitude().getUnit();
        String string2 = skyCoordinates2.getLongitude().getUnit();
        double d = Math.toRadians(this.origin.getLatitude().getContentInUnits(Angle.UNIT_DEG));
        double d2 = Math.cos(d);
        double d3 = Math.toRadians(this.origin.getLongitude().getContentInUnits(Angle.UNIT_DEG));
        double d4 = Math.toRadians(skyCoordinates.getLatitude().getContentInUnits(Angle.UNIT_DEG));
        double d5 = Math.toRadians(skyCoordinates.getLongitude().getContentInUnits(Angle.UNIT_DEG));
        double d6 = d + d4;
        double d7 = d3 + d5 / d2;
        double d8 = Math.toDegrees(d6);
        double d9 = Math.toDegrees(d7);
        Latitude latitude = Latitude.createLatitude();
        latitude.setContentInDeg(d8);
        skyCoordinates2.getLatitude().setContent(latitude.getContentInUnits(string));
        Longitude longitude = Longitude.createLongitude();
        longitude.setContentInDeg(d9);
        skyCoordinates2.getLongitude().setContent(longitude.getContentInUnits(string2));
    }

    public void offsetToAbsoluteEuler(SkyCoordinates skyCoordinates, SkyCoordinates skyCoordinates2) {
        this.matchSystemToOrigin(skyCoordinates);
        skyCoordinates2.setSystem(this.origin.getSystem());
        String string = skyCoordinates2.getLatitude().getUnit();
        String string2 = skyCoordinates2.getLongitude().getUnit();
        double d = Math.toRadians(this.origin.getLatitude().getContentInUnits(Angle.UNIT_DEG));
        double d2 = Math.toRadians(this.origin.getLongitude().getContentInUnits(Angle.UNIT_DEG));
        double d3 = Math.toRadians(skyCoordinates.getLatitude().getContentInUnits(Angle.UNIT_DEG));
        double d4 = Math.toRadians(skyCoordinates.getLongitude().getContentInUnits(Angle.UNIT_DEG));
        double[] dArray = new double[3];
        PointingCoordsConverter.dcs2c(d4, d3, dArray);
        double[][] dArray2 = new double[3][3];
        PointingCoordsConverter.euler("yz", d, -d2, 0.0, dArray2);
        double[] dArray3 = new double[3];
        PointingCoordsConverter.dmxv(dArray2, dArray, dArray3);
        double[] dArray4 = new double[2];
        PointingCoordsConverter.dcc2s(dArray3, dArray4);
        dArray4[0] = dArray4[0] % (Math.PI * 2);
        if (dArray4[0] < 0.0) {
            dArray4[0] = dArray4[0] + Math.PI * 2;
        }
        double d5 = Math.toDegrees(dArray4[0]);
        double d6 = Math.toDegrees(dArray4[1]);
        Latitude latitude = Latitude.createLatitude();
        latitude.setContentInDeg(d6);
        skyCoordinates2.getLatitude().setContent(latitude.getContentInUnits(string));
        Longitude longitude = Longitude.createLongitude();
        longitude.setContentInDeg(d5);
        skyCoordinates2.getLongitude().setContent(longitude.getContentInUnits(string2));
    }

    public void matchSystemToOrigin(SkyCoordinates skyCoordinates) {
        if (!skyCoordinates.isOffsetCoordinates()) {
            return;
        }
        String string = this.origin.getSystem();
        String string2 = skyCoordinates.getSystem();
        if (string != null && string.equals(string2)) {
            return;
        }
        if (!skyCoordinates.isSystemConvertSupported(string)) {
            return;
        }
        SkyCoordinates skyCoordinates2 = this.origin.deepCopy();
        skyCoordinates2.convertToSystem(string2);
        SkyCoordinates skyCoordinates3 = PointingCoordsConverter.toAbsolute(skyCoordinates, skyCoordinates2);
        skyCoordinates3.convertToSystem(string);
        this.toOffset(skyCoordinates3);
        skyCoordinates.setSystem(string);
        skyCoordinates.getLongitude().setContentAndUnit((ValueUnitPair)skyCoordinates3.getLongitude());
        skyCoordinates.getLatitude().setContentAndUnit((ValueUnitPair)skyCoordinates3.getLatitude());
    }

    public static PointingCoordsConverter getPointingCoordsConverter() {
        if (pointingCoordsConverter == null) {
            pointingCoordsConverter = new PointingCoordsConverter();
        }
        return pointingCoordsConverter;
    }

    public static SkyCoordinates toOffset(SkyCoordinates skyCoordinates, SkyCoordinates skyCoordinates2) {
        PointingCoordsConverter pointingCoordsConverter = new PointingCoordsConverter();
        pointingCoordsConverter.setOrigin(skyCoordinates2);
        return pointingCoordsConverter.absoluteToOffset(skyCoordinates);
    }

    public static SkyCoordinates toAbsolute(SkyCoordinates skyCoordinates, SkyCoordinates skyCoordinates2) {
        PointingCoordsConverter pointingCoordsConverter = new PointingCoordsConverter();
        pointingCoordsConverter.setOrigin(skyCoordinates2);
        return pointingCoordsConverter.offsetToAbsolute(skyCoordinates);
    }

    private static void dmxv(double[][] dArray, double[] dArray2, double[] dArray3) {
        int n;
        double[] dArray4 = new double[]{0.0, 0.0, 0.0};
        for (n = 0; n < 3; ++n) {
            double d = 0.0;
            for (int i = 0; i < 3; ++i) {
                d += dArray[n][i] * dArray2[i];
            }
            dArray4[n] = d;
        }
        for (n = 0; n < 3; ++n) {
            dArray3[n] = dArray4[n];
        }
    }

    private static void dcc2s(double[] dArray, double[] dArray2) {
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        double d4 = Math.sqrt(d * d + d2 * d2);
        dArray2[0] = d4 == 0.0 ? 0.0 : Math.atan2(d2, d);
        dArray2[1] = d3 == 0.0 ? 0.0 : Math.atan2(d3, d4);
    }

    private static void dcs2c(double d, double d2, double[] dArray) {
        double d3 = Math.cos(d2);
        dArray[0] = Math.cos(d) * d3;
        dArray[1] = Math.sin(d) * d3;
        dArray[2] = Math.sin(d2);
    }

    private static void euler(String string, double d, double d2, double d3, double[][] dArray) {
        int n;
        int n2;
        double[][] dArrayArray = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};
        double[][] dArrayArray2 = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};
        int n3 = string.length();
        for (n2 = 0; n2 < n3; ++n2) {
            int n4;
            double[][] dArrayArray3 = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};
            double d4 = n2 == 0 ? d : (n2 == 1 ? d2 : d3);
            double d5 = Math.sin(d4);
            double d6 = Math.cos(d4);
            if (string.substring(n2, n2 + 1).equalsIgnoreCase("x")) {
                dArrayArray3[1][1] = d6;
                dArrayArray3[1][2] = d5;
                dArrayArray3[2][1] = -d5;
                dArrayArray3[2][2] = d6;
            } else if (string.substring(n2, n2 + 1).equalsIgnoreCase("y")) {
                dArrayArray3[0][0] = d6;
                dArrayArray3[0][2] = -d5;
                dArrayArray3[2][0] = d5;
                dArrayArray3[2][2] = d6;
            } else if (string.substring(n2, n2 + 1).equalsIgnoreCase("z")) {
                dArrayArray3[0][0] = d6;
                dArrayArray3[0][1] = d5;
                dArrayArray3[1][0] = -d5;
                dArrayArray3[1][1] = d6;
            } else {
                n3 = 0;
            }
            for (n = 0; n < 3; ++n) {
                for (n4 = 0; n4 < 3; ++n4) {
                    double d7 = 0.0;
                    for (int i = 0; i < 3; ++i) {
                        d7 += dArrayArray3[n][i] * dArrayArray[i][n4];
                    }
                    dArrayArray2[n][n4] = d7;
                }
            }
            for (n = 0; n < 3; ++n) {
                for (n4 = 0; n4 < 3; ++n4) {
                    dArrayArray[n4][n] = dArrayArray2[n4][n];
                }
            }
        }
        for (n2 = 0; n2 < 3; ++n2) {
            for (n = 0; n < 3; ++n) {
                dArray[n][n2] = dArrayArray[n][n2];
            }
        }
    }
}

