/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.util.astro;

import alma.hla.runtime.obsprep.util.Log;
import alma.valuetypes.Velocity;
import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public abstract class Resolver
implements Runnable {
    private boolean isQuerySuccessful = false;
    private boolean isQueryCompleted = false;
    public static double NODATA = Double.POSITIVE_INFINITY;
    public static double INVALID = Double.NEGATIVE_INFINITY;
    protected String name = null;
    protected double ra;
    protected double dec;
    protected double properMotionRa;
    protected double properMotionDec;
    protected Velocity sourceVelocity;
    protected double parallax;
    protected final List<Resolver> results = new ArrayList<Resolver>(10);
    protected String errorMessage = null;
    protected ResolverService resolverService = ResolverService.UNKNOWN;

    public abstract void query(String var1) throws IOException, MalformedURLException;

    public Resolver() {
        this.reset();
    }

    public void reset() {
        this.setQueryCompleted(false);
        this.setQuerySuccessful(false);
        this.ra = NODATA;
        this.dec = NODATA;
        this.properMotionRa = NODATA;
        this.properMotionDec = NODATA;
        this.sourceVelocity = null;
        this.parallax = NODATA;
        this.errorMessage = null;
    }

    public void fail() {
        this.ra = INVALID;
        this.dec = INVALID;
        this.isQueryCompleted = false;
        this.isQuerySuccessful = false;
    }

    public boolean isQuerySuccessful() {
        return this.isQuerySuccessful;
    }

    public boolean isQueryReturned() {
        return this.isQueryCompleted;
    }

    public void setNameServer(String string) {
    }

    public String getNameServer() {
        return null;
    }

    public List<Resolver> getResults() {
        return Collections.unmodifiableList(this.results);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "Unknown";
        if (this.sourceVelocity != null) {
            string = this.sourceVelocity.toString();
        }
        stringBuffer.append("Server = " + this.getNameServer() + " : ").append("name = " + this.name + ", ").append("ra = " + this.doubleToString(this.ra) + ", ").append("dec = " + this.doubleToString(this.dec) + ", ").append("pmRA = " + this.doubleToString(this.properMotionRa) + ", ").append("pmDec = " + this.doubleToString(this.properMotionDec) + ", ").append("sourceVelocity = " + string + ", ").append("parallax = " + this.doubleToString(this.parallax)).append("resolver = " + this.resolverService.getResolutionServiceName());
        return stringBuffer.toString();
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    private String doubleToString(double d) {
        if (d == NODATA || d == INVALID) {
            return "(No Data)";
        }
        return new Double(d).toString();
    }

    public double getDec() {
        return this.dec;
    }

    public void setDec(double d) {
        this.dec = d;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public double getParallax() {
        return this.parallax;
    }

    public void setParallax(double d) {
        this.parallax = d;
    }

    public Double getProperMotionDec() {
        return this.properMotionDec;
    }

    public void setProperMotionDec(Double d) {
        this.properMotionDec = d;
    }

    public Double getProperMotionRa() {
        return this.properMotionRa;
    }

    public void setProperMotionRa(Double d) {
        this.properMotionRa = d;
    }

    public double getRa() {
        return this.ra;
    }

    public void setRa(double d) {
        this.ra = d;
    }

    public Velocity getSourceVelocity() {
        return this.sourceVelocity;
    }

    public void setSourceVelocity(Velocity velocity) {
        this.sourceVelocity = velocity;
    }

    @Override
    public void run() {
        try {
            this.query(this.getName());
        }
        catch (MalformedURLException malformedURLException) {
            this.setErrorMessage("MalformedURLException:" + malformedURLException.getMessage());
            this.fail();
            return;
        }
        catch (UnknownHostException unknownHostException) {
            this.setErrorMessage("Unknown Host: " + unknownHostException.getMessage() + ".\nIs the network online?");
            this.fail();
            return;
        }
        catch (ConnectException connectException) {
            this.setErrorMessage("Could not connect to the host: " + connectException.getMessage() + "\nIs the network online? Server trouble?");
            this.fail();
            return;
        }
        catch (IOException iOException) {
            this.setErrorMessage("IO Error : Network trouble?");
            this.fail();
            return;
        }
    }

    public final ResolverService getResolverService() {
        return this.resolverService;
    }

    public final void setResolverService(ResolverService resolverService) {
        this.resolverService = resolverService;
    }

    protected void failedResolutionHandler(String string, String string2) {
        this.setErrorMessage(string + " " + string2);
        Log.logger((Object)this).warning(string + " " + string2);
        this.reset();
        this.fail();
        this.results.clear();
    }

    public void setQuerySuccessful(boolean bl) {
        this.isQuerySuccessful = bl;
    }

    public boolean isQueryCompleted() {
        return this.isQueryCompleted;
    }

    public void setQueryCompleted(boolean bl) {
        this.isQueryCompleted = bl;
    }

    public static enum ResolverService {
        UNKNOWN("Unknown"),
        SIMBAD("SIMBAD"),
        NED("NED"),
        VIZIER("Vizier");

        private String nameResolutionService;

        private ResolverService(String string2) {
            if (string2 == null) {
                throw new NullPointerException("Illegal argument. The argument cannot be null: nameResolutionService");
            }
            this.nameResolutionService = string2;
        }

        public String getResolutionServiceName() {
            return this.nameResolutionService;
        }

        public static ResolverService findService(String string) {
            if (string == null) {
                throw new NullPointerException("Illegal argument. The argument cannot be null: serviceToFind");
            }
            for (ResolverService resolverService : ResolverService.values()) {
                if (!StringUtils.containsIgnoreCase((CharSequence)string, (CharSequence)resolverService.nameResolutionService)) continue;
                return resolverService;
            }
            return UNKNOWN;
        }
    }
}

