/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.util.astro;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.services.network.sesame.PmVector;
import alma.obsprep.ot.services.network.sesame.ResolverAdapter;
import alma.obsprep.ot.services.network.sesame.Sesame;
import alma.obsprep.ot.services.network.sesame.Target;
import alma.obsprep.ot.services.network.sesame.ws.SesameServiceLocator;
import alma.obsprep.ot.services.network.sesame.ws.SesameSoapBindingStub;
import alma.obsprep.util.astro.Resolver;
import alma.valuetypes.Speed;
import alma.valuetypes.Velocity;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import javax.xml.bind.JAXB;
import javax.xml.rpc.ServiceException;

public class SesameNameResolver
extends Resolver {
    private static final int CLIENT_RESPONSE_TIME_OUT = 10000;
    private String nameServer = "cdsws.u-strasbg.fr";

    @Override
    public void query(String string) throws IOException, MalformedURLException {
        if (string == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: objectName");
        }
        SesameServiceLocator sesameServiceLocator = new SesameServiceLocator();
        String string2 = null;
        Log.logger(SesameNameResolver.class).fine("Using sesame to resolve " + string);
        this.reset();
        this.setName(string);
        this.results.clear();
        try {
            alma.obsprep.ot.services.network.sesame.ws.Sesame sesame = sesameServiceLocator.getSesame();
            SesameSoapBindingStub sesameSoapBindingStub = (SesameSoapBindingStub)sesame;
            sesameSoapBindingStub.setTimeout(10000);
            string2 = sesame.sesame(string, "xI", true, "SN@");
        }
        catch (ServiceException serviceException) {
            this.setErrorMessage("Unable to contact the sesame name resolver: " + serviceException.getMessage());
            this.reset();
            throw new IOException(serviceException);
        }
        assert (string2 != null);
        try {
            this.processXMLQueryResponse(string2);
        }
        catch (UnableToProcessSesameResponseException unableToProcessSesameResponseException) {
            this.setErrorMessage("Unable to process XML response from sesame: " + unableToProcessSesameResponseException.getMessage());
            Log.logger(SesameNameResolver.class).warning("Unable to process XML response from sesame: " + unableToProcessSesameResponseException.getMessage());
            this.reset();
            this.fail();
            this.results.clear();
        }
        catch (UnableToResolveObjectException unableToResolveObjectException) {
            this.setErrorMessage("Sesame unable to resolve the object: " + string);
            Log.logger(SesameNameResolver.class).warning("Sesame unable to resolve the object: " + string);
            this.reset();
            this.fail();
            this.results.clear();
        }
    }

    private void processXMLQueryResponse(String string) throws UnableToProcessSesameResponseException, UnableToResolveObjectException {
        if (string == null) {
            throw new UnableToProcessSesameResponseException("No XML query response found");
        }
        Log.logger(SesameNameResolver.class).fine("xmlQueryResult: " + string);
        Sesame sesame = (Sesame)JAXB.unmarshal((Reader)new StringReader(string), Sesame.class);
        if (sesame.getTarget().isEmpty()) {
            throw new UnableToResolveObjectException();
        }
        for (Target target : sesame.getTarget()) {
            if (target.getResolver().isEmpty()) {
                throw new UnableToResolveObjectException();
            }
            this.reset();
            this.ra = this.dec = INVALID;
            this.properMotionDec = this.parallax = NODATA;
            this.properMotionRa = this.parallax;
            this.sourceVelocity = null;
            for (alma.obsprep.ot.services.network.sesame.Resolver resolver : target.getResolver()) {
                ResolverAdapter resolverAdapter = new ResolverAdapter(resolver);
                SesameNameResolver sesameNameResolver = new SesameNameResolver();
                sesameNameResolver.setResolverService(Resolver.ResolverService.findService(resolver.getName()));
                if (resolverAdapter.getOname().isEmpty()) continue;
                if (resolverAdapter.getJradeg().isEmpty()) {
                    throw new UnableToProcessSesameResponseException("No RA found in sesame XML response");
                }
                if (resolverAdapter.getJdedeg().isEmpty()) {
                    throw new UnableToProcessSesameResponseException("No Dec found in sesame XML response");
                }
                sesameNameResolver.setName(resolverAdapter.getOname().get(0));
                this.ra = resolverAdapter.getJradeg().get(0).doubleValue();
                sesameNameResolver.setRa(this.ra);
                this.dec = resolverAdapter.getJdedeg().get(0).doubleValue();
                sesameNameResolver.setDec(this.dec);
                if (!resolverAdapter.getPm().isEmpty()) {
                    PmVector pmVector = resolverAdapter.getPm().get(0);
                    this.properMotionDec = pmVector.getPmDE().doubleValue();
                    sesameNameResolver.setProperMotionDec(this.properMotionDec);
                    this.properMotionRa = pmVector.getPmRA().doubleValue();
                    sesameNameResolver.setProperMotionRa(this.properMotionRa);
                }
                if (!resolverAdapter.getPlx().isEmpty()) {
                    this.parallax = resolverAdapter.getPlx().get(0).getV().doubleValue();
                    sesameNameResolver.setParallax(this.parallax);
                }
                if (!resolverAdapter.getVel().isEmpty()) {
                    this.sourceVelocity = Velocity.createVelocity();
                    this.sourceVelocity.setDopplerCalcType(Velocity.DOPPLERCALCTYPE_RELATIVISTIC);
                    this.sourceVelocity.setReferenceSystem(Velocity.REFERENCESYSTEM_HEL);
                    this.sourceVelocity.setCenterVelocity(Speed.createSpeed((double)resolverAdapter.getVel().get(0).getV().doubleValue(), (String)Speed.UNIT_KM_S));
                    sesameNameResolver.setSourceVelocity(this.sourceVelocity);
                } else if (!resolverAdapter.getZ().isEmpty()) {
                    this.sourceVelocity = Velocity.createVelocity();
                    this.sourceVelocity.setDopplerCalcType(Velocity.DOPPLERCALCTYPE_RELATIVISTIC);
                    this.sourceVelocity.setReferenceSystem(Velocity.REFERENCESYSTEM_HEL);
                    double d = this.sourceVelocity.fromRedshift(resolverAdapter.getZ().get(0).getV().doubleValue()).getCenterVelocity().getContentInUnits(Speed.UNIT_KM_S);
                    this.sourceVelocity.setCenterVelocity(Speed.createSpeed((double)d, (String)Speed.UNIT_KM_S));
                    sesameNameResolver.setSourceVelocity(this.sourceVelocity);
                }
                this.results.add(sesameNameResolver);
            }
        }
    }

    @Override
    public void setNameServer(String string) {
        this.nameServer = string;
    }

    @Override
    public String getNameServer() {
        return this.nameServer;
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        SesameNameResolver sesameNameResolver = new SesameNameResolver();
        try {
            sesameNameResolver.query("SDSS J085519.05+575140.7");
            sesameNameResolver.query("ngc250");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public class UnableToProcessSesameResponseException
    extends Exception {
        public UnableToProcessSesameResponseException(String string) {
        }
    }

    public class UnableToResolveObjectException
    extends Exception {
    }
}

