/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.util.astro;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.util.astro.Resolver;
import alma.valuetypes.Speed;
import alma.valuetypes.Velocity;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import jsky.catalog.vo.VoTable;
import org.apache.commons.lang3.StringUtils;

public class SimbadNameResolver
extends Resolver {
    private String nameServer = "simbad.u-strasbg.fr";

    @Override
    public void query(String string) throws IOException, MalformedURLException {
        if (string == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: objectName");
        }
        Log.logger(this.getClass()).fine("Using SIMBAD to resolve " + string);
        this.reset();
        this.setName(string);
        this.results.clear();
        VoTable voTable = null;
        try {
            URL uRL = new URL("http://" + this.nameServer + "/simbad/sim-id?output.format=votable&Ident=" + URLEncoder.encode(StringUtils.trim((String)string), "UTF-8") + "&output.params=coo(d;ICRS);velocity,plx,pmra,pmdec,main_id,velocity");
            Log.logger(SimbadNameResolver.class).info("SIMBAD query: " + URLDecoder.decode(uRL.toString(), "UTF-8"));
            voTable = VoTable.createVoTable((URL)uRL, (String)string, (String)"sourceDetails");
        }
        catch (IOException iOException) {
            this.failedResolutionHandler("Unable to process VOtable response from simbad : " + iOException.getMessage(), string);
            throw iOException;
        }
        if (voTable == null) {
            this.failedResolutionHandler("Unable to process VOtable response from simbad : ", string);
        }
        try {
            this.processVOTableResponse(voTable);
            this.setQueryCompleted(true);
        }
        catch (UnableToProcessSourceResolverResponseException unableToProcessSourceResolverResponseException) {
            this.failedResolutionHandler("Unable to process XML response from SIMBAD: " + unableToProcessSourceResolverResponseException.getMessage(), string);
        }
        catch (UnableToResolveObjectException unableToResolveObjectException) {
            this.failedResolutionHandler("SIMBAD unable to resolve the object: ", string);
        }
    }

    private void processVOTableResponse(VoTable voTable) throws UnableToProcessSourceResolverResponseException, UnableToResolveObjectException {
        if (voTable == null) {
            throw new UnableToProcessSourceResolverResponseException("No VOtable query response found");
        }
        this.reset();
        this.ra = this.dec = INVALID;
        this.properMotionDec = this.parallax = NODATA;
        this.properMotionRa = this.parallax;
        this.sourceVelocity = null;
        SimbadNameResolver simbadNameResolver = new SimbadNameResolver();
        for (int i = 0; i < voTable.getRowCount(); ++i) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            for (SimbadQueryResponseFields simbadQueryResponseFields : SimbadQueryResponseFields.values()) {
                if (!simbadQueryResponseFields.isRequired() || (object4 = voTable.getValueAt(i, simbadQueryResponseFields.getAttribute())) != null) continue;
                throw new UnableToProcessSourceResolverResponseException("No " + simbadQueryResponseFields.getAttribute() + " found in SIMBAD VOtable response");
            }
            simbadNameResolver.setResolverService(Resolver.ResolverService.SIMBAD);
            double d = (Double)voTable.getValueAt(i, SimbadQueryResponseFields.RA.getAttribute());
            simbadNameResolver.setRa(d);
            double d2 = (Double)voTable.getValueAt(i, SimbadQueryResponseFields.DEC.getAttribute());
            simbadNameResolver.setDec(d2);
            simbadNameResolver.setName((String)voTable.getValueAt(i, SimbadQueryResponseFields.MAINID.getAttribute()));
            object4 = voTable.getValueAt(i, SimbadQueryResponseFields.PMDEC.getAttribute());
            if (object4 != null) {
                simbadNameResolver.setProperMotionDec((double)((Double)object4));
            }
            if ((object3 = voTable.getValueAt(i, SimbadQueryResponseFields.PMRA.getAttribute())) != null) {
                simbadNameResolver.setProperMotionRa((double)((Double)object3));
            }
            if ((object2 = voTable.getValueAt(i, SimbadQueryResponseFields.PARALLAX.getAttribute())) != null) {
                simbadNameResolver.setParallax((Double)object2);
            }
            if ((object = voTable.getValueAt(i, SimbadQueryResponseFields.VELTYPE.getAttribute())) != null) {
                Object object5 = voTable.getValueAt(i, SimbadQueryResponseFields.VEL.getAttribute());
                Character c = (Character)object;
                if (c.charValue() == 'v' || c.charValue() == 'c') {
                    this.sourceVelocity = Velocity.createVelocity();
                    this.sourceVelocity.setDopplerCalcType(Velocity.DOPPLERCALCTYPE_RELATIVISTIC);
                    this.sourceVelocity.setReferenceSystem(Velocity.REFERENCESYSTEM_HEL);
                    this.sourceVelocity.setCenterVelocity(Speed.createSpeed((double)((Double)object5), (String)Speed.UNIT_KM_S));
                    simbadNameResolver.setSourceVelocity(this.sourceVelocity);
                } else if (c.charValue() == 'z') {
                    this.sourceVelocity = Velocity.createVelocity();
                    this.sourceVelocity.setDopplerCalcType(Velocity.DOPPLERCALCTYPE_RELATIVISTIC);
                    this.sourceVelocity.setReferenceSystem(Velocity.REFERENCESYSTEM_HEL);
                    double d3 = this.sourceVelocity.fromRedshift((Double)object5).getCenterVelocity().getContentInUnits(Speed.UNIT_KM_S);
                    this.sourceVelocity.setCenterVelocity(Speed.createSpeed((double)d3, (String)Speed.UNIT_KM_S));
                    simbadNameResolver.setSourceVelocity(this.sourceVelocity);
                } else {
                    throw new UnableToProcessSourceResolverResponseException("Unknown velocity type returned " + c);
                }
            }
            this.results.add(simbadNameResolver);
            this.setQuerySuccessful(true);
        }
    }

    @Override
    public void setNameServer(String string) {
        this.nameServer = string;
    }

    @Override
    public String getNameServer() {
        return this.nameServer;
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        try {
            URL uRL = new URL("http://simbad.u-strasbg.fr/simbad/sim-id?output.format=votable&Ident=" + URLEncoder.encode(StringUtils.trim((String)"HL tau"), "UTF-8") + "&output.params=coo(d;ICRS);velocity,plx,pmra,pmdec,main_id,velocity");
            VoTable voTable = VoTable.createVoTable((URL)uRL, (String)"source", (String)"catalog");
            for (Object e : voTable.getColumnIdentifiers()) {
                System.out.println(e);
            }
            System.out.println(voTable.getValueAt(0, "RA_d_ICRS"));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public class UnableToProcessSourceResolverResponseException
    extends Exception {
        public UnableToProcessSourceResolverResponseException(String string) {
        }
    }

    public class UnableToResolveObjectException
    extends Exception {
    }

    public static enum SimbadQueryResponseFields {
        MAINID("MAIN_ID", true),
        RA("RA_d_ICRS", true),
        DEC("DEC_d_ICRS", true),
        PMRA("PMRA", false),
        PMDEC("PMDEC", false),
        VELTYPE("RVZ_TYPE", false),
        VEL("RVZ_RADVEL", false),
        PARALLAX("PLX_VALUE", false);

        private String attribute;
        private boolean isRequired = false;

        private SimbadQueryResponseFields(String string2, boolean bl) {
            this.attribute = string2;
            this.isRequired = bl;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public boolean isRequired() {
            return this.isRequired;
        }
    }
}

