/*
 * Decompiled with CFR 0.152.
 */
package alma.valuetypes;

import alma.entity.xmlbinding.valuetypes.AngleT;
import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.valuetypes.Length;
import alma.valuetypes.UserAngle;
import alma.valuetypes.data.AngleData;

public class Angle
extends AngleData<Angle> {
    public static final String[] units_mas_sec = new String[]{UNIT_MAS, UNIT_ARCSEC};
    public static final String[] units_sec_min_deg = new String[]{UNIT_ARCSEC, UNIT_ARCMIN, UNIT_DEG};

    public Angle(AngleT angleT) {
        super(angleT);
    }

    protected void initAsNew() {
        super.initAsNew();
        this.setContent(0.0);
    }

    public double getArcsec() {
        return this.getContentInUnits(UNIT_ARCSEC);
    }

    public double getDegs() {
        return this.getContentInUnits(UNIT_DEG);
    }

    public String defaultUnit() {
        return this.unitMap().getDefaultUnit();
    }

    public static Angle arcAngle(Length length, Length length2) {
        double d = length.getContentInDefaultUnits() / length2.getContentInDefaultUnits();
        return Angle.createAngle((double)d, (String)UNIT_RAD);
    }

    public static Angle createAngleArcsec(double d) {
        return Angle.createAngle((double)d, (String)UNIT_ARCSEC);
    }

    public static UserAngle max(UserAngle userAngle, UserAngle userAngle2) {
        return userAngle.isGreaterThan((AbstractDoubleWithUnit)userAngle2) ? userAngle : userAngle2;
    }

    public static UserAngle min(UserAngle userAngle, UserAngle userAngle2) {
        return userAngle.isLessThan((AbstractDoubleWithUnit)userAngle2) ? userAngle : userAngle2;
    }
}

