/*
 * Decompiled with CFR 0.152.
 */
package alma.valuetypes;

import alma.entity.xmlbinding.valuetypes.FrequencyT;
import alma.valuetypes.Length;
import alma.valuetypes.Speed;
import alma.valuetypes.Velocity;
import alma.valuetypes.data.FrequencyData;
import java.math.BigDecimal;

public class Frequency
extends FrequencyData<Frequency> {
    public Frequency(FrequencyT frequencyT) {
        super(frequencyT);
    }

    public String defaultUnit() {
        return this.unitMap().getDefaultUnit();
    }

    public static Frequency createFrequencyGHZ(double d) {
        return Frequency.createFrequency((double)d, (String)UNIT_GHZ);
    }

    public double getContentInGHz() {
        return this.getContentInUnits(UNIT_GHZ);
    }

    public void setContentInGHz(double d) {
        this.setContent(d);
        this.setUnit(UNIT_GHZ);
    }

    public void convertToGHz() {
        this.convertToUnit(UNIT_GHZ);
    }

    public static Frequency createFrequencyMHZ(double d) {
        return Frequency.createFrequency((double)d, (String)UNIT_MHZ);
    }

    public double getContentInMHz() {
        return this.getContentInUnits(UNIT_MHZ);
    }

    public void setContentInMHz(double d) {
        this.setContent(d);
        this.setUnit(UNIT_MHZ);
    }

    public void convertToMHz() {
        this.convertToUnit(UNIT_MHZ);
    }

    public Frequency convertToFriendlyUnit() {
        if (this.isZero()) {
            return this;
        }
        this.convertToUnit(this.getFriendlyUnit());
        return this;
    }

    public double getWavelengthM() {
        double d = this.getContentInUnits(UNIT_GHZ) * 1.0E9;
        return 2.99792458E8 / d;
    }

    public Length getWavelength() {
        return Length.createLength((double)this.getWavelengthM(), (String)Length.UNIT_M);
    }

    public Frequency dopplerShifted(Velocity velocity) {
        return velocity.dopplerShift(this);
    }

    public Frequency inverseDopplerShifted(Velocity velocity) {
        return velocity.reverseShift(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Frequency)) {
            return false;
        }
        Frequency frequency = (Frequency)((Object)object);
        return frequency.getContentInGHz() == this.getContentInGHz();
    }

    public int hashCode() {
        int n = 17;
        long l = Double.doubleToLongBits(this.getContentInGHz());
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public static Speed getSpeedResolution(Frequency frequency, Frequency frequency2) {
        return Speed.getSpeedResolution(frequency, frequency2);
    }

    public static Frequency getFrequencyResolution(Speed speed, Frequency frequency) {
        return Speed.getFrequencyResolution(speed, frequency);
    }

    public static String formatFrequencyGHz(Frequency frequency) {
        double d = 0.0;
        if (frequency.getContent() > 0.0 && frequency.getContent() < Double.POSITIVE_INFINITY) {
            BigDecimal bigDecimal = new BigDecimal(String.valueOf(frequency.getContentInUnits(UNIT_GHZ)));
            d = bigDecimal.setScale(2, 4).doubleValue();
        }
        return String.format("%4.3f %s", d, UNIT_GHZ);
    }
}

