/*
 * Decompiled with CFR 0.152.
 */
package alma.valuetypes;

import alma.entity.xmlbinding.valuetypes.SkyCoordinatesT;
import alma.hla.runtime.obsprep.bo.CopyException;
import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.guiutil.mvc.InvalidCoordException;
import alma.obsprep.guiutil.mvc.OutOfRangeException;
import alma.obsprep.ot.editors.misc.SkyCoordinatesSummaryTableColumns;
import alma.obsprep.ot.models.misc.SummaryTableColumns;
import alma.obsprep.ot.models.misc.SummaryTableRow;
import alma.obsprep.util.astro.CoordsSystemConversionHelper;
import alma.obsprep.util.astro.CoordsSystemConverterFactory;
import alma.obsprep.util.astro.PointingCoordsConverter;
import alma.obsprep.util.astro.SkyPoint;
import alma.valuetypes.Angle;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.data.SkyCoordinatesData;
import java.awt.geom.Point2D;

public class SkyCoordinates
extends SkyCoordinatesData
implements SummaryTableRow {
    public static final int COORD_ALTAZ = 0;
    public static final int COORD_ECLIPTIC = 1;
    public static final int COORD_EQUATORIAL = 2;
    public static final int COORD_GALACTIC = 3;
    private CoordsSystemConversionHelper sysconHelper = CoordsSystemConverterFactory.createConverter(this);
    private SummaryTableColumns summaryTableColumns = new SkyCoordinatesSummaryTableColumns(this);
    public static final String FK5_J2000 = "FK5 J2000";

    public SkyCoordinates(SkyCoordinatesT skyCoordinatesT) {
        super(skyCoordinatesT);
    }

    protected synchronized void initAsNew() {
        super.initAsNew();
        this.setSystem(SYSTEM_ICRS);
        this.setType(TYPE_ABSOLUTE);
        this.setFieldName("None");
        this.setLatitude(Latitude.createLatitude((double)0.0, (String)Latitude.UNIT_DEG));
        this.setLongitude(Longitude.createLongitude((double)0.0, (String)Longitude.UNIT_DEG));
    }

    public static boolean isAltAz(String string) {
        return string.equals(SYSTEM_AZEL) || string.equals(SYSTEM_HORIZON);
    }

    public static boolean isEcliptic(String string) {
        return string.equals(SYSTEM_ECLIPTIC);
    }

    public static boolean isEquatorial(String string) {
        return string.equals(SYSTEM_ICRS) || string.equals(SYSTEM_J2000);
    }

    public static boolean isGalactic(String string) {
        return string.equals(SYSTEM_GALACTIC);
    }

    public synchronized boolean isGalactic() {
        return SkyCoordinates.isGalactic(this.getSystem());
    }

    public String getName() {
        return "";
    }

    public static int getSystemType(String string) {
        if (SkyCoordinates.isAltAz(string)) {
            return 0;
        }
        if (SkyCoordinates.isEcliptic(string)) {
            return 1;
        }
        if (SkyCoordinates.isEquatorial(string)) {
            return 2;
        }
        if (SkyCoordinates.isGalactic(string)) {
            return 3;
        }
        throw new IllegalArgumentException("Unknown coordinate system type: " + string);
    }

    public synchronized SkyCoordinates getAbsoluteCoordinates(SkyCoordinates skyCoordinates) {
        if (this.isOffsetCoordinates()) {
            return PointingCoordsConverter.toAbsolute(this, skyCoordinates);
        }
        return this;
    }

    public synchronized SkyCoordinates getOffsetCoordinates(SkyCoordinates skyCoordinates) {
        if (this.isOffsetCoordinates()) {
            return this;
        }
        return PointingCoordsConverter.toOffset(this, skyCoordinates);
    }

    public synchronized SkyCoordinates getCoordinatesInType(SkyCoordinates skyCoordinates, String string) {
        if (string.equals(TYPE_RELATIVE)) {
            return this.getOffsetCoordinates(skyCoordinates);
        }
        if (string.equals(TYPE_ABSOLUTE)) {
            return this.getAbsoluteCoordinates(skyCoordinates);
        }
        return null;
    }

    public synchronized void toCoordinatesInType(SkyCoordinates skyCoordinates, String string) {
        SkyCoordinates skyCoordinates2 = this.getCoordinatesInType(skyCoordinates, string);
        this.setType(string);
        this.setSystem(skyCoordinates2.getSystem());
        this.getLatitude().setContentAndUnit((ValueUnitPair)skyCoordinates2.getLatitude());
        this.getLongitude().setContentAndUnit((ValueUnitPair)skyCoordinates2.getLongitude());
        if (this.isAbsoluteCoordinates()) {
            if (skyCoordinates == null) {
                Log.logger((Object)this).warning("Origin must be specified to calculate offset coordinates.");
            } else {
                this.convertToSystem(skyCoordinates.getSystem());
            }
        }
    }

    public synchronized boolean isAbsoluteCoordinates() {
        return this.getType().equals(TYPE_ABSOLUTE);
    }

    public synchronized boolean isOffsetCoordinates() {
        return this.getType().equals(TYPE_RELATIVE);
    }

    public static SkyCoordinates createAbsoluteCoordinates() {
        return SkyCoordinates.createSkyCoordinates(TYPE_ABSOLUTE);
    }

    public static SkyCoordinates createOffsetCoordinates() {
        return SkyCoordinates.createSkyCoordinates(TYPE_RELATIVE);
    }

    public static SkyCoordinates createSkyCoordinates(String string) {
        SkyCoordinates skyCoordinates = SkyCoordinates.createSkyCoordinates();
        skyCoordinates.setType(string);
        if (string.equals(TYPE_RELATIVE)) {
            skyCoordinates.getLatitude().setUnit(Angle.UNIT_ARCSEC);
            skyCoordinates.getLongitude().setUnit(Angle.UNIT_ARCSEC);
        } else {
            skyCoordinates.getLatitude().setUnit(Angle.UNIT_DEG);
            skyCoordinates.getLongitude().setUnit(Angle.UNIT_DEG);
        }
        return skyCoordinates;
    }

    public synchronized boolean isSystemConvertSupportedForAbsolute(String string) {
        if (this.sysconHelper == null) {
            return false;
        }
        if (!this.isAbsoluteCoordinates()) {
            return false;
        }
        String string2 = this.getSystem();
        if (this.sysconHelper.isValidSystem(string2) && this.sysconHelper.isValidSystem(string)) {
            return CoordsSystemConversionHelper.isSupportedTransform(string2, string);
        }
        return false;
    }

    public synchronized boolean isSystemConvertSupported(String string) {
        if (this.sysconHelper == null) {
            return false;
        }
        String string2 = this.getSystem();
        if (this.sysconHelper.isValidSystem(string2) && this.sysconHelper.isValidSystem(string)) {
            return CoordsSystemConversionHelper.isSupportedTransform(string2, string);
        }
        return false;
    }

    public void convertToJ2000() {
        this.convertToSystem(SYSTEM_J2000);
    }

    public void convertToICRS() {
        this.convertToSystem(SYSTEM_ICRS);
    }

    public void convertToGalactic() {
        this.convertToSystem(SYSTEM_GALACTIC);
    }

    public synchronized void convertToSystem(String string) {
        if (string == null) {
            Log.logger((Object)this).warning("system converting to must not be null");
            return;
        }
        if (string.equals(this.getSystem())) {
            return;
        }
        SkyPoint skyPoint = this.getAbsoluteSkyPointInDegInSystem(string);
        this.setAbsoluteCoordinatesInDegInSystem(skyPoint.getX(), skyPoint.getY(), string);
    }

    public synchronized SkyCoordinates getJ2000SkyCoordinates() {
        return this.getSkyCoordinatesInSystem(SYSTEM_ICRS);
    }

    public synchronized SkyCoordinates getICRSSkyCoordinates() {
        return this.getSkyCoordinatesInSystem(SYSTEM_ICRS);
    }

    public synchronized SkyCoordinates getGalacticSkyCoordinates() {
        return this.getSkyCoordinatesInSystem(SYSTEM_GALACTIC);
    }

    private synchronized SkyCoordinates getSkyCoordinatesInSystem(String string) {
        String string2 = this.getSystem();
        if (string2 == null) {
            Log.logger((Object)this).warning("System must not be null.");
            return this;
        }
        if (string2.equals(string)) {
            return this;
        }
        SkyCoordinates skyCoordinates = this.deepCopy();
        skyCoordinates.convertToSystem(string);
        return skyCoordinates;
    }

    public synchronized void setAbsoluteCoordinatesInJ2000Deg(Point2D point2D) {
        this.setAbsoluteCoordinatesInJ2000Deg(point2D.getX(), point2D.getY());
    }

    public synchronized void setAbsoluteCoordinatesInJ2000Deg(double d, double d2) {
        this.setAbsoluteCoordinatesInDegInSystem(d, d2, SYSTEM_J2000);
    }

    public synchronized void setAbsoluteCoordinatesInGalacticDeg(Point2D point2D) {
        this.setAbsoluteCoordinatesInGalacticDeg(point2D.getX(), point2D.getY());
    }

    public void setAbsoluteCoordinatesInGalacticDeg(double d, double d2) {
        this.setAbsoluteCoordinatesInDegInSystem(d, d2, SYSTEM_GALACTIC);
    }

    public synchronized void setAbsoluteCoordinatesInDegInSystem(double d, double d2, String string) {
        this.getLongitude().setContentInDeg(d);
        this.getLatitude().setContentInDeg(d2);
        this.setType(TYPE_ABSOLUTE);
        this.setSystem(string);
    }

    public SkyPoint getAbsoluteSkyPointInJ2000Deg() {
        return this.getAbsoluteSkyPointInDegInSystem(SYSTEM_J2000);
    }

    public synchronized SkyPoint getAbsoluteSkyPointInGalacticDeg() {
        return this.getAbsoluteSkyPointInDegInSystem(SYSTEM_GALACTIC);
    }

    public SkyPoint getAbsoluteSkyPointInICRSDeg() {
        return this.getAbsoluteSkyPointInDegInSystem(SYSTEM_ICRS);
    }

    private synchronized SkyPoint getAbsoluteSkyPointInDegInSystem(String string) {
        if (this.sysconHelper == null) {
            throw new RuntimeException("This feature is not supported in this version.");
        }
        return this.sysconHelper.getAbsoluteSkyPointInDegInSystem(string);
    }

    public String toHTML() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getSystem();
        stringBuffer.append("<table border=0>");
        stringBuffer.append("<tr><td>Type</td>");
        stringBuffer.append("<td>" + this.getType() + "</td><td></td></tr>");
        stringBuffer.append("<tr><td>Lat</td>");
        stringBuffer.append("<td>");
        stringBuffer.append(this.getLatitude().getContent());
        stringBuffer.append("</td><td>");
        stringBuffer.append(this.getLatitude().getUnit());
        stringBuffer.append("</td></tr>");
        stringBuffer.append("<tr><td>Lon</td>");
        stringBuffer.append("<td>");
        stringBuffer.append(this.getLongitude().getContent());
        stringBuffer.append("</td><td>");
        stringBuffer.append(this.getLongitude().getUnit());
        stringBuffer.append("</td></tr>");
        stringBuffer.append("</tr></table>");
        return stringBuffer.toString();
    }

    public synchronized String getType() {
        String string = super.getType();
        if (string == null) {
            string = TYPE_ABSOLUTE;
        }
        return string;
    }

    public synchronized SkyCoordinates deepCopy() throws CopyException {
        return super.deepCopy();
    }

    public synchronized String formatRADec() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "invalid";
        String string2 = "invalid";
        try {
            string = this.getLongitude().toHHMMSS();
        }
        catch (OutOfRangeException outOfRangeException) {
        }
        catch (InvalidCoordException invalidCoordException) {
            // empty catch block
        }
        try {
            string2 = this.getLatitude().toDDMMSS();
        }
        catch (OutOfRangeException outOfRangeException) {
        }
        catch (InvalidCoordException invalidCoordException) {
            // empty catch block
        }
        stringBuilder.append(string).append(", ");
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getSimpleName()).append("[type=").append(this.getType()).append(",lon=").append(this.getLongitude().getContent()).append("/").append(this.getLongitude().getUnit()).append(",lat=").append(this.getLatitude().getContent()).append("/").append(this.getLatitude().getUnit()).append(",sys=").append(this.getSystem()).append("]");
        try {
            stringBuffer.append(",RA" + this.getLongitude().toHHMMSS()).append(",Dec" + this.getLatitude().toDDMMSS());
        }
        catch (InvalidCoordException | OutOfRangeException exception) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    @Override
    public SummaryTableColumns getSummaryTableColumns() {
        return this.summaryTableColumns;
    }

    public synchronized boolean verifySkyCoordinates() {
        Latitude latitude = this.getLatitude();
        Longitude longitude = this.getLongitude();
        double d = latitude.getContentInUnits(Latitude.UNIT_DEG);
        if (d < -90.0 || d > 90.0) {
            return false;
        }
        double d2 = this.isGalactic() ? -180.0 : 0.0;
        double d3 = this.isGalactic() ? 180.0 : 360.0;
        double d4 = longitude.getContentInUnits(Longitude.UNIT_DEG);
        return !(d4 < d2) && !(d4 > d3);
    }
}

