/*
 * Decompiled with CFR 0.152.
 */
package alma.valuetypes;

import alma.entity.xmlbinding.valuetypes.VelocityT;
import alma.hla.runtime.obsprep.util.Log;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Speed;
import alma.valuetypes.data.VelocityData;

public class Velocity
extends VelocityData {
    public static final double C = 2.99792458E8;
    public static final double GIGAHERTZ_TO_HERTZ = 1.0E9;
    public static final String defaultDopplerCalcType = DOPPLERCALCTYPE_RADIO;
    private static double[] SOLAR_MOTIONS = new double[]{-0.29, 17.31726, -10.00141};

    public Velocity(VelocityT velocityT) {
        super(velocityT);
    }

    protected void initAsNew() {
        super.initAsNew();
        this.setDopplerCalcType(defaultDopplerCalcType);
        this.setReferenceSystem(REFERENCESYSTEM_LSRK);
        this.setCenterVelocity(Speed.createSpeed((double)0.0, (String)Speed.UNIT_KM_S));
    }

    public Frequency dopplerShift(Frequency frequency) {
        double d = this.getDopplerShiftFactor();
        Frequency frequency2 = Frequency.createFrequency((double)(frequency.getContent() * d), (String)frequency.getUnit());
        return frequency2;
    }

    public Frequency reverseShift(Frequency frequency) {
        double d = this.getDopplerShiftFactor();
        Frequency frequency2 = Frequency.createFrequency((double)(frequency.getContent() / d), (String)frequency.getUnit());
        return frequency2;
    }

    public double getDopplerShiftFactor() {
        double d;
        double d2 = this.getCenterVelocity().getContentInUnits(Speed.UNIT_M_S) / 2.99792458E8;
        String string = this.checkType();
        if (string.equals(DOPPLERCALCTYPE_RELATIVISTIC)) {
            d = Math.sqrt((1.0 - d2) / (1.0 + d2));
        } else if (string.equals(DOPPLERCALCTYPE_OPTICAL)) {
            d = 1.0 / (1.0 + d2);
        } else if (string.equals(DOPPLERCALCTYPE_RADIO)) {
            d = 1.0 - d2;
        } else {
            assert (false);
            throw new IllegalArgumentException("Unknown DopplerCalcType : " + string);
        }
        if (Double.isNaN(d) || d < 0.0 || Double.isInfinite(d)) {
            d = 1.0;
        }
        return d;
    }

    private String checkType() {
        String string = this.getDopplerCalcType();
        if (string == null) {
            Log.logger((Object)((Object)this)).warning("DopplerCalcType is not set. Assuming \"" + defaultDopplerCalcType + "\"");
            string = defaultDopplerCalcType;
        }
        return string;
    }

    public double asRedshift() {
        double d = this.getCenterVelocity().getContentInUnits(Speed.UNIT_M_S) / 2.99792458E8;
        String string = this.checkType();
        double d2 = 0.0;
        if (string.equals(DOPPLERCALCTYPE_RELATIVISTIC)) {
            d2 = Math.sqrt((1.0 + d) / (1.0 - d)) - 1.0;
        } else if (string.equals(DOPPLERCALCTYPE_OPTICAL)) {
            d2 = d;
        } else if (string.equals(DOPPLERCALCTYPE_RADIO)) {
            d2 = d / (1.0 - d);
        } else {
            assert (false);
            throw new RuntimeException("Unknown DopplerCalcType : " + string);
        }
        return d2;
    }

    public Velocity fromRedshift(double d) {
        String string = this.checkType();
        Speed speed = null;
        if (string.equals(DOPPLERCALCTYPE_RELATIVISTIC)) {
            double d2 = (d + 1.0) * (d + 1.0);
            double d3 = (d2 - 1.0) / (d2 + 1.0);
            speed = Speed.createSpeed((double)(d3 * 2.99792458E8), (String)Speed.UNIT_M_S);
        } else if (string.equals(DOPPLERCALCTYPE_OPTICAL)) {
            speed = Speed.createSpeed((double)(d * 2.99792458E8), (String)Speed.UNIT_M_S);
        } else if (string.equals(DOPPLERCALCTYPE_RADIO)) {
            speed = Speed.createSpeed((double)(d * 2.99792458E8 / (1.0 + d)), (String)Speed.UNIT_M_S);
        } else {
            throw new RuntimeException("Unknown DopplerCalcType : " + string);
        }
        Velocity velocity = Velocity.createVelocity();
        velocity.setCenterVelocity(speed);
        velocity.setDopplerCalcType(this.getDopplerCalcType());
        return velocity;
    }

    public String toString() {
        return this.getCenterVelocity().toString();
    }

    public Velocity getVelocityInBary(SkyCoordinates skyCoordinates) {
        if (skyCoordinates == null) {
            throw new NullPointerException("Illegal argument - the argument sourceCoordinates cannot be null");
        }
        String string = this.getReferenceSystem();
        Velocity velocity = REFERENCESYSTEM_BAR == string || REFERENCESYSTEM_HEL == string ? this.deepCopy() : (REFERENCESYSTEM_LSR == string || REFERENCESYSTEM_LSRK == string ? Velocity.applyLSRKToBarycentricCorrection(skyCoordinates, this) : this.deepCopy());
        assert (velocity != null);
        return velocity;
    }

    public static Velocity applyLSRKToBarycentricCorrection(SkyCoordinates skyCoordinates, Velocity velocity) {
        SkyCoordinates skyCoordinates2 = skyCoordinates.getJ2000SkyCoordinates();
        double d = skyCoordinates2.getLongitude().getContentInUnits(Angle.UNIT_RAD);
        double d2 = skyCoordinates2.getLatitude().getContentInUnits(Angle.UNIT_RAD);
        double d3 = Velocity.solarRadialVelocityLsrk(d, d2);
        Velocity velocity2 = velocity.deepCopy();
        velocity2.setCenterVelocity(Speed.createSpeed((double)d3, (String)Speed.UNIT_KM_S));
        double d4 = velocity2.getDopplerShiftFactor();
        double d5 = velocity.getDopplerShiftFactor();
        double d6 = d5 * d4;
        Velocity velocity3 = velocity.fromRedshift(1.0 / d6 - 1.0);
        velocity3.setReferenceSystem(REFERENCESYSTEM_BAR);
        return velocity3;
    }

    public void setReferenceSystem(String string) {
        String string2 = string;
        if (string.equals(REFERENCESYSTEM_LSR)) {
            string2 = REFERENCESYSTEM_LSRK;
        }
        super.setReferenceSystem(string2);
    }

    public String getReferenceSystem() {
        String string = super.getReferenceSystem();
        if (string.equals(REFERENCESYSTEM_LSR)) {
            string = REFERENCESYSTEM_LSRK;
            super.setReferenceSystem(REFERENCESYSTEM_LSRK);
        }
        return string;
    }

    private static double solarRadialVelocityLsrk(double d, double d2) {
        return Velocity.scalarProduct(SOLAR_MOTIONS, Velocity.spherical2cosine(d, d2));
    }

    private static double scalarProduct(double[] dArray, double[] dArray2) {
        return dArray[0] * dArray2[0] + dArray[1] * dArray2[1] + dArray[2] * dArray2[2];
    }

    private static double[] spherical2cosine(double d, double d2) {
        double[] dArray = new double[3];
        double d3 = Math.cos(d2);
        dArray[0] = Math.cos(d) * d3;
        dArray[1] = Math.sin(d) * d3;
        dArray[2] = Math.sin(d2);
        return dArray;
    }

    public void updateLocalReference() {
        this.getReferenceSystem();
    }
}

