/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import com.microstar.xml.HandlerBase;
import java.io.StringReader;
import java.util.Stack;
import org.gjt.sp.jedit.ActionSet;
import org.gjt.sp.jedit.BeanShellAction;
import org.gjt.sp.util.Log;

class ActionListHandler
extends HandlerBase {
    private String path;
    private ActionSet actionSet;
    private String actionName;
    private String code;
    private String isSelected;
    private boolean noRepeat;
    private boolean noRecord;
    private boolean noRememberLast;
    private Stack stateStack;

    ActionListHandler(String path, ActionSet actionSet) {
        this.path = path;
        this.actionSet = actionSet;
        this.stateStack = new Stack();
    }

    public Object resolveEntity(String publicId, String systemId) {
        if ("actions.dtd".equals(systemId)) {
            return new StringReader("<!-- -->");
        }
        return null;
    }

    public void attribute(String aname, String value, boolean isSpecified) {
        aname = aname == null ? null : aname.intern();
        String string = value = value == null ? null : value.intern();
        if (aname == "NAME") {
            this.actionName = value;
        } else if (aname == "NO_REPEAT") {
            this.noRepeat = value == "TRUE";
        } else if (aname == "NO_RECORD") {
            this.noRecord = value == "TRUE";
        } else if (aname == "NO_REMEMBER_LAST") {
            this.noRememberLast = value == "TRUE";
        }
    }

    public void doctypeDecl(String name, String publicId, String systemId) throws Exception {
        if ("ACTIONS".equals(name)) {
            return;
        }
        Log.log(9, this, this.path + ": DOCTYPE must be ACTIONS");
    }

    public void charData(char[] c, int off, int len) {
        String tag = this.peekElement();
        String text = new String(c, off, len);
        if (tag == "CODE") {
            this.code = text;
        } else if (tag == "IS_SELECTED") {
            this.isSelected = text;
        }
    }

    public void startElement(String tag) {
        if ((tag = this.pushElement(tag)) == "ACTION") {
            this.code = null;
            this.isSelected = null;
        }
    }

    public void endElement(String name) {
        if (name == null) {
            return;
        }
        String tag = this.peekElement();
        if (name.equals(tag)) {
            if (tag == "ACTION") {
                this.actionSet.addAction(new BeanShellAction(this.actionName, this.code, this.isSelected, this.noRepeat, this.noRecord, this.noRememberLast));
                this.noRememberLast = false;
                this.noRecord = false;
                this.noRepeat = false;
            }
        } else {
            throw new InternalError();
        }
        this.popElement();
    }

    public void startDocument() {
        try {
            this.pushElement(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String pushElement(String name) {
        name = name == null ? null : name.intern();
        this.stateStack.push(name);
        return name;
    }

    private String peekElement() {
        return (String)this.stateStack.peek();
    }

    private String popElement() {
        return (String)this.stateStack.pop();
    }
}

