/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.BufferSwitcher;
import org.gjt.sp.jedit.gui.StatusBar;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.options.GlobalOptions;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.jedit.textarea.Gutter;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.TextAreaPainter;
import org.gjt.sp.util.Log;

public class EditPane
extends JPanel
implements EBComponent {
    private static Method initBufferSwitcher;
    private boolean init = true;
    private View view;
    private Buffer buffer;
    private Buffer recentBuffer;
    private BufferSwitcher bufferSwitcher;
    private JEditTextArea textArea;
    static /* synthetic */ Class class$org$gjt$sp$jedit$EditPane;
    static /* synthetic */ Class class$org$gjt$sp$jedit$gui$BufferSwitcher;
    static /* synthetic */ Class class$org$gjt$sp$jedit$Java14;

    public View getView() {
        return this.view;
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(final Buffer buffer) {
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (this.buffer == buffer) {
            return;
        }
        this.recentBuffer = this.buffer;
        if (this.recentBuffer != null) {
            this.saveCaretInfo();
        }
        this.buffer = buffer;
        this.textArea.setBuffer(buffer);
        if (!this.init) {
            this.view.updateTitle();
            if (this.bufferSwitcher != null && this.bufferSwitcher.getSelectedItem() != buffer) {
                this.bufferSwitcher.setSelectedItem(buffer);
            }
            EditBus.send(new EditPaneUpdate(this, EditPaneUpdate.BUFFER_CHANGED));
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (!(EditPane.this.view.getEditPane() != EditPane.this || EditPane.this.bufferSwitcher != null && EditPane.this.bufferSwitcher.isPopupVisible())) {
                    EditPane.this.textArea.requestFocus();
                }
            }
        });
        Runnable runnable = new Runnable(){

            public void run() {
                if (buffer == EditPane.this.getBuffer()) {
                    EditPane.this.loadCaretInfo();
                }
            }
        };
        if (buffer.isPerformingIO()) {
            VFSManager.runInAWTThread(runnable);
        } else {
            runnable.run();
        }
    }

    public void prevBuffer() {
        Buffer buffer = this.buffer.getPrev();
        if (buffer == null) {
            this.setBuffer(jEdit.getLastBuffer());
        } else {
            this.setBuffer(buffer);
        }
    }

    public void nextBuffer() {
        Buffer buffer = this.buffer.getNext();
        if (buffer == null) {
            this.setBuffer(jEdit.getFirstBuffer());
        } else {
            this.setBuffer(buffer);
        }
    }

    public void recentBuffer() {
        if (this.recentBuffer != null) {
            this.setBuffer(this.recentBuffer);
        } else {
            this.getToolkit().beep();
        }
    }

    public void focusOnTextArea() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                EditPane.this.textArea.requestFocus();
            }
        });
    }

    public JEditTextArea getTextArea() {
        return this.textArea;
    }

    public BufferSwitcher getBufferSwitcher() {
        return this.bufferSwitcher;
    }

    public void showBufferSwitcher() {
        if (this.bufferSwitcher == null) {
            this.getToolkit().beep();
        } else {
            this.bufferSwitcher.requestFocus();
            this.bufferSwitcher.showPopup();
        }
    }

    public void saveCaretInfo() {
        if (!this.buffer.isLoaded()) {
            return;
        }
        this.buffer.setIntegerProperty("Buffer__caret", this.textArea.getCaretPosition());
        this.buffer.setIntegerProperty("Buffer__scrollVert", this.textArea.getFirstPhysicalLine());
        this.buffer.setIntegerProperty("Buffer__scrollHoriz", this.textArea.getHorizontalOffset());
    }

    public void loadCaretInfo() {
        Integer caret = (Integer)this.buffer.getProperty("Buffer__caret");
        Integer firstLine = (Integer)this.buffer.getProperty("Buffer__scrollVert");
        Integer horizontalOffset = (Integer)this.buffer.getProperty("Buffer__scrollHoriz");
        if (caret != null) {
            this.textArea.setCaretPosition(Math.min(caret, this.buffer.getLength()));
        }
        if (firstLine != null) {
            this.textArea.setFirstPhysicalLine(firstLine);
        }
        if (horizontalOffset != null) {
            this.textArea.setHorizontalOffset(horizontalOffset);
        }
        this.view.getStatus().setMessage(null);
    }

    public void handleMessage(EBMessage msg) {
        if (msg instanceof PropertiesChanged) {
            this.propertiesChanged();
            this.loadBufferSwitcher();
        } else if (msg instanceof BufferUpdate) {
            this.handleBufferUpdate((BufferUpdate)msg);
        }
    }

    public final Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public String toString() {
        return this.getClass().getName() + "[" + (this.view.getEditPane() == this ? "active" : "inactive") + "]";
    }

    EditPane(View view, Buffer buffer) {
        super(new BorderLayout());
        this.view = view;
        EditBus.addToBus(this);
        this.textArea = new JEditTextArea(view);
        this.add("Center", this.textArea);
        this.propertiesChanged();
        if (buffer == null) {
            this.setBuffer(jEdit.getFirstBuffer());
        } else {
            this.setBuffer(buffer);
        }
        this.loadBufferSwitcher();
        this.init = false;
    }

    void close() {
        this.saveCaretInfo();
        EditBus.send(new EditPaneUpdate(this, EditPaneUpdate.DESTROYED));
        EditBus.removeFromBus(this);
        this.textArea.dispose();
    }

    private void propertiesChanged() {
        TextAreaPainter painter = this.textArea.getPainter();
        painter.setFont(jEdit.getFontProperty("view.font"));
        painter.setStructureHighlightEnabled(jEdit.getBooleanProperty("view.structureHighlight"));
        painter.setStructureHighlightColor(jEdit.getColorProperty("view.structureHighlightColor"));
        painter.setEOLMarkersPainted(jEdit.getBooleanProperty("view.eolMarkers"));
        painter.setEOLMarkerColor(jEdit.getColorProperty("view.eolMarkerColor"));
        painter.setWrapGuidePainted(jEdit.getBooleanProperty("view.wrapGuide"));
        painter.setWrapGuideColor(jEdit.getColorProperty("view.wrapGuideColor"));
        painter.setCaretColor(jEdit.getColorProperty("view.caretColor"));
        painter.setSelectionColor(jEdit.getColorProperty("view.selectionColor"));
        painter.setMultipleSelectionColor(jEdit.getColorProperty("view.multipleSelectionColor"));
        painter.setBackground(jEdit.getColorProperty("view.bgColor"));
        painter.setForeground(jEdit.getColorProperty("view.fgColor"));
        painter.setBlockCaretEnabled(jEdit.getBooleanProperty("view.blockCaret"));
        painter.setLineHighlightEnabled(jEdit.getBooleanProperty("view.lineHighlight"));
        painter.setLineHighlightColor(jEdit.getColorProperty("view.lineHighlightColor"));
        painter.setAntiAliasEnabled(jEdit.getBooleanProperty("view.antiAlias"));
        painter.setFractionalFontMetricsEnabled(jEdit.getBooleanProperty("view.fracFontMetrics"));
        String defaultFont = jEdit.getProperty("view.font");
        int defaultFontSize = jEdit.getIntegerProperty("view.fontsize", 12);
        painter.setStyles(GUIUtilities.loadStyles(defaultFont, defaultFontSize));
        SyntaxStyle[] foldLineStyle = new SyntaxStyle[4];
        for (int i = 0; i <= 3; ++i) {
            foldLineStyle[i] = GUIUtilities.parseStyle(jEdit.getProperty("view.style.foldLine." + i), defaultFont, defaultFontSize);
        }
        painter.setFoldLineStyle(foldLineStyle);
        Gutter gutter = this.textArea.getGutter();
        gutter.setExpanded(jEdit.getBooleanProperty("view.gutter.lineNumbers"));
        int interval = jEdit.getIntegerProperty("view.gutter.highlightInterval", 5);
        gutter.setHighlightInterval(interval);
        gutter.setCurrentLineHighlightEnabled(jEdit.getBooleanProperty("view.gutter.highlightCurrentLine"));
        gutter.setStructureHighlightEnabled(jEdit.getBooleanProperty("view.gutter.structureHighlight"));
        gutter.setStructureHighlightColor(jEdit.getColorProperty("view.gutter.structureHighlightColor"));
        gutter.setBackground(jEdit.getColorProperty("view.gutter.bgColor"));
        gutter.setForeground(jEdit.getColorProperty("view.gutter.fgColor"));
        gutter.setHighlightedForeground(jEdit.getColorProperty("view.gutter.highlightColor"));
        gutter.setFoldColor(jEdit.getColorProperty("view.gutter.foldColor"));
        gutter.setMarkerHighlightColor(jEdit.getColorProperty("view.gutter.markerColor"));
        gutter.setMarkerHighlightEnabled(jEdit.getBooleanProperty("view.gutter.markerHighlight"));
        gutter.setCurrentLineForeground(jEdit.getColorProperty("view.gutter.currentLineColor"));
        String alignment = jEdit.getProperty("view.gutter.numberAlignment");
        if ("right".equals(alignment)) {
            gutter.setLineNumberAlignment(4);
        } else if ("center".equals(alignment)) {
            gutter.setLineNumberAlignment(0);
        } else {
            gutter.setLineNumberAlignment(2);
        }
        gutter.setFont(jEdit.getFontProperty("view.gutter.font"));
        int width = jEdit.getIntegerProperty("view.gutter.borderWidth", 3);
        gutter.setBorder(width, jEdit.getColorProperty("view.gutter.focusBorderColor"), jEdit.getColorProperty("view.gutter.noFocusBorderColor"), this.textArea.getPainter().getBackground());
        this.textArea.setCaretBlinkEnabled(jEdit.getBooleanProperty("view.caretBlink"));
        this.textArea.setElectricScroll(jEdit.getIntegerProperty("view.electricBorders", 0));
        JPopupMenu popup = GUIUtilities.loadPopupMenu("view.context");
        JMenuItem customize = new JMenuItem(jEdit.getProperty("view.context.customize"));
        customize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                new GlobalOptions((Frame)EditPane.this.view, "context");
            }
        });
        popup.addSeparator();
        popup.add(customize);
        this.textArea.setRightClickPopup(popup);
        this.textArea.setQuickCopyEnabled(jEdit.getBooleanProperty("view.middleMousePaste"));
        this.textArea.setDragEnabled(jEdit.getBooleanProperty("view.dragAndDrop"));
        this.textArea.propertiesChanged();
    }

    private void loadBufferSwitcher() {
        if (jEdit.getBooleanProperty("view.showBufferSwitcher")) {
            if (this.bufferSwitcher == null) {
                this.bufferSwitcher = new BufferSwitcher(this);
                if (initBufferSwitcher != null) {
                    try {
                        initBufferSwitcher.invoke(null, this, this.bufferSwitcher);
                    }
                    catch (Exception e) {
                        Log.log(9, this, e);
                    }
                }
                this.add("North", this.bufferSwitcher);
                this.bufferSwitcher.updateBufferList();
                this.revalidate();
            }
        } else if (this.bufferSwitcher != null) {
            this.remove(this.bufferSwitcher);
            this.revalidate();
            this.bufferSwitcher = null;
        }
    }

    private void handleBufferUpdate(BufferUpdate msg) {
        Buffer _buffer = msg.getBuffer();
        if (msg.getWhat() == BufferUpdate.CREATED) {
            if (this.bufferSwitcher != null) {
                this.bufferSwitcher.updateBufferList();
            }
            if (this.buffer.isClosed()) {
                this.setBuffer(jEdit.getFirstBuffer());
                this.recentBuffer = null;
            }
        } else if (msg.getWhat() == BufferUpdate.CLOSED) {
            if (this.bufferSwitcher != null) {
                this.bufferSwitcher.updateBufferList();
            }
            if (_buffer == this.buffer) {
                Buffer newBuffer;
                Buffer buffer = newBuffer = this.recentBuffer != null ? this.recentBuffer : _buffer.getPrev();
                if (newBuffer != null && !newBuffer.isClosed()) {
                    this.setBuffer(newBuffer);
                } else if (jEdit.getBufferCount() != 0) {
                    this.setBuffer(jEdit.getFirstBuffer());
                }
                this.recentBuffer = null;
            } else if (_buffer == this.recentBuffer) {
                this.recentBuffer = null;
            }
        } else if (msg.getWhat() == BufferUpdate.LOAD_STARTED) {
            if (_buffer == this.buffer) {
                this.textArea.setCaretPosition(0);
                this.textArea.getPainter().repaint();
            }
        } else if (msg.getWhat() == BufferUpdate.LOADED) {
            if (_buffer == this.buffer) {
                this.textArea.repaint();
                if (this.bufferSwitcher != null) {
                    this.bufferSwitcher.updateBufferList();
                }
                if (this.view.getEditPane() == this) {
                    StatusBar status = this.view.getStatus();
                    status.updateCaretStatus();
                    status.updateBufferStatus();
                    status.updateMiscStatus();
                }
                this.loadCaretInfo();
            }
        } else if (msg.getWhat() == BufferUpdate.DIRTY_CHANGED) {
            if (_buffer == this.buffer && this.bufferSwitcher != null) {
                if (this.buffer.isDirty()) {
                    this.bufferSwitcher.repaint();
                } else {
                    this.bufferSwitcher.updateBufferList();
                }
            }
        } else if (msg.getWhat() == BufferUpdate.MARKERS_CHANGED) {
            if (_buffer == this.buffer) {
                this.textArea.getGutter().repaint();
            }
        } else if (msg.getWhat() == BufferUpdate.PROPERTIES_CHANGED) {
            if (_buffer == this.buffer) {
                this.textArea.propertiesChanged();
                if (this.view.getEditPane() == this) {
                    this.view.getStatus().updateBufferStatus();
                }
            }
        } else if (msg.getWhat() == BufferUpdate.SAVED && _buffer == this.buffer) {
            this.textArea.propertiesChanged();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        if (OperatingSystem.hasJava14()) {
            try {
                initBufferSwitcher = (class$org$gjt$sp$jedit$Java14 == null ? (class$org$gjt$sp$jedit$Java14 = EditPane.class$("org.gjt.sp.jedit.Java14")) : class$org$gjt$sp$jedit$Java14).getMethod("initBufferSwitcher", class$org$gjt$sp$jedit$EditPane == null ? (class$org$gjt$sp$jedit$EditPane = EditPane.class$("org.gjt.sp.jedit.EditPane")) : class$org$gjt$sp$jedit$EditPane, class$org$gjt$sp$jedit$gui$BufferSwitcher == null ? (class$org$gjt$sp$jedit$gui$BufferSwitcher = EditPane.class$("org.gjt.sp.jedit.gui.BufferSwitcher")) : class$org$gjt$sp$jedit$gui$BufferSwitcher);
            }
            catch (Exception e) {
                Log.log(9, class$org$gjt$sp$jedit$EditPane == null ? (class$org$gjt$sp$jedit$EditPane = EditPane.class$("org.gjt.sp.jedit.EditPane")) : class$org$gjt$sp$jedit$EditPane, e);
            }
        }
    }
}

