/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.ActionSet;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBPlugin;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.JARClassLoader;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.buffer.DummyFoldHandler;
import org.gjt.sp.jedit.buffer.FoldHandler;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.PluginUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.util.Log;

public class PluginJAR {
    private String path;
    private String cachePath;
    private File file;
    private JARClassLoader classLoader;
    private ZipFile zipFile;
    private Properties properties;
    private String[] classes;
    private ActionSet actions;
    private ActionSet browserActions;
    private EditPlugin plugin;
    private URL dockablesURI;
    private URL servicesURI;
    private boolean activated;
    private List theseRequireMe = new LinkedList();
    private List weRequireThese = new LinkedList();
    static /* synthetic */ Class class$org$gjt$sp$jedit$EditPlugin;
    static /* synthetic */ Class class$org$gjt$sp$jedit$PluginJAR;

    public String getPath() {
        return this.path;
    }

    public String getCachePath() {
        return this.cachePath;
    }

    public File getFile() {
        return this.file;
    }

    public JARClassLoader getClassLoader() {
        return this.classLoader;
    }

    public synchronized ZipFile getZipFile() throws IOException {
        if (this.zipFile == null) {
            Log.log(1, this, "Opening " + this.path);
            this.zipFile = new ZipFile(this.path);
        }
        return this.zipFile;
    }

    public ActionSet getActions() {
        return this.getActionSet();
    }

    public ActionSet getActionSet() {
        return this.actions;
    }

    public ActionSet getBrowserActionSet() {
        return this.browserActions;
    }

    public boolean checkDependencies() {
        String dep;
        if (this.plugin == null) {
            return true;
        }
        int i = 0;
        boolean ok = true;
        boolean optional = false;
        String name = this.plugin.getClassName();
        while ((dep = jEdit.getProperty("plugin." + name + ".depend." + i++)) != null) {
            Object[] args;
            int index;
            if (dep.startsWith("optional ")) {
                optional = true;
                dep = dep.substring("optional ".length());
            }
            if ((index = dep.indexOf(32)) == -1) {
                Log.log(9, this, name + " has an invalid" + " dependency: " + dep);
                ok = false;
                continue;
            }
            String what = dep.substring(0, index);
            String arg = dep.substring(index + 1);
            if (what.equals("jdk")) {
                if (optional || MiscUtilities.compareStrings(System.getProperty("java.version"), arg, false) >= 0) continue;
                Object[] args2 = new String[]{arg, System.getProperty("java.version")};
                jEdit.pluginError(this.path, "plugin-error.dep-jdk", args2);
                ok = false;
                continue;
            }
            if (what.equals("jedit")) {
                if (arg.length() != 11) {
                    Log.log(9, this, "Invalid jEdit version number: " + arg);
                    ok = false;
                }
                if (optional || MiscUtilities.compareStrings(jEdit.getBuild(), arg, false) >= 0) continue;
                String needs = MiscUtilities.buildToVersion(arg);
                args = new String[]{needs, jEdit.getVersion()};
                jEdit.pluginError(this.path, "plugin-error.dep-jedit", args);
                ok = false;
                continue;
            }
            if (what.equals("plugin")) {
                Object[] args3;
                int index2 = arg.indexOf(32);
                if (index2 == -1) {
                    Log.log(9, this, name + " has an invalid dependency: " + dep + " (version is missing)");
                    ok = false;
                    continue;
                }
                String pluginName = arg.substring(0, index2);
                String needVersion = arg.substring(index2 + 1);
                String currVersion = jEdit.getProperty("plugin." + pluginName + ".version");
                EditPlugin plugin = jEdit.getPlugin(pluginName);
                if (plugin == null) {
                    if (optional) continue;
                    args3 = new String[]{needVersion, pluginName};
                    jEdit.pluginError(this.path, "plugin-error.dep-plugin.no-version", args3);
                    ok = false;
                    continue;
                }
                if (MiscUtilities.compareStrings(currVersion, needVersion, false) < 0) {
                    if (optional) continue;
                    args3 = new String[]{needVersion, pluginName, currVersion};
                    jEdit.pluginError(this.path, "plugin-error.dep-plugin", args3);
                    ok = false;
                    continue;
                }
                if (plugin instanceof EditPlugin.Broken) {
                    if (optional) continue;
                    args3 = new String[]{pluginName};
                    jEdit.pluginError(this.path, "plugin-error.dep-plugin.broken", args3);
                    ok = false;
                    continue;
                }
                PluginJAR jar = plugin.getPluginJAR();
                jar.theseRequireMe.add(this.path);
                this.weRequireThese.add(jar.getPath());
                continue;
            }
            if (what.equals("class")) {
                if (optional) continue;
                try {
                    this.classLoader.loadClass(arg, false);
                }
                catch (Exception e) {
                    args = new String[]{arg};
                    jEdit.pluginError(this.path, "plugin-error.dep-class", args);
                    ok = false;
                }
                continue;
            }
            Log.log(9, this, name + " has unknown" + " dependency: " + dep);
            ok = false;
        }
        String jars = jEdit.getProperty("plugin." + this.plugin.getClassName() + ".jars");
        if (jars != null) {
            String dir2 = MiscUtilities.getParentOfPath(this.path);
            StringTokenizer st = new StringTokenizer(jars);
            while (st.hasMoreTokens()) {
                String jarPath = MiscUtilities.constructPath(dir2, st.nextToken());
                PluginJAR jar = jEdit.getPluginJAR(jarPath);
                if (jar == null) {
                    Object[] args = new String[]{jarPath};
                    jEdit.pluginError(this.path, "plugin-error.missing-jar", args);
                    ok = false;
                    continue;
                }
                this.weRequireThese.add(jarPath);
                jar.theseRequireMe.add(this.path);
            }
        }
        if (!ok) {
            this.breakPlugin();
        }
        return ok;
    }

    public String[] getDependentPlugins() {
        return this.theseRequireMe.toArray(new String[this.theseRequireMe.size()]);
    }

    public EditPlugin getPlugin() {
        return this.plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activatePlugin() {
        PluginJAR pluginJAR = this;
        synchronized (pluginJAR) {
            if (this.activated) {
                return;
            }
            this.activated = true;
        }
        if (!(this.plugin instanceof EditPlugin.Deferred)) {
            return;
        }
        String className = this.plugin.getClassName();
        try {
            Class clazz = this.classLoader.loadClass(className, false);
            int modifiers = clazz.getModifiers();
            if (Modifier.isInterface(modifiers) || Modifier.isAbstract(modifiers) || !(class$org$gjt$sp$jedit$EditPlugin == null ? (class$org$gjt$sp$jedit$EditPlugin = PluginJAR.class$("org.gjt.sp.jedit.EditPlugin")) : class$org$gjt$sp$jedit$EditPlugin).isAssignableFrom(clazz)) {
                Log.log(9, this, "Plugin has properties but does not extend EditPlugin: " + className);
                this.breakPlugin();
                return;
            }
            this.plugin = (EditPlugin)clazz.newInstance();
            this.plugin.jar = (EditPlugin.JAR)this;
        }
        catch (Throwable t) {
            this.breakPlugin();
            Log.log(9, this, "Error while starting plugin " + className);
            Log.log(9, this, t);
            Object[] args = new String[]{t.toString()};
            jEdit.pluginError(this.path, "plugin-error.start-error", args);
            return;
        }
        if (jEdit.isMainThread() || SwingUtilities.isEventDispatchThread()) {
            this.startPlugin();
        } else {
            this.startPluginLater();
        }
        EditBus.send(new PluginUpdate(this, PluginUpdate.ACTIVATED, false));
    }

    public void activatePluginIfNecessary() {
        if (!(this.plugin instanceof EditPlugin.Deferred) || this.plugin == null) {
            return;
        }
        String className = this.plugin.getClassName();
        String activate = jEdit.getProperty("plugin." + className + ".activate");
        if (activate == null) {
            if (!jEdit.isMainThread()) {
                this.breakPlugin();
                jEdit.pluginError(this.path, "plugin-error.not-42", null);
            } else {
                this.activatePlugin();
            }
        } else {
            boolean load = false;
            StringTokenizer st = new StringTokenizer(activate);
            while (st.hasMoreTokens()) {
                String prop = st.nextToken();
                boolean value = jEdit.getBooleanProperty(prop);
                if (!value) continue;
                Log.log(1, this, "Activating " + className + " because of " + prop);
                load = true;
                break;
            }
            if (load) {
                this.activatePlugin();
            }
        }
    }

    public void deactivatePlugin(boolean exit) {
        if (!this.activated) {
            return;
        }
        if (!exit) {
            for (Buffer buffer = jEdit.getFirstBuffer(); buffer != null; buffer = buffer.getNext()) {
                if (buffer.getFoldHandler() == null || buffer.getFoldHandler().getClass().getClassLoader() != this.classLoader) continue;
                buffer.setFoldHandler(new DummyFoldHandler());
            }
        }
        if (this.plugin != null && !(this.plugin instanceof EditPlugin.Broken)) {
            String activate;
            if (this.plugin instanceof EBPlugin) {
                EditBus.removeFromBus((EBPlugin)this.plugin);
            }
            try {
                this.plugin.stop();
            }
            catch (Throwable t) {
                Log.log(9, this, "Error while stopping plugin:");
                Log.log(9, this, t);
            }
            this.plugin = new EditPlugin.Deferred(this.plugin.getClassName());
            this.plugin.jar = (EditPlugin.JAR)this;
            EditBus.send(new PluginUpdate(this, PluginUpdate.DEACTIVATED, exit));
            if (!exit && (activate = jEdit.getProperty("plugin." + this.plugin.getClassName() + ".activate")) == null) {
                this.breakPlugin();
                jEdit.pluginError(this.path, "plugin-error.not-42", null);
            }
        }
        this.activated = false;
    }

    public URL getDockablesURI() {
        return this.dockablesURI;
    }

    public URL getServicesURI() {
        return this.servicesURI;
    }

    public String toString() {
        if (this.plugin == null) {
            return this.path;
        }
        return this.path + ",class=" + this.plugin.getClassName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static PluginCacheEntry getPluginCache(PluginJAR plugin) {
        FilterInputStream din;
        block19: {
            String jarCachePath = plugin.getCachePath();
            if (jarCachePath == null) {
                return null;
            }
            din = null;
            PluginCacheEntry cache = new PluginCacheEntry();
            cache.plugin = plugin;
            cache.modTime = plugin.getFile().lastModified();
            din = new DataInputStream(new BufferedInputStream(new FileInputStream(jarCachePath)));
            if (!cache.read((DataInputStream)din)) break block19;
            PluginCacheEntry pluginCacheEntry = cache;
            Object var6_10 = null;
            try {
                if (din != null) {
                    din.close();
                }
            }
            catch (IOException io2) {
                Log.log(9, class$org$gjt$sp$jedit$PluginJAR == null ? (class$org$gjt$sp$jedit$PluginJAR = PluginJAR.class$("org.gjt.sp.jedit.PluginJAR")) : class$org$gjt$sp$jedit$PluginJAR, io2);
            }
            return pluginCacheEntry;
        }
        PluginCacheEntry pluginCacheEntry = null;
        Object var6_11 = null;
        try {
            if (din != null) {
                din.close();
            }
        }
        catch (IOException io2) {
            Log.log(9, class$org$gjt$sp$jedit$PluginJAR == null ? (class$org$gjt$sp$jedit$PluginJAR = PluginJAR.class$("org.gjt.sp.jedit.PluginJAR")) : class$org$gjt$sp$jedit$PluginJAR, io2);
        }
        return pluginCacheEntry;
        catch (FileNotFoundException fnf) {
            PluginCacheEntry pluginCacheEntry2 = null;
            Object var6_12 = null;
            try {
                if (din != null) {
                    din.close();
                }
            }
            catch (IOException io2) {
                Log.log(9, class$org$gjt$sp$jedit$PluginJAR == null ? (class$org$gjt$sp$jedit$PluginJAR = PluginJAR.class$("org.gjt.sp.jedit.PluginJAR")) : class$org$gjt$sp$jedit$PluginJAR, io2);
            }
            return pluginCacheEntry2;
        }
        catch (IOException io) {
            Log.log(9, class$org$gjt$sp$jedit$PluginJAR == null ? (class$org$gjt$sp$jedit$PluginJAR = PluginJAR.class$("org.gjt.sp.jedit.PluginJAR")) : class$org$gjt$sp$jedit$PluginJAR, io);
            PluginCacheEntry pluginCacheEntry3 = null;
            Object var6_13 = null;
            {
                catch (Throwable throwable) {
                    Object var6_14 = null;
                    try {
                        if (din != null) {
                            din.close();
                        }
                    }
                    catch (IOException io2) {
                        Log.log(9, class$org$gjt$sp$jedit$PluginJAR == null ? (class$org$gjt$sp$jedit$PluginJAR = PluginJAR.class$("org.gjt.sp.jedit.PluginJAR")) : class$org$gjt$sp$jedit$PluginJAR, io2);
                    }
                    throw throwable;
                }
            }
            try {
                if (din != null) {
                    din.close();
                }
            }
            catch (IOException io2) {
                Log.log(9, class$org$gjt$sp$jedit$PluginJAR == null ? (class$org$gjt$sp$jedit$PluginJAR = PluginJAR.class$("org.gjt.sp.jedit.PluginJAR")) : class$org$gjt$sp$jedit$PluginJAR, io2);
            }
            return pluginCacheEntry3;
        }
    }

    static void setPluginCache(PluginJAR plugin, PluginCacheEntry cache) {
        String jarCachePath = plugin.getCachePath();
        if (jarCachePath == null) {
            return;
        }
        Log.log(1, class$org$gjt$sp$jedit$PluginJAR == null ? (class$org$gjt$sp$jedit$PluginJAR = PluginJAR.class$("org.gjt.sp.jedit.PluginJAR")) : class$org$gjt$sp$jedit$PluginJAR, "Writing " + jarCachePath);
        DataOutputStream dout = null;
        try {
            dout = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(jarCachePath)));
            cache.write(dout);
            dout.close();
        }
        catch (IOException io) {
            Log.log(9, class$org$gjt$sp$jedit$PluginJAR == null ? (class$org$gjt$sp$jedit$PluginJAR = PluginJAR.class$("org.gjt.sp.jedit.PluginJAR")) : class$org$gjt$sp$jedit$PluginJAR, io);
            try {
                if (dout != null) {
                    dout.close();
                }
            }
            catch (IOException io2) {
                Log.log(9, class$org$gjt$sp$jedit$PluginJAR == null ? (class$org$gjt$sp$jedit$PluginJAR = PluginJAR.class$("org.gjt.sp.jedit.PluginJAR")) : class$org$gjt$sp$jedit$PluginJAR, io2);
            }
            new File(jarCachePath).delete();
        }
    }

    PluginJAR(File file) {
        this.path = file.getPath();
        String jarCacheDir = jEdit.getJARCacheDirectory();
        if (jarCacheDir != null) {
            this.cachePath = MiscUtilities.constructPath(jarCacheDir, file.getName() + ".summary");
        }
        this.file = file;
        this.classLoader = new JARClassLoader(this);
        this.actions = new ActionSet();
    }

    void init() {
        boolean initialized = false;
        PluginCacheEntry cache = PluginJAR.getPluginCache(this);
        if (cache != null) {
            this.loadCache(cache);
            this.classLoader.activate();
            initialized = true;
        } else {
            try {
                cache = this.generateCache();
                if (cache != null) {
                    PluginJAR.setPluginCache(this, cache);
                    this.classLoader.activate();
                    initialized = true;
                }
            }
            catch (IOException io) {
                Log.log(9, this, "Cannot load plugin " + this.path);
                Log.log(9, this, io);
                Object[] args = new String[]{io.toString()};
                jEdit.pluginError(this.path, "plugin-error.load-error", args);
                this.uninit(false);
            }
        }
    }

    void uninit(boolean exit) {
        this.deactivatePlugin(exit);
        if (!exit) {
            Iterator iter = this.weRequireThese.iterator();
            while (iter.hasNext()) {
                String path = (String)iter.next();
                PluginJAR jar = jEdit.getPluginJAR(path);
                if (jar == null) continue;
                jar.theseRequireMe.remove(this.path);
            }
            this.classLoader.deactivate();
            BeanShell.resetClassManager();
            if (this.actions != null) {
                jEdit.getActionContext().removeActionSet(this.actions);
            }
            if (this.browserActions != null) {
                VFSBrowser.getActionContext().removeActionSet(this.browserActions);
            }
            DockableWindowManager.unloadDockableWindows(this);
            ServiceManager.unloadServices(this);
            jEdit.removePluginProps(this.properties);
            try {
                if (this.zipFile != null) {
                    this.zipFile.close();
                    this.zipFile = null;
                }
            }
            catch (IOException io) {
                Log.log(9, this, io);
            }
        }
    }

    String[] getClasses() {
        return this.classes;
    }

    private void actionsPresentButNotCoreClass() {
        Log.log(7, this, this.getPath() + " has an actions.xml but no plugin core class");
        this.actions.setLabel("MISSING PLUGIN CORE CLASS");
    }

    private void loadCache(PluginCacheEntry cache) {
        this.classes = cache.classes;
        if (cache.cachedProperties != null) {
            this.properties = cache.cachedProperties;
            jEdit.addPluginProps(cache.cachedProperties);
        }
        if (cache.actionsURI != null && cache.cachedActionNames != null) {
            this.actions = new ActionSet(this, cache.cachedActionNames, cache.cachedActionToggleFlags, cache.actionsURI);
        }
        if (cache.browserActionsURI != null && cache.cachedBrowserActionNames != null) {
            this.browserActions = new ActionSet(this, cache.cachedBrowserActionNames, cache.cachedBrowserActionToggleFlags, cache.browserActionsURI);
            VFSBrowser.getActionContext().addActionSet(this.browserActions);
        }
        if (cache.dockablesURI != null && cache.cachedDockableNames != null && cache.cachedDockableActionFlags != null) {
            this.dockablesURI = cache.dockablesURI;
            DockableWindowManager.cacheDockableWindows(this, cache.cachedDockableNames, cache.cachedDockableActionFlags);
        }
        if (this.actions.size() != 0) {
            jEdit.addActionSet(this.actions);
        }
        if (cache.servicesURI != null && cache.cachedServices != null) {
            this.servicesURI = cache.servicesURI;
            for (int i = 0; i < cache.cachedServices.length; ++i) {
                ServiceManager.Descriptor d = cache.cachedServices[i];
                ServiceManager.registerService(d);
            }
        }
        if (cache.pluginClass != null) {
            if (jEdit.getPlugin(cache.pluginClass) != null) {
                jEdit.pluginError(this.path, "plugin-error.already-loaded", null);
                this.uninit(false);
            } else {
                String label = jEdit.getProperty("plugin." + cache.pluginClass + ".name");
                this.actions.setLabel(jEdit.getProperty("action-set.plugin", new String[]{label}));
                this.plugin = new EditPlugin.Deferred(cache.pluginClass);
                this.plugin.jar = (EditPlugin.JAR)this;
            }
        } else if (this.actions.size() != 0) {
            this.actionsPresentButNotCoreClass();
        }
    }

    private PluginCacheEntry generateCache() throws IOException {
        this.properties = new Properties();
        LinkedList<String> classes = new LinkedList<String>();
        ZipFile zipFile = this.getZipFile();
        LinkedList<String> plugins = new LinkedList<String>();
        PluginCacheEntry cache = new PluginCacheEntry();
        cache.modTime = this.file.lastModified();
        cache.cachedProperties = new Properties();
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            String lname = name.toLowerCase();
            if (lname.equals("actions.xml")) {
                cache.actionsURI = this.classLoader.getResource(name);
                continue;
            }
            if (lname.equals("browser.actions.xml")) {
                cache.browserActionsURI = this.classLoader.getResource(name);
                continue;
            }
            if (lname.equals("dockables.xml")) {
                cache.dockablesURI = this.dockablesURI = this.classLoader.getResource(name);
                continue;
            }
            if (lname.equals("services.xml")) {
                cache.servicesURI = this.servicesURI = this.classLoader.getResource(name);
                continue;
            }
            if (lname.endsWith(".props")) {
                InputStream in = this.classLoader.getResourceAsStream(name);
                this.properties.load(in);
                in.close();
                continue;
            }
            if (!name.endsWith(".class")) continue;
            String className = MiscUtilities.fileToClass(name);
            if (className.endsWith("Plugin")) {
                plugins.add(className);
            }
            classes.add(className);
        }
        cache.cachedProperties = this.properties;
        jEdit.addPluginProps(this.properties);
        cache.classes = classes.toArray(new String[classes.size()]);
        this.classes = cache.classes;
        String label = null;
        Iterator iter = plugins.iterator();
        while (iter.hasNext()) {
            String className = (String)iter.next();
            String _label = jEdit.getProperty("plugin." + className + ".name");
            String version = jEdit.getProperty("plugin." + className + ".version");
            if (_label == null || version == null) {
                Log.log(7, this, "Ignoring: " + className);
                continue;
            }
            cache.pluginClass = className;
            if (jEdit.getPlugin(className) != null) {
                jEdit.pluginError(this.path, "plugin-error.already-loaded", null);
                return null;
            }
            this.plugin = new EditPlugin.Deferred(className);
            this.plugin.jar = (EditPlugin.JAR)this;
            label = _label;
            break;
        }
        if (cache.actionsURI != null) {
            this.actions = new ActionSet(this, null, null, cache.actionsURI);
            this.actions.load();
            cache.cachedActionNames = this.actions.getCacheableActionNames();
            cache.cachedActionToggleFlags = new boolean[cache.cachedActionNames.length];
            for (int i = 0; i < cache.cachedActionNames.length; ++i) {
                cache.cachedActionToggleFlags[i] = jEdit.getBooleanProperty(cache.cachedActionNames[i] + ".toggle");
            }
        }
        if (cache.browserActionsURI != null) {
            this.browserActions = new ActionSet(this, null, null, cache.browserActionsURI);
            this.browserActions.load();
            VFSBrowser.getActionContext().addActionSet(this.browserActions);
            cache.cachedBrowserActionNames = this.browserActions.getCacheableActionNames();
            cache.cachedBrowserActionToggleFlags = new boolean[cache.cachedBrowserActionNames.length];
            for (int i = 0; i < cache.cachedBrowserActionNames.length; ++i) {
                cache.cachedBrowserActionToggleFlags[i] = jEdit.getBooleanProperty(cache.cachedBrowserActionNames[i] + ".toggle");
            }
        }
        if (this.dockablesURI != null) {
            DockableWindowManager.loadDockableWindows(this, this.dockablesURI, cache);
        }
        if (this.actions.size() != 0) {
            if (label != null) {
                this.actions.setLabel(jEdit.getProperty("action-set.plugin", new String[]{label}));
            } else {
                this.actionsPresentButNotCoreClass();
            }
            jEdit.addActionSet(this.actions);
        }
        if (this.servicesURI != null) {
            ServiceManager.loadServices(this, this.servicesURI, cache);
        }
        return cache;
    }

    private void startPlugin() {
        try {
            this.plugin.start();
        }
        catch (Throwable t) {
            this.breakPlugin();
            Log.log(9, this, "Error while starting plugin " + this.plugin.getClassName());
            Log.log(9, this, t);
            Object[] args = new String[]{t.toString()};
            jEdit.pluginError(this.path, "plugin-error.start-error", args);
        }
        if (this.plugin instanceof EBPlugin) {
            if (jEdit.getProperty("plugin." + this.plugin.getClassName() + ".activate") == null) {
                ((EBComponent)((Object)this.plugin)).handleMessage(new PropertiesChanged(null));
            }
            EditBus.addToBus((EBPlugin)this.plugin);
        }
        for (Buffer buffer = jEdit.getFirstBuffer(); buffer != null; buffer = buffer.getNext()) {
            FoldHandler handler = FoldHandler.getFoldHandler(buffer.getStringProperty("folding"));
            if (buffer.getFoldHandler() == null || handler == null || handler == buffer.getFoldHandler()) continue;
            buffer.setFoldHandler(handler);
        }
    }

    private void startPluginLater() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (!PluginJAR.this.activated) {
                    return;
                }
                PluginJAR.this.startPlugin();
            }
        });
    }

    private void breakPlugin() {
        this.plugin = new EditPlugin.Broken(this.plugin.getClassName());
        this.plugin.jar = (EditPlugin.JAR)this;
        this.uninit(false);
        jEdit.addPluginProps(this.properties);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class PluginCacheEntry {
        public static final int MAGIC = -1214061536;
        public PluginJAR plugin;
        public long modTime;
        public String[] classes;
        public URL actionsURI;
        public String[] cachedActionNames;
        public boolean[] cachedActionToggleFlags;
        public URL browserActionsURI;
        public String[] cachedBrowserActionNames;
        public boolean[] cachedBrowserActionToggleFlags;
        public URL dockablesURI;
        public String[] cachedDockableNames;
        public boolean[] cachedDockableActionFlags;
        public URL servicesURI;
        public ServiceManager.Descriptor[] cachedServices;
        public Properties cachedProperties;
        public String pluginClass;

        public boolean read(DataInputStream din) throws IOException {
            int cacheMagic = din.readInt();
            if (cacheMagic != -1214061536) {
                return false;
            }
            String cacheBuild = this.readString(din);
            if (!cacheBuild.equals(jEdit.getBuild())) {
                return false;
            }
            long cacheModTime = din.readLong();
            if (cacheModTime != this.modTime) {
                return false;
            }
            this.actionsURI = this.readURI(din);
            this.cachedActionNames = this.readStringArray(din);
            this.cachedActionToggleFlags = this.readBooleanArray(din);
            this.browserActionsURI = this.readURI(din);
            this.cachedBrowserActionNames = this.readStringArray(din);
            this.cachedBrowserActionToggleFlags = this.readBooleanArray(din);
            this.dockablesURI = this.readURI(din);
            this.cachedDockableNames = this.readStringArray(din);
            this.cachedDockableActionFlags = this.readBooleanArray(din);
            this.servicesURI = this.readURI(din);
            int len = din.readInt();
            if (len == 0) {
                this.cachedServices = null;
            } else {
                this.cachedServices = new ServiceManager.Descriptor[len];
                for (int i = 0; i < len; ++i) {
                    ServiceManager.Descriptor d;
                    this.cachedServices[i] = d = new ServiceManager.Descriptor(this.readString(din), this.readString(din), null, this.plugin);
                }
            }
            this.classes = this.readStringArray(din);
            this.cachedProperties = this.readMap(din);
            this.pluginClass = this.readString(din);
            return true;
        }

        public void write(DataOutputStream dout) throws IOException {
            dout.writeInt(-1214061536);
            this.writeString(dout, jEdit.getBuild());
            dout.writeLong(this.modTime);
            this.writeString(dout, this.actionsURI);
            this.writeStringArray(dout, this.cachedActionNames);
            this.writeBooleanArray(dout, this.cachedActionToggleFlags);
            this.writeString(dout, this.browserActionsURI);
            this.writeStringArray(dout, this.cachedBrowserActionNames);
            this.writeBooleanArray(dout, this.cachedBrowserActionToggleFlags);
            this.writeString(dout, this.dockablesURI);
            this.writeStringArray(dout, this.cachedDockableNames);
            this.writeBooleanArray(dout, this.cachedDockableActionFlags);
            this.writeString(dout, this.servicesURI);
            if (this.cachedServices == null) {
                dout.writeInt(0);
            } else {
                dout.writeInt(this.cachedServices.length);
                for (int i = 0; i < this.cachedServices.length; ++i) {
                    this.writeString(dout, this.cachedServices[i].clazz);
                    this.writeString(dout, this.cachedServices[i].name);
                }
            }
            this.writeStringArray(dout, this.classes);
            this.writeMap(dout, this.cachedProperties);
            this.writeString(dout, this.pluginClass);
        }

        private String readString(DataInputStream din) throws IOException {
            int len = din.readInt();
            if (len == 0) {
                return null;
            }
            char[] str = new char[len];
            for (int i = 0; i < len; ++i) {
                str[i] = din.readChar();
            }
            return new String(str);
        }

        private URL readURI(DataInputStream din) throws IOException {
            String str = this.readString(din);
            if (str == null) {
                return null;
            }
            return new URL(str);
        }

        private String[] readStringArray(DataInputStream din) throws IOException {
            int len = din.readInt();
            if (len == 0) {
                return null;
            }
            String[] str = new String[len];
            for (int i = 0; i < len; ++i) {
                str[i] = this.readString(din);
            }
            return str;
        }

        private boolean[] readBooleanArray(DataInputStream din) throws IOException {
            int len = din.readInt();
            if (len == 0) {
                return null;
            }
            boolean[] bools = new boolean[len];
            for (int i = 0; i < len; ++i) {
                bools[i] = din.readBoolean();
            }
            return bools;
        }

        private Properties readMap(DataInputStream din) throws IOException {
            Properties returnValue = new Properties();
            int count = din.readInt();
            for (int i = 0; i < count; ++i) {
                String key = this.readString(din);
                String value = this.readString(din);
                if (value == null) {
                    value = "";
                }
                returnValue.put(key, value);
            }
            return returnValue;
        }

        private void writeString(DataOutputStream dout, Object obj) throws IOException {
            if (obj == null) {
                dout.writeInt(0);
            } else {
                String str = obj.toString();
                dout.writeInt(str.length());
                dout.writeChars(str);
            }
        }

        private void writeStringArray(DataOutputStream dout, String[] str) throws IOException {
            if (str == null) {
                dout.writeInt(0);
            } else {
                dout.writeInt(str.length);
                for (int i = 0; i < str.length; ++i) {
                    this.writeString(dout, str[i]);
                }
            }
        }

        private void writeBooleanArray(DataOutputStream dout, boolean[] bools) throws IOException {
            if (bools == null) {
                dout.writeInt(0);
            } else {
                dout.writeInt(bools.length);
                for (int i = 0; i < bools.length; ++i) {
                    dout.writeBoolean(bools[i]);
                }
            }
        }

        private void writeMap(DataOutputStream dout, Map map) throws IOException {
            dout.writeInt(map.size());
            Iterator iter = map.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                this.writeString(dout, key);
                this.writeString(dout, map.get(key));
            }
        }
    }
}

