/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.buffer;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.Marker;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.IntegerArray;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.SegmentBuffer;
import org.gjt.sp.util.WorkRequest;
import org.gjt.sp.util.WorkThread;

public class BufferIORequest
extends WorkRequest {
    public static final int IOBUFSIZE = 32768;
    public static final int PROGRESS_INTERVAL = 300;
    public static final String LOAD_DATA = "BufferIORequest__loadData";
    public static final String END_OFFSETS = "BufferIORequest__endOffsets";
    public static final String NEW_PATH = "BufferIORequest__newPath";
    public static final String ERROR_OCCURRED = "BufferIORequest__error";
    public static final int LOAD = 0;
    public static final int SAVE = 1;
    public static final int AUTOSAVE = 2;
    public static final int INSERT = 3;
    public static final int GZIP_MAGIC_1 = 31;
    public static final int GZIP_MAGIC_2 = 139;
    public static final int UNICODE_MAGIC_1 = 254;
    public static final int UNICODE_MAGIC_2 = 255;
    public static final int UTF8_MAGIC_1 = 239;
    public static final int UTF8_MAGIC_2 = 187;
    public static final int UTF8_MAGIC_3 = 191;
    public static final int XML_PI_LENGTH = 50;
    private int type;
    private View view;
    private Buffer buffer;
    private Object session;
    private VFS vfs;
    private String path;
    private String markersPath;

    public BufferIORequest(int type, View view, Buffer buffer, Object session, VFS vfs, String path) {
        this.type = type;
        this.view = view;
        this.buffer = buffer;
        this.session = session;
        this.vfs = vfs;
        this.path = path;
        this.markersPath = vfs.getParentOfPath(path) + '.' + vfs.getFileName(path) + ".marks";
    }

    public void run() {
        switch (this.type) {
            case 0: {
                this.load();
                break;
            }
            case 1: {
                this.save();
                break;
            }
            case 2: {
                this.autosave();
                break;
            }
            case 3: {
                this.insert();
                break;
            }
            default: {
                throw new InternalError();
            }
        }
    }

    public String toString() {
        String typeString;
        switch (this.type) {
            case 0: {
                typeString = "LOAD";
                break;
            }
            case 1: {
                typeString = "SAVE";
                break;
            }
            case 2: {
                typeString = "AUTOSAVE";
                break;
            }
            default: {
                typeString = "UNKNOWN!!!";
            }
        }
        return this.getClass().getName() + "[type=" + typeString + ",buffer=" + this.buffer + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void load() {
        in = null;
        try {
            block30: {
                try {
                    args = new String[]{this.vfs.getFileName(this.path)};
                    this.setAbortable(true);
                    if (!this.buffer.isTemporary()) {
                        this.setStatus(jEdit.getProperty("vfs.status.load", args));
                        this.setProgressValue(0);
                    }
                    this.path = this.vfs._canonPath(this.session, this.path, this.view);
                    entry = this.vfs._getDirectoryEntry(this.session, this.path, this.view);
                    length = entry != null ? entry.length : 0L;
                    in = this.vfs._createInputStream(this.session, this.path, false, this.view);
                    if (in == null) {
                    }
                    ** GOTO lbl-1000
                }
                catch (CharConversionException ch) {
                    Log.log(9, this, ch);
                    pp = new Object[]{this.buffer.getProperty("encoding"), ch.toString()};
                    VFSManager.error(this.view, this.path, "ioerror.encoding-error", pp);
                    this.buffer.setBooleanProperty("BufferIORequest__error", true);
                    break block30;
                }
                catch (UnsupportedEncodingException uu) {
                    Log.log(9, this, uu);
                    pp = new Object[]{this.buffer.getProperty("encoding"), uu.toString()};
                    VFSManager.error(this.view, this.path, "ioerror.encoding-error", pp);
                    this.buffer.setBooleanProperty("BufferIORequest__error", true);
                    break block30;
                }
                catch (IOException io) {
                    Log.log(9, this, io);
                    pp = new Object[]{io.toString()};
                    VFSManager.error(this.view, this.path, "ioerror.read-error", pp);
                    this.buffer.setBooleanProperty("BufferIORequest__error", true);
                    break block30;
                }
                catch (OutOfMemoryError oom) {
                    Log.log(9, this, oom);
                    VFSManager.error(this.view, this.path, "out-of-memory-error", null);
                    this.buffer.setBooleanProperty("BufferIORequest__error", true);
                    break block30;
                }
                var7_12 = null;
                ** GOTO lbl98
lbl-1000:
                // 1 sources

                {
                    this.read(this.autodetect(in), length, false);
                    this.buffer.setNewFile(false);
                }
            }
            if (!jEdit.getBooleanProperty("persistentMarkers")) ** GOTO lbl110
            try {
                args = new String[]{this.vfs.getFileName(this.path)};
                if (!this.buffer.isTemporary()) {
                    this.setStatus(jEdit.getProperty("vfs.status.load-markers", args));
                }
                this.setAbortable(true);
                in = this.vfs._createInputStream(this.session, this.markersPath, true, this.view);
                if (in != null) {
                    this.readMarkers(this.buffer, in);
                }
                ** GOTO lbl110
            }
            catch (IOException io) {
            }
            ** GOTO lbl110
        }
        catch (WorkThread.Abort a) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException var3_10) {
                    // empty catch block
                }
            }
            this.buffer.setBooleanProperty("BufferIORequest__error", true);
            var7_14 = null;
            try {
                this.vfs._endVFSSession(this.session, this.view);
                return;
            }
            catch (IOException io) {
                Log.log(9, this, io);
                pp = new String[]{io.toString()};
                VFSManager.error(this.view, this.path, "ioerror.read-error", pp);
                this.buffer.setBooleanProperty("BufferIORequest__error", true);
                return;
            }
            catch (WorkThread.Abort a) {
                this.buffer.setBooleanProperty("BufferIORequest__error", true);
                return;
            }
        }
        {
            catch (Throwable var6_28) {
                var7_15 = null;
                ** try [egrp 6[TRYBLOCK] [16, 17 : 495->513)] { 
lbl87:
                // 1 sources

                this.vfs._endVFSSession(this.session, this.view);
                throw var6_28;
lbl89:
                // 1 sources

                catch (IOException io) {
                    Log.log(9, this, io);
                    pp = new String[]{io.toString()};
                    VFSManager.error(this.view, this.path, "ioerror.read-error", pp);
                    this.buffer.setBooleanProperty("BufferIORequest__error", true);
                    throw var6_28;
                }
lbl95:
                // 1 sources

                catch (WorkThread.Abort a) {
                    this.buffer.setBooleanProperty("BufferIORequest__error", true);
                }
                throw var6_28;
            }
lbl98:
            // 1 sources

            ** try [egrp 6[TRYBLOCK] [16, 17 : 495->513)] { 
lbl99:
            // 1 sources

            this.vfs._endVFSSession(this.session, this.view);
            return;
lbl101:
            // 1 sources

            catch (IOException io) {
                Log.log(9, this, io);
                pp = new String[]{io.toString()};
                VFSManager.error(this.view, this.path, "ioerror.read-error", pp);
                this.buffer.setBooleanProperty("BufferIORequest__error", true);
                return;
            }
lbl107:
            // 1 sources

            catch (WorkThread.Abort a) {
                this.buffer.setBooleanProperty("BufferIORequest__error", true);
                return;
            }
lbl110:
            // 4 sources

            var7_13 = null;
            ** try [egrp 6[TRYBLOCK] [16, 17 : 495->513)] { 
lbl112:
            // 1 sources

            this.vfs._endVFSSession(this.session, this.view);
            return;
lbl114:
            // 1 sources

            catch (IOException io) {
                Log.log(9, this, io);
                pp = new String[]{io.toString()};
                VFSManager.error(this.view, this.path, "ioerror.read-error", pp);
                this.buffer.setBooleanProperty("BufferIORequest__error", true);
                return;
            }
lbl120:
            // 1 sources

            catch (WorkThread.Abort a) {}
            this.buffer.setBooleanProperty("BufferIORequest__error", true);
            return;
        }
    }

    private Reader autodetect(InputStream in) throws IOException {
        in = new BufferedInputStream(in);
        String encoding = this.buffer.getStringProperty("encoding");
        if (!in.markSupported()) {
            Log.log(7, this, "Mark not supported: " + in);
        } else if (this.buffer.getBooleanProperty("encodingAutodetect")) {
            in.mark(50);
            int b1 = in.read();
            int b2 = in.read();
            int b3 = in.read();
            if (encoding.equals("UTF-8Y")) {
                if (b1 != 239 || b2 != 187 || b3 != 191) {
                    in.reset();
                }
                encoding = "UTF-8";
            } else {
                if (b1 == 31 && b2 == 139) {
                    in.reset();
                    in = new GZIPInputStream(in);
                    this.buffer.setBooleanProperty("gzipped", true);
                    return this.autodetect(in);
                }
                if (b1 == 254 && b2 == 255 || b1 == 255 && b2 == 254) {
                    in.reset();
                    encoding = "UTF-16";
                    this.buffer.setProperty("encoding", encoding);
                } else if (b1 == 239 && b2 == 187 && b3 == 191) {
                    this.buffer.setProperty("encoding", "UTF-8Y");
                    encoding = "UTF-8";
                } else {
                    int index;
                    int count;
                    in.reset();
                    byte[] _xmlPI = new byte[50];
                    int offset = 0;
                    while ((count = in.read(_xmlPI, offset, 50 - offset)) != -1 && (offset += count) != 50) {
                    }
                    String xmlPI = new String(_xmlPI, 0, offset, "ASCII");
                    if (xmlPI.startsWith("<?xml") && (index = xmlPI.indexOf("encoding=")) != -1 && index + 9 != xmlPI.length()) {
                        char ch = xmlPI.charAt(index + 9);
                        int endIndex = xmlPI.indexOf(ch, index + 10);
                        encoding = xmlPI.substring(index + 10, endIndex);
                        if (MiscUtilities.isSupportedEncoding(encoding)) {
                            this.buffer.setProperty("encoding", encoding);
                        } else {
                            Log.log(7, this, "XML PI specifies unsupported encoding: " + encoding);
                        }
                    }
                    in.reset();
                }
            }
        }
        return new InputStreamReader(in, encoding);
    }

    private SegmentBuffer read(Reader in, long length, boolean insert) throws IOException {
        char ch;
        int len;
        boolean trackProgress;
        IntegerArray endOffsets = new IntegerArray(Math.max(1, (int)(length / 50L)));
        boolean bl = trackProgress = !this.buffer.isTemporary() && length != 0L;
        if (trackProgress) {
            this.setProgressValue(0);
            this.setProgressMaximum((int)length);
        }
        if (length == 0L) {
            length = 32768L;
        }
        SegmentBuffer seg = new SegmentBuffer((int)length + 1);
        char[] buf = new char[32768];
        boolean CRLF = false;
        boolean CROnly = false;
        boolean lastWasCR = false;
        int lineCount = 0;
        while ((len = in.read(buf, 0, buf.length)) != -1) {
            int lastLine = 0;
            block5: for (int i = 0; i < len; ++i) {
                switch (buf[i]) {
                    case '\r': {
                        if (lastWasCR) {
                            CROnly = true;
                            CRLF = false;
                        } else {
                            lastWasCR = true;
                        }
                        seg.append(buf, lastLine, i - lastLine);
                        seg.append('\n');
                        endOffsets.add(seg.count);
                        if (trackProgress && lineCount++ % 300 == 0) {
                            this.setProgressValue(seg.count);
                        }
                        lastLine = i + 1;
                        continue block5;
                    }
                    case '\n': {
                        if (lastWasCR) {
                            CROnly = false;
                            CRLF = true;
                            lastWasCR = false;
                            lastLine = i + 1;
                            continue block5;
                        }
                        CROnly = false;
                        CRLF = false;
                        seg.append(buf, lastLine, i - lastLine);
                        seg.append('\n');
                        endOffsets.add(seg.count);
                        if (trackProgress && lineCount++ % 300 == 0) {
                            this.setProgressValue(seg.count);
                        }
                        lastLine = i + 1;
                        continue block5;
                    }
                    default: {
                        if (!lastWasCR) continue block5;
                        CROnly = true;
                        CRLF = false;
                        lastWasCR = false;
                    }
                }
            }
            if (trackProgress) {
                this.setProgressValue(seg.count);
            }
            seg.append(buf, lastLine, len - lastLine);
        }
        this.setAbortable(false);
        String lineSeparator = seg.count == 0 ? jEdit.getProperty("buffer.lineSeparator", System.getProperty("line.separator")) : (CRLF ? "\r\n" : (CROnly ? "\r" : "\n"));
        in.close();
        int bufferLength = seg.count--;
        if (bufferLength == 0 || (ch = seg.array[bufferLength - 1]) == '\u001a') {
            // empty if block
        }
        this.buffer.setBooleanProperty("trailingEOL", false);
        if (bufferLength != 0 && jEdit.getBooleanProperty("stripTrailingEOL") && (ch = seg.array[bufferLength - 1]) == '\n') {
            this.buffer.setBooleanProperty("trailingEOL", true);
            --seg.count;
            endOffsets.setSize(endOffsets.getSize() - 1);
        }
        endOffsets.add(seg.count + 1);
        if (!insert) {
            this.buffer.setProperty(LOAD_DATA, seg);
            this.buffer.setProperty(END_OFFSETS, endOffsets);
            this.buffer.setProperty(NEW_PATH, this.path);
            if (lineSeparator != null) {
                this.buffer.setProperty("lineSeparator", lineSeparator);
            }
        }
        return seg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readMarkers(Buffer buffer, InputStream _in) throws IOException {
        buffer.removeAllMarkers();
        BufferedReader in = new BufferedReader(new InputStreamReader(_in));
        try {
            String line;
            while ((line = in.readLine()) != null) {
                if (!line.startsWith("!")) continue;
                char shortcut = line.charAt(1);
                int start = line.indexOf(59);
                int end = line.indexOf(59, start + 1);
                int position = Integer.parseInt(line.substring(start + 1, end));
                buffer.addMarker(shortcut, position);
            }
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void save() {
        block33: {
            OutputStream out = null;
            Object[] args = new String[]{this.vfs.getFileName(this.path)};
            this.setStatus(jEdit.getProperty("vfs.status.save", args));
            this.setAbortable(true);
            this.path = this.vfs._canonPath(this.session, this.path, this.view);
            if (!MiscUtilities.isURL(this.path)) {
                this.path = MiscUtilities.resolveSymlinks(this.path);
            }
            if (this.buffer.getProperty("Buffer__backedUp") == null || jEdit.getBooleanProperty("backupEverySave")) {
                this.vfs._backup(this.session, this.path, this.view);
                this.buffer.setBooleanProperty("Buffer__backedUp", true);
            }
            boolean twoStageSave = (this.vfs.getCapabilities() & 0x10) != 0 && jEdit.getBooleanProperty("twoStageSave");
            String savePath = twoStageSave ? this.vfs.getTwoStageSaveName(this.path) : this.path;
            out = this.vfs._createOutputStream(this.session, savePath, this.view);
            try {
                this.buffer.readLock();
                if (out != null) {
                    if (savePath.endsWith(".gz")) {
                        this.buffer.setBooleanProperty("gzipped", true);
                    }
                    if (this.buffer.getBooleanProperty("gzipped")) {
                        out = new GZIPOutputStream(out);
                    }
                    this.write(this.buffer, out);
                    if (twoStageSave && !this.vfs._rename(this.session, savePath, this.path, this.view)) {
                        throw new IOException("Rename failed: " + savePath);
                    }
                    if ((this.vfs.getCapabilities() & 8) != 0) {
                        if (jEdit.getBooleanProperty("persistentMarkers") && this.buffer.getMarkers().size() != 0) {
                            this.setStatus(jEdit.getProperty("vfs.status.save-markers", args));
                            this.setProgressValue(0);
                            out = this.vfs._createOutputStream(this.session, this.markersPath, this.view);
                            if (out != null) {
                                this.writeMarkers(this.buffer, out);
                            }
                        } else {
                            this.vfs._delete(this.session, this.markersPath, this.view);
                        }
                    }
                } else {
                    this.buffer.setBooleanProperty(ERROR_OCCURRED, true);
                }
                if (!twoStageSave) {
                    VFSManager.sendVFSUpdate(this.vfs, this.path, true);
                }
            }
            finally {
                this.buffer.readUnlock();
            }
            Object var7_10 = null;
            try {
                this.vfs._saveComplete(this.session, this.buffer, this.path, this.view);
                this.vfs._endVFSSession(this.session, this.view);
            }
            catch (IOException io2) {
                Log.log(9, this, io2);
                Object[] pp2 = new String[]{io2.toString()};
                VFSManager.error(this.view, this.path, "ioerror.write-error", pp2);
                this.buffer.setBooleanProperty(ERROR_OCCURRED, true);
            }
            catch (WorkThread.Abort a2) {
                this.buffer.setBooleanProperty(ERROR_OCCURRED, true);
            }
            break block33;
            {
                catch (IOException io) {
                    Log.log(9, this, io);
                    Object[] pp = new String[]{io.toString()};
                    VFSManager.error(this.view, this.path, "ioerror.write-error", pp);
                    this.buffer.setBooleanProperty(ERROR_OCCURRED, true);
                    Object var7_11 = null;
                    try {
                        this.vfs._saveComplete(this.session, this.buffer, this.path, this.view);
                        this.vfs._endVFSSession(this.session, this.view);
                    }
                    catch (IOException io2) {
                        Log.log(9, this, io2);
                        Object[] pp2 = new String[]{io2.toString()};
                        VFSManager.error(this.view, this.path, "ioerror.write-error", pp2);
                        this.buffer.setBooleanProperty(ERROR_OCCURRED, true);
                    }
                    catch (WorkThread.Abort a2) {
                        this.buffer.setBooleanProperty(ERROR_OCCURRED, true);
                    }
                    break block33;
                }
                catch (WorkThread.Abort a) {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    this.buffer.setBooleanProperty(ERROR_OCCURRED, true);
                    Object var7_12 = null;
                    try {
                        this.vfs._saveComplete(this.session, this.buffer, this.path, this.view);
                        this.vfs._endVFSSession(this.session, this.view);
                    }
                    catch (IOException io2) {
                        Log.log(9, this, io2);
                        Object[] pp2 = new String[]{io2.toString()};
                        VFSManager.error(this.view, this.path, "ioerror.write-error", pp2);
                        this.buffer.setBooleanProperty(ERROR_OCCURRED, true);
                    }
                    catch (WorkThread.Abort a2) {
                        this.buffer.setBooleanProperty(ERROR_OCCURRED, true);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_13 = null;
                try {
                    this.vfs._saveComplete(this.session, this.buffer, this.path, this.view);
                    this.vfs._endVFSSession(this.session, this.view);
                }
                catch (IOException io2) {
                    Log.log(9, this, io2);
                    Object[] pp2 = new String[]{io2.toString()};
                    VFSManager.error(this.view, this.path, "ioerror.write-error", pp2);
                    this.buffer.setBooleanProperty(ERROR_OCCURRED, true);
                }
                catch (WorkThread.Abort a2) {
                    this.buffer.setBooleanProperty(ERROR_OCCURRED, true);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autosave() {
        block10: {
            OutputStream out = null;
            try {
                Object[] args = new String[]{this.vfs.getFileName(this.path)};
                this.setStatus(jEdit.getProperty("vfs.status.autosave", args));
                this.setAbortable(true);
                try {
                    if (!this.buffer.isDirty()) {
                        return;
                    }
                    out = this.vfs._createOutputStream(this.session, this.path, this.view);
                    if (out == null) {
                        return;
                    }
                    this.write(this.buffer, out);
                }
                catch (Exception e) {}
            }
            catch (WorkThread.Abort a) {
                if (out == null) break block10;
                try {
                    out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void write(Buffer buffer, OutputStream _out) throws IOException {
        block8: {
            BufferedWriter out = null;
            try {
                String encoding = buffer.getStringProperty("encoding");
                if (encoding.equals("UTF-8Y")) {
                    _out.write(239);
                    _out.write(187);
                    _out.write(191);
                    _out.flush();
                    encoding = "UTF-8";
                }
                out = new BufferedWriter(new OutputStreamWriter(_out, encoding), 32768);
                Segment lineSegment = new Segment();
                String newline = buffer.getStringProperty("lineSeparator");
                if (newline == null) {
                    newline = System.getProperty("line.separator");
                }
                this.setProgressMaximum(buffer.getLineCount() / 300);
                this.setProgressValue(0);
                int i = 0;
                while (i < buffer.getLineCount()) {
                    buffer.getLineText(i, lineSegment);
                    out.write(lineSegment.array, lineSegment.offset, lineSegment.count);
                    if (i != buffer.getLineCount() - 1) {
                        out.write(newline);
                    }
                    if (++i % 300 != 0) continue;
                    this.setProgressValue(i / 300);
                }
                if (jEdit.getBooleanProperty("stripTrailingEOL") && buffer.getBooleanProperty("trailingEOL")) {
                    out.write(newline);
                }
                Object var9_8 = null;
                if (out == null) break block8;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (out != null) {
                    out.close();
                    throw throwable;
                }
                _out.close();
                throw throwable;
            }
            out.close();
            return;
        }
        _out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMarkers(Buffer buffer, OutputStream out) throws IOException {
        BufferedWriter o = new BufferedWriter(new OutputStreamWriter(out));
        try {
            Vector markers = buffer.getMarkers();
            for (int i = 0; i < markers.size(); ++i) {
                Marker marker = (Marker)markers.elementAt(i);
                ((Writer)o).write(33);
                ((Writer)o).write(marker.getShortcut());
                ((Writer)o).write(59);
                String pos = String.valueOf(marker.getPosition());
                o.write(pos);
                ((Writer)o).write(59);
                o.write(pos);
                ((Writer)o).write(10);
            }
        }
        finally {
            ((Writer)o).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void insert() {
        in = null;
        try {
            try {
                args = new String[]{this.vfs.getFileName(this.path)};
                this.setStatus(jEdit.getProperty("vfs.status.load", args));
                this.setAbortable(true);
                this.path = this.vfs._canonPath(this.session, this.path, this.view);
                entry = this.vfs._getDirectoryEntry(this.session, this.path, this.view);
                length = entry != null ? entry.length : 0L;
                in = this.vfs._createInputStream(this.session, this.path, false, this.view);
                if (in == null) {
                }
                ** GOTO lbl-1000
            }
            catch (IOException io) {
                Log.log(9, this, io);
                pp = new String[]{io.toString()};
                VFSManager.error(this.view, this.path, "ioerror.read-error", pp);
                this.buffer.setBooleanProperty("BufferIORequest__error", true);
                ** GOTO lbl76
            }
            var8_8 = null;
            ** GOTO lbl64
lbl-1000:
            // 1 sources

            {
                seg = this.read(this.autodetect(in), length, true);
                VFSManager.runInAWTThread(new Runnable(){

                    public void run() {
                        BufferIORequest.this.view.getTextArea().setSelectedText(seg.toString());
                    }
                });
                ** GOTO lbl76
            }
        }
        catch (WorkThread.Abort a) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException var3_6) {
                    // empty catch block
                }
            }
            this.buffer.setBooleanProperty("BufferIORequest__error", true);
            var8_10 = null;
            try {
                this.vfs._endVFSSession(this.session, this.view);
                return;
            }
            catch (IOException io) {
                Log.log(9, this, io);
                pp = new String[]{io.toString()};
                VFSManager.error(this.view, this.path, "ioerror.read-error", pp);
                this.buffer.setBooleanProperty("BufferIORequest__error", true);
                return;
            }
            catch (WorkThread.Abort a) {
                this.buffer.setBooleanProperty("BufferIORequest__error", true);
                return;
            }
        }
        {
            catch (Throwable var7_25) {
                var8_11 = null;
                ** try [egrp 5[TRYBLOCK] [9, 10 : 243->261)] { 
lbl53:
                // 1 sources

                this.vfs._endVFSSession(this.session, this.view);
                throw var7_25;
lbl55:
                // 1 sources

                catch (IOException io) {
                    Log.log(9, this, io);
                    pp = new String[]{io.toString()};
                    VFSManager.error(this.view, this.path, "ioerror.read-error", pp);
                    this.buffer.setBooleanProperty("BufferIORequest__error", true);
                    throw var7_25;
                }
lbl61:
                // 1 sources

                catch (WorkThread.Abort a) {
                    this.buffer.setBooleanProperty("BufferIORequest__error", true);
                }
                throw var7_25;
            }
lbl64:
            // 1 sources

            ** try [egrp 5[TRYBLOCK] [9, 10 : 243->261)] { 
lbl65:
            // 1 sources

            this.vfs._endVFSSession(this.session, this.view);
            return;
lbl67:
            // 1 sources

            catch (IOException io) {
                Log.log(9, this, io);
                pp = new String[]{io.toString()};
                VFSManager.error(this.view, this.path, "ioerror.read-error", pp);
                this.buffer.setBooleanProperty("BufferIORequest__error", true);
                return;
            }
lbl73:
            // 1 sources

            catch (WorkThread.Abort a) {
                this.buffer.setBooleanProperty("BufferIORequest__error", true);
                return;
            }
lbl76:
            // 2 sources

            var8_9 = null;
            ** try [egrp 5[TRYBLOCK] [9, 10 : 243->261)] { 
lbl78:
            // 1 sources

            this.vfs._endVFSSession(this.session, this.view);
            return;
lbl80:
            // 1 sources

            catch (IOException io) {
                Log.log(9, this, io);
                pp = new String[]{io.toString()};
                VFSManager.error(this.view, this.path, "ioerror.read-error", pp);
                this.buffer.setBooleanProperty("BufferIORequest__error", true);
                return;
            }
lbl86:
            // 1 sources

            catch (WorkThread.Abort a) {}
            this.buffer.setBooleanProperty("BufferIORequest__error", true);
            return;
        }
    }
}

