/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.gui.DefaultFocusComponent;
import org.gjt.sp.jedit.gui.DockableWindowContainer;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.gui.RolloverButton;

public class FloatingWindowContainer
extends JFrame
implements DockableWindowContainer {
    private DockableWindowManager dockableWindowManager;
    private boolean clone;
    private DockableWindowManager.Entry entry;
    private JButton menu;

    public FloatingWindowContainer(DockableWindowManager dockableWindowManager, boolean clone) {
        this.dockableWindowManager = dockableWindowManager;
        this.clone = clone;
        this.setIconImage(GUIUtilities.getPluginIcon());
        this.setDefaultCloseOperation(2);
        Box caption = new Box(0);
        this.menu = new RolloverButton(GUIUtilities.loadIcon("ToolbarMenu.gif"));
        caption.add(this.menu);
        this.menu.addMouseListener(new MouseHandler());
        Box separatorBox = new Box(1);
        separatorBox.add(Box.createVerticalStrut(3));
        separatorBox.add(new JSeparator(0));
        separatorBox.add(Box.createVerticalStrut(3));
        caption.add(separatorBox);
        this.getContentPane().add("North", caption);
    }

    public void register(DockableWindowManager.Entry entry) {
        this.entry = entry;
        this.setTitle(entry.title);
        this.getContentPane().add("Center", entry.win);
        this.pack();
        GUIUtilities.loadGeometry(this, entry.factory.name);
        this.setVisible(true);
    }

    public void remove(DockableWindowManager.Entry entry) {
        entry.container = null;
        this.dispose();
    }

    public void unregister(DockableWindowManager.Entry entry) {
        this.dispose();
    }

    public void show(final DockableWindowManager.Entry entry) {
        if (entry == null) {
            this.dispose();
        } else {
            this.toFront();
            this.requestFocus();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (entry.win instanceof DefaultFocusComponent) {
                        ((DefaultFocusComponent)((Object)entry.win)).focusOnDefaultComponent();
                    } else {
                        entry.win.requestDefaultFocus();
                    }
                }
            });
        }
    }

    public boolean isVisible(DockableWindowManager.Entry entry) {
        return true;
    }

    public void dispose() {
        GUIUtilities.saveGeometry(this, this.entry.factory.name);
        this.entry.container = null;
        this.entry.win = null;
        super.dispose();
    }

    public DockableWindowManager getDockableWindowManager() {
        return this.dockableWindowManager;
    }

    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    class MouseHandler
    extends MouseAdapter {
        JPopupMenu popup;

        MouseHandler() {
        }

        public void mousePressed(MouseEvent evt) {
            if (this.popup != null && this.popup.isVisible()) {
                this.popup.setVisible(false);
            } else {
                this.popup = FloatingWindowContainer.this.dockableWindowManager.createPopupMenu(FloatingWindowContainer.this, ((FloatingWindowContainer)FloatingWindowContainer.this).entry.factory.name, FloatingWindowContainer.this.clone);
                GUIUtilities.showPopupMenu(this.popup, FloatingWindowContainer.this.menu, FloatingWindowContainer.this.menu.getX(), FloatingWindowContainer.this.menu.getY() + FloatingWindowContainer.this.menu.getHeight(), false);
            }
        }
    }
}

