/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.border.EtchedBorder;
import javax.swing.plaf.basic.BasicButtonUI;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.util.Log;

public class RolloverButton
extends JButton {
    private static AlphaComposite c = AlphaComposite.getInstance(3, 0.5f);
    private static Method method;
    private boolean revalidateBlocked;

    public RolloverButton() {
        if (OperatingSystem.hasJava15()) {
            this.setContentAreaFilled(false);
        }
        if (method != null) {
            try {
                method.invoke((Object)this, (Object[])new Boolean[]{Boolean.TRUE});
            }
            catch (Exception e) {
                Log.log(9, this, e);
            }
        } else {
            this.addMouseListener(new MouseOverHandler());
        }
    }

    public RolloverButton(Icon icon) {
        this();
        this.setIcon(icon);
    }

    public void updateUI() {
        if (OperatingSystem.isWindows()) {
            this.setUI(new BasicButtonUI());
        } else {
            super.updateUI();
        }
        this.setBorder(new EtchedBorder());
        this.setBorderPainted(false);
        this.setMargin(new Insets(1, 1, 1, 1));
        this.setRequestFocusEnabled(false);
    }

    public boolean isOpaque() {
        return false;
    }

    public void setEnabled(boolean b) {
        super.setEnabled(b);
        if (method == null) {
            this.setBorderPainted(false);
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBorderPainted(boolean b) {
        try {
            this.revalidateBlocked = true;
            super.setBorderPainted(b);
        }
        finally {
            this.revalidateBlocked = false;
        }
    }

    public void revalidate() {
        if (!this.revalidateBlocked) {
            super.revalidate();
        }
    }

    public void paint(Graphics g) {
        if (method != null || this.isEnabled()) {
            super.paint(g);
        } else {
            Graphics2D g2 = (Graphics2D)g;
            g2.setComposite(c);
            super.paint(g2);
        }
    }

    class MouseOverHandler
    extends MouseAdapter {
        MouseOverHandler() {
        }

        public void mouseEntered(MouseEvent e) {
            if (RolloverButton.this.isEnabled()) {
                RolloverButton.this.setBorderPainted(true);
            }
        }

        public void mouseExited(MouseEvent e) {
            RolloverButton.this.setBorderPainted(false);
        }
    }
}

