/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;

public class SelectLineRange
extends EnhancedDialog
implements ActionListener {
    private View view;
    private JTextField startField;
    private JTextField endField;
    private JButton ok;
    private JButton cancel;

    public SelectLineRange(View view) {
        super(view, jEdit.getProperty("selectlinerange.title"), true);
        this.view = view;
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(new EmptyBorder(12, 12, 12, 0));
        this.setContentPane(content);
        JLabel label = new JLabel(jEdit.getProperty("selectlinerange.caption"));
        label.setBorder(new EmptyBorder(0, 0, 6, 12));
        content.add("North", label);
        JPanel panel = this.createFieldPanel();
        content.add("Center", panel);
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setBorder(new EmptyBorder(6, 0, 0, 12));
        panel.add(Box.createGlue());
        panel.add(Box.createGlue());
        this.ok = new JButton(jEdit.getProperty("common.ok"));
        this.ok.addActionListener(this);
        this.getRootPane().setDefaultButton(this.ok);
        panel.add(this.ok);
        panel.add(Box.createHorizontalStrut(6));
        this.cancel = new JButton(jEdit.getProperty("common.cancel"));
        this.cancel.addActionListener(this);
        panel.add(this.cancel);
        panel.add(Box.createGlue());
        content.add((Component)panel, "South");
        GUIUtilities.requestFocus(this, this.startField);
        this.pack();
        this.setLocationRelativeTo(view);
        this.setVisible(true);
    }

    public void ok() {
        int endLine;
        int startLine;
        try {
            startLine = Integer.parseInt(this.startField.getText()) - 1;
            endLine = Integer.parseInt(this.endField.getText()) - 1;
        }
        catch (NumberFormatException nf) {
            this.getToolkit().beep();
            return;
        }
        Buffer buffer = this.view.getBuffer();
        if (startLine < 0 || endLine >= buffer.getLineCount() || startLine > endLine) {
            this.getToolkit().beep();
            return;
        }
        JEditTextArea textArea = this.view.getTextArea();
        Selection.Range s = new Selection.Range(buffer.getLineStartOffset(startLine), buffer.getLineEndOffset(endLine) - 1);
        if (textArea.isMultipleSelectionEnabled()) {
            textArea.addToSelection(s);
        } else {
            textArea.setSelection(s);
        }
        textArea.moveCaretPosition(buffer.getLineEndOffset(endLine) - 1);
        this.dispose();
    }

    public void cancel() {
        this.dispose();
    }

    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.ok) {
            this.ok();
        } else if (source == this.cancel) {
            this.cancel();
        }
    }

    private JPanel createFieldPanel() {
        GridBagLayout layout = new GridBagLayout();
        JPanel panel = new JPanel(layout);
        GridBagConstraints cons = new GridBagConstraints();
        cons.insets = new Insets(0, 0, 6, 12);
        cons.gridheight = 1;
        cons.gridwidth = 1;
        cons.gridy = 0;
        cons.gridx = 0;
        cons.fill = 1;
        JLabel label = new JLabel(jEdit.getProperty("selectlinerange.start"), 4);
        layout.setConstraints(label, cons);
        panel.add(label);
        this.startField = new JTextField(10);
        cons.gridx = 1;
        cons.weightx = 1.0;
        layout.setConstraints(this.startField, cons);
        panel.add(this.startField);
        label = new JLabel(jEdit.getProperty("selectlinerange.end"), 4);
        cons.gridx = 0;
        cons.weightx = 0.0;
        cons.gridy = 1;
        layout.setConstraints(label, cons);
        panel.add(label);
        this.endField = new JTextField(10);
        cons.gridx = 1;
        cons.weightx = 1.0;
        layout.setConstraints(this.endField, cons);
        panel.add(this.endField);
        return panel;
    }
}

