/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import javax.swing.JComponent;
import javax.swing.JWindow;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class SplashScreen
extends JComponent {
    private FontMetrics fm;
    private JWindow win;
    private Image image;
    private int progress;
    private static final int PROGRESS_HEIGHT = 20;

    public SplashScreen() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.setBackground(Color.white);
        Font font = new Font("Dialog", 0, 10);
        this.setFont(font);
        this.fm = this.getFontMetrics(font);
        this.image = this.getToolkit().getImage(this.getClass().getResource("/org/gjt/sp/jedit/icons/splash.png"));
        MediaTracker tracker = new MediaTracker(this);
        tracker.addImage(this.image, 0);
        try {
            tracker.waitForAll();
        }
        catch (Exception e) {
            Log.log(9, this, e);
        }
        this.win = new JWindow();
        Dimension screen = this.getToolkit().getScreenSize();
        Dimension size = new Dimension(this.image.getWidth(this) + 2, this.image.getHeight(this) + 2 + 20);
        this.win.setSize(size);
        this.win.getContentPane().add("Center", this);
        this.win.setLocation((screen.width - size.width) / 2, (screen.height - size.height) / 2);
        this.win.validate();
        this.win.setVisible(true);
    }

    public void dispose() {
        this.win.dispose();
    }

    public synchronized void advance() {
        ++this.progress;
        this.repaint();
        try {
            this.wait();
        }
        catch (InterruptedException ie) {
            Log.log(9, this, ie);
        }
    }

    public synchronized void paintComponent(Graphics g) {
        Dimension size = this.getSize();
        g.setColor(Color.black);
        g.drawRect(0, 0, size.width - 1, size.height - 1);
        g.drawImage(this.image, 1, 1, this);
        g.setColor(Color.white);
        g.fillRect(1, this.image.getHeight(this) + 1, (this.win.getWidth() - 2) * this.progress / 5, 20);
        g.setColor(Color.black);
        String str = "VERSION " + jEdit.getVersion();
        g.drawString(str, (this.getWidth() - this.fm.stringWidth(str)) / 2, this.image.getHeight(this) + (20 + this.fm.getAscent() + this.fm.getDescent()) / 2);
        this.notify();
    }
}

