/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.io;

import gnu.regexp.RE;
import gnu.regexp.REException;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.buffer.BufferIORequest;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.util.Log;

public abstract class VFS {
    public static final int READ_CAP = 1;
    public static final int WRITE_CAP = 2;
    public static final int BROWSE_CAP = 4;
    public static final int DELETE_CAP = 8;
    public static final int RENAME_CAP = 16;
    public static final int MKDIR_CAP = 32;
    public static final int LOW_LATENCY_CAP = 64;
    public static final int CASE_INSENSITIVE_CAP = 128;
    public static final String EA_TYPE = "type";
    public static final String EA_STATUS = "status";
    public static final String EA_SIZE = "size";
    public static final String EA_MODIFIED = "modified";
    private String name;
    private int caps;
    private String[] extAttrs;
    private static Vector colors;
    private static Object lock;
    static /* synthetic */ Class class$org$gjt$sp$jedit$io$VFS;

    public VFS(String name) {
        this(name, 0);
    }

    public VFS(String name, int caps) {
        this.name = name;
        this.caps = caps;
        this.extAttrs = new String[]{EA_SIZE, EA_TYPE};
    }

    public VFS(String name, int caps, String[] extAttrs) {
        this.name = name;
        this.caps = caps;
        this.extAttrs = extAttrs;
    }

    public String getName() {
        return this.name;
    }

    public int getCapabilities() {
        return this.caps;
    }

    public String[] getExtendedAttributes() {
        return this.extAttrs;
    }

    public String showBrowseDialog(Object[] session, Component comp) {
        return null;
    }

    public String getFileName(String path) {
        int index;
        if (path.equals("/")) {
            return path;
        }
        if (path.endsWith("/") || path.endsWith(File.separator)) {
            path = path.substring(0, path.length() - 1);
        }
        if ((index = Math.max(path.lastIndexOf(47), path.lastIndexOf(File.separatorChar))) == -1) {
            index = path.indexOf(58);
        }
        if (index == -1 || index == path.length() - 1) {
            return path;
        }
        return path.substring(index + 1);
    }

    public String getParentOfPath(String path) {
        int count = Math.max(0, path.length() - 2);
        int index = path.lastIndexOf(File.separatorChar, count);
        if (index == -1) {
            index = path.lastIndexOf(47, count);
        }
        if (index == -1) {
            index = path.lastIndexOf(58);
        }
        return path.substring(0, index + 1);
    }

    public String constructPath(String parent, String path) {
        return parent + path;
    }

    public char getFileSeparator() {
        return '/';
    }

    public String getTwoStageSaveName(String path) {
        return MiscUtilities.constructPath(this.getParentOfPath(path), '#' + this.getFileName(path) + "#save#");
    }

    public void reloadDirectory(String path) {
    }

    public Object createVFSSession(String path, Component comp) {
        return new Object();
    }

    public boolean load(View view, Buffer buffer, String path) {
        if ((this.getCapabilities() & 1) == 0) {
            VFSManager.error(view, path, "vfs.not-supported.load", new String[]{this.name});
            return false;
        }
        Object session = this.createVFSSession(path, view);
        if (session == null) {
            return false;
        }
        if ((this.getCapabilities() & 2) == 0) {
            buffer.setReadOnly(true);
        }
        BufferIORequest request = new BufferIORequest(0, view, buffer, session, this, path);
        if (buffer.isTemporary()) {
            request.run();
        } else {
            VFSManager.runInWorkThread(request);
        }
        return true;
    }

    public boolean save(View view, Buffer buffer, String path) {
        if ((this.getCapabilities() & 2) == 0) {
            VFSManager.error(view, path, "vfs.not-supported.save", new String[]{this.name});
            return false;
        }
        Object session = this.createVFSSession(path, view);
        if (session == null) {
            return false;
        }
        if (!path.equals(buffer.getPath())) {
            buffer.unsetProperty("Buffer__backedUp");
        }
        VFSManager.runInWorkThread(new BufferIORequest(1, view, buffer, session, this, path));
        return true;
    }

    public boolean insert(View view, Buffer buffer, String path) {
        if ((this.getCapabilities() & 1) == 0) {
            VFSManager.error(view, path, "vfs.not-supported.load", new String[]{this.name});
            return false;
        }
        Object session = this.createVFSSession(path, view);
        if (session == null) {
            return false;
        }
        VFSManager.runInWorkThread(new BufferIORequest(3, view, buffer, session, this, path));
        return true;
    }

    public String _canonPath(Object session, String path, Component comp) throws IOException {
        return path;
    }

    public String[] _listDirectory(Object session, String directory, String glob, boolean recursive, Component comp) throws IOException {
        RE filter;
        Log.log(1, this, "Listing " + directory);
        ArrayList files = new ArrayList(100);
        try {
            filter = new RE(MiscUtilities.globToRE(glob), 2);
        }
        catch (REException e) {
            Log.log(9, this, e);
            return null;
        }
        this._listDirectory(session, new ArrayList(), files, directory, filter, recursive, comp);
        String[] retVal = files.toArray(new String[files.size()]);
        Arrays.sort(retVal, new MiscUtilities.StringICaseCompare());
        return retVal;
    }

    public DirectoryEntry[] _listDirectory(Object session, String directory, Component comp) throws IOException {
        VFSManager.error(comp, directory, "vfs.not-supported.list", new String[]{this.name});
        return null;
    }

    public DirectoryEntry _getDirectoryEntry(Object session, String path, Component comp) throws IOException {
        return null;
    }

    public boolean _delete(Object session, String path, Component comp) throws IOException {
        return false;
    }

    public boolean _rename(Object session, String from, String to, Component comp) throws IOException {
        return false;
    }

    public boolean _mkdir(Object session, String directory, Component comp) throws IOException {
        return false;
    }

    public void _backup(Object session, String path, Component comp) throws IOException {
    }

    public InputStream _createInputStream(Object session, String path, boolean ignoreErrors, Component comp) throws IOException {
        VFSManager.error(comp, path, "vfs.not-supported.load", new String[]{this.name});
        return null;
    }

    public OutputStream _createOutputStream(Object session, String path, Component comp) throws IOException {
        VFSManager.error(comp, path, "vfs.not-supported.save", new String[]{this.name});
        return null;
    }

    public void _saveComplete(Object session, Buffer buffer, String path, Component comp) throws IOException {
    }

    public void _endVFSSession(Object session, Component comp) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Color getDefaultColorFor(String name) {
        Object object = lock;
        synchronized (object) {
            if (colors == null) {
                VFS.loadColors();
            }
            for (int i = 0; i < colors.size(); ++i) {
                ColorEntry entry = (ColorEntry)colors.elementAt(i);
                if (!entry.re.isMatch(name)) continue;
                return entry.color;
            }
            return null;
        }
    }

    private void _listDirectory(Object session, ArrayList stack, ArrayList files, String directory, RE glob, boolean recursive, Component comp) throws IOException {
        if (stack.contains(directory)) {
            Log.log(9, this, "Recursion in _listDirectory(): " + directory);
            return;
        }
        stack.add(directory);
        DirectoryEntry[] _files = this._listDirectory(session, directory, comp);
        if (_files == null || _files.length == 0) {
            return;
        }
        for (int i = 0; i < _files.length; ++i) {
            DirectoryEntry file = _files[i];
            if (file.type == 1 || file.type == 2) {
                if (!recursive) continue;
                String canonPath = this._canonPath(session, file.path, comp);
                if (!MiscUtilities.isURL(canonPath)) {
                    canonPath = MiscUtilities.resolveSymlinks(canonPath);
                }
                this._listDirectory(session, stack, files, canonPath, glob, recursive, comp);
                continue;
            }
            if (!glob.isMatch(file.name)) continue;
            Log.log(1, this, file.path);
            files.add(file.path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadColors() {
        Object object = lock;
        synchronized (object) {
            String glob;
            colors = new Vector();
            if (!jEdit.getBooleanProperty("vfs.browser.colorize")) {
                return;
            }
            int i = 0;
            while ((glob = jEdit.getProperty("vfs.browser.colors." + i + ".glob")) != null) {
                try {
                    colors.addElement(new ColorEntry(new RE(MiscUtilities.globToRE(glob)), jEdit.getColorProperty("vfs.browser.colors." + i + ".color", Color.black)));
                }
                catch (REException e) {
                    Log.log(9, class$org$gjt$sp$jedit$io$VFS == null ? VFS.class$("org.gjt.sp.jedit.io.VFS") : class$org$gjt$sp$jedit$io$VFS, "Invalid regular expression: " + glob);
                    Log.log(9, class$org$gjt$sp$jedit$io$VFS == null ? VFS.class$("org.gjt.sp.jedit.io.VFS") : class$org$gjt$sp$jedit$io$VFS, e);
                }
                ++i;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        lock = new Object();
        EditBus.addToBus(new EBComponent(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleMessage(EBMessage msg) {
                if (msg instanceof PropertiesChanged) {
                    Object object = lock;
                    synchronized (object) {
                        colors = null;
                    }
                }
            }
        });
    }

    static class ColorEntry {
        RE re;
        Color color;

        ColorEntry(RE re, Color color) {
            this.re = re;
            this.color = color;
        }
    }

    public static class DirectoryEntryCompare
    implements MiscUtilities.Compare {
        private boolean sortIgnoreCase;
        private boolean sortMixFilesAndDirs;

        public DirectoryEntryCompare(boolean sortMixFilesAndDirs, boolean sortIgnoreCase) {
            this.sortMixFilesAndDirs = sortMixFilesAndDirs;
            this.sortIgnoreCase = sortIgnoreCase;
        }

        public int compare(Object obj1, Object obj2) {
            DirectoryEntry file1 = (DirectoryEntry)obj1;
            DirectoryEntry file2 = (DirectoryEntry)obj2;
            if (!this.sortMixFilesAndDirs && file1.type != file2.type) {
                return file2.type - file1.type;
            }
            return MiscUtilities.compareStrings(file1.name, file2.name, this.sortIgnoreCase);
        }
    }

    public static class DirectoryEntry
    implements Serializable {
        public static final int FILE = 0;
        public static final int DIRECTORY = 1;
        public static final int FILESYSTEM = 2;
        public String name;
        public String path;
        public String symlinkPath;
        public String deletePath;
        public int type;
        public long length;
        public boolean hidden;
        public boolean canRead;
        public boolean canWrite;
        protected boolean colorCalculated;
        protected Color color;

        public DirectoryEntry() {
        }

        public DirectoryEntry(String name, String path, String deletePath, int type, long length, boolean hidden) {
            this.name = name;
            this.path = path;
            this.deletePath = deletePath;
            this.symlinkPath = path;
            this.type = type;
            this.length = length;
            this.hidden = hidden;
            if (path != null) {
                VFS vfs = VFSManager.getVFSForPath(path);
                this.canRead = (vfs.getCapabilities() & 1) != 0;
                this.canWrite = (vfs.getCapabilities() & 2) != 0;
            }
        }

        public String getExtendedAttribute(String name) {
            if (name.equals(VFS.EA_TYPE)) {
                switch (this.type) {
                    case 0: {
                        return jEdit.getProperty("vfs.browser.type.file");
                    }
                    case 1: {
                        return jEdit.getProperty("vfs.browser.type.directory");
                    }
                    case 2: {
                        return jEdit.getProperty("vfs.browser.type.filesystem");
                    }
                }
                throw new IllegalArgumentException();
            }
            if (name.equals(VFS.EA_STATUS)) {
                if (this.canRead) {
                    if (this.canWrite) {
                        return jEdit.getProperty("vfs.browser.status.rw");
                    }
                    return jEdit.getProperty("vfs.browser.status.ro");
                }
                if (this.canWrite) {
                    return jEdit.getProperty("vfs.browser.status.append");
                }
                return jEdit.getProperty("vfs.browser.status.no");
            }
            if (name.equals(VFS.EA_SIZE)) {
                if (this.type != 0) {
                    return null;
                }
                return MiscUtilities.formatFileSize(this.length);
            }
            return null;
        }

        public Color getColor() {
            if (!this.colorCalculated) {
                this.colorCalculated = true;
                this.color = VFS.getDefaultColorFor(this.name);
            }
            return this.color;
        }

        public String toString() {
            return this.name;
        }
    }
}

