/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.ActionSet;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Macros;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.gui.GrabKeyDialog;
import org.gjt.sp.jedit.jEdit;

public class ShortcutsOptionPane
extends AbstractOptionPane {
    private JTable keyTable;
    private Vector models;
    private ShortcutsModel currentModel;
    private JComboBox selectModel;
    private Vector allBindings;

    public ShortcutsOptionPane() {
        super("shortcuts");
    }

    protected void _init() {
        this.allBindings = new Vector();
        this.setLayout(new BorderLayout(12, 12));
        this.initModels();
        this.selectModel = new JComboBox(this.models);
        this.selectModel.addActionListener(new ActionHandler());
        Box north = Box.createHorizontalBox();
        north.add(new JLabel(jEdit.getProperty("options.shortcuts.select.label")));
        north.add(Box.createHorizontalStrut(6));
        north.add(this.selectModel);
        this.keyTable = new JTable(this.currentModel);
        this.keyTable.getTableHeader().setReorderingAllowed(false);
        this.keyTable.getTableHeader().addMouseListener(new HeaderMouseHandler());
        this.keyTable.addMouseListener(new TableMouseHandler());
        Dimension d = this.keyTable.getPreferredSize();
        d.height = Math.min(d.height, 200);
        JScrollPane scroller = new JScrollPane(this.keyTable);
        scroller.setPreferredSize(d);
        this.add("North", north);
        this.add("Center", scroller);
    }

    protected void _save() {
        if (this.keyTable.getCellEditor() != null) {
            this.keyTable.getCellEditor().stopCellEditing();
        }
        Enumeration e = this.models.elements();
        while (e.hasMoreElements()) {
            ((ShortcutsModel)e.nextElement()).save();
        }
        Macros.loadMacros();
    }

    private void initModels() {
        this.models = new Vector();
        ActionSet[] actionSets = jEdit.getActionSets();
        for (int i = 0; i < actionSets.length; ++i) {
            ActionSet actionSet = actionSets[i];
            if (actionSet.getActionCount() == 0) continue;
            String modelLabel = actionSet.getLabel();
            if (modelLabel == null) {
                System.err.println("Empty action set: " + actionSet.getPluginJAR());
            }
            this.models.addElement(this.createModel(modelLabel, actionSet.getActionNames()));
        }
        Collections.sort(this.models, new MiscUtilities.StringICaseCompare());
        this.currentModel = (ShortcutsModel)this.models.elementAt(0);
    }

    private ShortcutsModel createModel(String modelLabel, String[] actions) {
        Vector bindings = new Vector(actions.length);
        for (int i = 0; i < actions.length; ++i) {
            String name = actions[i];
            String label = jEdit.getProperty(actions[i] + ".label");
            if (label == null) continue;
            label = GUIUtilities.prettifyMenuLabel(label);
            this.addBindings(name, label, bindings);
        }
        return new ShortcutsModel(modelLabel, bindings);
    }

    private void addBindings(String name, String label, Vector bindings) {
        GrabKeyDialog.KeyBinding[] b = new GrabKeyDialog.KeyBinding[]{this.createBinding(name, label, jEdit.getProperty(name + ".shortcut")), this.createBinding(name, label, jEdit.getProperty(name + ".shortcut2"))};
        bindings.addElement(b);
    }

    private GrabKeyDialog.KeyBinding createBinding(String name, String label, String shortcut) {
        if (shortcut != null && shortcut.length() == 0) {
            shortcut = null;
        }
        GrabKeyDialog.KeyBinding binding = new GrabKeyDialog.KeyBinding(name, label, shortcut, false);
        this.allBindings.addElement(binding);
        return binding;
    }

    class ShortcutsModel
    extends AbstractTableModel {
        private Vector bindings;
        private String name;

        ShortcutsModel(String name, Vector bindings) {
            this.name = name;
            this.bindings = bindings;
            this.sort(0);
        }

        public void sort(int col) {
            MiscUtilities.quicksort(this.bindings, (MiscUtilities.Compare)new KeyCompare(col));
            this.fireTableDataChanged();
        }

        public int getColumnCount() {
            return 3;
        }

        public int getRowCount() {
            return this.bindings.size();
        }

        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return this.getBindingAt((int)row, (int)0).label;
                }
                case 1: {
                    return this.getBindingAt((int)row, (int)0).shortcut;
                }
                case 2: {
                    return this.getBindingAt((int)row, (int)1).shortcut;
                }
            }
            return null;
        }

        public void setValueAt(Object value, int row, int col) {
            if (col == 0) {
                return;
            }
            this.getBindingAt((int)row, (int)(col - 1)).shortcut = (String)value;
            this.fireTableDataChanged();
        }

        public String getColumnName(int index) {
            switch (index) {
                case 0: {
                    return jEdit.getProperty("options.shortcuts.name");
                }
                case 1: {
                    return jEdit.getProperty("options.shortcuts.shortcut1");
                }
                case 2: {
                    return jEdit.getProperty("options.shortcuts.shortcut2");
                }
            }
            return null;
        }

        public void save() {
            Enumeration e = this.bindings.elements();
            while (e.hasMoreElements()) {
                GrabKeyDialog.KeyBinding[] binding = (GrabKeyDialog.KeyBinding[])e.nextElement();
                jEdit.setProperty(binding[0].name + ".shortcut", binding[0].shortcut);
                jEdit.setProperty(binding[1].name + ".shortcut2", binding[1].shortcut);
            }
        }

        public GrabKeyDialog.KeyBinding getBindingAt(int row, int nr) {
            GrabKeyDialog.KeyBinding[] binding = (GrabKeyDialog.KeyBinding[])this.bindings.elementAt(row);
            return binding[nr];
        }

        public String toString() {
            return this.name;
        }

        class KeyCompare
        implements MiscUtilities.Compare {
            int col;

            KeyCompare(int col) {
                this.col = col;
            }

            public int compare(Object obj1, Object obj2) {
                String shortcut2;
                String shortcut1;
                GrabKeyDialog.KeyBinding[] k1 = (GrabKeyDialog.KeyBinding[])obj1;
                GrabKeyDialog.KeyBinding[] k2 = (GrabKeyDialog.KeyBinding[])obj2;
                String label1 = k1[0].label.toLowerCase();
                String label2 = k2[0].label.toLowerCase();
                if (this.col == 0) {
                    return MiscUtilities.compareStrings(label1, label2, true);
                }
                if (this.col == 1) {
                    shortcut1 = k1[0].shortcut;
                    shortcut2 = k2[0].shortcut;
                } else {
                    shortcut1 = k1[1].shortcut;
                    shortcut2 = k2[1].shortcut;
                }
                if (shortcut1 == null && shortcut2 != null) {
                    return 1;
                }
                if (shortcut2 == null && shortcut1 != null) {
                    return -1;
                }
                if (shortcut1 == null && shortcut2 == null) {
                    return MiscUtilities.compareStrings(label1, label2, true);
                }
                return MiscUtilities.compareStrings(shortcut1, shortcut2, true);
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            ShortcutsModel newModel = (ShortcutsModel)ShortcutsOptionPane.this.selectModel.getSelectedItem();
            if (ShortcutsOptionPane.this.currentModel != newModel) {
                ShortcutsOptionPane.this.currentModel = newModel;
                ShortcutsOptionPane.this.keyTable.setModel(ShortcutsOptionPane.this.currentModel);
            }
        }
    }

    class TableMouseHandler
    extends MouseAdapter {
        TableMouseHandler() {
        }

        public void mouseClicked(MouseEvent evt) {
            GrabKeyDialog gkd;
            int row = ShortcutsOptionPane.this.keyTable.getSelectedRow();
            int col = ShortcutsOptionPane.this.keyTable.getSelectedColumn();
            if (col != 0 && row != -1 && (gkd = new GrabKeyDialog((Dialog)GUIUtilities.getParentDialog(ShortcutsOptionPane.this), ShortcutsOptionPane.this.currentModel.getBindingAt(row, col - 1), ShortcutsOptionPane.this.allBindings, null)).isOK()) {
                ShortcutsOptionPane.this.currentModel.setValueAt(gkd.getShortcut(), row, col);
            }
        }
    }

    class HeaderMouseHandler
    extends MouseAdapter {
        HeaderMouseHandler() {
        }

        public void mouseClicked(MouseEvent evt) {
            switch (ShortcutsOptionPane.this.keyTable.getTableHeader().columnAtPoint(evt.getPoint())) {
                case 0: {
                    ShortcutsOptionPane.this.currentModel.sort(0);
                    break;
                }
                case 1: {
                    ShortcutsOptionPane.this.currentModel.sort(1);
                    break;
                }
                case 2: {
                    ShortcutsOptionPane.this.currentModel.sort(2);
                }
            }
        }
    }
}

